/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ValueRange
extends ASTNode
implements IIncrementallyUpdateable {
    private static final String FULLNAMEPART1 = ".<lower_boundary>";
    private static final String FULLNAMEPART2 = ".<lower_boundary>";
    private final Value min;
    private final Value max;

    public ValueRange(Value min, Value max) {
        this.min = min;
        this.max = max;
        if (min != null) {
            min.setFullNameParent(this);
        }
        if (max != null) {
            max.setFullNameParent(this);
        }
    }

    public Value getMin() {
        return this.min;
    }

    public Value getMax() {
        return this.max;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.min != null) {
            this.min.setMyScope(scope);
        }
        if (this.max != null) {
            this.max.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.min == child) {
            return builder.append(".<lower_boundary>");
        }
        if (this.max == child) {
            return builder.append(".<lower_boundary>");
        }
        return builder;
    }

    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        if (this.min == null) {
            builder.append("-infinity");
        } else {
            builder.append(this.min.createStringRepresentation());
        }
        builder.append(" .. ");
        if (this.max == null) {
            builder.append("infinity");
        } else {
            builder.append(this.max.createStringRepresentation());
        }
        builder.append(')');
        return builder.toString();
    }

    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        IType type;
        if (this.min != null && (type = this.min.getExpressionGovernor(timestamp, expectedValue)) != null) {
            return type;
        }
        if (this.max != null && (type = this.max.getExpressionGovernor(timestamp, expectedValue)) != null) {
            return type;
        }
        return null;
    }

    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        IType.Type_type type;
        if (this.min != null && !IType.Type_type.TYPE_UNDEFINED.equals((Object)(type = this.min.getExpressionReturntype(timestamp, expectedValue)))) {
            return type;
        }
        if (this.max != null && !IType.Type_type.TYPE_UNDEFINED.equals((Object)(type = this.max.getExpressionReturntype(timestamp, expectedValue)))) {
            return type;
        }
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.min != null) {
            this.min.updateSyntax(reparser, false);
            reparser.updateLocation(this.min.getLocation());
        }
        if (this.max != null) {
            this.max.updateSyntax(reparser, false);
            reparser.updateLocation(this.max.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.min != null) {
            this.min.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.max != null) {
            this.max.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.min != null && !this.min.accept(v)) {
            return false;
        }
        return this.max == null || this.max.accept(v);
    }
}

