/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Type;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.IndexedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.Indexed_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.SubsetMatch_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.SupersetMatch_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Template_List;
import org.eclipse.titan.designer.AST.TTCN3.types.AbstractOfType;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubType;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SetOf_Value;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class SetOf_Type
extends AbstractOfType {
    public static final String SETOFVALUEEXPECTED1 = "SET OF value was expected";
    public static final String SETOFVALUEEXPECTED2 = "set of value was expected";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for setof type `{1}''";
    private static final String REDUNDANTLENGTHRESTRICTION = "Redundant usage of length restriction with `omit''";
    private static final String ANYOROMITINSUBSET = "`*'' in subset. This template will match everything";
    private static final String ANYOROMITINSUPERSET = "`*'' in superset has no effect during matching";
    private static final String NOTCOMPATIBLESETSETOF = "set/SET and set of/SET OF types are compatible only with other set/SET and set of/SET OF types";
    private static final String NOTCOMPATIBLEUNIONANYTYPE = "union/CHOICE/anytype types are compatible only with other union/CHOICE/anytype types";

    public SetOf_Type(IType ofType) {
        super(ofType);
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_SET_OF;
    }

    @Override
    public IASN1Type newInstance() {
        if (this.getOfType() instanceof ASN1Type) {
            return new SetOf_Type(((IASN1Type)this.getOfType()).newInstance());
        }
        return this;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType lastOtherType = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || lastOtherType.getIsErroneous(timestamp) || this == lastOtherType) {
            return true;
        }
        if (info == null || noStructuredTypeCompatibility) {
            IType last = this.getTypeRefdLast(timestamp);
            return last.isStronglyCompatible(timestamp, lastOtherType, info, leftChain, rightChain);
        }
        switch (lastOtherType.getTypetype()) {
            case TYPE_ASN1_SET: {
                if (!this.isSubtypeCompatible(timestamp, lastOtherType)) {
                    info.setErrorStr("Incompatible set of/SET OF subtypes");
                    return false;
                }
                ASN1_Set_Type tempType = (ASN1_Set_Type)lastOtherType;
                int tempTypeNofComps = tempType.getNofComponents(timestamp);
                if (tempTypeNofComps == 0) {
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                for (int i = 0; i < tempTypeNofComps; ++i) {
                    CompField tempTypeCf = tempType.getComponentByIndex(i);
                    IType ofType = this.getOfType().getTypeRefdLast(timestamp);
                    IType tempTypeCfType = tempTypeCf.getType().getTypeRefdLast(timestamp);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(ofType, tempTypeCfType, false);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(ofType);
                    rChain.add(tempTypeCfType);
                    if (!(ofType.equals(tempTypeCfType) || lChain.hasRecursion() && rChain.hasRecursion() || ofType.isCompatible(timestamp, tempTypeCfType, infoTemp, lChain, rChain))) {
                        if (infoTemp.getOp1RefStr().length() > 0) {
                            info.appendOp1Ref("[]");
                        }
                        info.appendOp1Ref(infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + tempTypeCf.getIdentifier().getDisplayName() + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_TTCN3_SET: {
                if (!this.isSubtypeCompatible(timestamp, lastOtherType)) {
                    info.setErrorStr("Incompatible set of/SET OF subtypes");
                    return false;
                }
                TTCN3_Set_Type tempType = (TTCN3_Set_Type)lastOtherType;
                int tempTypeNofComps = tempType.getNofComponents();
                if (tempTypeNofComps == 0) {
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                for (int i = 0; i < tempTypeNofComps; ++i) {
                    CompField tempTypeCf = tempType.getComponentByIndex(i);
                    IType ofType = this.getOfType().getTypeRefdLast(timestamp);
                    IType tempTypeCfType = tempTypeCf.getType().getTypeRefdLast(timestamp);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(ofType, tempTypeCfType, false);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(ofType);
                    rChain.add(tempTypeCfType);
                    if (!(ofType.equals(tempTypeCfType) || lChain.hasRecursion() && rChain.hasRecursion() || ofType.isCompatible(timestamp, tempTypeCfType, infoTemp, lChain, rChain))) {
                        if (infoTemp.getOp1RefStr().length() > 0) {
                            info.appendOp1Ref("[]");
                        }
                        info.appendOp1Ref(infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + tempTypeCf.getIdentifier().getDisplayName() + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_SET_OF: {
                if (!this.isSubtypeCompatible(timestamp, lastOtherType)) {
                    info.setErrorStr("Incompatible set of/SET OF subtypes");
                    return false;
                }
                SetOf_Type tempType = (SetOf_Type)lastOtherType;
                if (this == tempType) {
                    return true;
                }
                IType ofType = this.getOfType().getTypeRefdLast(timestamp);
                IType tempTypeOfType = tempType.getOfType().getTypeRefdLast(timestamp);
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                lChain.markState();
                rChain.markState();
                lChain.add(ofType);
                rChain.add(tempTypeOfType);
                TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(ofType, tempTypeOfType, false);
                if (!(ofType.equals(tempTypeOfType) || lChain.hasRecursion() && rChain.hasRecursion() || ofType.isCompatible(timestamp, tempTypeOfType, infoTemp, lChain, rChain))) {
                    if (info.getOp1RefStr().length() > 0) {
                        info.appendOp1Ref("[]");
                    }
                    if (info.getOp2RefStr().length() > 0) {
                        info.appendOp2Ref("[]");
                    }
                    info.appendOp1Ref(infoTemp.getOp1RefStr());
                    info.appendOp2Ref(infoTemp.getOp2RefStr());
                    info.setOp1Type(infoTemp.getOp1Type());
                    info.setOp2Type(infoTemp.getOp2Type());
                    info.setErrorStr(infoTemp.getErrorStr());
                    lChain.previousState();
                    rChain.previousState();
                    return false;
                }
                info.setNeedsConversion(true);
                lChain.previousState();
                rChain.previousState();
                return true;
            }
            case TYPE_ASN1_CHOICE: 
            case TYPE_TTCN3_CHOICE: 
            case TYPE_ANYTYPE: {
                info.setErrorStr(NOTCOMPATIBLEUNIONANYTYPE);
                return false;
            }
            case TYPE_ASN1_SEQUENCE: 
            case TYPE_TTCN3_SEQUENCE: 
            case TYPE_SEQUENCE_OF: 
            case TYPE_ARRAY: {
                info.setErrorStr(NOTCOMPATIBLESETSETOF);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isStronglyCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        IType lastOtherType = otherType.getTypeRefdLast(timestamp);
        if (IType.Type_type.TYPE_SET_OF.equals((Object)lastOtherType.getTypetype())) {
            IType oftOther = ((SetOf_Type)lastOtherType).getOfType();
            IType oft = this.getOfType().getTypeRefdLast(timestamp);
            if (oft != null && oftOther != null) {
                switch (oft.getTypetype()) {
                    case TYPE_BOOL: 
                    case TYPE_BITSTRING: 
                    case TYPE_OCTETSTRING: 
                    case TYPE_INTEGER: 
                    case TYPE_REAL: 
                    case TYPE_CHARSTRING: 
                    case TYPE_HEXSTRING: 
                    case TYPE_UCHARSTRING: 
                    case TYPE_INTEGER_A: 
                    case TYPE_ASN1_ENUMERATED: 
                    case TYPE_BITSTRING_A: 
                    case TYPE_UTF8STRING: 
                    case TYPE_NUMERICSTRING: 
                    case TYPE_PRINTABLESTRING: 
                    case TYPE_TELETEXSTRING: 
                    case TYPE_VIDEOTEXSTRING: 
                    case TYPE_IA5STRING: 
                    case TYPE_GRAPHICSTRING: 
                    case TYPE_VISIBLESTRING: 
                    case TYPE_GENERALSTRING: 
                    case TYPE_UNIVERSALSTRING: 
                    case TYPE_BMPSTRING: 
                    case TYPE_UNRESTRICTEDSTRING: 
                    case TYPE_UTCTIME: 
                    case TYPE_GENERALIZEDTIME: 
                    case TYPE_OBJECTDESCRIPTOR: {
                        if (!oft.isStronglyCompatible(timestamp, oftOther, info, leftChain, rightChain)) break;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public String getOutlineIcon() {
        return "set_of.gif";
    }

    @Override
    public SubType.SubType_type getSubtypeType() {
        return SubType.SubType_type.ST_SETOF;
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        super.checkThisValue(timestamp, value, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return;
            }
        }
        if (IValue.Value_type.UNDEFINED_BLOCK.equals((Object)last.getValuetype())) {
            last = last.setValuetype(timestamp, IValue.Value_type.SETOF_VALUE);
        }
        if (last.getIsErroneous(timestamp)) {
            return;
        }
        switch (last.getValuetype()) {
            case SEQUENCEOF_VALUE: {
                last = last.setValuetype(timestamp, IValue.Value_type.SETOF_VALUE);
                this.checkThisValueSetOf(timestamp, (SetOf_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case SETOF_VALUE: {
                this.checkThisValueSetOf(timestamp, (SetOf_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                if (value.isAsn()) {
                    value.getLocation().reportSemanticError(SETOFVALUEEXPECTED1);
                } else {
                    value.getLocation().reportSemanticError(SETOFVALUEEXPECTED2);
                }
                value.setIsErroneous(true);
            }
        }
        if (valueCheckingOptions.sub_check && this.subType != null) {
            this.subType.checkThisValue(timestamp, last);
        }
        value.setLastTimeChecked(timestamp);
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        switch (template.getTemplatetype()) {
            case OMIT_VALUE: {
                if (template.getLengthRestriction() == null) break;
                template.getLocation().reportSemanticWarning(REDUNDANTLENGTHRESTRICTION);
                break;
            }
            case SUBSET_MATCH: {
                SubsetMatch_Template subsetTemplate = (SubsetMatch_Template)template;
                int nofComponents = subsetTemplate.getNofTemplates();
                for (int i = 0; i < nofComponents; ++i) {
                    ITTCN3Template templateComponent = subsetTemplate.getTemplateByIndex(i);
                    templateComponent.setMyGovernor(this.getOfType());
                    templateComponent = this.getOfType().checkThisTemplateRef(timestamp, templateComponent);
                    templateComponent.checkThisTemplateGeneric(timestamp, this.getOfType(), false, false, true, true, implicitOmit);
                    if (!ITTCN3Template.Template_type.ANY_OR_OMIT.equals((Object)templateComponent.getTemplateReferencedLast(timestamp, null).getTemplatetype())) continue;
                    templateComponent.getLocation().reportSemanticWarning(ANYOROMITINSUBSET);
                }
                break;
            }
            case SUPERSET_MATCH: {
                SupersetMatch_Template supersetTemplate = (SupersetMatch_Template)template;
                int nofComponents = supersetTemplate.getNofTemplates();
                for (int i = 0; i < nofComponents; ++i) {
                    ITTCN3Template templateComponent = supersetTemplate.getTemplateByIndex(i);
                    templateComponent.setMyGovernor(this.getOfType());
                    templateComponent = this.getOfType().checkThisTemplateRef(timestamp, templateComponent);
                    templateComponent.checkThisTemplateGeneric(timestamp, this.getOfType(), false, false, true, true, implicitOmit);
                    if (!ITTCN3Template.Template_type.ANY_OR_OMIT.equals((Object)templateComponent.getTemplateReferencedLast(timestamp, null).getTemplatetype())) continue;
                    templateComponent.getLocation().reportSemanticWarning(ANYOROMITINSUPERSET);
                }
                break;
            }
            case TEMPLATE_LIST: {
                ITTCN3Template.Completeness_type completeness = template.getCompletenessConditionSeof(timestamp, isModified);
                Template_List base = null;
                int nofBaseComps = 0;
                if (ITTCN3Template.Completeness_type.PARTIAL.equals((Object)completeness)) {
                    ITTCN3Template tempBase = template.getBaseTemplate();
                    if (tempBase != null) {
                        tempBase = tempBase.getTemplateReferencedLast(timestamp);
                    }
                    if (tempBase == null) {
                        this.setIsErroneous(true);
                        return;
                    }
                    base = (Template_List)tempBase;
                    nofBaseComps = base.getNofTemplates();
                }
                Template_List templateList = (Template_List)template;
                int nofComponents = templateList.getNofTemplates();
                block13: for (int i = 0; i < nofComponents; ++i) {
                    ITTCN3Template component = templateList.getTemplateByIndex(i);
                    component.setMyGovernor(this.getOfType());
                    if (base != null && nofBaseComps > i) {
                        component.setBaseTemplate(base.getTemplateByIndex(i));
                    } else {
                        component.setBaseTemplate(null);
                    }
                    component = this.getOfType().checkThisTemplateRef(timestamp, component);
                    switch (component.getTemplatetype()) {
                        case PERMUTATION_MATCH: {
                            component.getLocation().reportSemanticError(MessageFormat.format("{0} cannot be used for `set of' type `{1}''", component.getTemplateTypeName(), this.getTypename()));
                            continue block13;
                        }
                        case TEMPLATE_NOTUSED: {
                            if (ITTCN3Template.Completeness_type.MUST_COMPLETE.equals((Object)completeness)) {
                                component.getLocation().reportSemanticError("Not used symbol `-' cannot be used here because there is no corresponding element in the base template");
                                continue block13;
                            }
                            if (!ITTCN3Template.Completeness_type.PARTIAL.equals((Object)completeness) || i < nofBaseComps) continue block13;
                            component.getLocation().reportSemanticError("Not used symbol `-' cannot be used here because there is no corresponding element in the base template");
                            continue block13;
                        }
                        default: {
                            boolean embeddedModified = completeness == ITTCN3Template.Completeness_type.MAY_INCOMPLETE || completeness == ITTCN3Template.Completeness_type.PARTIAL && i < nofBaseComps;
                            component.checkThisTemplateGeneric(timestamp, this.getOfType(), embeddedModified, false, true, true, implicitOmit);
                        }
                    }
                }
                break;
            }
            case INDEXED_TEMPLATE_LIST: {
                HashMap<Long, Integer> indexMap = new HashMap<Long, Integer>();
                Indexed_Template_List indexedTemplateList = (Indexed_Template_List)template;
                for (int i = 0; i < indexedTemplateList.getNofTemplates(); ++i) {
                    IndexedTemplate indexedTemplate = indexedTemplateList.getIndexedTemplateByIndex(i);
                    Value indexValue = indexedTemplate.getIndex().getValue();
                    ITTCN3Template templateComponent = indexedTemplate.getTemplate();
                    ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                    IValue lastValue = indexValue.getValueRefdLast(timestamp, chain);
                    chain.release();
                    if (IValue.Value_type.INTEGER_VALUE.equals((Object)lastValue.getValuetype())) {
                        long index = ((Integer_Value)lastValue).getValue();
                        if (index > Integer.MAX_VALUE) {
                            indexValue.getLocation().reportSemanticError(MessageFormat.format("An integer value less than `{0}'' was expected for indexing type `{1}'' instead of `{2}''", Integer.MAX_VALUE, this.getTypename(), index));
                            indexValue.setIsErroneous(true);
                        } else if (index < 0L) {
                            indexValue.getLocation().reportSemanticError(MessageFormat.format("A non-negative integer value was expected for indexing type `{0}'' instead of `{1}''", this.getTypename(), index));
                            indexValue.setIsErroneous(true);
                        } else if (indexMap.containsKey(index)) {
                            indexValue.getLocation().reportSemanticError(MessageFormat.format("Duplicate index value `{0}'' for component `{1}'' and `{2}''", index, i + 1, indexMap.get(index)));
                            indexValue.setIsErroneous(true);
                        } else {
                            indexMap.put(index, i);
                        }
                    } else {
                        indexValue.getLocation().reportSemanticError("The index should be an integer value");
                        indexValue.setIsErroneous(true);
                    }
                    templateComponent.setMyGovernor(this.getOfType());
                    templateComponent = this.getOfType().checkThisTemplateRef(timestamp, templateComponent);
                    templateComponent.checkThisTemplateGeneric(timestamp, this.getOfType(), true, false, true, true, implicitOmit);
                }
                break;
            }
            default: {
                template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName(), this.getTypename()));
            }
        }
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        builder.append("set of ");
        if (this.getOfType() != null) {
            this.getOfType().getProposalDescription(builder);
        }
        return builder;
    }
}

