/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types.subtypes;

import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.CharLimit;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.EmptyStringSet;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.FullStringSet;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.RangeListConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SizeLimit;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.StringPatternConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.StringSetOperation;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.StringSubtypeTreeElement;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.StringValueConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubtypeConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.TernaryBool;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.UCharLimit;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.UStringValueConstraint;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring;

public final class StringSetConstraint
extends StringSubtypeTreeElement {
    private final ConstraintType constraintType;
    private final SubtypeConstraint constraint;

    public StringSetConstraint(StringSubtypeTreeElement.StringType stringType, ConstraintType constraintType, SubtypeConstraint constraint) {
        super(stringType);
        this.constraintType = constraintType;
        this.constraint = constraint;
    }

    @Override
    public StringSubtypeTreeElement.ElementType getElementType() {
        return StringSubtypeTreeElement.ElementType.CONSTRAINT;
    }

    public ConstraintType getType() {
        return this.constraintType;
    }

    public SubtypeConstraint getConstraint() {
        return this.constraint;
    }

    @Override
    public StringSetConstraint complement() {
        return new StringSetConstraint(this.stringType, this.constraintType, this.constraint.complement());
    }

    @Override
    public SubtypeConstraint intersection(SubtypeConstraint other) {
        StringSubtypeTreeElement o = (StringSubtypeTreeElement)other;
        if (o instanceof StringSetConstraint) {
            StringSetConstraint ssc = (StringSetConstraint)o;
            if (ssc.constraintType == this.constraintType) {
                return new StringSetConstraint(this.stringType, this.constraintType, this.constraint.intersection(((StringSetConstraint)o).constraint));
            }
        }
        StringSetOperation returnValue = new StringSetOperation(this.stringType, StringSetOperation.OperationType.INTERSECTION, this, o);
        return returnValue.evaluate();
    }

    @Override
    public SubtypeConstraint union(SubtypeConstraint other) {
        StringSubtypeTreeElement o = (StringSubtypeTreeElement)other;
        if (o instanceof StringSetConstraint) {
            StringSetConstraint ssc = (StringSetConstraint)o;
            if (ssc.constraintType == this.constraintType) {
                return new StringSetConstraint(this.stringType, this.constraintType, this.constraint.union(((StringSetConstraint)o).constraint));
            }
        }
        StringSetOperation returnValue = new StringSetOperation(this.stringType, StringSetOperation.OperationType.UNION, this, o);
        return returnValue.evaluate();
    }

    @Override
    public SubtypeConstraint except(SubtypeConstraint other) {
        StringSubtypeTreeElement o = (StringSubtypeTreeElement)other;
        if (o instanceof StringSetConstraint) {
            StringSetConstraint ssc = (StringSetConstraint)o;
            if (ssc.constraintType == this.constraintType) {
                return new StringSetConstraint(this.stringType, this.constraintType, this.constraint.except(((StringSetConstraint)o).constraint));
            }
        }
        StringSetOperation returnValue = new StringSetOperation(this.stringType, StringSetOperation.OperationType.EXCEPT, this, o);
        return returnValue.evaluate();
    }

    @Override
    public TernaryBool isSubset(SubtypeConstraint other) {
        StringSubtypeTreeElement o = (StringSubtypeTreeElement)other;
        if (o instanceof StringSetConstraint) {
            StringSetConstraint ssc = (StringSetConstraint)o;
            if (this.constraintType == ssc.constraintType) {
                return this.constraint.isSubset(ssc.constraint);
            }
        }
        return TernaryBool.TUNKNOWN;
    }

    @Override
    public boolean isElement(Object o) {
        switch (this.constraintType) {
            case ALPHABET_CONSTRAINT: {
                if (this.stringType == StringSubtypeTreeElement.StringType.CHARSTRING) {
                    String str = (String)o;
                    for (int i = 0; i < str.length(); ++i) {
                        if (this.constraint.isElement(new CharLimit(str.charAt(i)))) continue;
                        return false;
                    }
                    return true;
                }
                UniversalCharstring str = (UniversalCharstring)o;
                for (int i = 0; i < str.length(); ++i) {
                    if (this.constraint.isElement(new UCharLimit(str.get(i)))) continue;
                    return false;
                }
                return true;
            }
            case SIZE_CONSTRAINT: {
                if (this.stringType == StringSubtypeTreeElement.StringType.CHARSTRING) {
                    String str = (String)o;
                    return this.constraint.isElement(new SizeLimit(str.length()));
                }
                UniversalCharstring str = (UniversalCharstring)o;
                return this.constraint.isElement(new SizeLimit(str.length()));
            }
            case PATTERN_CONSTRAINT: 
            case VALUE_CONSTRAINT: {
                return this.constraint.isElement(o);
            }
        }
        ErrorReporter.INTERNAL_ERROR();
        return true;
    }

    @Override
    public TernaryBool isEmpty() {
        return this.constraint.isEmpty();
    }

    @Override
    public TernaryBool isEqual(SubtypeConstraint other) {
        return this.constraint.isEqual(other);
    }

    @Override
    public TernaryBool isFull() {
        return this.constraint.isFull();
    }

    @Override
    public void toString(StringBuilder sb) {
        if (this.constraintType == ConstraintType.SIZE_CONSTRAINT) {
            sb.append("length");
        }
        this.constraint.toString(sb);
    }

    @Override
    public StringSubtypeTreeElement evaluate() {
        if (this.constraint.isEmpty() == TernaryBool.TTRUE) {
            return new EmptyStringSet(this.stringType);
        }
        if (this.constraint.isFull() == TernaryBool.TTRUE) {
            return new FullStringSet(this.stringType);
        }
        return this;
    }

    public StringSetConstraint remove(StringSubtypeTreeElement other, boolean ifElement) {
        if (this.constraintType != ConstraintType.VALUE_CONSTRAINT) {
            return this;
        }
        if (!(other instanceof StringSetConstraint)) {
            return this;
        }
        StringSetConstraint o = (StringSetConstraint)other;
        switch (o.getType()) {
            case ALPHABET_CONSTRAINT: 
            case SIZE_CONSTRAINT: {
                if (this.stringType == StringSubtypeTreeElement.StringType.CHARSTRING) {
                    StringValueConstraint svc = (StringValueConstraint)this.constraint;
                    return new StringSetConstraint(this.stringType, this.constraintType, svc.remove((RangeListConstraint)o.getConstraint(), ifElement));
                }
                UStringValueConstraint usvc = (UStringValueConstraint)this.constraint;
                return new StringSetConstraint(this.stringType, this.constraintType, usvc.remove((RangeListConstraint)o.getConstraint(), ifElement));
            }
            case PATTERN_CONSTRAINT: {
                if (this.stringType == StringSubtypeTreeElement.StringType.CHARSTRING) {
                    StringValueConstraint svc = (StringValueConstraint)this.constraint;
                    return new StringSetConstraint(this.stringType, this.constraintType, svc.remove((StringPatternConstraint)o.getConstraint(), ifElement));
                }
                UStringValueConstraint usvc = (UStringValueConstraint)this.constraint;
                return new StringSetConstraint(this.stringType, this.constraintType, usvc.remove((StringPatternConstraint)o.getConstraint(), ifElement));
            }
        }
        return this;
    }

    public static enum ConstraintType {
        SIZE_CONSTRAINT,
        ALPHABET_CONSTRAINT,
        VALUE_CONSTRAINT,
        PATTERN_CONSTRAINT;

    }
}

