/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types.subtypes;

import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.LimitType;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.RangeListConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SizeLimit;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubtypeConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.TernaryBool;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.ValueListConstraint;
import org.eclipse.titan.designer.AST.TTCN3.values.Array_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SetOf_Value;

public final class ValueListAndSizeConstraint
extends SubtypeConstraint {
    private RangeListConstraint sizeConstraint;
    private ValueListConstraint hasValues;
    private ValueListConstraint notValues;

    public ValueListAndSizeConstraint() {
        this.sizeConstraint = new RangeListConstraint(LimitType.Type.SIZE);
        this.hasValues = new ValueListConstraint();
        this.notValues = new ValueListConstraint();
    }

    public ValueListAndSizeConstraint(IValue value) {
        this.sizeConstraint = new RangeListConstraint(LimitType.Type.SIZE);
        this.hasValues = new ValueListConstraint(value);
        this.notValues = new ValueListConstraint();
    }

    public ValueListAndSizeConstraint(SizeLimit l) {
        this.sizeConstraint = new RangeListConstraint(l);
        this.hasValues = new ValueListConstraint();
        this.notValues = new ValueListConstraint();
    }

    public ValueListAndSizeConstraint(SizeLimit lBegin, SizeLimit lEnd) {
        this.sizeConstraint = new RangeListConstraint(lBegin, lEnd);
        this.hasValues = new ValueListConstraint();
        this.notValues = new ValueListConstraint();
    }

    @Override
    public ValueListAndSizeConstraint complement() {
        ValueListAndSizeConstraint returnValue = new ValueListAndSizeConstraint();
        returnValue.sizeConstraint = this.sizeConstraint.complement();
        returnValue.hasValues = this.notValues;
        returnValue.notValues = this.hasValues;
        return returnValue;
    }

    public ValueListAndSizeConstraint setOperation(SubtypeConstraint other, boolean isUnion) {
        ValueListConstraint vlc1;
        ValueListAndSizeConstraint o = (ValueListAndSizeConstraint)other;
        ValueListAndSizeConstraint returnValue = new ValueListAndSizeConstraint();
        returnValue.sizeConstraint = this.sizeConstraint.setOperation(o.sizeConstraint, isUnion);
        if (isUnion) {
            returnValue.hasValues = this.hasValues.union(o.hasValues);
            vlc1 = o.notValues.remove(this.sizeConstraint, true);
            ValueListConstraint vlc2 = this.notValues.remove(o.sizeConstraint, true);
            returnValue.notValues = vlc1.union(vlc2).union(this.notValues.intersection(o.notValues));
        } else {
            vlc1 = this.hasValues.remove(o.sizeConstraint, false).except(o.notValues);
            ValueListConstraint vlc2 = o.hasValues.remove(this.sizeConstraint, false).except(this.notValues);
            returnValue.hasValues = (ValueListConstraint)this.hasValues.intersection(o.hasValues).union(vlc1).union(vlc2);
            returnValue.notValues = this.notValues.union(o.notValues);
        }
        ValueListConstraint vlc = (ValueListConstraint)returnValue.hasValues.intersection(returnValue.notValues);
        returnValue.hasValues = returnValue.hasValues.except(vlc);
        returnValue.notValues = returnValue.notValues.except(vlc);
        returnValue.hasValues = returnValue.hasValues.remove(returnValue.sizeConstraint, true);
        returnValue.notValues = returnValue.notValues.remove(returnValue.sizeConstraint, false);
        return returnValue;
    }

    @Override
    public ValueListAndSizeConstraint intersection(SubtypeConstraint other) {
        return this.setOperation(other, false);
    }

    @Override
    public boolean isElement(Object o) {
        SizeLimit sl;
        IValue v = (IValue)o;
        switch (v.getValuetype()) {
            case ARRAY_VALUE: {
                sl = new SizeLimit(((Array_Value)v).getNofComponents());
                break;
            }
            case SEQUENCEOF_VALUE: {
                sl = new SizeLimit(((SequenceOf_Value)v).getNofComponents());
                break;
            }
            case SETOF_VALUE: {
                sl = new SizeLimit(((SetOf_Value)v).getNofComponents());
                break;
            }
            default: {
                ErrorReporter.INTERNAL_ERROR();
                return true;
            }
        }
        if (this.sizeConstraint.isElement(sl)) {
            return !this.notValues.isElement(v);
        }
        return this.hasValues.isElement(v);
    }

    @Override
    public TernaryBool isEmpty() {
        if (this.sizeConstraint.isEmpty() == TernaryBool.TTRUE && this.hasValues.isEmpty() == TernaryBool.TTRUE) {
            return TernaryBool.TTRUE;
        }
        if (this.hasValues.isEmpty() == TernaryBool.TFALSE) {
            return TernaryBool.TFALSE;
        }
        if (this.notValues.isEmpty() == TernaryBool.TTRUE) {
            return TernaryBool.TFALSE;
        }
        return TernaryBool.TUNKNOWN;
    }

    @Override
    public TernaryBool isEqual(SubtypeConstraint other) {
        ValueListAndSizeConstraint o = (ValueListAndSizeConstraint)other;
        if (this.sizeConstraint.isEqual(o.sizeConstraint) == TernaryBool.TTRUE && this.hasValues.isEqual(o.hasValues) == TernaryBool.TTRUE && this.notValues.isEqual(o.notValues) == TernaryBool.TTRUE) {
            return TernaryBool.TTRUE;
        }
        return TernaryBool.TUNKNOWN;
    }

    @Override
    public TernaryBool isFull() {
        if (this.sizeConstraint.isFull() == TernaryBool.TTRUE && this.notValues.isEmpty() == TernaryBool.TTRUE) {
            return TernaryBool.TTRUE;
        }
        if (this.notValues.isEmpty() == TernaryBool.TFALSE) {
            return TernaryBool.TFALSE;
        }
        return TernaryBool.TUNKNOWN;
    }

    @Override
    public void toString(StringBuilder sb) {
        boolean hv;
        boolean bl = hv = this.hasValues.isEmpty() != TernaryBool.TTRUE;
        if (hv) {
            this.hasValues.toString(sb);
        }
        if (this.sizeConstraint.isEmpty() != TernaryBool.TTRUE) {
            if (hv) {
                sb.append(" UNION ");
            }
            sb.append("length");
            this.sizeConstraint.toString(sb);
        }
        if (this.notValues.isEmpty() != TernaryBool.TTRUE) {
            sb.append(" EXCEPT ");
            this.notValues.toString(sb);
        }
    }

    @Override
    public ValueListAndSizeConstraint union(SubtypeConstraint other) {
        return this.setOperation(other, true);
    }
}

