/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.values.ISO2022String_Value;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.types.CharString_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalChar;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Charstring_Value
extends Value {
    private static final String QUADRUPLEPROBLEM = "This string value cannot contain multiple-byte characters, but it has quadruple char({0},{1},{2},{3}) at index {4}";
    private static final String CHARACTERCODEPROBLEM = "This string value may not contain characters with code higher than 127, but it has character with code {0} at index {1}";
    private final String value;

    public Charstring_Value(String value) {
        this.value = value;
    }

    public static Charstring_Value convert(CompilationTimeStamp timestamp, UniversalCharstring_Value original) {
        UniversalCharstring oldString = original.getValue();
        if (oldString == null) {
            original.setIsErroneous(true);
            Charstring_Value target = new Charstring_Value(null);
            target.copyGeneralProperties(original);
            return target;
        }
        boolean warning = false;
        for (int i = 0; i < oldString.length() && !original.getIsErroneous(timestamp); ++i) {
            UniversalChar uchar = oldString.get(i);
            if (uchar.group() != 0 || uchar.plane() != 0 || uchar.row() != 0) {
                original.getLocation().reportSemanticError(MessageFormat.format(QUADRUPLEPROBLEM, uchar.group(), uchar.plane(), uchar.row(), uchar.cell(), i));
                original.setIsErroneous(true);
                continue;
            }
            if (uchar.cell() <= 127 || warning) continue;
            original.getLocation().reportSemanticWarning(MessageFormat.format(CHARACTERCODEPROBLEM, uchar.cell(), i));
        }
        Charstring_Value target = original.getIsErroneous(timestamp) ? new Charstring_Value(null) : new Charstring_Value(oldString.getString());
        target.copyGeneralProperties(original);
        return target;
    }

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.CHARSTRING_VALUE;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_CHARSTRING;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append('\"').append(this.value).append('\"');
        return builder.toString();
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.myGovernor != null) {
            return this.myGovernor;
        }
        return new CharString_Type();
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                Value arrayIndex = ((ArraySubReference)subreference).getValue();
                IValue valueIndex = arrayIndex.getValueRefdLast(timestamp, refChain);
                if (!valueIndex.isUnfoldable(timestamp)) {
                    if (IValue.Value_type.INTEGER_VALUE.equals((Object)valueIndex.getValuetype())) {
                        int index = ((Integer_Value)valueIndex).intValue();
                        return this.getStringElement(index, arrayIndex.getLocation());
                    }
                    arrayIndex.getLocation().reportSemanticError("An integer value was expected as index");
                    return null;
                }
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), type.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError("Invalid reference: internal parameterisation is not supported");
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return false;
    }

    public String getValue() {
        return this.value;
    }

    public int getValueLength() {
        if (this.value == null || this.isErroneous) {
            return 0;
        }
        return this.value.length();
    }

    public Charstring_Value getStringElement(int index, Location location) {
        if (this.value == null) {
            return null;
        }
        if (index < 0) {
            location.reportSemanticError(MessageFormat.format("A non-negative integer value was expected instead of {0} for indexing a string element", index));
            return null;
        }
        if (index >= this.value.length()) {
            location.reportSemanticError(MessageFormat.format("Index overflow when accessing a string element: the index is {0}, but the string has only {1} elements", index, this.value.length()));
            return null;
        }
        return new Charstring_Value(this.value.substring(index, index + 1));
    }

    @Override
    public Value setValuetype(CompilationTimeStamp timestamp, IValue.Value_type newType) {
        switch (newType) {
            case UNIVERSALCHARSTRING_VALUE: {
                return new UniversalCharstring_Value(this);
            }
            case ISO2022STRING_VALUE: {
                return new ISO2022String_Value(this);
            }
        }
        return super.setValuetype(timestamp, newType);
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = other.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        switch (last.getValuetype()) {
            case CHARSTRING_VALUE: {
                return this.value.equals(((Charstring_Value)last).getValue());
            }
            case UNIVERSALCHARSTRING_VALUE: {
                return this.value.equals(((UniversalCharstring_Value)last).getValue().getString());
            }
            case ISO2022STRING_VALUE: {
                return this.value.equals(((ISO2022String_Value)last).getValueISO2022String());
            }
        }
        return false;
    }

    @Override
    public boolean evaluateIsvalue(boolean fromSequence) {
        return true;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return true;
    }
}

