/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Choice_Type;
import org.eclipse.titan.designer.AST.ASN1.types.Open_Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Choice_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValue;
import org.eclipse.titan.designer.AST.TTCN3.values.Sequence_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Choice_Value
extends Value {
    private static final String ONEFIELDEXPECTED1 = "Union value must have one active field";
    private static final String ONEFIELDEXPECTED2 = "Only one field was expected in union value istead of {0}";
    private static final String NONEXISTENTFIELD = "Reference to non-existent union field `{0}'' in type `{1}''";
    private static final String INACTIVEFIELD = "Reference to inactive field `{0}'' in a value of union type `{1}''. The active field is `{2}''";
    private final Identifier name;
    private final IValue value;

    public Choice_Value(Identifier name, IValue value) {
        this.name = name;
        this.value = value;
    }

    public Choice_Value(CompilationTimeStamp timestamp, Sequence_Value value) {
        this.copyGeneralProperties(value);
        int valueSize = value.getNofComponents();
        if (valueSize < 1) {
            this.name = null;
            this.value = null;
            value.getLocation().reportSemanticError(ONEFIELDEXPECTED1);
            this.setIsErroneous(true);
            this.lastTimeChecked = timestamp;
        } else if (valueSize > 1) {
            this.name = null;
            this.value = null;
            value.getLocation().reportSemanticError(MessageFormat.format(ONEFIELDEXPECTED2, valueSize));
            this.setIsErroneous(true);
            this.lastTimeChecked = timestamp;
        } else {
            NamedValue namedValue = value.getSeqValueByIndex(0);
            this.name = namedValue.getName();
            this.value = namedValue.getValue();
        }
    }

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.CHOICE_VALUE;
    }

    public Identifier getName() {
        return this.name;
    }

    public IValue getValue() {
        return this.value;
    }

    public boolean hasComponentWithName(Identifier name) {
        return this.name.getDisplayName().equals(name.getDisplayName());
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        if (this.isAsn()) {
            builder.append(this.name.getDisplayName()).append(" : ");
            builder.append(this.value.createStringRepresentation());
        } else {
            builder.append('{').append(this.name.getDisplayName()).append(" := ");
            builder.append(this.value.createStringRepresentation()).append('}');
        }
        return builder.toString();
    }

    public boolean fieldIsChosen(Identifier name) {
        if (this.value == null) {
            return false;
        }
        return this.name.equals(name);
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        if (type.getIsErroneous(timestamp)) {
            return null;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid array element reference: type `{0}'' can not be indexed", type.getTypename()));
                return null;
            }
            case fieldSubReference: {
                Identifier fieldId = ((FieldSubReference)subreference).getId();
                switch (type.getTypetype()) {
                    case TYPE_TTCN3_CHOICE: {
                        if (((TTCN3_Choice_Type)type).hasComponentWithName(fieldId.getName())) break;
                        subreference.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTFIELD, fieldId.getDisplayName(), type.getTypename()));
                        return null;
                    }
                    case TYPE_ASN1_CHOICE: {
                        if (((ASN1_Choice_Type)type).hasComponentWithName(fieldId)) break;
                        subreference.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTFIELD, fieldId.getDisplayName(), type.getTypename()));
                        return null;
                    }
                    case TYPE_OPENTYPE: {
                        if (((Open_Type)type).hasComponentWithName(fieldId)) break;
                        subreference.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTFIELD, fieldId.getDisplayName(), type.getTypename()));
                        return null;
                    }
                    default: {
                        return null;
                    }
                }
                if (this.name.getDisplayName().equals(fieldId.getDisplayName())) {
                    return this.value.getReferencedSubValue(timestamp, reference, actualSubReference + 1, refChain);
                }
                if (!reference.getUsedInIsbound()) {
                    subreference.getLocation().reportSemanticError(MessageFormat.format(INACTIVEFIELD, fieldId.getDisplayName(), type.getTypename(), this.name.getDisplayName()));
                }
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError("Invalid reference: internal parameterisation is not supported");
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value == null) {
            return true;
        }
        return this.value.isUnfoldable(timestamp, expectedValue, referenceChain);
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value == child) {
            builder.append('.').append(this.name.getDisplayName());
        }
        return builder;
    }

    @Override
    public boolean evaluateIsvalue(boolean fromSequence) {
        if (this.value == null) {
            return true;
        }
        return this.value.evaluateIsvalue(false);
    }

    @Override
    public boolean evaluateIsbound(CompilationTimeStamp timestamp, Reference reference, int actualSubReference) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return true;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        if (type.getIsErroneous(timestamp)) {
            return false;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                return false;
            }
            case fieldSubReference: {
                Identifier fieldId = ((FieldSubReference)subreference).getId();
                switch (type.getTypetype()) {
                    case TYPE_TTCN3_CHOICE: {
                        if (((TTCN3_Choice_Type)type).hasComponentWithName(fieldId.getName())) break;
                        return false;
                    }
                    case TYPE_ASN1_CHOICE: {
                        if (((ASN1_Choice_Type)type).hasComponentWithName(fieldId)) break;
                        return false;
                    }
                    case TYPE_OPENTYPE: {
                        if (((Open_Type)type).hasComponentWithName(fieldId)) break;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
                if (this.name.getDisplayName().equals(fieldId.getDisplayName())) {
                    return this.value.evaluateIsbound(timestamp, reference, actualSubReference + 1);
                }
                return false;
            }
            case parameterisedSubReference: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean evaluateIspresent(CompilationTimeStamp timestamp, Reference reference, int actualSubReference) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return true;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        if (type.getIsErroneous(timestamp)) {
            return false;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                return false;
            }
            case fieldSubReference: {
                Identifier fieldId = ((FieldSubReference)subreference).getId();
                switch (type.getTypetype()) {
                    case TYPE_TTCN3_CHOICE: {
                        if (((TTCN3_Choice_Type)type).hasComponentWithName(fieldId.getName())) break;
                        return false;
                    }
                    case TYPE_ASN1_CHOICE: {
                        if (((ASN1_Choice_Type)type).hasComponentWithName(fieldId)) break;
                        return false;
                    }
                    case TYPE_OPENTYPE: {
                        if (((Open_Type)type).hasComponentWithName(fieldId)) break;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
                if (this.name.getDisplayName().equals(fieldId.getDisplayName())) {
                    return this.value.evaluateIspresent(timestamp, reference, actualSubReference + 1);
                }
                return false;
            }
            case parameterisedSubReference: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = other.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        if (!IValue.Value_type.CHOICE_VALUE.equals((Object)last.getValuetype())) {
            return false;
        }
        Choice_Value otherChoice = (Choice_Value)last;
        return this.name.equals(otherChoice.name) && this.value.checkEquality(timestamp, otherChoice.value);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value == null) {
            return;
        }
        this.value.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.name != null && !this.name.accept(v)) {
            return false;
        }
        return this.value == null || this.value.accept(v);
    }
}

