/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.IsValueExpression;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class EncodeExpression
extends Expression_Value {
    private static final String OPERANDERROR1 = "Cannot determine the argument type of `encvalue' operation";
    private static final String OPERANDERROR2 = "The operand of the `encvalue' operation cannot be encoded";
    private final TemplateInstance templateInstance;

    public EncodeExpression(TemplateInstance templateInstance) {
        this.templateInstance = templateInstance;
        if (templateInstance != null) {
            templateInstance.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.ENCODE_OPERATION;
    }

    @Override
    public String createStringRepresentation() {
        if (this.templateInstance == null) {
            return "<erroneous value>";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("encvalue(").append(this.templateInstance.createStringRepresentation()).append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.templateInstance != null) {
            this.templateInstance.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.templateInstance == child) {
            return builder.append(".<operand>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_BITSTRING;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.templateInstance == null) {
            this.setIsErroneous(true);
            return;
        }
        Expected_Value_type internalExpectation = Expected_Value_type.EXPECTED_DYNAMIC_VALUE.equals((Object)expectedValue) ? Expected_Value_type.EXPECTED_TEMPLATE : expectedValue;
        IType type = this.templateInstance.getExpressionGovernor(timestamp, internalExpectation);
        if (type == null) {
            ITTCN3Template template = this.templateInstance.getTemplateBody().setLoweridToReference(timestamp);
            type = template.getExpressionGovernor(timestamp, internalExpectation);
        }
        if (type == null) {
            this.templateInstance.getLocation().reportSemanticError(OPERANDERROR1);
            this.setIsErroneous(true);
            return;
        }
        IsValueExpression.checkExpressionTemplateInstance(timestamp, this, this.templateInstance, type, referenceChain, expectedValue);
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        this.templateInstance.getTemplateBody().checkSpecificValue(timestamp, false);
        type = type.getTypeRefdLast(timestamp);
        switch (type.getTypetype()) {
            case TYPE_UNDEFINED: 
            case TYPE_NULL: 
            case TYPE_REFERENCED: 
            case TYPE_VERDICT: 
            case TYPE_PORT: 
            case TYPE_COMPONENT: 
            case TYPE_DEFAULT: 
            case TYPE_SIGNATURE: 
            case TYPE_FUNCTION: 
            case TYPE_ALTSTEP: 
            case TYPE_TESTCASE: {
                if (this.isErroneous) break;
                this.location.reportSemanticError(OPERANDERROR2);
                this.setIsErroneous(true);
                break;
            }
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.templateInstance != null) {
            this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        }
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this) && this.templateInstance != null) {
            referenceChain.markState();
            this.templateInstance.checkRecursions(timestamp, referenceChain);
            referenceChain.previousState();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.templateInstance != null) {
            this.templateInstance.updateSyntax(reparser, false);
            reparser.updateLocation(this.templateInstance.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.templateInstance == null) {
            return;
        }
        this.templateInstance.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.templateInstance == null || this.templateInstance.accept(v);
    }
}

