/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Undefined_LowerIdentifier_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class ExpressionUtilities {
    private static final String UNDETERMINABLEOPERANDSERROR = "Cannot determine the type of the operands";
    private static final String INCOMPATIBLEOPERANDERROR = "The operands should be of compatible types";
    private static final String PLEASEUSEREFERENCES = "Please use references as operands";
    private static final String TYPECOMPATWARNING = "Type compatibility between `{0}'' and `{1}''";
    private static String typeCompatibilitySeverity = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportTypeCompatibility", "warning", null);

    private ExpressionUtilities() {
    }

    public static void checkExpressionOperatorCompatibility(CompilationTimeStamp timestamp, Expression_Value expression, IReferenceChain referenceChain, Expected_Value_type expectedValue, Value operand1, Value operand2) {
        if (expression == null || operand1 == null || operand2 == null) {
            return;
        }
        operand1.setIsErroneous(false);
        operand2.setIsErroneous(false);
        boolean governor1set = operand1.getMyGovernor() != null;
        boolean governor2set = operand2.getMyGovernor() != null;
        ExpressionUtilities.checkExpressionOperatorCompatibilityInternal(timestamp, expression, referenceChain, expectedValue, (IValue)operand1, operand2);
        if (!governor1set) {
            operand1.setMyGovernor(null);
        }
        if (!governor2set) {
            operand2.setMyGovernor(null);
        }
    }

    public static void checkExpressionOperatorCompatibility(CompilationTimeStamp timestamp, Expression_Value expression, IReferenceChain referenceChain, Expected_Value_type expectedValue, Value operand1, TemplateInstance operand2) {
        if (expression == null || operand1 == null || operand2 == null) {
            return;
        }
        operand1.setIsErroneous(false);
        operand2.getTemplateBody().setIsErroneous(false);
        boolean governor1set = operand1.getMyGovernor() != null;
        boolean governor2set = operand2.getTemplateBody().getMyGovernor() != null;
        ExpressionUtilities.checkExpressionOperatorCompatibilityInternal(timestamp, expression, referenceChain, expectedValue, (IValue)operand1, operand2);
        if (!governor1set) {
            operand1.setMyGovernor(null);
        }
        if (!governor2set) {
            operand2.getTemplateBody().setMyGovernor(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void checkExpressionOperatorCompatibilityInternal(CompilationTimeStamp timestamp, Expression_Value expression, IReferenceChain referenceChain, Expected_Value_type expectedValue, IValue param1, IValue param2) {
        if (expression == null) return;
        if (param1 == null) return;
        if (param2 == null) {
            return;
        }
        if (param1.getIsErroneous(timestamp) || param2.getIsErroneous(timestamp)) {
            expression.setIsErroneous(true);
            return;
        }
        IValue operand1 = param1;
        IValue operand2 = param2;
        IType.Type_type tempType1 = operand1.getExpressionReturntype(timestamp, expectedValue);
        IType.Type_type tempType2 = operand2.getExpressionReturntype(timestamp, expectedValue);
        if (IType.Type_type.TYPE_UNDEFINED.equals((Object)tempType1)) {
            if (IType.Type_type.TYPE_UNDEFINED.equals((Object)tempType2)) {
                if (IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)operand1.getValuetype())) {
                    if (!IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)operand2.getValuetype())) {
                        operand1 = operand1.setLoweridToReference(timestamp);
                        ExpressionUtilities.checkExpressionOperatorCompatibilityInternal(timestamp, expression, referenceChain, expectedValue, operand1, operand2);
                        return;
                    }
                    Scope scope = expression.getMyScope();
                    Module module = scope.getModuleScope();
                    Identifier identifier = ((Undefined_LowerIdentifier_Value)operand1).getIdentifier();
                    if (scope.hasAssignmentWithId(timestamp, identifier) || module.hasImportedAssignmentWithID(timestamp, identifier)) {
                        operand1 = operand1.setLoweridToReference(timestamp);
                        ExpressionUtilities.checkExpressionOperatorCompatibilityInternal(timestamp, expression, referenceChain, expectedValue, operand1, operand2);
                        return;
                    }
                    Identifier identifier2 = ((Undefined_LowerIdentifier_Value)operand2).getIdentifier();
                    if (scope.hasAssignmentWithId(timestamp, identifier2) || module.hasImportedAssignmentWithID(timestamp, identifier2)) {
                        operand2 = operand2.setLoweridToReference(timestamp);
                        ExpressionUtilities.checkExpressionOperatorCompatibilityInternal(timestamp, expression, referenceChain, expectedValue, operand1, operand2);
                        return;
                    }
                } else if (IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)operand2.getValuetype())) {
                    operand2 = operand2.setLoweridToReference(timestamp);
                    ExpressionUtilities.checkExpressionOperatorCompatibilityInternal(timestamp, expression, referenceChain, expectedValue, operand1, operand2);
                    return;
                }
                if (!operand1.getIsErroneous(timestamp) && !operand2.getIsErroneous(timestamp)) {
                    expression.getLocation().reportSemanticError(UNDETERMINABLEOPERANDSERROR);
                    expression.setIsErroneous(true);
                    return;
                }
                expression.setIsErroneous(true);
                return;
            }
            if (IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)operand1.getValuetype()) && !IType.Type_type.TYPE_TTCN3_ENUMERATED.equals((Object)tempType2)) {
                operand1 = operand1.setLoweridToReference(timestamp);
                ExpressionUtilities.checkExpressionOperatorCompatibilityInternal(timestamp, expression, referenceChain, expectedValue, operand1, operand2);
                return;
            }
        } else if (IType.Type_type.TYPE_UNDEFINED.equals((Object)tempType2) && IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)operand2.getValuetype()) && !IType.Type_type.TYPE_TTCN3_ENUMERATED.equals((Object)tempType1)) {
            operand2 = operand2.setLoweridToReference(timestamp);
            ExpressionUtilities.checkExpressionOperatorCompatibilityInternal(timestamp, expression, referenceChain, expectedValue, operand1, operand2);
            return;
        }
        IType type1 = operand1.getExpressionGovernor(timestamp, expectedValue);
        IType type2 = operand2.getExpressionGovernor(timestamp, expectedValue);
        if (operand1.getIsErroneous(timestamp) || operand2.getIsErroneous(timestamp)) {
            expression.setIsErroneous(true);
            return;
        }
        if (type1 != null) {
            if (type2 != null) {
                TypeCompatibilityInfo info1 = new TypeCompatibilityInfo(type1, type2, true);
                TypeCompatibilityInfo info2 = new TypeCompatibilityInfo(type2, type1, true);
                boolean retVal1 = type1.isCompatible(timestamp, type2, info1, null, null);
                boolean retVal2 = type2.isCompatible(timestamp, type1, info2, null, null);
                if (!retVal1 && !retVal2) {
                    expression.getLocation().reportSemanticError(info1.toString());
                    expression.setIsErroneous(true);
                    return;
                }
                if (!"warning".equals(typeCompatibilitySeverity)) return;
                if (info1.getNeedsConversion()) {
                    expression.getLocation().reportSemanticWarning(MessageFormat.format(TYPECOMPATWARNING, type1.getTypename(), type2.getTypename()));
                    return;
                }
                if (!info2.getNeedsConversion()) return;
                expression.getLocation().reportSemanticWarning(MessageFormat.format(TYPECOMPATWARNING, type2.getTypename(), type1.getTypename()));
                return;
            }
            operand2.setMyGovernor(type1);
            IValue tempValue = type1.checkThisValueRef(timestamp, operand2);
            if (IValue.Value_type.OMIT_VALUE.equals((Object)operand2.getValuetype())) {
                operand1.checkExpressionOmitComparison(timestamp, expectedValue);
                return;
            }
            type1.checkThisValue(timestamp, tempValue, new IType.ValueCheckingOptions(expectedValue, false, false, false, false, false));
            ExpressionUtilities.checkExpressionOperatorCompatibilityInternal(timestamp, expression, referenceChain, expectedValue, operand1, tempValue);
            return;
        }
        if (type2 != null) {
            operand1.setMyGovernor(type2);
            IValue tempValue = type2.checkThisValueRef(timestamp, operand1);
            if (IValue.Value_type.OMIT_VALUE.equals((Object)operand1.getValuetype())) {
                operand2.checkExpressionOmitComparison(timestamp, expectedValue);
                return;
            }
            type2.checkThisValue(timestamp, tempValue, new IType.ValueCheckingOptions(expectedValue, false, false, false, false, false));
            ExpressionUtilities.checkExpressionOperatorCompatibilityInternal(timestamp, expression, referenceChain, expectedValue, tempValue, operand2);
            return;
        }
        if (!IType.Type_type.TYPE_UNDEFINED.equals((Object)tempType1) && !IType.Type_type.TYPE_UNDEFINED.equals((Object)tempType2)) {
            if (Type.isCompatible(timestamp, tempType1, tempType2, false, false)) return;
            if (Type.isCompatible(timestamp, tempType2, tempType1, false, false)) return;
            expression.getLocation().reportSemanticError(INCOMPATIBLEOPERANDERROR);
            expression.setIsErroneous(true);
            return;
        }
        expression.getLocation().reportSemanticError(PLEASEUSEREFERENCES);
        expression.setIsErroneous(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void checkExpressionOperatorCompatibilityInternal(CompilationTimeStamp timestamp, Expression_Value expression, IReferenceChain referenceChain, Expected_Value_type expectedValue, IValue param1, TemplateInstance param2) {
        if (expression == null) return;
        if (param1 == null) return;
        if (param2 == null) {
            return;
        }
        if (param1.getIsErroneous(timestamp) || param2.getTemplateBody().getIsErroneous(timestamp)) {
            expression.setIsErroneous(true);
            return;
        }
        IValue operand1 = param1;
        TemplateInstance operand2 = param2;
        IType.Type_type tempType1 = operand1.getExpressionReturntype(timestamp, expectedValue);
        IType.Type_type tempType2 = operand2.getExpressionReturntype(timestamp, expectedValue);
        ITTCN3Template temp2 = operand2.getTemplateBody();
        if (IType.Type_type.TYPE_UNDEFINED.equals((Object)tempType1)) {
            if (IType.Type_type.TYPE_UNDEFINED.equals((Object)tempType2)) {
                block26: {
                    if (IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)operand1.getValuetype())) {
                        if (ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)temp2.getTemplatetype()) && IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)((SpecificValue_Template)temp2).getSpecificValue().getValuetype())) {
                            Scope scope = expression.getMyScope();
                            Module module = scope.getModuleScope();
                            Identifier identifier = ((Undefined_LowerIdentifier_Value)operand1).getIdentifier();
                            if (scope.hasAssignmentWithId(timestamp, identifier) || module.hasImportedAssignmentWithID(timestamp, identifier)) {
                                operand1 = operand1.setLoweridToReference(timestamp);
                                ExpressionUtilities.checkExpressionOperatorCompatibilityInternal(timestamp, expression, referenceChain, expectedValue, operand1, operand2);
                                return;
                            }
                            Identifier identifier2 = ((Undefined_LowerIdentifier_Value)((SpecificValue_Template)temp2).getSpecificValue()).getIdentifier();
                            if (scope.hasAssignmentWithId(timestamp, identifier2) || module.hasImportedAssignmentWithID(timestamp, identifier2)) {
                                temp2 = temp2.setLoweridToReference(timestamp);
                                ExpressionUtilities.checkExpressionOperatorCompatibilityInternal(timestamp, expression, referenceChain, expectedValue, operand1, operand2);
                                return;
                            }
                            break block26;
                        } else {
                            operand1 = operand1.setLoweridToReference(timestamp);
                            ExpressionUtilities.checkExpressionOperatorCompatibilityInternal(timestamp, expression, referenceChain, expectedValue, operand1, operand2);
                            return;
                        }
                    }
                    if (ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)temp2.getTemplatetype()) && IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)((SpecificValue_Template)temp2).getSpecificValue().getValuetype())) {
                        temp2 = temp2.setLoweridToReference(timestamp);
                        TemplateInstance tempTemplateInstance2 = new TemplateInstance(operand2.getType(), operand2.getDerivedReference(), (TTCN3Template)temp2);
                        if (operand2 == tempTemplateInstance2) {
                            return;
                        }
                        ExpressionUtilities.checkExpressionOperatorCompatibilityInternal(timestamp, expression, referenceChain, expectedValue, operand1, tempTemplateInstance2);
                        return;
                    }
                }
                if (!operand1.getIsErroneous(timestamp) && !temp2.getIsErroneous(timestamp)) {
                    expression.getLocation().reportSemanticError(UNDETERMINABLEOPERANDSERROR);
                    expression.setIsErroneous(true);
                    return;
                }
                expression.setIsErroneous(true);
                return;
            }
            if (IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)operand1.getValuetype()) && !IType.Type_type.TYPE_TTCN3_ENUMERATED.equals((Object)tempType2)) {
                operand1 = operand1.setLoweridToReference(timestamp);
                ExpressionUtilities.checkExpressionOperatorCompatibilityInternal(timestamp, expression, referenceChain, expectedValue, operand1, operand2);
                return;
            }
        } else if (IType.Type_type.TYPE_UNDEFINED.equals((Object)tempType2) && ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)temp2.getTemplatetype()) && IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)((SpecificValue_Template)temp2).getSpecificValue().getValuetype()) && !IType.Type_type.TYPE_TTCN3_ENUMERATED.equals((Object)tempType1)) {
            temp2 = temp2.setLoweridToReference(timestamp);
            TemplateInstance tempTemplateInstance2 = new TemplateInstance(operand2.getType(), operand2.getDerivedReference(), (TTCN3Template)temp2);
            if (operand2 == tempTemplateInstance2) {
                return;
            }
            ExpressionUtilities.checkExpressionOperatorCompatibilityInternal(timestamp, expression, referenceChain, expectedValue, operand1, tempTemplateInstance2);
            return;
        }
        IType type1 = operand1.getExpressionGovernor(timestamp, expectedValue);
        IType type2 = operand2.getExpressionGovernor(timestamp, expectedValue);
        if (operand1.getIsErroneous(timestamp) || temp2.getIsErroneous(timestamp)) {
            expression.setIsErroneous(true);
            return;
        }
        if (type1 != null) {
            if (type2 != null) {
                TypeCompatibilityInfo info1 = new TypeCompatibilityInfo(type1, type2, true);
                TypeCompatibilityInfo info2 = new TypeCompatibilityInfo(type2, type1, true);
                boolean retVal1 = type1.isCompatible(timestamp, type2, info1, null, null);
                boolean retVal2 = type2.isCompatible(timestamp, type1, info2, null, null);
                if (!retVal1 && !retVal2) {
                    expression.getLocation().reportSemanticError(info1.toString());
                    expression.setIsErroneous(true);
                    return;
                }
                if (!"warning".equals(typeCompatibilitySeverity)) return;
                if (info1.getNeedsConversion()) {
                    expression.getLocation().reportSemanticWarning(MessageFormat.format(TYPECOMPATWARNING, type1.getTypename(), type2.getTypename()));
                    return;
                }
                if (!info2.getNeedsConversion()) return;
                expression.getLocation().reportSemanticWarning(MessageFormat.format(TYPECOMPATWARNING, type2.getTypename(), type1.getTypename()));
                return;
            }
            temp2.setMyGovernor(type1);
            ITTCN3Template tempValue = type1.checkThisTemplateRef(timestamp, temp2);
            if (ITTCN3Template.Template_type.OMIT_VALUE.equals((Object)temp2.getTemplatetype()) || ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)temp2.getTemplatetype()) && IValue.Value_type.OMIT_VALUE.equals((Object)((SpecificValue_Template)temp2).getSpecificValue().getValuetype())) {
                operand1.checkExpressionOmitComparison(timestamp, expectedValue);
                return;
            }
            type1.checkThisTemplate(timestamp, (TTCN3Template)tempValue, false, false);
            TemplateInstance tempTemplateInstance2 = new TemplateInstance(operand2.getType(), operand2.getDerivedReference(), (TTCN3Template)tempValue);
            if (operand2 == tempTemplateInstance2) {
                return;
            }
            ExpressionUtilities.checkExpressionOperatorCompatibilityInternal(timestamp, expression, referenceChain, expectedValue, operand1, tempTemplateInstance2);
            return;
        }
        if (type2 != null) {
            operand1.setMyGovernor(type2);
            IValue tempValue = type2.checkThisValueRef(timestamp, operand1);
            if (IValue.Value_type.OMIT_VALUE.equals((Object)operand1.getValuetype())) {
                return;
            }
            type2.checkThisValue(timestamp, tempValue, new IType.ValueCheckingOptions(expectedValue, false, false, false, false, false));
            ExpressionUtilities.checkExpressionOperatorCompatibilityInternal(timestamp, expression, referenceChain, expectedValue, tempValue, operand2);
            return;
        }
        if (!IType.Type_type.TYPE_UNDEFINED.equals((Object)tempType1) && !IType.Type_type.TYPE_UNDEFINED.equals((Object)tempType2)) {
            if (Type.isCompatible(timestamp, tempType1, tempType2, false, false)) return;
            if (Type.isCompatible(timestamp, tempType2, tempType1, false, false)) return;
            expression.getLocation().reportSemanticError(INCOMPATIBLEOPERANDERROR);
            expression.setIsErroneous(true);
            return;
        }
        expression.getLocation().reportSemanticError(PLEASEUSEREFERENCES);
        expression.setIsErroneous(true);
    }

    static {
        Activator activator = Activator.getDefault();
        if (activator != null) {
            activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if ("org.eclipse.titan.designer.reportTypeCompatibility".equals(property)) {
                        typeCompatibilitySeverity = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportTypeCompatibility", "warning", null);
                    }
                }
            });
        }
    }
}

