/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.Bitstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Hexstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Octetstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ShiftRightExpression;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ShiftLeftExpression
extends Expression_Value {
    private static final String FIRSTOPERANDERROR = "The first operand of the `<<' operation should be a binary string value";
    private static final String SECONDOPERANDERROR = "The second operand of the `<<' operation should be an integer value";
    private static final String NEGATIVESHIFTPROBLEM = "Shifting to the right should be used instead of shifting to the left with a negative value";
    private static final String ZEROSHIFTPROBLEM = "Shifting to the left with 0 will not change the original value";
    private static final String TOOBIGSHIFTPROBLEM = "Shifting a {0} long string to the left with {1} will always result in a string of same size, but filled with '0' -s.";
    private static final String LARGEINTEGERSECONDOPERANDERROR = "Using a large integer value ({0}) as the second operand of the `<<'' operation is not supported";
    private final Value value1;
    private final Value value2;

    public ShiftLeftExpression(Value value1, Value value2) {
        this.value1 = value1;
        this.value2 = value2;
        if (value1 != null) {
            value1.setFullNameParent(this);
        }
        if (value2 != null) {
            value2.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.SHIFTLEFT_OPERATION;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append('(').append(this.value1.createStringRepresentation());
        builder.append(" << ");
        builder.append(this.value2.createStringRepresentation()).append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value1 != null) {
            this.value1.setMyScope(scope);
        }
        if (this.value2 != null) {
            this.value2.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value1 == child) {
            return builder.append(".<operand1>");
        }
        if (this.value2 == child) {
            return builder.append(".<operand2>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        IValue last = this.getValueRefdLast(timestamp, expectedValue, null);
        if (last == null || this.value1 == null) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        if (last.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return IType.Type_type.TYPE_UNDEFINED;
        }
        this.value1.setLoweridToReference(timestamp);
        IType.Type_type tempType = this.value1.getExpressionReturntype(timestamp, expectedValue);
        switch (tempType) {
            case TYPE_BITSTRING: 
            case TYPE_HEXSTRING: 
            case TYPE_OCTETSTRING: {
                return tempType;
            }
            case TYPE_UNDEFINED: {
                return tempType;
            }
        }
        this.setIsErroneous(true);
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value1 == null || this.value2 == null || this.getIsErroneous(timestamp)) {
            return true;
        }
        return this.value1.isUnfoldable(timestamp, expectedValue, referenceChain) || this.value2.isUnfoldable(timestamp, expectedValue, referenceChain);
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        IValue tempValue;
        IType.Type_type tempType1 = null;
        IType.Type_type tempType2 = null;
        long stringSize = 0L;
        long shiftSize = 0L;
        if (this.value1 != null) {
            this.value1.setLoweridToReference(timestamp);
            tempType1 = this.value1.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType1) {
                case TYPE_BITSTRING: {
                    tempValue = this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (!IValue.Value_type.BITSTRING_VALUE.equals((Object)tempValue.getValuetype())) break;
                    stringSize = ((Bitstring_Value)tempValue).getValueLength();
                    break;
                }
                case TYPE_HEXSTRING: {
                    tempValue = this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (!IValue.Value_type.HEXSTRING_VALUE.equals((Object)tempValue.getValuetype())) break;
                    stringSize = ((Hexstring_Value)tempValue).getValueLength();
                    break;
                }
                case TYPE_OCTETSTRING: {
                    tempValue = this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (!IValue.Value_type.OCTETSTRING_VALUE.equals((Object)tempValue.getValuetype())) break;
                    stringSize = ((Octetstring_Value)tempValue).getValueLength();
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.location.reportSemanticError(FIRSTOPERANDERROR);
                    this.setIsErroneous(true);
                }
            }
        }
        if (this.value2 != null) {
            this.value2.setLoweridToReference(timestamp);
            tempType2 = this.value2.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType2) {
                case TYPE_INTEGER: {
                    tempValue = this.value2.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (!IValue.Value_type.INTEGER_VALUE.equals((Object)tempValue.getValuetype()) || this.getIsErroneous(timestamp)) break;
                    if (!((Integer_Value)tempValue).isNative()) {
                        this.value2.getLocation().reportSemanticError(MessageFormat.format(LARGEINTEGERSECONDOPERANDERROR, tempValue));
                        this.setIsErroneous(true);
                        break;
                    }
                    shiftSize = ((Integer_Value)tempValue).getValue();
                    if (this.value1 == null || this.value1.isUnfoldable(timestamp)) break;
                    String severity = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportIncorrectShiftRotateSize", "warning", null);
                    if (shiftSize < 0L) {
                        this.location.reportConfigurableSemanticProblem(severity, NEGATIVESHIFTPROBLEM);
                        break;
                    }
                    if (shiftSize == 0L) {
                        this.location.reportConfigurableSemanticProblem(severity, ZEROSHIFTPROBLEM);
                        break;
                    }
                    if (shiftSize <= stringSize) break;
                    this.location.reportConfigurableSemanticProblem(severity, MessageFormat.format(TOOBIGSHIFTPROBLEM, stringSize, shiftSize));
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.location.reportSemanticError(SECONDOPERANDERROR);
                    this.setIsErroneous(true);
                }
            }
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.value1 == null || this.value2 == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp) || this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        IValue last1 = this.value1.getValueRefdLast(timestamp, referenceChain);
        IValue last2 = this.value2.getValueRefdLast(timestamp, referenceChain);
        switch (last1.getValuetype()) {
            case BITSTRING_VALUE: {
                String string = ((Bitstring_Value)last1).getValue();
                long shiftSize = ((Integer_Value)last2).getValue();
                this.lastValue = new Bitstring_Value(ShiftLeftExpression.shiftLeft(string, shiftSize));
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case HEXSTRING_VALUE: {
                String string = ((Hexstring_Value)last1).getValue();
                long shiftSize = ((Integer_Value)last2).getValue();
                this.lastValue = new Hexstring_Value(ShiftLeftExpression.shiftLeft(string, shiftSize));
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case OCTETSTRING_VALUE: {
                String string = ((Octetstring_Value)last1).getValue();
                long shiftSize = ((Integer_Value)last2).getValue() * 2L;
                this.lastValue = new Octetstring_Value(ShiftLeftExpression.shiftLeft(string, shiftSize));
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            default: {
                this.setIsErroneous(true);
            }
        }
        return this.lastValue;
    }

    public static String shiftLeft(String string, long shiftSize) {
        if (shiftSize > 0L) {
            StringBuilder result;
            if (shiftSize < (long)string.length()) {
                result = new StringBuilder(string);
                result.replace(0, (int)shiftSize, "");
            } else {
                result = new StringBuilder();
            }
            while (result.length() < string.length()) {
                result.append('0');
            }
            return result.toString();
        }
        if (shiftSize < 0L) {
            return ShiftRightExpression.shiftRight(string, -shiftSize);
        }
        return string;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            if (this.value1 != null) {
                referenceChain.markState();
                this.value1.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.value2 != null) {
                referenceChain.markState();
                this.value2.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value1 != null) {
            this.value1.updateSyntax(reparser, false);
            reparser.updateLocation(this.value1.getLocation());
        }
        if (this.value2 != null) {
            this.value2.updateSyntax(reparser, false);
            reparser.updateLocation(this.value2.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value1 != null) {
            this.value1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.value2 != null) {
            this.value2.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.value1 != null && !this.value1.accept(v)) {
            return false;
        }
        return this.value2 == null || this.value2.accept(v);
    }

    public Value getValue1() {
        return this.value1;
    }

    public Value getValue2() {
        return this.value2;
    }
}

