/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.commonFilters;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;

public final class WorkingDirectoryFilter
extends ViewerFilter {
    private static final String FILTER_ID = "org.eclipse.titan.designer.commonFilters.WorkingDirectoryFilter";
    private static final String NAVIGATOR_QUALIFIER = "org.eclipse.ui.navigator";
    private static final String FILTER_ACTIVATION_KEY = "org.eclipse.ui.navigator.ProjectExplorer.filterActivation";
    private IContainer[] workingDirectories = null;
    private static boolean isActive = false;
    private static boolean isActiveSet = false;

    private static void checkIsActive() {
        IEclipsePreferences rootNode = (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("instance").node(NAVIGATOR_QUALIFIER);
        rootNode.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (WorkingDirectoryFilter.FILTER_ACTIVATION_KEY.equals(event.getKey())) {
                    String temp = Platform.getPreferencesService().getString(WorkingDirectoryFilter.NAVIGATOR_QUALIFIER, WorkingDirectoryFilter.FILTER_ACTIVATION_KEY, "", null);
                    isActive = temp.indexOf(WorkingDirectoryFilter.FILTER_ID) != -1;
                    isActiveSet = true;
                }
            }
        });
        String temp = Platform.getPreferencesService().getString(NAVIGATOR_QUALIFIER, FILTER_ACTIVATION_KEY, "", null);
        isActive = temp.indexOf(FILTER_ID) != -1;
        isActiveSet = true;
    }

    public static boolean isActive() {
        if (!isActiveSet) {
            WorkingDirectoryFilter.checkIsActive();
        }
        return isActive;
    }

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        this.workingDirectories = null;
        Object tempParent = parent;
        if (parent instanceof TreePath) {
            tempParent = ((TreePath)parent).getLastSegment();
        }
        if (!(tempParent instanceof IResource)) {
            return elements;
        }
        IResource parentResource = (IResource)tempParent;
        IProject project = parentResource.getProject();
        if (project == null) {
            return elements;
        }
        this.workingDirectories = ProjectBasedBuilder.getProjectBasedBuilder(project).getWorkingDirectoryResources(false);
        int size = elements.length;
        ArrayList<Object> out = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            Object element = elements[i];
            if (!this.specialSelect(viewer, tempParent, element)) continue;
            out.add(element);
        }
        return out.toArray();
    }

    public Object[] filter(Viewer viewer, TreePath parentPath, Object[] elements) {
        this.workingDirectories = null;
        return super.filter(viewer, parentPath, elements);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IContainer[] workingDirectories;
        if (!(element instanceof IFolder)) {
            return true;
        }
        IFolder folder = (IFolder)element;
        IProject project = folder.getProject();
        for (IContainer workingDirectory : workingDirectories = ProjectBasedBuilder.getProjectBasedBuilder(project).getWorkingDirectoryResources(false)) {
            if (!workingDirectory.equals(folder)) continue;
            return false;
        }
        return true;
    }

    private boolean specialSelect(Viewer viewer, Object parentElement, Object element) {
        if (!(element instanceof IFolder) || this.workingDirectories == null || this.workingDirectories.length == 0) {
            return true;
        }
        IFolder folder = (IFolder)element;
        for (IContainer workingDirectory : this.workingDirectories) {
            if (!workingDirectory.equals(folder)) continue;
            return false;
        }
        return true;
    }
}

