/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor;

import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.cfg.CfgAnalyzer;
import org.eclipse.titan.common.parsers.cfg.CfgParseTreePrinter;
import org.eclipse.titan.designer.editors.configeditor.ConfigTextEditor;
import org.eclipse.titan.designer.editors.configeditor.FormColorCache;
import org.eclipse.titan.designer.editors.configeditor.pages.compgroupmc.ComponentsGroupsMCPage;
import org.eclipse.titan.designer.editors.configeditor.pages.execute.ExecuteExternalcommandsPage;
import org.eclipse.titan.designer.editors.configeditor.pages.include.IncludeDefinePage;
import org.eclipse.titan.designer.editors.configeditor.pages.logging.LoggingPage;
import org.eclipse.titan.designer.editors.configeditor.pages.modulepar.ModuleParameterSectionPage;
import org.eclipse.titan.designer.editors.configeditor.pages.testportpar.TestportParametersSectionPage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public final class ConfigEditor
extends FormEditor
implements IResourceChangeListener {
    private static final boolean CONFIG_EDITOR_TABS_VISIBLE = true;
    private ConfigTextEditor editor = new ConfigTextEditor(this);
    private int editorPageIndex;
    private boolean isDirty = false;
    private String errorMessage;
    private ModuleParameterSectionPage mModuleParameterSectionEditor;
    private TestportParametersSectionPage mTestportParameterSectionEditor;
    private ComponentsGroupsMCPage mComponentGroupMCSectionEditor;
    private ExecuteExternalcommandsPage mExecuteExternalCommandsEditor;
    private IncludeDefinePage mIncludeDefineEditor;
    private LoggingPage mLoggingEditor;
    private ParserRuleContext mParseTreeRoot;
    private List<Token> mTokens;

    public ConfigEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(FormColorCache.getFormColors(display));
    }

    void createTextEditorPage() {
        try {
            this.editorPageIndex = this.addPage((IEditorPart)this.editor, this.getEditorInput());
            this.setPageText(this.editorPageIndex, this.editor.getTitle());
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    public void setDirty() {
        this.isDirty = true;
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        return this.isDirty || this.editor.isDirty();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(this.editorPageIndex);
        IDE.gotoMarker((IEditorPart)this.getEditor(this.editorPageIndex), (IMarker)marker);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IEditorInput input;
        if (event.getType() == 2 && (input = this.editor.getEditorInput()) instanceof FileEditorInput && ((FileEditorInput)input).getFile().getProject().equals(event.getResource())) {
            final IWorkbenchPage[] pages = this.getSite().getWorkbenchWindow().getPages();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < pages.length; ++i) {
                        IEditorPart editorPart = pages[i].findEditor(ConfigEditor.this.editor.getEditorInput());
                        pages[i].closeEditor(editorPart, true);
                    }
                }
            });
        }
    }

    public ConfigTextEditor getEditor() {
        return this.editor;
    }

    public void refresh(final CfgAnalyzer cfgAnalyzer) {
        this.getSite().getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ConfigEditor.this.mModuleParameterSectionEditor.refreshData(cfgAnalyzer.getModuleParametersHandler());
                ConfigEditor.this.mTestportParameterSectionEditor.refreshData(cfgAnalyzer.getTestportParametersHandler());
                ConfigEditor.this.mComponentGroupMCSectionEditor.refreshData(cfgAnalyzer.getComponentSectionHandler(), cfgAnalyzer.getGroupSectionHandler(), cfgAnalyzer.getMcSectionHandler());
                ConfigEditor.this.mExecuteExternalCommandsEditor.refreshData(cfgAnalyzer.getExternalCommandsSectionHandler(), cfgAnalyzer.getExecuteSectionHandler());
                ConfigEditor.this.mIncludeDefineEditor.refreshData(cfgAnalyzer.getIncludeSectionHandler(), cfgAnalyzer.getDefineSectionHandler());
                ConfigEditor.this.mLoggingEditor.refreshData(cfgAnalyzer.getLoggingSectionHandler());
            }
        });
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConfigEditor.this.mModuleParameterSectionEditor.setErrorMessage();
                ConfigEditor.this.mTestportParameterSectionEditor.setErrorMessage();
                ConfigEditor.this.mComponentGroupMCSectionEditor.setErrorMessage();
                ConfigEditor.this.mExecuteExternalCommandsEditor.setErrorMessage();
                ConfigEditor.this.mIncludeDefineEditor.setErrorMessage();
                ConfigEditor.this.mLoggingEditor.setErrorMessage();
            }
        });
    }

    protected void addPages() {
        try {
            this.createTextEditorPage();
            this.mModuleParameterSectionEditor = new ModuleParameterSectionPage(this);
            this.addPage((IFormPage)this.mModuleParameterSectionEditor);
            this.mTestportParameterSectionEditor = new TestportParametersSectionPage(this);
            this.addPage((IFormPage)this.mTestportParameterSectionEditor);
            this.mComponentGroupMCSectionEditor = new ComponentsGroupsMCPage(this);
            this.addPage((IFormPage)this.mComponentGroupMCSectionEditor);
            this.mExecuteExternalCommandsEditor = new ExecuteExternalcommandsPage(this);
            this.addPage((IFormPage)this.mExecuteExternalCommandsEditor);
            this.mIncludeDefineEditor = new IncludeDefinePage(this);
            this.addPage((IFormPage)this.mIncludeDefineEditor);
            this.mLoggingEditor = new LoggingPage(this);
            this.addPage((IFormPage)this.mLoggingEditor);
        }
        catch (PartInitException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        this.setPartName(this.getEditorInput().getName());
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.isDirty) {
            this.updateTextualPage();
        }
        this.editor.doSave(monitor);
        this.isDirty = false;
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
        if (this.isDirty) {
            this.updateTextualPage();
        }
        this.editor.doSaveAs();
        this.setPageText(this.editorPageIndex, this.editor.getTitle());
        this.setInput(this.editor.getEditorInput());
        this.isDirty = false;
        this.firePropertyChange(257);
    }

    public ParserRuleContext getParseTreeRoot() {
        return this.mParseTreeRoot;
    }

    public void setParseTreeRoot(ParserRuleContext aParseTreeRoot) {
        this.mParseTreeRoot = aParseTreeRoot;
    }

    public List<Token> getTokens() {
        return this.mTokens;
    }

    public void setTokens(List<Token> aTokens) {
        this.mTokens = aTokens;
    }

    private void updateTextualPage() {
        if (this.mParseTreeRoot != null && this.mTokens != null) {
            String original = this.editor.getDocument().get();
            String content = CfgParseTreePrinter.toStringWithHidden((ParseTree)this.mParseTreeRoot, this.mTokens, (boolean)true);
            if (!content.equals(original)) {
                this.editor.getDocument().set(content);
            }
        }
    }

    protected void pageChange(int newPageIndex) {
        if (newPageIndex == this.editorPageIndex) {
            this.updateTextualPage();
        }
        super.pageChange(newPageIndex);
    }
}

