/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers.asn1parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.WritableToken;
import org.eclipse.core.resources.IFile;
import org.eclipse.titan.designer.parsers.asn1parser.TokenWithIndexAndSubTokens;

public class ModuleLevelTokenStreamTracker
extends BufferedTokenStream {
    private HashSet<Integer> discardMask = new HashSet();
    private IFile sourceFile = null;

    public ModuleLevelTokenStreamTracker(TokenSource source) {
        super(source);
    }

    public void setActualFile(IFile sourceFile) {
        this.sourceFile = sourceFile;
    }

    public void discard(int ttype) {
        this.discardMask.add(ttype);
    }

    public int fetch(int n) {
        if (this.fetchedEOF) {
            return 0;
        }
        int i = 0;
        do {
            Token t;
            if ((t = this.getTokenSource().nextToken()) instanceof WritableToken) {
                ((WritableToken)t).setTokenIndex(this.tokens.size());
            }
            Token first = t;
            if (t.getType() == -1) {
                this.fetchedEOF = true;
                this.tokens.add(new TokenWithIndexAndSubTokens(t));
                return ++i;
            }
            if (this.discardMask.contains(t.getType())) continue;
            if (t.getType() == 108) {
                this.fetchedEOF = this.getBlock(first);
                if (this.fetchedEOF) {
                    return ++i;
                }
                ++i;
                --n;
                continue;
            }
            this.tokens.add(t);
            ++i;
            --n;
        } while (0 < n);
        return i;
    }

    private boolean getBlock(Token first) {
        Token t = this.getTokenSource().nextToken();
        if (t instanceof WritableToken) {
            ((WritableToken)t).setTokenIndex(this.tokens.size());
        }
        ArrayList<Token> tokenList = new ArrayList<Token>();
        int nofUnclosedParanthesis = 1;
        while (t != null && t.getType() != -1) {
            if (t.getType() == 108) {
                ++nofUnclosedParanthesis;
            } else if (t.getType() == 109 && --nofUnclosedParanthesis == 0) {
                TokenWithIndexAndSubTokens result = new TokenWithIndexAndSubTokens(1, tokenList, this.sourceFile);
                result.setCharPositionInLine(first.getCharPositionInLine());
                result.setLine(first.getLine());
                result.setStartIndex(((TokenWithIndexAndSubTokens)first).getStopIndex());
                result.setStopIndex(((TokenWithIndexAndSubTokens)t).getStopIndex());
                result.setText(this.makeString(tokenList));
                this.tokens.add(result);
                return false;
            }
            if (!this.discardMask.contains(t.getType())) {
                tokenList.add((Token)new TokenWithIndexAndSubTokens(t));
            }
            t = this.getTokenSource().nextToken();
        }
        TokenWithIndexAndSubTokens result = new TokenWithIndexAndSubTokens(1, tokenList, this.sourceFile);
        result.setCharPositionInLine(first.getCharPositionInLine());
        result.setLine(first.getLine());
        result.setStartIndex(((TokenWithIndexAndSubTokens)first).getStopIndex());
        if (t != null) {
            result.setStopIndex(((TokenWithIndexAndSubTokens)t).getStopIndex());
        }
        this.tokens.add(result);
        return true;
    }

    private String makeString(List<Token> list) {
        StringBuilder text = new StringBuilder();
        for (Token t : list) {
            text.append(t.getText());
        }
        return text.toString();
    }
}

