/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.preferences.pages;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.asn1editor.CodeScanner;
import org.eclipse.titan.designer.preferences.PreferenceInitializer;
import org.eclipse.titan.designer.preferences.pages.SyntaxHighlightColoringElement;
import org.eclipse.titan.designer.preferences.pages.SyntaxHighlightColoringGroup;
import org.eclipse.titan.designer.preferences.pages.SyntaxHighlightContentProvider;
import org.eclipse.titan.designer.preferences.pages.SyntaxhighlightLabelProvider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class SyntaxHighlightPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Composite pageComposite;
    private Composite upperHalfComposite;
    private Composite colorEditorsComposite;
    private ColorFieldEditor foregroundColorEditor;
    private ColorFieldEditor backgroundColorEditor;
    private BooleanFieldEditor useBackgroundColor;
    private BooleanFieldEditor isBold;
    private TreeViewer treeViewer;
    private Text coloredWords;
    private SyntaxhighlightLabelProvider labelProvider;
    private PreferenceStore tempstore;
    private Map<String, String> possiblyChangedPreferences = new HashMap<String, String>();
    private final ISelectionChangedListener treeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection;
            if (event.getSelection().isEmpty()) {
                return;
            }
            if (event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).size() == 1 && selection.getFirstElement() instanceof SyntaxHighlightColoringElement) {
                SyntaxHighlightColoringElement element = (SyntaxHighlightColoringElement)selection.getFirstElement();
                SyntaxHighlightPage.this.foregroundColorEditor.setEnabled(true, SyntaxHighlightPage.this.colorEditorsComposite);
                SyntaxHighlightPage.this.loadIntoTemp(element.getBasePreferenceKey() + ".foreground");
                SyntaxHighlightPage.this.foregroundColorEditor.setPreferenceName(element.getBasePreferenceKey() + ".foreground");
                SyntaxHighlightPage.this.foregroundColorEditor.load();
                SyntaxHighlightPage.this.backgroundColorEditor.setEnabled(true, SyntaxHighlightPage.this.colorEditorsComposite);
                SyntaxHighlightPage.this.loadIntoTemp(element.getBasePreferenceKey() + ".background");
                SyntaxHighlightPage.this.backgroundColorEditor.setPreferenceName(element.getBasePreferenceKey() + ".background");
                SyntaxHighlightPage.this.backgroundColorEditor.load();
                SyntaxHighlightPage.this.useBackgroundColor.setEnabled(true, SyntaxHighlightPage.this.colorEditorsComposite);
                SyntaxHighlightPage.this.loadIntoTemp(element.getBasePreferenceKey() + ".usebackgroundcolor");
                SyntaxHighlightPage.this.useBackgroundColor.setPreferenceName(element.getBasePreferenceKey() + ".usebackgroundcolor");
                SyntaxHighlightPage.this.useBackgroundColor.load();
                SyntaxHighlightPage.this.isBold.setEnabled(true, SyntaxHighlightPage.this.colorEditorsComposite);
                SyntaxHighlightPage.this.loadIntoTemp(element.getBasePreferenceKey() + ".bold");
                SyntaxHighlightPage.this.isBold.setPreferenceName(element.getBasePreferenceKey() + ".bold");
                SyntaxHighlightPage.this.isBold.load();
                if (element.getWords() != null) {
                    SyntaxHighlightPage.this.coloredWords.setText(element.getWords());
                } else {
                    SyntaxHighlightPage.this.coloredWords.setText("");
                }
                return;
            }
            SyntaxHighlightPage.this.foregroundColorEditor.setEnabled(false, SyntaxHighlightPage.this.colorEditorsComposite);
            SyntaxHighlightPage.this.backgroundColorEditor.setEnabled(false, SyntaxHighlightPage.this.colorEditorsComposite);
            SyntaxHighlightPage.this.useBackgroundColor.setEnabled(false, SyntaxHighlightPage.this.colorEditorsComposite);
            SyntaxHighlightPage.this.isBold.setEnabled(false, SyntaxHighlightPage.this.colorEditorsComposite);
            SyntaxHighlightPage.this.coloredWords.setText("");
        }
    };

    protected void loadIntoTemp(String preferenceName) {
        if (!this.possiblyChangedPreferences.containsKey(preferenceName)) {
            this.tempstore.setValue(preferenceName, this.getPreferenceStore().getString(preferenceName));
        }
    }

    private void storeIntoFinal(String preferenceName) {
        this.getPreferenceStore().setValue(preferenceName, this.tempstore.getString(preferenceName));
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.tempstore = new PreferenceStore();
        TempPreferenceInitializer inittializer = new TempPreferenceInitializer();
        inittializer.initializeDefaultPreferences();
    }

    public boolean performOk() {
        for (String changedKey : this.possiblyChangedPreferences.keySet()) {
            this.storeIntoFinal(changedKey);
        }
        return super.performOk();
    }

    protected void performDefaults() {
        String[] preferenceNames;
        for (String preferenceName : preferenceNames = this.tempstore.preferenceNames()) {
            this.tempstore.setValue(preferenceName, this.tempstore.getDefaultString(preferenceName));
            this.possiblyChangedPreferences.put(preferenceName, null);
        }
        if (this.foregroundColorEditor != null) {
            this.foregroundColorEditor.loadDefault();
        }
        if (this.backgroundColorEditor != null) {
            this.backgroundColorEditor.loadDefault();
        }
        if (this.useBackgroundColor != null) {
            this.useBackgroundColor.loadDefault();
        }
        if (this.isBold != null) {
            this.isBold.loadDefault();
        }
        super.performDefaults();
    }

    public void dispose() {
        this.foregroundColorEditor.dispose();
        this.backgroundColorEditor.dispose();
        this.useBackgroundColor.dispose();
        this.isBold.dispose();
        this.coloredWords.dispose();
        this.labelProvider.dispose();
        this.colorEditorsComposite.dispose();
        this.upperHalfComposite.dispose();
        this.pageComposite.dispose();
        super.dispose();
    }

    protected Control createTreeViewer(Composite parent) {
        GridLayout treeLayout = new GridLayout();
        treeLayout.numColumns = 2;
        GridData treeData = new GridData();
        treeData.horizontalAlignment = 4;
        treeData.verticalAlignment = 4;
        treeData.grabExcessHorizontalSpace = true;
        treeData.grabExcessVerticalSpace = true;
        this.treeViewer = new TreeViewer(parent);
        this.treeViewer.getControl().setLayoutData((Object)treeData);
        this.treeViewer.setContentProvider((IContentProvider)new SyntaxHighlightContentProvider());
        this.labelProvider = new SyntaxhighlightLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setInput((Object)this.initialInput());
        this.treeViewer.addSelectionChangedListener(this.treeListener);
        return null;
    }

    protected Control createColorEditors(Composite parent) {
        this.colorEditorsComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.colorEditorsComposite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.colorEditorsComposite.setLayoutData((Object)gridData);
        this.loadIntoTemp("org.eclipse.titan.designer.color.ttcn3_keywords.foreground");
        this.foregroundColorEditor = new ColorFieldEditor("org.eclipse.titan.designer.color.ttcn3_keywords.foreground", "foreground color:", this.colorEditorsComposite);
        this.foregroundColorEditor.setEnabled(false, this.colorEditorsComposite);
        this.foregroundColorEditor.setPreferenceStore((IPreferenceStore)this.tempstore);
        this.foregroundColorEditor.setPage((DialogPage)this);
        this.foregroundColorEditor.load();
        this.foregroundColorEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SyntaxHighlightPage.this.possiblyChangedPreferences.put(SyntaxHighlightPage.this.foregroundColorEditor.getPreferenceName(), null);
                SyntaxHighlightPage.this.foregroundColorEditor.store();
            }
        });
        this.loadIntoTemp("org.eclipse.titan.designer.color.ttcn3_keywords.background");
        this.backgroundColorEditor = new ColorFieldEditor("org.eclipse.titan.designer.color.ttcn3_keywords.background", "background color:", this.colorEditorsComposite);
        this.backgroundColorEditor.setEnabled(false, this.colorEditorsComposite);
        this.backgroundColorEditor.setPreferenceStore((IPreferenceStore)this.tempstore);
        this.backgroundColorEditor.setPage((DialogPage)this);
        this.backgroundColorEditor.load();
        this.backgroundColorEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SyntaxHighlightPage.this.possiblyChangedPreferences.put(SyntaxHighlightPage.this.backgroundColorEditor.getPreferenceName(), null);
                SyntaxHighlightPage.this.backgroundColorEditor.store();
            }
        });
        this.loadIntoTemp("org.eclipse.titan.designer.color.ttcn3_keywords.usebackgroundcolor");
        this.useBackgroundColor = new BooleanFieldEditor("org.eclipse.titan.designer.color.ttcn3_keywords.usebackgroundcolor", "use background color", 32, this.colorEditorsComposite);
        this.useBackgroundColor.setEnabled(false, this.colorEditorsComposite);
        this.useBackgroundColor.setPreferenceStore((IPreferenceStore)this.tempstore);
        this.useBackgroundColor.setPage((DialogPage)this);
        this.useBackgroundColor.load();
        this.useBackgroundColor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SyntaxHighlightPage.this.possiblyChangedPreferences.put(SyntaxHighlightPage.this.useBackgroundColor.getPreferenceName(), null);
                SyntaxHighlightPage.this.useBackgroundColor.store();
            }
        });
        this.loadIntoTemp("org.eclipse.titan.designer.color.ttcn3_keywords.bold");
        this.isBold = new BooleanFieldEditor("org.eclipse.titan.designer.color.ttcn3_keywords.bold", "bold", 32, this.colorEditorsComposite);
        this.isBold.setEnabled(false, this.colorEditorsComposite);
        this.isBold.setPreferenceStore((IPreferenceStore)this.tempstore);
        this.isBold.setPage((DialogPage)this);
        this.isBold.load();
        this.isBold.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SyntaxHighlightPage.this.possiblyChangedPreferences.put(SyntaxHighlightPage.this.isBold.getPreferenceName(), null);
                SyntaxHighlightPage.this.isBold.store();
            }
        });
        GridData wordsGridData = new GridData();
        wordsGridData.horizontalAlignment = 4;
        wordsGridData.verticalAlignment = 4;
        wordsGridData.horizontalSpan = 2;
        wordsGridData.grabExcessHorizontalSpace = true;
        wordsGridData.grabExcessVerticalSpace = true;
        this.coloredWords = new Text(this.colorEditorsComposite, 2634);
        this.coloredWords.setEditable(false);
        this.coloredWords.setLayoutData((Object)wordsGridData);
        return null;
    }

    protected Control createUpperHalf(Composite parent) {
        this.upperHalfComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.upperHalfComposite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.upperHalfComposite.setLayoutData((Object)gridData);
        this.createTreeViewer(this.upperHalfComposite);
        this.createColorEditors(this.upperHalfComposite);
        return null;
    }

    protected Control createContents(Composite parent) {
        this.pageComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.pageComposite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.pageComposite.setLayoutData((Object)gridData);
        this.createUpperHalf(this.pageComposite);
        return this.pageComposite;
    }

    private SyntaxHighlightColoringGroup initialInput() {
        SyntaxHighlightColoringGroup root = new SyntaxHighlightColoringGroup("root");
        SyntaxHighlightColoringGroup generalGroup = new SyntaxHighlightColoringGroup("General");
        generalGroup.add(new SyntaxHighlightColoringElement("Plain text", "org.eclipse.titan.designer.color.normalText", "Example text"));
        generalGroup.add(new SyntaxHighlightColoringElement("Comments", "org.eclipse.titan.designer.color.comments", "/* Example comment */"));
        generalGroup.add(new SyntaxHighlightColoringElement("Strings", "org.eclipse.titan.designer.color.strings", "\" Example string \""));
        root.add(generalGroup);
        SyntaxHighlightColoringGroup asn1Group = new SyntaxHighlightColoringGroup("ASN.1 specific");
        asn1Group.add(new SyntaxHighlightColoringElement("Keywords", "org.eclipse.titan.designer.color.asn1keywords", CodeScanner.KEYWORDS));
        asn1Group.add(new SyntaxHighlightColoringElement("CMIP verbs", "org.eclipse.titan.designer.color.CMIP_Verb", CodeScanner.VERBS));
        asn1Group.add(new SyntaxHighlightColoringElement("compare types", "org.eclipse.titan.designer.color.compare_type", CodeScanner.COMPARE_TYPES));
        asn1Group.add(new SyntaxHighlightColoringElement("Status", "org.eclipse.titan.designer.color.status_type", CodeScanner.STATUS_TYPE));
        asn1Group.add(new SyntaxHighlightColoringElement("Tags", "org.eclipse.titan.designer.color.tag", CodeScanner.TAGS));
        asn1Group.add(new SyntaxHighlightColoringElement("Storage", "org.eclipse.titan.designer.color.storage", CodeScanner.STORAGE));
        asn1Group.add(new SyntaxHighlightColoringElement("Modifier", "org.eclipse.titan.designer.color.modifier", CodeScanner.MODIFIER));
        asn1Group.add(new SyntaxHighlightColoringElement("Access types", "org.eclipse.titan.designer.color.access_type", CodeScanner.ACCESS_TYPE));
        root.add(asn1Group);
        SyntaxHighlightColoringGroup configGroup = new SyntaxHighlightColoringGroup("Configuration specific");
        configGroup.add(new SyntaxHighlightColoringElement("Keywords", "org.eclipse.titan.designer.color.config_keywords", org.eclipse.titan.designer.editors.configeditor.CodeScanner.KEYWORDS));
        configGroup.add(new SyntaxHighlightColoringElement("Section title", "org.eclipse.titan.designer.color.section_title", org.eclipse.titan.designer.editors.configeditor.CodeScanner.SECTION_TITLES));
        configGroup.add(new SyntaxHighlightColoringElement("File and control mask options", "org.eclipse.titan.designer.color.file_and_control_mask_options", org.eclipse.titan.designer.editors.configeditor.CodeScanner.MASK_OPTIONS));
        configGroup.add(new SyntaxHighlightColoringElement("External command types", "org.eclipse.titan.designer.color.external_command_types", org.eclipse.titan.designer.editors.configeditor.CodeScanner.EXTERNAL_COMMAND_TYPES));
        root.add(configGroup);
        SyntaxHighlightColoringGroup ttcn3Group = new SyntaxHighlightColoringGroup("TTCN-3 specific");
        ttcn3Group.add(new SyntaxHighlightColoringElement("Keywords", "org.eclipse.titan.designer.color.ttcn3_keywords", org.eclipse.titan.designer.editors.ttcn3editor.CodeScanner.KEYWORDS));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Preprocessor", "org.eclipse.titan.designer.color.preprocessor", "Example #include"));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Visibility modifiers", "org.eclipse.titan.designer.color.visibility_op", org.eclipse.titan.designer.editors.ttcn3editor.CodeScanner.VISIBILITY_MODIFIERS));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Template match", "org.eclipse.titan.designer.color.template_match", org.eclipse.titan.designer.editors.ttcn3editor.CodeScanner.TEMPLATE_MATCH));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Type", "org.eclipse.titan.designer.color.type", org.eclipse.titan.designer.editors.ttcn3editor.CodeScanner.TYPES));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Timer operators", "org.eclipse.titan.designer.color.timer_op", org.eclipse.titan.designer.editors.ttcn3editor.CodeScanner.TIMER_OPERATIONS));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Port operators", "org.eclipse.titan.designer.color.port_op", org.eclipse.titan.designer.editors.ttcn3editor.CodeScanner.PORT_OPERATIONS));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Config operators", "org.eclipse.titan.designer.color.config_op", org.eclipse.titan.designer.editors.ttcn3editor.CodeScanner.CONFIGURATION_OPERATIONS));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Verdict operators", "org.eclipse.titan.designer.color.verdict_op", org.eclipse.titan.designer.editors.ttcn3editor.CodeScanner.VERDICT_OPERATIONS));
        ttcn3Group.add(new SyntaxHighlightColoringElement("System under test related operators", "org.eclipse.titan.designer.color.sut_op", org.eclipse.titan.designer.editors.ttcn3editor.CodeScanner.SUT_OPERATION));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Function operators", "org.eclipse.titan.designer.color.function_op", org.eclipse.titan.designer.editors.ttcn3editor.CodeScanner.FUNCTION_OPERATIONS));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Predefined operators", "org.eclipse.titan.designer.color.predefined_op", org.eclipse.titan.designer.editors.ttcn3editor.CodeScanner.PREDEFINED_OPERATIONS));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Boolean consts", "org.eclipse.titan.designer.color.boolean_const", org.eclipse.titan.designer.editors.ttcn3editor.CodeScanner.BOOLEAN_CONSTANTS));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Verdict consts", "org.eclipse.titan.designer.color.ttcn3_verdict_const", org.eclipse.titan.designer.editors.ttcn3editor.CodeScanner.VERDICT_CONSTANT));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Other consts", "org.eclipse.titan.designer.color.other_const", org.eclipse.titan.designer.editors.ttcn3editor.CodeScanner.OTHER_CONSTANT));
        root.add(ttcn3Group);
        return root;
    }

    final class TempPreferenceInitializer
    extends PreferenceInitializer {
        TempPreferenceInitializer() {
        }

        @Override
        public IPreferenceStore getPreference() {
            return SyntaxHighlightPage.this.tempstore;
        }
    }
}

