/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.efm.sew.launcher.Activator;
import org.eclipse.efm.sew.launcher.views.page.LaunchExecConsoleManager;
import org.eclipse.efm.sew.launcher.workflow.IWorkflowConfigurationConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.framework.Bundle;

public class WorkflowFAVM
implements IWorkflowConfigurationConstants {
    private final String FAVM_TEMPLATE = "resources/sew/template.favm";
    private IPath fFavmLocation = null;
    private IPath fWorkingDirectory = null;
    private String fAnalysisProfile = null;
    public static String fModelAnalysis = "";
    public boolean fEnableTraceExtension = false;
    LaunchExecConsoleManager fConsoleManager = new LaunchExecConsoleManager();
    boolean fEnabledDebugOrDeveloperMode = false;

    public void configure(ILaunchConfiguration configuration, IPath xorkingDirectory, String favmFilename) {
        this.fWorkingDirectory = xorkingDirectory;
        this.fFavmLocation = this.fWorkingDirectory.append(favmFilename);
        try {
            String fFolderName;
            this.fAnalysisProfile = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_ANALYSIS_PROFILE", "MODEL");
            fModelAnalysis = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_MODEL_ANALYSIS", "");
            Bundle bundle = Platform.getBundle((String)"org.eclipse.efm.sew.launcher");
            URL url = bundle.getEntry("resources/sew/template.favm");
            URL favmTemplateURL = FileLocator.toFileURL((URL)url);
            InputStream inputTemplate = favmTemplateURL.openStream();
            BufferedReader bufferedTemplate = new BufferedReader(new InputStreamReader(inputTemplate));
            StringBuffer buffer = new StringBuffer();
            String line = bufferedTemplate.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append("\n");
                line = bufferedTemplate.readLine();
            }
            bufferedTemplate.close();
            String favmString = buffer.toString();
            String projectLocation = this.fWorkingDirectory.toString();
            favmString = favmString.replace("__LOCATION_PROJECT__", projectLocation);
            String fModelPath = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_MODEL_FILE_LOCATION", "");
            if (fModelPath.startsWith(projectLocation)) {
                boolean endWidthSeparator = projectLocation.charAt(projectLocation.length() - 1) == '/';
                fModelPath = fModelPath.substring(projectLocation.length() + (endWidthSeparator ? 0 : 1));
            }
            favmString = favmString.replace("__SPECIFICATION_MAIN__", fModelPath);
            int i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_STOP_CRITERIA_NODE", -1);
            favmString = favmString.replace("__NODE__", Integer.toString(i));
            i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_STOP_CRITERIA_WIDTH", -1);
            favmString = favmString.replace("__WIDTH__", Integer.toString(i));
            i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_STOP_CRITERIA_HEIGHT", -1);
            favmString = favmString.replace("__HEIGHT__", Integer.toString(i));
            i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_STOP_CRITERIA_STEPS", -1);
            favmString = favmString.replace("__EVAL__", Integer.toString(i));
            switch (this.fAnalysisProfile) {
                case "MODEL": {
                    switch (fModelAnalysis) {
                        case "Exploration": {
                            favmString = favmString.replace("__EXECUTION_QUEUE_STRATEGY__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_ANALYZE_STRATEGY", ""));
                            break;
                        }
                        case "Transition Coverage": {
                            favmString = favmString.replace("__EXECUTION_QUEUE_STRATEGY__", "WEIGHT_BFS");
                            break;
                        }
                        case "Behavior Selection": {
                            String fElementNameListStringField = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BEHAVIOR_ANALYSIS_ELEMENT_NAME_LIST", "");
                            String[] tabString = fElementNameListStringField.trim().split("\\R|;");
                            StringBuffer elementStringList = new StringBuffer();
                            String[] stringArray = tabString;
                            int n = tabString.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String eltString = stringArray[n2];
                                if ((eltString = eltString.trim()).length() != 0) {
                                    if (eltString.startsWith("//")) {
                                        elementStringList.append("\t\t\t\t\t\t").append(eltString).append("\n");
                                    } else {
                                        int pos = eltString.indexOf(61);
                                        if (pos > 0) {
                                            String kind = eltString.substring(0, pos).trim();
                                            String object = eltString.substring(pos + 1).trim();
                                            if (!(kind.equals("transition") || kind.equals("state") || kind.equals("input") || kind.equals("output") || kind.equals("inout"))) {
                                                kind.equals("com");
                                            }
                                            if (object.matches("[^\"'].*\\s+.*[^\"']")) {
                                                object = "\"" + object + "\"";
                                            }
                                            elementStringList.append("\t\t\t\t\t\t@").append(kind).append(" = ").append(object).append(";\n");
                                        } else {
                                            elementStringList.append("\t\t\t\t\t\t@").append(eltString).append(";\n");
                                        }
                                    }
                                }
                                ++n2;
                            }
                            if (elementStringList.length() > 0) {
                                favmString = favmString.replace("\t\t\t\t\t\t//__ELEMENT_LIST_TO_COVER__", elementStringList);
                            }
                            favmString = favmString.replace("__EXECUTION_QUEUE_STRATEGY__", "WEIGHT_BFS");
                            break;
                        }
                        default: {
                            favmString = favmString.replace("__EXECUTION_QUEUE_STRATEGY__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_ANALYZE_STRATEGY", ""));
                        }
                    }
                    favmString = WorkflowFAVM.suppressProcessString(favmString, "//BEGIN_OFFLINE_TEST_PHASE1", "//END_OFFLINE_TEST_PHASE1");
                    favmString = this.filterRedundancyPhase1(configuration, favmString);
                    break;
                }
                case "TESTOFFLINE": {
                    fModelAnalysis = "";
                    String traceFile = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TRACE_FILE_LOCATION", "<DEFAULT trace file>");
                    favmString = favmString.replace("__TRACE_FILE__", traceFile);
                    String testPurposeFile = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TEST_PURPOSE_FILE_LOCATION", "<test purpose file>");
                    favmString = testPurposeFile.equals("") || testPurposeFile.equals("<test purpose file>") ? favmString.replace("@testPurposeFile", "//__@testPurposeFile") : favmString.replace("__TEST_PURPOSE_FILE__", testPurposeFile);
                    favmString = favmString.replace("__EXECUTION_QUEUE_STRATEGY__", "WEIGHT_BFS");
                    favmString = favmString.replace("//__&process::offline_test", "&process::offline_test");
                    break;
                }
            }
            favmString = this.filterTransitionCoveragePhase1(configuration, favmString);
            favmString = this.processHOJPhase1(configuration, favmString);
            favmString = WorkflowFAVM.suppressProcessString(favmString, "//BEGIN_GRAPH_SLICER_IO_PHASE2", "//END_GRAPH_SLICER_IO_PHASE2");
            if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_ENABLED", false)) {
                favmString = favmString.replace("//__&process::BASIC_trace_generator", "&process::BASIC_trace_generator");
                fFolderName = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_FOLDER_NAME", "Basic");
                favmString = favmString.replace("__BASIC_FOLDER_NAME__", fFolderName);
                String fFileName = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_FILE_NAME", "tests.txt");
                favmString = favmString.replace("__BASIC_FILE_NAME__", fFileName);
                favmString = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_ELIMINATION_REDUNDANCE", true) ? favmString.replace("//__BASIC__@normalize = true;", "@normalize = true;") : favmString.replace("//__BASIC__@normalize = true;", "@normalize = false;");
                boolean enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_TIME_SELECTION", false);
                if (enabled) {
                    favmString = favmString.replace("//__BASIC__@time", "@time");
                }
                if (enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_ALL_EXTERNAL_INPUT_COM_SELECTION", false)) {
                    favmString = favmString.replace("//__BASIC__@input#env", "@input#env");
                }
                if (enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_ALL_EXTERNAL_OUTPUT_COM_SELECTION", false)) {
                    favmString = favmString.replace("//__BASIC__@output#env", "@output#env");
                }
                if (enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_ALL_INPUT_COM_SELECTION", false)) {
                    favmString = favmString.replace("//__BASIC__@input", "@input");
                }
                if (enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_ALL_IOUTPUT_COM_SELECTION", false)) {
                    favmString = favmString.replace("//__BASIC__@output", "@output");
                }
                if (enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_ALL_VARIABLE_SELECTION", false)) {
                    favmString = favmString.replace("//__BASIC__@variable", "@variable");
                }
                if (enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_ALL_TRANSITION_SELECTION", false)) {
                    favmString = favmString.replace("//__BASIC__@transition", "@transition");
                }
                if (enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_ALL_STATE_SELECTION", false)) {
                    favmString = favmString.replace("//__BASIC__@state", "@state");
                }
                String detailsTraceList = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_DETAILS_ELEMENT_LIST", "");
                if (!(detailsTraceList = WorkflowFAVM.parseFormatTrace(detailsTraceList, "\t\t\t\t\t\t")).isEmpty()) {
                    favmString = favmString.replace("\t\t\t\t\t\t//__DetailsElementsListToTrace", detailsTraceList);
                }
                favmString = favmString.replace("__EXECUTION_QUEUE_STRATEGY__", "WEIGHT_BFS");
            } else {
                favmString = WorkflowFAVM.suppressProcessString(favmString, "//BEGIN_BASIC_TRACE_GENERATOR_PHASE2", "//END_BASIC_TRACE_GENERATOR_PHASE2");
            }
            if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TTCN_ENABLED", false)) {
                favmString = favmString.replace("//__&process::TTCN_trace_generator", "&process::TTCN_trace_generator");
                fFolderName = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TTCN_FOLDER_NAME", "");
                favmString = favmString.replace("__TTCN_FOLDER_NAME__", fFolderName);
            } else {
                favmString = WorkflowFAVM.suppressProcessString(favmString, "//BEGIN_TTCN_TRACE_GENERATOR_PHASE2", "//END_TTCN_TRACE_GENERATOR_PHASE2");
            }
            this.fEnableTraceExtension = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_EXTENSION", false);
            if (this.fEnableTraceExtension) {
                i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TRACE_EXTENSION_EVALUATION_STEPS", -1);
                favmString = favmString.replace("__EVAL2__", Integer.toString(i));
                favmString = favmString.replace("//__PHASE2_&process::hit_or_jump", "&process::hit_or_jump");
                favmString = favmString.replace("//__&engine::io_continuation", "&engine::io_continuation");
                String detailsTraceList = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TRACE_EXTENSION_OBJECTIVE", "");
                if (!(detailsTraceList = WorkflowFAVM.parseFormatTrace(detailsTraceList, "\t\t\t\t\t\t")).isEmpty()) {
                    favmString = favmString.replace("\t\t\t\t\t\t//__EXTENSION_OBJECTIVE_TO_REACH__", detailsTraceList);
                }
            } else if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_ENABLED", false) || configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TTCN_ENABLED", false)) {
                favmString = favmString.replace("__EVAL2__", "0");
                favmString = WorkflowFAVM.suppressProcessString(favmString, "//BEGIN_HOJ_PHASE2", "//END_HOJ_PHASE2");
                favmString = favmString.replace("//__&engine::io_continuation", "&engine::io_continuation");
            } else {
                favmString = WorkflowFAVM.suppressProcessString(favmString, "//BEGIN_IO_CONTINUATION_PHASE2", "//END_IO_CONTINUATION_PHASE2");
                favmString = favmString.replace("\n\t\t\t//__&engine::io_continuation", "");
            }
            favmString = this.modeDebug(configuration, favmString);
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.fFavmLocation.toFile()));
            writer.write(favmString);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private String filterTransitionCoveragePhase1(ILaunchConfiguration configuration, String currentFavmString) {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        boolean expertMode = prefs.getBoolean("org.eclipse.efm.sew.launcher.ui.PREF_EXPERT_MODE");
        if (this.fAnalysisProfile.equals("MODEL") && fModelAnalysis.equals("Transition Coverage")) {
            try {
                String fTransitionButton = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRANSITION_BUTTON", "All");
                if (fTransitionButton.equals("Details")) {
                    currentFavmString = currentFavmString.replace("__TC1_SCOPE__", "DETAILS");
                    List selectedTransitions = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SELECTED_TRANSITIONS", new ArrayList());
                    StringBuffer TransitionStringList = new StringBuffer();
                    for (String eltString : selectedTransitions) {
                        TransitionStringList.append("\t\t\t\t\t\t@transition = \"").append(eltString).append("\";\n");
                    }
                    currentFavmString = currentFavmString.replace("\t\t\t\t\t\t//__TC1_TransitionListToCover", TransitionStringList.toString());
                }
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            currentFavmString = currentFavmString.replace("//__PHASE1_&filter::transition_coverage", "&filter::transition_coverage");
            if (expertMode) {
                try {
                    int i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_BEGIN_STEP", 0);
                    currentFavmString = currentFavmString.replace("__TC1_BEGIN_STEP__", Integer.toString(i));
                    boolean b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_STOP", true);
                    currentFavmString = currentFavmString.replace("__TC1_STOP__", Boolean.toString(b));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_MINIMIZE", true);
                    currentFavmString = currentFavmString.replace("__TC1_MINIMIZE__", Boolean.toString(b));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_SLICE", true);
                    currentFavmString = currentFavmString.replace("__TC1_SLICE__", Boolean.toString(b));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HEURISTIC", true);
                    currentFavmString = currentFavmString.replace("__TC1_HEURISTIC__", Boolean.toString(b));
                    currentFavmString = currentFavmString.replace("__TC1_SCOPE__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_SCOPE", "MODEL"));
                    currentFavmString = currentFavmString.replace("__TC1_HEURISTIC_START__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HEURISTIC_START", "BASIC"));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HEURISTIC_TRIALS", -1);
                    currentFavmString = currentFavmString.replace("__TC1_HEURISTIC_TRIALS__", Integer.toString(i));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_OBJECTIVE_RATE", 100);
                    currentFavmString = currentFavmString.replace("__TC1_OBJECTIVE_RATE__", Integer.toString(i));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_OBJECTIVE_REST", 0);
                    currentFavmString = currentFavmString.replace("__TC1_OBJECTIVE_REST__", Integer.toString(i));
                    currentFavmString = currentFavmString.replace("__TC1_DIRECTIVE_TRACE_HEURISTIC__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_DIRECTIVE_TRACE_HEURISTIC", "SMART"));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_DIRECTIVE_TRACE_COUNT_LIMIT", 8);
                    currentFavmString = currentFavmString.replace("__TC1_DIRECTIVE_TRACE_COUNT_LIMIT__", Integer.toString(i));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_DIRECTIVE_TRACE_SIZE_LIMIT", 8);
                    currentFavmString = currentFavmString.replace("__TC1_DIRECTIVE_TRACE_SIZE_LIMIT__", Integer.toString(i));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_LOOKAHEAD_DEPTH", 7);
                    currentFavmString = currentFavmString.replace("__TC1_COVERAGE_HEIGHT__", Integer.toString(i));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_LOOKAHEAD_WIDTH", 42);
                    currentFavmString = currentFavmString.replace("__TC1_COVERAGE_HEIGHT_REACHED_LIMIT__", Integer.toString(i));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HIT_STRONGLY_RANDOM", false);
                    currentFavmString = currentFavmString.replace("__TC1_HIT_STRONGLY_RANDOM__", Boolean.toString(b));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HIT_STRONGLY_COUNT", 1);
                    currentFavmString = currentFavmString.replace("__TC1_HIT_STRONGLY_COUNT__", Integer.toString(i));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HIT_WEAKLY_RANDOM", false);
                    currentFavmString = currentFavmString.replace("__TC1_HIT_WEAKLY_RANDOM__", Boolean.toString(b));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HIT_WEAKLY_COUNT", 1);
                    currentFavmString = currentFavmString.replace("__TC1_HIT_WEAKLY_COUNT__", Integer.toString(i));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HIT_OTHER_RANDOM", false);
                    currentFavmString = currentFavmString.replace("__TC1_HIT_OTHER_RANDOM__", Boolean.toString(b));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HIT_OTHER_COUNT", 1);
                    currentFavmString = currentFavmString.replace("__TC1_HIT_OTHER_COUNT__", Integer.toString(i));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            } else {
                currentFavmString = currentFavmString.replace("__TC1_BEGIN_STEP__", "0");
                currentFavmString = currentFavmString.replace("__TC1_STOP__", "true");
                currentFavmString = currentFavmString.replace("__TC1_MINIMIZE__", "true");
                currentFavmString = currentFavmString.replace("__TC1_SLICE__", "true");
                currentFavmString = currentFavmString.replace("__TC1_HEURISTIC__", "true");
                currentFavmString = currentFavmString.replace("__TC1_SCOPE__", "MODEL");
                currentFavmString = currentFavmString.replace("__TC1_HEURISTIC_START__", "BASIC");
                currentFavmString = currentFavmString.replace("__TC1_HEURISTIC_TRIALS__", "7");
                currentFavmString = currentFavmString.replace("__TC1_OBJECTIVE_RATE__", "100");
                currentFavmString = currentFavmString.replace("__TC1_OBJECTIVE_REST__", "0");
                currentFavmString = currentFavmString.replace("__TC1_DIRECTIVE_TRACE_HEURISTIC__", "SMART");
                currentFavmString = currentFavmString.replace("__TC1_DIRECTIVE_TRACE_COUNT_LIMIT__", "8");
                currentFavmString = currentFavmString.replace("__TC1_DIRECTIVE_TRACE_SIZE_LIMIT__", "8");
                currentFavmString = currentFavmString.replace("__TC1_COVERAGE_HEIGHT__", "7");
                currentFavmString = currentFavmString.replace("__TC1_COVERAGE_HEIGHT_REACHED_LIMIT__", "42");
                currentFavmString = currentFavmString.replace("__TC1_HIT_STRONGLY_RANDOM__", "false");
                currentFavmString = currentFavmString.replace("__TC1_HIT_STRONGLY_COUNT__", "1");
                currentFavmString = currentFavmString.replace("__TC1_HIT_WEAKLY_RANDOM__", "false");
                currentFavmString = currentFavmString.replace("__TC1_HIT_WEAKLY_COUNT__", "1");
                currentFavmString = currentFavmString.replace("__TC1_HIT_OTHER_RANDOM__", "false");
                currentFavmString = currentFavmString.replace("__TC1_HIT_OTHER_COUNT__", "1");
            }
        } else {
            currentFavmString = WorkflowFAVM.suppressProcessString(currentFavmString, "//BEGIN_TRANSITION_COVERAGE_PHASE1", "//END_TRANSITION_COVERAGE_PHASE1");
        }
        return currentFavmString;
    }

    private String filterRedundancyPhase1(ILaunchConfiguration configuration, String currentFavmString) {
        try {
            boolean enableInclusion = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_INCLUSION_CRITERION", false);
            currentFavmString = fModelAnalysis.equals("Exploration") && enableInclusion ? currentFavmString.replace("//__PHASE1_&filter::redundancy", "&filter::redundancy") : WorkflowFAVM.suppressProcessString(currentFavmString, "//BEGIN_REDUNDANCY_PHASE1", "//END_REDUNDANCY_PHASE1");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return currentFavmString;
    }

    private String processHOJPhase1(ILaunchConfiguration configuration, String currentFavmString) {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        boolean expertMode = prefs.getBoolean("org.eclipse.efm.sew.launcher.ui.PREF_EXPERT_MODE");
        if (this.fAnalysisProfile.equals("MODEL") && fModelAnalysis.equals("Behavior Selection")) {
            currentFavmString = currentFavmString.replace("//__PHASE1_&process::hit_or_jump", "&process::hit_or_jump");
            if (expertMode) {
                try {
                    int i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_BEGIN_STEP", 0);
                    currentFavmString = currentFavmString.replace("__HOJ1_BEGIN_STEP__", Integer.toString(i));
                    boolean b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_HEURISTIC", true);
                    currentFavmString = currentFavmString.replace("__HOJ1_HEURISTIC__", Boolean.toString(b));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_STOP", true);
                    currentFavmString = currentFavmString.replace("__HOJ1_STOP__", Boolean.toString(b));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_SLICE", true);
                    currentFavmString = currentFavmString.replace("__HOJ1_SLICE__", Boolean.toString(b));
                    currentFavmString = currentFavmString.replace("__HOJ1_SEARCH_SCOPE__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_SEARCH_SCOPE", "LOCALLY"));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_JUMP_HEIGHT", 6);
                    currentFavmString = currentFavmString.replace("__HOJ1_JUMP_HEIGHT__", Integer.toString(i));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_JUMP_TRIALS_LIMIT", 2);
                    currentFavmString = currentFavmString.replace("__HOJ1_JUMP_LIMIT__", Integer.toString(i));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_HIT_COUNT", 1);
                    currentFavmString = currentFavmString.replace("__HOJ1_HIT_COUNT__", Integer.toString(i));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_HIT_CONSECUTIVE", false);
                    currentFavmString = currentFavmString.replace("__HOJ1_HIT_CONSECUTIVE__", Boolean.toString(b));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_HIT_MAX", false);
                    currentFavmString = currentFavmString.replace("__HOJ1_HIT_MAX__", Boolean.toString(b));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_JUMP_COUNT", 1);
                    currentFavmString = currentFavmString.replace("__HOJ1_JUMP_COUNT__", Integer.toString(i));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_JUMP_SLICE", false);
                    currentFavmString = currentFavmString.replace("__HOJ1_JUMP_SLICE__", Boolean.toString(b));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_SCHEDULER_ORDERED", true);
                    currentFavmString = currentFavmString.replace("__HOJ1_SCHEDULER__", b ? "|;|" : "|i|");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            } else {
                currentFavmString = currentFavmString.replace("__HOJ1_BEGIN_STEP__", "0");
                currentFavmString = currentFavmString.replace("__HOJ1_HEURISTIC__", "true");
                currentFavmString = currentFavmString.replace("__HOJ1_STOP__", "true");
                currentFavmString = currentFavmString.replace("__HOJ1_SLICE__", "true");
                currentFavmString = currentFavmString.replace("__HOJ1_SEARCH_SCOPE__", "LOCALLY");
                currentFavmString = currentFavmString.replace("__HOJ1_JUMP_HEIGHT__", "6");
                currentFavmString = currentFavmString.replace("__HOJ1_JUMP_LIMIT__", "2");
                currentFavmString = currentFavmString.replace("__HOJ1_HIT_COUNT__", "1");
                currentFavmString = currentFavmString.replace("__HOJ1_HIT_CONSECUTIVE__", "false");
                currentFavmString = currentFavmString.replace("__HOJ1_HIT_MAX__", "false");
                currentFavmString = currentFavmString.replace("__HOJ1_JUMP_COUNT__", "1");
                currentFavmString = currentFavmString.replace("__HOJ1_JUMP_SLICE__", "false");
                currentFavmString = currentFavmString.replace("__HOJ1_SCHEDULER__", "|;|");
            }
        } else {
            currentFavmString = WorkflowFAVM.suppressProcessString(currentFavmString, "//BEGIN_HOJ_PHASE1", "//END_HOJ_PHASE1");
        }
        return currentFavmString;
    }

    private String modeDebug(ILaunchConfiguration configuration, String currentFavmString) {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        boolean debugOptionMode = prefs.getBoolean("org.eclipse.efm.sew.launcher.ui.PREF_DEBUG_OPTIONS");
        if (debugOptionMode) {
            try {
                if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_PARSED_MODEL_GRAPHVIZ_GENERATION", false)) {
                    currentFavmString = currentFavmString.replace("//__@file_statemachine_graph", "@file");
                    currentFavmString = currentFavmString.replace("//__PHASE1_&processor::serializer#statemachine", "&processor::serializer#statemachine");
                } else {
                    currentFavmString = WorkflowFAVM.suppressProcessString(currentFavmString, "//BEGIN_SERIALIZER_STATEMACHINE_PHASE1", "//END_SERIALIZER_STATEMACHINE_PHASE1");
                }
                if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_GENERATION", false)) {
                    currentFavmString = currentFavmString.replace("//__@file_phase1_execution_graph", "@file");
                    currentFavmString = currentFavmString.replace("//__PHASE1_&processor::serializer#execution_graph", "&processor::serializer#execution_graph");
                } else {
                    currentFavmString = WorkflowFAVM.suppressProcessString(currentFavmString, "//BEGIN_SERIALIZER_EXECUTION_GRAPH_PHASE1", "//END_SERIALIZER_EXECUTION_GRAPH_PHASE1");
                }
                if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_GENERATION", false)) {
                    currentFavmString = currentFavmString.replace("//__@file_phase2_execution_graph", "@file");
                    currentFavmString = currentFavmString.replace("//__PHASE2_&processor::serializer#execution_graph", "&processor::serializer#execution_graph");
                } else if (this.fEnableTraceExtension) {
                    currentFavmString = WorkflowFAVM.suppressProcessString(currentFavmString, "//BEGIN_SERIALIZER_EXECUTION_GRAPH_PHASE2", "//END_SERIALIZER_EXECUTION_GRAPH_PHASE2");
                }
                currentFavmString = currentFavmString.replace("__CONSOLE_TRACE_LEVEL__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_CONSOLE_LOG_VERBOSE_LEVEL", "MINIMUM"));
                if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_DEVELOPER_TUNING", false)) {
                    currentFavmString = currentFavmString.replace("//__@log =", "@log =");
                    currentFavmString = currentFavmString.replace("__AVM_LOG__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_DEVELOPER_TUNING_LOG_FILENAME", "avm.log"));
                    currentFavmString = currentFavmString.replace("//__@debug =", "@debug =");
                    currentFavmString = currentFavmString.replace("__AVM_TRACE__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_DEVELOPER_TUNING_DEBUG_FILENAME", "avm.trace"));
                    currentFavmString = currentFavmString.replace("__TRACE_LEVEL__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_DEVELOPER_TUNING_DEBUG_LEVEL", "LOW"));
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_PARSING", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'PARSING';", "@kind = 'PARSING';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_COMPILING", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'COMPILING';", "@kind = 'COMPILING';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_COMPUTING", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'COMPUTING';", "@kind = 'COMPUTING';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_ALL_PROCESS_STAGE", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'ALL_PROCESS_STAGE';", "@kind = 'ALL_PROCESS_STAGE';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_PROGRAM", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'PROGRAM';", "@kind = 'PROGRAM';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_STATEMENT_ASSIGNMENT", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'STMNT_ASSIGN';", "@kind = 'STMNT_ASSIGN';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_STATEMENT", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'STATEMENT';", "@kind = 'STATEMENT';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_BYTECODE", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'BYTECODE';", "@kind = 'BYTECODE';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_STATEMENT_COMMUNICATION", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'STMNT_COM';", "@kind = 'STMNT_COM';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_SOLVING", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'SOLVING';", "@kind = 'SOLVING';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_DATA", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'DATA';", "@kind = 'DATA';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_REPORTING", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'REPORTING';", "@kind = 'REPORTING';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_CONFIGURING", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'CONFIGURING';", "@kind = 'CONFIGURING';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_REDUNDANCE", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'REDUNDANCE';", "@kind = 'REDUNDANCE';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_TRACE", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'TRACE';", "@kind = 'TRACE';");
                    }
                } else {
                    currentFavmString = currentFavmString.replace("__TRACE_LEVEL__", "ZERO");
                }
                if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_COMPILED_MODEL_TEXTUAL_GENERATION", false)) {
                    currentFavmString = currentFavmString.replace("//__PHASE1_@executable =", "@executable =");
                    currentFavmString = currentFavmString.replace("__PHASE1_EXE__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_FIRST_COMPILED_MODEL_TEXTUAL_FILENAME", "phase1.fexe"));
                }
                if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_SYMBEX_OUTPUT_TEXTUAL_GENERATION", false)) {
                    currentFavmString = currentFavmString.replace("//__PHASE1_@scenarii =", "@scenarii =");
                    currentFavmString = currentFavmString.replace("__PHASE1_FSCN__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_FIRST_SYMBEX_OUTPUT_TEXTUAL_FILENAME", "symbex_output.fscn"));
                }
                if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_SECOND_COMPILED_MODEL_TEXTUAL_GENERATION", false)) {
                    currentFavmString = currentFavmString.replace("//__PHASE2_@executable =", "@executable =");
                    currentFavmString = currentFavmString.replace("__PHASE2_EXE__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_SECOND_COMPILED_MODEL_TEXTUAL_GENERATION", "phase2.fexe"));
                }
                if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_SECOND_SYMBEX_OUTPUT_TEXTUAL_GENERATION", false)) {
                    currentFavmString = currentFavmString.replace("//__PHASE2_@scenarii =", "@scenarii =");
                    currentFavmString = currentFavmString.replace("__PHASE2_FSCN__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SECOND_SYMBEX_OUTPUT_TEXTUAL_FILENAME", "symbex_output_extension.fscn"));
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            currentFavmString = currentFavmString.replace("__CONSOLE_TRACE_LEVEL__", "MINIMUM");
            currentFavmString = currentFavmString.replace("__TRACE_LEVEL__", "ZERO");
        }
        return currentFavmString;
    }

    private static String parseFormatTrace(String traceText, String tab) {
        String[] traceList = traceText.trim().split(";|\\R");
        StringBuffer buffer = new StringBuffer();
        String[] stringArray = traceList;
        int n = traceList.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (!(element = element.toString()).isEmpty()) {
                if (element.startsWith("//")) {
                    buffer.append(tab).append(element).append("\n");
                } else {
                    int pos = element.indexOf(61);
                    if (pos > 0) {
                        String kind = element.substring(0, pos).trim();
                        String value = element.substring(pos + 1).trim();
                        buffer.append(tab).append("@").append(kind).append(" = ");
                        if (value.isEmpty()) {
                            buffer.append("\"\";\n");
                        } else if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
                            buffer.append(value).append(";\n");
                        } else {
                            buffer.append("\"").append(value).append("\";\n");
                        }
                    } else {
                        buffer.append(tab).append("//").append(element).append("\n");
                    }
                }
            }
            ++n2;
        }
        return buffer.toString();
    }

    private static String suppressProcessString(String input, String beginString, String endString) {
        int firstPos = input.indexOf(beginString);
        int lastPos = input.indexOf(endString) + endString.length() + 2;
        String result = String.valueOf(input.substring(0, firstPos)) + input.substring(lastPos, input.length());
        return result;
    }
}

