/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher.views.page;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.efm.sew.launcher.Activator;
import org.eclipse.efm.sew.launcher.LaunchDelegate;
import org.eclipse.efm.sew.launcher.views.page.SEWConsoleViewer;
import org.eclipse.efm.sew.launcher.views.page.SWTSpider;
import org.eclipse.efm.sew.launcher.workflow.IWorkflowConfigurationConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.part.Page;

public class SEWConsoleSpiderPage
extends Page
implements IWorkflowConfigurationConstants {
    private Composite fMainPageControl;
    private ScrolledComposite compSpider;
    private boolean consoleView;
    private boolean spiderView;
    private int nbExecution;
    private boolean firstLine;
    private boolean lastLine;
    private ProcessBuilder avmProcessBuilder;
    private Process avmProcess;
    private SEWConsoleViewer fConsoleViewer;
    private IOConsole fSEWDashbordConsole;
    private SWTSpider fSpider;
    private static final int DEFAULT_PERIOD_VALUE = 10;
    private int nbStep;
    private int maxStep = 0;
    private boolean resizeStep = false;
    private int stepStep = 10;
    private int nbContext;
    private int maxContext = 0;
    private boolean resizeContext = false;
    private int stepContext = 10;
    private int nbHeight;
    private int maxHeight = 0;
    private int oldNbHeight = 0;
    private int currentNbHeight = 0;
    private boolean resizeHeight = false;
    private int stepHeight = 10;
    private int nbWidth;
    private int maxWidth = 0;
    private int oldNbWidth = 0;
    private int currentNbWidth = 0;
    private boolean resizeWidth = false;
    private int stepWidth = 10;
    private int nbCoverage;
    private int maxCoverage = 0;
    private static final String CONSOLE_INIFINITE_SYMBOL = "+oo";
    private static final String CONSOLE_CONTEXT_SYMBOL = "context:";
    private static final String CONSOLE_COVERAGE_SYMBOL = "coverage:";
    private static final String CONSOLE_STEP_SYMBOL = "step:";
    private static final String CONSOLE_HEIGHT_SYMBOL = "height:";
    private static final String CONSOLE_WIDTH_SYMBOL = "width:";

    public void createControl(Composite parent) {
        this.fMainPageControl = new Composite(parent, 2064);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fMainPageControl, "org.eclipse.efm.sew.launcher.efm_sew_console");
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        this.consoleView = prefs.getBoolean("org.eclipse.efm.sew.launcher.ui.PREF_CONSOLE_VIEW");
        this.spiderView = prefs.getBoolean("org.eclipse.efm.sew.launcher.ui.PREF_SPIDER_VIEW");
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        this.fMainPageControl.setLayout((Layout)layout);
        this.fSpider = this.createSpider(this.fMainPageControl, 100, 90, 150);
        this.createConsoleViewer(this.fMainPageControl);
    }

    private void createConsoleViewer(Composite parent) {
        Composite comp = new Composite(parent, 2064);
        this.fSEWDashbordConsole = new IOConsole("SEW-Console", null);
        GridData dataRight = new GridData();
        dataRight.horizontalSpan = 2;
        dataRight.grabExcessHorizontalSpace = true;
        dataRight.grabExcessVerticalSpace = true;
        dataRight.horizontalAlignment = 4;
        dataRight.verticalAlignment = 4;
        this.fConsoleViewer = new SEWConsoleViewer(comp, (TextConsole)this.fSEWDashbordConsole);
        comp.setLayout((Layout)new FillLayout());
        comp.setLayoutData((Object)dataRight);
    }

    private SWTSpider createSpider(Composite parent, int x, int y, int r) {
        this.compSpider = new ScrolledComposite(parent, 2832);
        this.fSpider = new SWTSpider(this.compSpider, 0, x, y, r);
        this.compSpider.setContent((Control)this.fSpider);
        this.compSpider.setExpandHorizontal(true);
        this.compSpider.setExpandVertical(true);
        this.compSpider.setMinSize(480, 420);
        GridData dataLeft = new GridData();
        dataLeft.heightHint = 200;
        dataLeft.grabExcessHorizontalSpace = true;
        dataLeft.grabExcessVerticalSpace = true;
        dataLeft.horizontalAlignment = 4;
        dataLeft.verticalAlignment = 4;
        this.compSpider.setLayout((Layout)new FillLayout());
        this.compSpider.setLayoutData((Object)dataLeft);
        return this.fSpider;
    }

    public Control getControl() {
        return this.fMainPageControl;
    }

    public void setFocus() {
        this.fMainPageControl.setFocus();
    }

    public void sewLaunchExecProcess(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor, String[] cmdLine, File workingDir, String[] envp) {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        this.consoleView = prefs.getBoolean("org.eclipse.efm.sew.launcher.ui.PREF_CONSOLE_VIEW");
        try {
            block17: {
                IOConsoleOutputStream outputStream2 = null;
                OutputStreamWriter outputStreamWriter2 = null;
                BufferedWriter bufferedWriter2 = null;
                if (this.consoleView) {
                    outputStream2 = this.fSEWDashbordConsole.newOutputStream();
                    outputStreamWriter2 = new OutputStreamWriter((OutputStream)outputStream2);
                    bufferedWriter2 = new BufferedWriter(outputStreamWriter2);
                }
                this.fSEWDashbordConsole.clearConsole();
                if (this.fSpider != null) {
                    this.fSpider.resetSpider();
                }
                this.avmProcessBuilder = new ProcessBuilder(cmdLine);
                this.avmProcessBuilder = this.avmProcessBuilder.redirectErrorStream(true);
                this.avmProcessBuilder.directory(workingDir);
                try {
                    this.avmProcess = this.avmProcessBuilder.start();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                if (this.avmProcess == null) {
                    return;
                }
                InputStream inputStream1 = this.avmProcess.getInputStream();
                InputStreamReader inputStreamReader1 = new InputStreamReader(inputStream1);
                BufferedReader bufferedReader1 = new BufferedReader(inputStreamReader1);
                this.firstLine = true;
                this.lastLine = false;
                String traceLine = null;
                this.nbExecution = 0;
                do {
                    if (bufferedReader1.ready()) {
                        traceLine = bufferedReader1.readLine();
                        if (traceLine == null) continue;
                        this.majSpider(traceLine);
                        if (!this.consoleView) continue;
                        bufferedWriter2.append(traceLine).append("\n");
                        bufferedWriter2.flush();
                        continue;
                    }
                    try {
                        this.avmProcess.exitValue();
                        break block17;
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {}
                } while (!monitor.isCanceled());
                this.avmProcess.destroy();
                if (this.consoleView) {
                    bufferedWriter2.append("\n***********************\n* EXECUTION ABORTED ! *\n***********************");
                    bufferedWriter2.flush();
                }
                return;
            }
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (this.avmProcess != null) {
                this.avmProcess.destroy();
            }
            monitor.done();
        }
    }

    private void majSpider(String traceLine) {
        String tmpString = null;
        if (traceLine.startsWith(CONSOLE_STEP_SYMBOL) || traceLine.startsWith("stop:")) {
            tmpString = traceLine.replaceAll(" ", "");
            if (this.firstLine) {
                this.firstLine = false;
                ++this.nbExecution;
                if (this.nbExecution == 1) {
                    this.initVar();
                    this.initMaxAndResize(tmpString, this.nbExecution);
                }
            } else if (!this.lastLine) {
                this.majDisplayedData(tmpString, this.nbExecution);
                this.majStepAndMax();
                this.fSpider.updateSpider(this.nbExecution, this.nbStep, this.maxStep, this.nbContext, this.maxContext, this.nbHeight, this.maxHeight, this.nbWidth, this.maxWidth, this.nbCoverage, this.maxCoverage);
                if (traceLine.startsWith("stop:")) {
                    if (this.nbExecution == 1) {
                        this.firstLine = true;
                    } else {
                        this.lastLine = true;
                    }
                }
            }
        }
    }

    private void initVar() {
        this.maxStep = 0;
        this.resizeStep = false;
        this.stepStep = 10;
        this.maxContext = 0;
        this.resizeContext = false;
        this.stepContext = 10;
        this.maxHeight = 0;
        this.oldNbHeight = 0;
        this.currentNbHeight = 0;
        this.resizeHeight = false;
        this.stepHeight = 10;
        this.maxWidth = 0;
        this.oldNbWidth = 0;
        this.currentNbWidth = 0;
        this.resizeWidth = false;
        this.stepWidth = 10;
        this.maxCoverage = 0;
    }

    private void initMaxAndResize(String aString, int nbExe) {
        String s = aString.substring(CONSOLE_STEP_SYMBOL.length(), aString.indexOf(CONSOLE_CONTEXT_SYMBOL) - 1);
        this.maxStep = s.equals(CONSOLE_INIFINITE_SYMBOL) ? 10 : Integer.parseInt(s);
        this.resizeStep = s.equals(CONSOLE_INIFINITE_SYMBOL);
        s = aString.substring(aString.indexOf(CONSOLE_CONTEXT_SYMBOL) + CONSOLE_CONTEXT_SYMBOL.length(), aString.indexOf(CONSOLE_HEIGHT_SYMBOL) - 1);
        this.maxContext = s.equals(CONSOLE_INIFINITE_SYMBOL) ? 10 : Integer.parseInt(s);
        this.resizeContext = s.equals(CONSOLE_INIFINITE_SYMBOL);
        s = aString.substring(aString.indexOf(CONSOLE_HEIGHT_SYMBOL) + CONSOLE_HEIGHT_SYMBOL.length(), aString.indexOf(CONSOLE_WIDTH_SYMBOL) - 1);
        this.maxHeight = s.equals(CONSOLE_INIFINITE_SYMBOL) ? 10 : Integer.parseInt(s);
        this.resizeHeight = s.equals(CONSOLE_INIFINITE_SYMBOL);
        if (nbExe == 1 && (LaunchDelegate.fModelAnalysis.equals("Exploration") || LaunchDelegate.fModelAnalysis.equals(""))) {
            s = aString.substring(aString.indexOf(CONSOLE_WIDTH_SYMBOL) + CONSOLE_WIDTH_SYMBOL.length(), aString.length());
            this.maxWidth = s.equals(CONSOLE_INIFINITE_SYMBOL) ? 10 : Integer.parseInt(s);
            this.resizeWidth = s.equals(CONSOLE_INIFINITE_SYMBOL);
        } else if (nbExe == 1 || LaunchDelegate.fEnableTraceExtension) {
            s = aString.substring(aString.indexOf(CONSOLE_WIDTH_SYMBOL) + CONSOLE_WIDTH_SYMBOL.length(), aString.indexOf(CONSOLE_COVERAGE_SYMBOL) - 1);
            this.maxWidth = s.equals(CONSOLE_INIFINITE_SYMBOL) ? 10 : Integer.parseInt(s);
            this.resizeWidth = s.equals(CONSOLE_INIFINITE_SYMBOL);
            s = aString.substring(aString.indexOf("/") + 1);
            this.maxCoverage = Integer.parseInt(s);
        }
    }

    private void majDisplayedData(String aString, int nbExe) {
        int beginIndex = CONSOLE_STEP_SYMBOL.length();
        int currentIndex = aString.indexOf(CONSOLE_CONTEXT_SYMBOL);
        int endIndex = currentIndex - 1;
        this.nbStep = Integer.parseInt(aString.substring(beginIndex, endIndex));
        beginIndex = currentIndex + CONSOLE_CONTEXT_SYMBOL.length();
        currentIndex = aString.indexOf(CONSOLE_HEIGHT_SYMBOL);
        endIndex = currentIndex - 1;
        this.nbContext = Integer.parseInt(aString.substring(beginIndex, endIndex));
        beginIndex = currentIndex + CONSOLE_HEIGHT_SYMBOL.length();
        currentIndex = aString.indexOf(CONSOLE_WIDTH_SYMBOL);
        endIndex = currentIndex - 1;
        this.currentNbHeight = Integer.parseInt(aString.substring(beginIndex, endIndex));
        int n = this.nbHeight = this.currentNbHeight > this.oldNbHeight ? this.currentNbHeight : this.oldNbHeight;
        if (nbExe == 1 && (LaunchDelegate.fModelAnalysis.equals("Exploration") || LaunchDelegate.fModelAnalysis.equals(""))) {
            beginIndex = currentIndex + 6;
            endIndex = aString.length();
            this.currentNbWidth = Integer.parseInt(aString.substring(beginIndex, endIndex));
            this.nbWidth = this.currentNbWidth > this.oldNbWidth ? this.currentNbWidth : this.oldNbWidth;
        } else if (nbExe == 1 || LaunchDelegate.fEnableTraceExtension) {
            beginIndex = currentIndex + CONSOLE_WIDTH_SYMBOL.length();
            currentIndex = aString.indexOf(CONSOLE_COVERAGE_SYMBOL);
            endIndex = currentIndex - 1;
            this.currentNbWidth = Integer.parseInt(aString.substring(beginIndex, endIndex));
            this.nbWidth = this.currentNbWidth > this.oldNbWidth ? this.currentNbWidth : this.oldNbWidth;
            beginIndex = currentIndex + CONSOLE_COVERAGE_SYMBOL.length();
            endIndex = aString.indexOf("/");
            this.nbCoverage = Integer.parseInt(aString.substring(beginIndex, endIndex));
        }
    }

    private void majStepAndMax() {
        if (this.resizeStep) {
            while (this.nbStep >= this.maxStep) {
                if (this.maxStep / this.stepStep <= 9) {
                    this.maxStep += this.stepStep;
                    continue;
                }
                this.stepStep *= 10;
                this.maxStep = this.stepStep;
            }
        }
        if (this.resizeContext) {
            while (this.nbContext >= this.maxContext) {
                if (this.maxContext / this.stepContext <= 9) {
                    this.maxContext += this.stepContext;
                    continue;
                }
                this.stepContext *= 10;
                this.maxContext = this.stepContext;
            }
        }
        if (this.resizeHeight) {
            while (this.nbHeight >= this.maxHeight) {
                if (this.maxHeight / this.stepHeight <= 9) {
                    this.maxHeight += this.stepHeight;
                    continue;
                }
                this.stepHeight *= 10;
                this.maxHeight = this.stepHeight;
            }
        }
        if (this.resizeWidth) {
            while (this.nbWidth >= this.maxWidth) {
                if (this.maxWidth / this.stepWidth <= 9) {
                    this.maxWidth += this.stepWidth;
                    continue;
                }
                this.stepWidth *= 10;
                this.maxWidth = this.stepWidth;
            }
        }
    }
}

