/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.text.java.IJavaReconcilingListener;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.swt.widgets.Shell;

class OverrideIndicatorManager
implements IJavaReconcilingListener {
    static final String ANNOTATION_TYPE = "org.eclipse.jdt.ui.overrideIndicator";
    private IAnnotationModel fAnnotationModel;
    private Object fAnnotationModelLockObject;
    private Annotation[] fOverrideAnnotations;
    private ITypeRoot fJavaElement;

    public OverrideIndicatorManager(IAnnotationModel annotationModel, ITypeRoot javaElement, CompilationUnit ast) {
        Assert.isNotNull((Object)annotationModel);
        Assert.isNotNull((Object)javaElement);
        this.fJavaElement = javaElement;
        this.fAnnotationModel = annotationModel;
        this.fAnnotationModelLockObject = this.getLockObject(this.fAnnotationModel);
        this.updateAnnotations(ast, (IProgressMonitor)new NullProgressMonitor());
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAnnotations(CompilationUnit ast, IProgressMonitor progressMonitor) {
        if (ast == null || progressMonitor.isCanceled()) {
            return;
        }
        final HashMap annotationMap = new HashMap(50);
        ast.accept(new ASTVisitor(false){

            public boolean visit(MethodDeclaration node) {
                IMethodBinding definingMethod;
                IMethodBinding binding = node.resolveBinding();
                if (binding != null && (definingMethod = Bindings.findOverriddenMethod(binding, true)) != null) {
                    ITypeBinding definingType = definingMethod.getDeclaringClass();
                    String qualifiedMethodName = String.valueOf(definingType.getQualifiedName()) + "." + binding.getName();
                    boolean isImplements = JdtFlags.isAbstract(definingMethod);
                    String text = isImplements ? Messages.format(JavaEditorMessages.OverrideIndicatorManager_implements, BasicElementLabels.getJavaElementName(qualifiedMethodName)) : Messages.format(JavaEditorMessages.OverrideIndicatorManager_overrides, BasicElementLabels.getJavaElementName(qualifiedMethodName));
                    SimpleName name = node.getName();
                    Position position = new Position(name.getStartPosition(), name.getLength());
                    annotationMap.put(new OverrideIndicator(isImplements, text, binding.getKey()), position);
                }
                return true;
            }
        });
        if (progressMonitor.isCanceled()) {
            return;
        }
        Object object = this.fAnnotationModelLockObject;
        synchronized (object) {
            if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(this.fOverrideAnnotations, annotationMap);
            } else {
                this.removeAnnotations();
                for (Map.Entry mapEntry : annotationMap.entrySet()) {
                    this.fAnnotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                }
            }
            this.fOverrideAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAnnotations() {
        if (this.fOverrideAnnotations == null) {
            return;
        }
        Object object = this.fAnnotationModelLockObject;
        synchronized (object) {
            if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(this.fOverrideAnnotations, null);
            } else {
                int i = 0;
                int length = this.fOverrideAnnotations.length;
                while (i < length) {
                    this.fAnnotationModel.removeAnnotation(this.fOverrideAnnotations[i]);
                    ++i;
                }
            }
            this.fOverrideAnnotations = null;
        }
    }

    @Override
    public void aboutToBeReconciled() {
    }

    @Override
    public void reconciled(CompilationUnit ast, boolean forced, IProgressMonitor progressMonitor) {
        this.updateAnnotations(ast, progressMonitor);
    }

    class OverrideIndicator
    extends Annotation {
        private boolean fIsOverwriteIndicator;
        private String fAstNodeKey;

        OverrideIndicator(boolean isOverwriteIndicator, String text, String key) {
            super(OverrideIndicatorManager.ANNOTATION_TYPE, false, text);
            this.fIsOverwriteIndicator = isOverwriteIndicator;
            this.fAstNodeKey = key;
        }

        public boolean isOverwriteIndicator() {
            return this.fIsOverwriteIndicator;
        }

        public void open() {
            ASTNode node;
            CompilationUnit ast = SharedASTProvider.getAST(OverrideIndicatorManager.this.fJavaElement, SharedASTProvider.WAIT_ACTIVE_ONLY, null);
            if (ast != null && (node = ast.findDeclaringNode(this.fAstNodeKey)) instanceof MethodDeclaration) {
                try {
                    IJavaElement definingMethod;
                    IMethodBinding methodBinding = ((MethodDeclaration)node).resolveBinding();
                    IMethodBinding definingMethodBinding = Bindings.findOverriddenMethod(methodBinding, true);
                    if (definingMethodBinding != null && (definingMethod = definingMethodBinding.getJavaElement()) != null) {
                        JavaUI.openInEditor(definingMethod, true, true);
                        return;
                    }
                }
                catch (CoreException e) {
                    ExceptionHandler.handle(e, JavaEditorMessages.OverrideIndicatorManager_open_error_title, JavaEditorMessages.OverrideIndicatorManager_open_error_messageHasLogEntry);
                    return;
                }
            }
            String title = JavaEditorMessages.OverrideIndicatorManager_open_error_title;
            String message = JavaEditorMessages.OverrideIndicatorManager_open_error_message;
            MessageDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
        }
    }
}

