/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.help.IContextProvider;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dnd.JdtViewerDragSupport;
import org.eclipse.jdt.internal.ui.dnd.JdtViewerDropSupport;
import org.eclipse.jdt.internal.ui.filters.OutputFolderFilter;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerActionGroup;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerLabelProvider;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jdt.internal.ui.packageview.WorkingSetAwareContentProvider;
import org.eclipse.jdt.internal.ui.packageview.WorkingSetAwareJavaElementSorter;
import org.eclipse.jdt.internal.ui.packageview.WorkingSetDropAdapter;
import org.eclipse.jdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.jdt.internal.ui.util.JavaUIHelp;
import org.eclipse.jdt.internal.ui.util.SelectionUtil;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.FilterUpdater;
import org.eclipse.jdt.internal.ui.viewsupport.IRefreshable;
import org.eclipse.jdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.jdt.internal.ui.viewsupport.StatusBarUpdater;
import org.eclipse.jdt.internal.ui.workingsets.ConfigureWorkingSetAction;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.actions.CustomFiltersActionGroup;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.FrameAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.TreeFrame;

public class PackageExplorerPart
extends ViewPart
implements ISetSelectionTarget,
IMenuListener,
IShowInTarget,
IRefreshable,
IPackagesViewPart,
IPropertyChangeListener,
IViewPartInputProvider {
    private static final String PERF_CREATE_PART_CONTROL = "org.eclipse.jdt.ui/perf/explorer/createPartControl";
    private static final String PERF_MAKE_ACTIONS = "org.eclipse.jdt.ui/perf/explorer/makeActions";
    private static final int HIERARCHICAL_LAYOUT = 1;
    private static final int FLAT_LAYOUT = 2;
    public static final int PROJECTS_AS_ROOTS = 1;
    public static final int WORKING_SETS_AS_ROOTS = 2;
    private static final String VIEW_ID = "org.eclipse.jdt.ui.PackageExplorer";
    private static final String TAG_LAYOUT = "layout";
    private static final String TAG_GROUP_LIBRARIES = "group_libraries";
    private static final String TAG_ROOT_MODE = "rootMode";
    private static final String TAG_LINK_EDITOR = "linkWithEditor";
    private static final String TAG_MEMENTO = "memento";
    private boolean fIsCurrentLayoutFlat;
    private boolean fShowLibrariesNode;
    private boolean fLinkingEnabled;
    private int fRootMode;
    private WorkingSetModel fWorkingSetModel;
    private PackageExplorerLabelProvider fLabelProvider;
    private DecoratingJavaLabelProvider fDecoratingLabelProvider;
    private PackageExplorerContentProvider fContentProvider;
    private FilterUpdater fFilterUpdater;
    private PackageExplorerActionGroup fActionSet;
    private ProblemTreeViewer fViewer;
    private Menu fContextMenu;
    private IMemento fMemento;
    private OpenAndLinkWithEditorHelper fOpenAndLinkWithEditorHelper;
    private String fWorkingSetLabel;
    private final IDialogSettings fDialogSettings;
    private final IPartListener2 fLinkWithEditorListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
            IWorkbenchPage activePage = JavaPlugin.getActivePage();
            if (partRef instanceof IEditorReference && activePage != null && activePage.getActivePartReference() == partRef) {
                PackageExplorerPart.this.editorActivated(((IEditorReference)partRef).getEditor(true));
            }
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            if (partRef instanceof IEditorReference) {
                PackageExplorerPart.this.editorActivated(((IEditorReference)partRef).getEditor(true));
            }
        }
    };
    private final ITreeViewerListener fExpansionListener = new ITreeViewerListener(){

        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            Object element = event.getElement();
            if (element instanceof ICompilationUnit || element instanceof IClassFile) {
                PackageExplorerPart.this.expandMainType(element);
            }
        }
    };

    public PackageExplorerPart() {
        this.fDialogSettings = JavaPlugin.getDefault().getDialogSettingsSection(this.getClass().getName());
        this.fShowLibrariesNode = this.fDialogSettings.get(TAG_GROUP_LIBRARIES) == null || this.fDialogSettings.getBoolean(TAG_GROUP_LIBRARIES);
        this.fLinkingEnabled = this.fDialogSettings.getBoolean(TAG_LINK_EDITOR);
        try {
            this.fIsCurrentLayoutFlat = this.fDialogSettings.getInt(TAG_LAYOUT) == 2;
        }
        catch (NumberFormatException numberFormatException) {
            this.fIsCurrentLayoutFlat = true;
        }
        try {
            this.fRootMode = this.fDialogSettings.getInt(TAG_ROOT_MODE);
        }
        catch (NumberFormatException numberFormatException) {
            this.fRootMode = 1;
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        String persistedMemento;
        super.init(site, memento);
        if (memento == null && (persistedMemento = this.fDialogSettings.get(TAG_MEMENTO)) != null) {
            try {
                memento = XMLMemento.createReadRoot((Reader)new StringReader(persistedMemento));
            }
            catch (WorkbenchException workbenchException) {}
        }
        this.fMemento = memento;
        if (memento != null) {
            this.restoreLayoutState(memento);
            this.restoreLinkingEnabled(memento);
            this.restoreRootMode(memento);
        }
        if (this.getRootMode() == 2) {
            this.createWorkingSetModel();
        }
    }

    private void restoreRootMode(IMemento memento) {
        Integer value = memento.getInteger(TAG_ROOT_MODE);
        int n = this.fRootMode = value == null ? 1 : value;
        if (this.fRootMode != 1 && this.fRootMode != 2) {
            this.fRootMode = 1;
        }
    }

    private void restoreLayoutState(IMemento memento) {
        Integer layoutState = memento.getInteger(TAG_LAYOUT);
        this.fIsCurrentLayoutFlat = layoutState == null || layoutState == 2;
        Integer groupLibraries = memento.getInteger(TAG_GROUP_LIBRARIES);
        this.fShowLibrariesNode = groupLibraries == null || groupLibraries != 0;
    }

    public static PackageExplorerPart getFromActivePerspective() {
        IWorkbenchPage activePage = JavaPlugin.getActivePage();
        if (activePage == null) {
            return null;
        }
        IViewPart view = activePage.findView(VIEW_ID);
        if (view instanceof PackageExplorerPart) {
            return (PackageExplorerPart)view;
        }
        return null;
    }

    public static PackageExplorerPart openInActivePerspective() {
        try {
            return (PackageExplorerPart)JavaPlugin.getActivePage().showView(VIEW_ID);
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public void dispose() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"packageExplorer");
        this.saveState((IMemento)memento);
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            this.fDialogSettings.put(TAG_MEMENTO, writer.getBuffer().toString());
        }
        catch (IOException iOException) {}
        if (this.fContextMenu != null && !this.fContextMenu.isDisposed()) {
            this.fContextMenu.dispose();
        }
        this.getSite().getPage().removePartListener(this.fLinkWithEditorListener);
        JavaPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.fViewer != null) {
            this.fViewer.removeTreeListener(this.fExpansionListener);
        }
        if (this.fActionSet != null) {
            this.fActionSet.dispose();
        }
        if (this.fFilterUpdater != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        }
        if (this.fWorkingSetModel != null) {
            this.fWorkingSetModel.dispose();
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        PerformanceStats stats = PerformanceStats.getStats((String)PERF_CREATE_PART_CONTROL, (Object)this);
        stats.startRun();
        this.fViewer = this.createViewer(parent);
        this.fViewer.setUseHashlookup(true);
        this.initDragAndDrop();
        this.setProviders();
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuMgr.createContextMenu((Control)this.fViewer.getTree());
        this.fViewer.getTree().setMenu(this.fContextMenu);
        IWorkbenchPartSite site = this.getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.fViewer);
        site.setSelectionProvider((ISelectionProvider)this.fViewer);
        this.makeActions();
        this.restoreFilterAndSorter();
        this.fViewer.setInput(this.findInputElement());
        this.initFrameActions();
        this.initKeyListener();
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PackageExplorerPart.this.fActionSet.handleDoubleClick(event);
            }
        });
        this.fOpenAndLinkWithEditorHelper = new OpenAndLinkWithEditorHelper((StructuredViewer)this.fViewer){

            protected void activate(ISelection selection) {
                try {
                    Object selectedElement = SelectionUtil.getSingleElement(selection);
                    if (EditorUtility.isOpenInEditor(selectedElement) != null) {
                        EditorUtility.openInEditor(selectedElement, true);
                    }
                }
                catch (PartInitException partInitException) {}
            }

            protected void linkToEditor(ISelection selection) {
                PackageExplorerPart.this.linkToEditor(selection);
            }

            protected void open(ISelection selection, boolean activate) {
                PackageExplorerPart.this.fActionSet.handleOpen(selection, activate);
            }
        };
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fViewer.addSelectionChangedListener(new StatusBarUpdater(slManager));
        this.fViewer.addTreeListener(this.fExpansionListener);
        JavaUIHelp.setHelp((StructuredViewer)this.fViewer, "org.eclipse.jdt.ui.package_view_context");
        this.fillActionBars();
        this.updateTitle();
        this.fFilterUpdater = new FilterUpdater(this.fViewer);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        this.setLinkingEnabled(this.isLinkingEnabled());
        stats.endRun();
    }

    private void initFrameActions() {
        this.fActionSet.getUpAction().update();
        this.fActionSet.getBackAction().update();
        this.fActionSet.getForwardAction().update();
    }

    private ProblemTreeViewer createViewer(Composite composite) {
        return new PackageExplorerProblemTreeViewer(composite, 770);
    }

    public boolean isFlatLayout() {
        return this.fIsCurrentLayoutFlat;
    }

    private void setProviders() {
        this.fContentProvider = this.createContentProvider();
        this.fContentProvider.setIsFlatLayout(this.fIsCurrentLayoutFlat);
        this.fContentProvider.setShowLibrariesNode(this.fShowLibrariesNode);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setComparer(this.createElementComparer());
        this.fLabelProvider = this.createLabelProvider();
        this.fLabelProvider.setIsFlatLayout(this.fIsCurrentLayoutFlat);
        this.fDecoratingLabelProvider = new DecoratingJavaLabelProvider(this.fLabelProvider, false, this.fIsCurrentLayoutFlat);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fDecoratingLabelProvider);
    }

    public void setShowLibrariesNode(boolean enabled) {
        this.fShowLibrariesNode = enabled;
        this.saveDialogSettings();
        this.fContentProvider.setShowLibrariesNode(enabled);
        this.fViewer.getControl().setRedraw(false);
        this.fViewer.refresh();
        this.fViewer.getControl().setRedraw(true);
    }

    boolean isLibrariesNodeShown() {
        return this.fShowLibrariesNode;
    }

    public void setFlatLayout(boolean enable) {
        this.fIsCurrentLayoutFlat = enable;
        this.saveDialogSettings();
        if (this.fViewer != null) {
            this.fContentProvider.setIsFlatLayout(this.isFlatLayout());
            this.fLabelProvider.setIsFlatLayout(this.isFlatLayout());
            this.fDecoratingLabelProvider.setFlatPackageMode(this.isFlatLayout());
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.refresh();
            this.fViewer.getControl().setRedraw(true);
        }
    }

    public PackageExplorerContentProvider createContentProvider() {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        boolean showCUChildren = store.getBoolean("org.eclipse.jdt.ui.packages.cuchildren");
        if (this.getRootMode() == 1) {
            return new PackageExplorerContentProvider(showCUChildren);
        }
        return new WorkingSetAwareContentProvider(showCUChildren, this.fWorkingSetModel);
    }

    private PackageExplorerLabelProvider createLabelProvider() {
        return new PackageExplorerLabelProvider(this.fContentProvider);
    }

    private IElementComparer createElementComparer() {
        if (this.getRootMode() == 1) {
            return null;
        }
        return WorkingSetModel.COMPARER;
    }

    private void fillActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fActionSet.fillActionBars(actionBars);
    }

    private Object findInputElement() {
        if (this.getRootMode() == 2) {
            return this.fWorkingSetModel;
        }
        IAdaptable input = this.getSite().getPage().getInput();
        if (input instanceof IWorkspace) {
            return JavaCore.create((IWorkspaceRoot)((IWorkspace)input).getRoot());
        }
        if (input instanceof IContainer) {
            IJavaElement element = JavaCore.create((IResource)((IContainer)input));
            if (element != null && element.exists()) {
                return element;
            }
            return input;
        }
        return JavaCore.create((IWorkspaceRoot)JavaPlugin.getWorkspace().getRoot());
    }

    public <T> T getAdapter(Class<T> key) {
        if (key.equals(ISelectionProvider.class)) {
            return (T)this.fViewer;
        }
        if (key == IShowInSource.class) {
            return (T)this.getShowInSource();
        }
        if (key == IShowInTargetList.class) {
            return (T)new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        if (key == IContextProvider.class) {
            return (T)JavaUIHelp.getHelpContextProvider((IWorkbenchPart)this, "org.eclipse.jdt.ui.package_view_context");
        }
        return (T)super.getAdapter(key);
    }

    String getToolTipText(Object element) {
        IPath path;
        String result = !(element instanceof IResource) ? (element instanceof IJavaModel ? PackagesMessages.PackageExplorerPart_workspace : (element instanceof IJavaElement ? JavaElementLabels.getTextLabel(element, JavaElementLabels.ALL_FULLY_QUALIFIED) : (element instanceof IWorkingSet ? ((IWorkingSet)element).getLabel() : (element instanceof WorkingSetModel ? PackagesMessages.PackageExplorerPart_workingSetModel : this.fLabelProvider.getText(element))))) : ((path = ((IResource)element).getFullPath()).isRoot() ? PackagesMessages.PackageExplorer_title : BasicElementLabels.getPathLabel(path, false));
        if (this.fRootMode == 1) {
            if (this.fWorkingSetLabel == null) {
                return result;
            }
            if (result.length() == 0) {
                return Messages.format(PackagesMessages.PackageExplorer_toolTip, new String[]{this.fWorkingSetLabel});
            }
            return Messages.format(PackagesMessages.PackageExplorer_toolTip2, new String[]{result, this.fWorkingSetLabel});
        }
        if (element != null && !(element instanceof IWorkingSet) && !(element instanceof WorkingSetModel) && this.fActionSet != null) {
            FrameList frameList = this.fActionSet.getFrameList();
            int index = frameList.getCurrentIndex();
            IWorkingSet ws = null;
            while (index >= 0) {
                Object input;
                Frame frame = frameList.getFrame(index);
                if (frame instanceof TreeFrame && (input = ((TreeFrame)frame).getInput()) instanceof IWorkingSet) {
                    ws = (IWorkingSet)input;
                    break;
                }
                --index;
            }
            if (ws != null) {
                return Messages.format(PackagesMessages.PackageExplorer_toolTip3, new String[]{BasicElementLabels.getWorkingSetLabel(ws), result});
            }
            return result;
        }
        return result;
    }

    public String getTitleToolTip() {
        if (this.fViewer == null) {
            return super.getTitleToolTip();
        }
        return this.getToolTipText(this.fViewer.getInput());
    }

    public void setFocus() {
        this.fViewer.getTree().setFocus();
    }

    private ISelection getSelection() {
        return this.fViewer.getSelection();
    }

    public void menuAboutToShow(IMenuManager menu) {
        JavaPlugin.createStandardGroups(menu);
        this.fActionSet.setContext(new ActionContext(this.getSelection()));
        this.fActionSet.fillContextMenu(menu);
        this.fActionSet.setContext(null);
    }

    private void makeActions() {
        PerformanceStats stats = PerformanceStats.getStats((String)PERF_MAKE_ACTIONS, (Object)this);
        stats.startRun();
        this.fActionSet = new PackageExplorerActionGroup(this);
        if (this.fWorkingSetModel != null) {
            this.fActionSet.getWorkingSetActionGroup().setWorkingSetModel(this.fWorkingSetModel);
        }
        stats.endRun();
    }

    private void initDragAndDrop() {
        this.initDrag();
        this.initDrop();
    }

    private void initDrag() {
        new JdtViewerDragSupport((StructuredViewer)this.fViewer).start();
    }

    private void initDrop() {
        JdtViewerDropSupport dropSupport = new JdtViewerDropSupport((StructuredViewer)this.fViewer);
        dropSupport.addDropTargetListener(new WorkingSetDropAdapter(this));
        dropSupport.start();
    }

    @Override
    public void refresh(IStructuredSelection selection) {
        Object[] selectedElements = selection.toArray();
        int i = 0;
        while (i < selectedElements.length) {
            this.fViewer.refresh(selectedElements[i]);
            ++i;
        }
    }

    public void selectReveal(ISelection selection) {
        Control ctrl = this.getTreeViewer().getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        this.fContentProvider.runPendingUpdates();
        this.fViewer.setSelection(this.convertSelection(selection), true);
    }

    public ISelection convertSelection(ISelection s) {
        if (!(s instanceof IStructuredSelection)) {
            return s;
        }
        Object[] elements = ((IStructuredSelection)s).toArray();
        boolean changed = false;
        int i = 0;
        while (i < elements.length) {
            Object convertedElement = this.convertElement(elements[i]);
            changed = changed || convertedElement != elements[i];
            elements[i] = convertedElement;
            ++i;
        }
        if (changed) {
            return new StructuredSelection(elements);
        }
        return s;
    }

    private Object convertElement(Object original) {
        if (original instanceof IJavaElement) {
            IResource resource;
            ICompilationUnit cu;
            IJavaProject javaProject;
            if (original instanceof ICompilationUnit && (javaProject = (cu = (ICompilationUnit)original).getJavaProject()) != null && javaProject.exists() && !javaProject.isOnClasspath((IJavaElement)cu) && (resource = cu.getResource()) != null) {
                return resource;
            }
            return original;
        }
        if (original instanceof IResource) {
            IJavaProject javaProject;
            IJavaElement je = JavaCore.create((IResource)((IResource)original));
            if (je != null && je.exists() && (javaProject = je.getJavaProject()) != null && javaProject.exists()) {
                if (javaProject.equals(je) || javaProject.isOnClasspath(je)) {
                    return je;
                }
                return original;
            }
        } else if (original instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)original;
            IJavaElement je = (IJavaElement)adaptable.getAdapter(IJavaElement.class);
            if (je != null && je.exists()) {
                return je;
            }
            IResource r = (IResource)adaptable.getAdapter(IResource.class);
            if (r != null) {
                je = JavaCore.create((IResource)r);
                if (je != null && je.exists()) {
                    return je;
                }
                return r;
            }
        }
        return original;
    }

    @Override
    public void selectAndReveal(Object element) {
        this.selectReveal((ISelection)new StructuredSelection(element));
    }

    @Override
    public boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    private void linkToEditor(ISelection selection) {
        IEditorPart part;
        Object obj = SelectionUtil.getSingleElement(selection);
        if (obj != null && (part = EditorUtility.isOpenInEditor(obj)) != null) {
            IWorkbenchPage page = this.getSite().getPage();
            page.bringToTop((IWorkbenchPart)part);
            if (obj instanceof IJavaElement) {
                EditorUtility.revealInEditor(part, (IJavaElement)obj);
            }
        }
    }

    public void saveState(IMemento memento) {
        if (this.fViewer == null && this.fMemento != null) {
            memento.putMemento(this.fMemento);
            return;
        }
        memento.putInteger(TAG_ROOT_MODE, this.fRootMode);
        if (this.fWorkingSetModel != null) {
            this.fWorkingSetModel.saveState(memento);
        }
        this.saveLayoutState(memento);
        this.saveLinkingEnabled(memento);
        if (this.fActionSet != null) {
            this.fActionSet.saveFilterAndSorterState(memento);
        }
    }

    private void saveLinkingEnabled(IMemento memento) {
        memento.putInteger(TAG_LINK_EDITOR, this.fLinkingEnabled ? 1 : 0);
    }

    private void saveLayoutState(IMemento memento) {
        if (memento != null) {
            memento.putInteger(TAG_LAYOUT, this.getLayoutAsInt());
            memento.putInteger(TAG_GROUP_LIBRARIES, this.fShowLibrariesNode ? 1 : 0);
        }
    }

    private void saveDialogSettings() {
        this.fDialogSettings.put(TAG_GROUP_LIBRARIES, this.fShowLibrariesNode);
        this.fDialogSettings.put(TAG_LAYOUT, this.getLayoutAsInt());
        this.fDialogSettings.put(TAG_ROOT_MODE, this.fRootMode);
        this.fDialogSettings.put(TAG_LINK_EDITOR, this.fLinkingEnabled);
    }

    private int getLayoutAsInt() {
        if (this.fIsCurrentLayoutFlat) {
            return 2;
        }
        return 1;
    }

    private void restoreFilterAndSorter() {
        this.fViewer.addFilter(new OutputFolderFilter());
        this.setComparator();
        if (this.fMemento != null) {
            this.fActionSet.restoreFilterAndSorterState(this.fMemento);
        }
    }

    private void restoreLinkingEnabled(IMemento memento) {
        Integer val = memento.getInteger(TAG_LINK_EDITOR);
        this.fLinkingEnabled = val != null && val != 0;
    }

    private void initKeyListener() {
        this.fViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                PackageExplorerPart.this.fActionSet.handleKeyEvent(event);
            }
        });
    }

    void editorActivated(IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return;
        }
        Object input = this.getInputFromEditor(editorInput);
        if (input == null) {
            return;
        }
        if (!this.inputIsSelected(editorInput)) {
            this.showInput(input);
        } else {
            this.getTreeViewer().getTree().showSelection();
        }
    }

    private Object getInputFromEditor(IEditorInput editorInput) {
        ICompilationUnit cu;
        Object input = JavaUI.getEditorInputJavaElement(editorInput);
        if (input instanceof ICompilationUnit && !(cu = (ICompilationUnit)input).getJavaProject().isOnClasspath((IJavaElement)cu)) {
            input = cu.getResource();
        }
        if (input == null) {
            input = editorInput.getAdapter(IFile.class);
        }
        if (input == null && editorInput instanceof IStorageEditorInput) {
            try {
                input = ((IStorageEditorInput)editorInput).getStorage();
            }
            catch (CoreException coreException) {}
        }
        return input;
    }

    private boolean inputIsSelected(IEditorInput input) {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (selection.size() != 1) {
            return false;
        }
        IEditorInput selectionAsInput = EditorUtility.getEditorInput(selection.getFirstElement());
        return input.equals(selectionAsInput);
    }

    boolean showInput(Object input) {
        Object element = null;
        if (input instanceof IFile && this.isOnClassPath((IFile)input)) {
            element = JavaCore.create((IFile)((IFile)input));
        }
        if (element == null) {
            element = input;
        }
        if (element != null) {
            StructuredSelection newSelection = new StructuredSelection(element);
            if (this.fViewer.getSelection().equals(newSelection)) {
                this.fViewer.reveal(element);
            } else {
                this.fViewer.setSelection((ISelection)newSelection, true);
                while (element != null && this.fViewer.getSelection().isEmpty()) {
                    if ((element = this.getParent(element)) == null) continue;
                    newSelection = new StructuredSelection(element);
                    this.fViewer.setSelection((ISelection)newSelection, true);
                }
            }
            return true;
        }
        return false;
    }

    private boolean isOnClassPath(IFile file) {
        IJavaProject jproject = JavaCore.create((IProject)file.getProject());
        return jproject.isOnClasspath((IResource)file);
    }

    private Object getParent(Object element) {
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).getParent();
        }
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        if (element instanceof IJarEntryResource) {
            return ((IJarEntryResource)element).getParent();
        }
        return null;
    }

    void expandMainType(Object element) {
        try {
            IType type = null;
            if (element instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)element;
                IType[] types = cu.getTypes();
                if (types.length > 0) {
                    type = types[0];
                }
            } else if (element instanceof IClassFile) {
                IClassFile cf = (IClassFile)element;
                type = cf.getType();
            }
            if (type != null) {
                final IType type2 = type;
                Control ctrl = this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ctrl.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Control ctrl2 = PackageExplorerPart.this.fViewer.getControl();
                            if (ctrl2 != null && !ctrl2.isDisposed()) {
                                PackageExplorerPart.this.fViewer.expandToLevel(type2, 1);
                            }
                        }
                    });
                }
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    @Override
    public TreeViewer getTreeViewer() {
        return this.fViewer;
    }

    boolean isExpandable(Object element) {
        if (this.fViewer == null) {
            return false;
        }
        return this.fViewer.isExpandable(element);
    }

    void setWorkingSetLabel(String workingSetName) {
        this.fWorkingSetLabel = workingSetName;
        this.setTitleToolTip(this.getTitleToolTip());
    }

    void updateToolbar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fActionSet.updateToolBar(actionBars.getToolBarManager());
    }

    void updateTitle() {
        Object input = this.fViewer.getInput();
        if (input == null || input instanceof IJavaModel) {
            this.setContentDescription("");
            this.setTitleToolTip("");
        } else {
            String inputText = JavaElementLabels.getTextLabel(input, 36283885813801L);
            this.setContentDescription(inputText);
            this.setTitleToolTip(this.getToolTipText(input));
        }
    }

    @Deprecated
    public void setLabelDecorator(ILabelDecorator decorator) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fViewer == null) {
            return;
        }
        boolean refreshViewer = false;
        if ("org.eclipse.jdt.ui.packages.cuchildren".equals(event.getProperty())) {
            boolean showCUChildren = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.packages.cuchildren");
            ((StandardJavaElementContentProvider)this.fViewer.getContentProvider()).setProvideMembers(showCUChildren);
            refreshViewer = true;
        } else if (MembersOrderPreferenceCache.isMemberOrderProperty(event.getProperty())) {
            refreshViewer = true;
        }
        if (refreshViewer) {
            this.fViewer.refresh();
        }
    }

    @Override
    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    public void collapseAll() {
        try {
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.collapseToLevel(this.getViewPartInput(), -1);
        }
        finally {
            this.fViewer.getControl().setRedraw(true);
        }
    }

    public boolean show(ShowInContext context) {
        Object input;
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1) {
                int res = this.tryToReveal(structuredSelection.getFirstElement());
                if (res == 0) {
                    return true;
                }
                if (res == 8) {
                    return false;
                }
            } else if (structuredSelection.size() > 1) {
                this.selectReveal((ISelection)structuredSelection);
                return true;
            }
        }
        if ((input = context.getInput()) instanceof IEditorInput) {
            Object elementOfInput = this.getInputFromEditor((IEditorInput)input);
            return elementOfInput != null && this.tryToReveal(elementOfInput) == 0;
        }
        return false;
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(PackageExplorerPart.this.getTreeViewer().getInput(), PackageExplorerPart.this.getTreeViewer().getSelection());
            }
        };
    }

    @Override
    public void setLinkingEnabled(boolean enabled) {
        this.fLinkingEnabled = enabled;
        this.saveDialogSettings();
        IWorkbenchPage page = this.getSite().getPage();
        if (enabled) {
            page.addPartListener(this.fLinkWithEditorListener);
            IEditorPart editor = page.getActiveEditor();
            if (editor != null) {
                this.editorActivated(editor);
            }
        } else {
            page.removePartListener(this.fLinkWithEditorListener);
        }
        this.fOpenAndLinkWithEditorHelper.setLinkWithEditor(enabled);
    }

    String getFrameName(Object element) {
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).getElementName();
        }
        if (element instanceof WorkingSetModel) {
            return "";
        }
        return this.fLabelProvider.getText(element);
    }

    public int tryToReveal(Object element) {
        String[] newFilters;
        CustomFiltersActionGroup filterGroup;
        String[] currentFilters;
        if (this.revealElementOrParent(element)) {
            return 0;
        }
        WorkingSetFilterActionGroup workingSetGroup = this.fActionSet.getWorkingSetActionGroup().getFilterGroup();
        if (workingSetGroup != null) {
            IWorkingSet workingSet = workingSetGroup.getWorkingSet();
            if (workingSetGroup.isFiltered(this.getVisibleParent(element), element)) {
                String message;
                if (element instanceof IJavaElement) {
                    String elementLabel = JavaElementLabels.getElementLabel((IJavaElement)element, JavaElementLabels.ALL_DEFAULT);
                    message = Messages.format(PackagesMessages.PackageExplorerPart_notFoundSepcific, new String[]{elementLabel, BasicElementLabels.getWorkingSetLabel(workingSet)});
                } else {
                    message = Messages.format(PackagesMessages.PackageExplorer_notFound, BasicElementLabels.getWorkingSetLabel(workingSet));
                }
                if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)PackagesMessages.PackageExplorer_filteredDialog_title, (String)message)) {
                    workingSetGroup.setWorkingSet(null, true);
                    if (this.revealElementOrParent(element)) {
                        return 0;
                    }
                } else {
                    return 8;
                }
            }
        }
        if ((currentFilters = (filterGroup = this.fActionSet.getCustomFilterActionGroup()).internalGetEnabledFilterIds()).length > (newFilters = filterGroup.removeFiltersFor(this.getVisibleParent(element), element, this.getTreeViewer().getContentProvider())).length) {
            String message;
            if (element instanceof IJavaElement) {
                String elementLabel = JavaElementLabels.getElementLabel((IJavaElement)element, JavaElementLabels.ALL_DEFAULT);
                message = Messages.format(PackagesMessages.PackageExplorerPart_removeFiltersSpecific, elementLabel);
            } else {
                message = PackagesMessages.PackageExplorer_removeFilters;
            }
            if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)PackagesMessages.PackageExplorer_filteredDialog_title, (String)message)) {
                filterGroup.setFilters(newFilters);
                if (this.revealElementOrParent(element)) {
                    return 0;
                }
            } else {
                return 8;
            }
        }
        FrameAction action = this.fActionSet.getUpAction();
        while (action.getFrameList().getCurrentIndex() > 0) {
            if (action.getFrameList().getSource().getFrame(3, 0) == null) break;
            action.run();
            if (!this.revealElementOrParent(element)) continue;
            return 0;
        }
        return 4;
    }

    private boolean revealElementOrParent(Object element) {
        if (this.revealAndVerify(element)) {
            return true;
        }
        if ((element = this.getVisibleParent(element)) != null) {
            IResource resource;
            if (this.revealAndVerify(element)) {
                return true;
            }
            if (element instanceof IJavaElement && (resource = ((IJavaElement)element).getResource()) != null && this.revealAndVerify(resource)) {
                return true;
            }
        }
        return false;
    }

    private Object getVisibleParent(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof IJavaElement)) {
            return object;
        }
        IJavaElement element2 = (IJavaElement)object;
        switch (element2.getElementType()) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                element2 = (IJavaElement)element2.getOpenable();
                break;
            }
            case 1: {
                element2 = null;
            }
        }
        return element2;
    }

    private boolean revealAndVerify(Object element) {
        if (element == null) {
            return false;
        }
        this.selectReveal((ISelection)new StructuredSelection(element));
        return !this.getSite().getSelectionProvider().getSelection().isEmpty();
    }

    public void rootModeChanged(int newMode) {
        this.fRootMode = newMode;
        this.saveDialogSettings();
        if (this.getRootMode() == 2 && this.fWorkingSetModel == null) {
            this.createWorkingSetModel();
            if (this.fActionSet != null) {
                this.fActionSet.getWorkingSetActionGroup().setWorkingSetModel(this.fWorkingSetModel);
            }
        }
        StructuredSelection selection = new StructuredSelection(((IStructuredSelection)this.fViewer.getSelection()).toArray());
        Object input = this.fViewer.getInput();
        boolean isRootInputChange = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).equals(input) || this.fWorkingSetModel != null && this.fWorkingSetModel.equals(input) || input instanceof IWorkingSet;
        try {
            this.fViewer.getControl().setRedraw(false);
            if (isRootInputChange) {
                this.fViewer.setInput(null);
            }
            this.setProviders();
            this.setComparator();
            this.fActionSet.getWorkingSetActionGroup().fillFilters((StructuredViewer)this.fViewer);
            if (isRootInputChange) {
                this.fViewer.setInput(this.findInputElement());
            }
            this.fViewer.setSelection((ISelection)selection, true);
        }
        finally {
            this.fViewer.getControl().setRedraw(true);
        }
        if (isRootInputChange && this.getRootMode() == 2 && this.fWorkingSetModel.needsConfiguration()) {
            ConfigureWorkingSetAction action = new ConfigureWorkingSetAction(this.getSite());
            action.setWorkingSetModel(this.fWorkingSetModel);
            action.run();
            this.fWorkingSetModel.configured();
        }
        this.setTitleToolTip(this.getTitleToolTip());
    }

    private void createWorkingSetModel() {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                PackageExplorerPart.this.fWorkingSetModel = new WorkingSetModel(PackageExplorerPart.this.fMemento);
            }

            public void handleException(Throwable exception) {
                PackageExplorerPart.this.fWorkingSetModel = new WorkingSetModel(null);
            }
        });
    }

    public IWorkingSet getFilterWorkingSet() {
        if (this.getRootMode() != 1) {
            return null;
        }
        if (this.fActionSet == null) {
            return null;
        }
        return this.fActionSet.getWorkingSetActionGroup().getFilterGroup().getWorkingSet();
    }

    public WorkingSetModel getWorkingSetModel() {
        return this.fWorkingSetModel;
    }

    public int getRootMode() {
        return this.fRootMode;
    }

    private void setComparator() {
        if (this.getRootMode() == 2) {
            this.fViewer.setComparator(new WorkingSetAwareJavaElementSorter());
        } else {
            this.fViewer.setComparator(new JavaElementComparator());
        }
    }

    private class PackageExplorerProblemTreeViewer
    extends ProblemTreeViewer {
        private final List<Object> fPendingRefreshes;

        public PackageExplorerProblemTreeViewer(Composite parent, int style) {
            super(parent, style);
            this.fPendingRefreshes = Collections.synchronizedList(new ArrayList());
        }

        public void add(Object parentElement, Object[] childElements) {
            if (this.fPendingRefreshes.contains(parentElement)) {
                return;
            }
            super.add(parentElement, childElements);
        }

        protected void internalRefresh(Object element, boolean updateLabels) {
            try {
                this.fPendingRefreshes.add(element);
                super.internalRefresh(element, updateLabels);
            }
            finally {
                this.fPendingRefreshes.remove(element);
            }
        }

        @Override
        protected boolean evaluateExpandableWithFilters(Object parent) {
            if (parent instanceof IJavaProject || parent instanceof ICompilationUnit || parent instanceof IClassFile || parent instanceof ClassPathContainer) {
                return false;
            }
            return !(parent instanceof IPackageFragmentRoot) || !((IPackageFragmentRoot)parent).isArchive();
        }

        @Override
        protected boolean isFiltered(Object object, Object parent, ViewerFilter[] filters) {
            boolean res = super.isFiltered(object, parent, filters);
            if (res && this.isEssential(object)) {
                return false;
            }
            return res;
        }

        private boolean isEssential(Object object) {
            try {
                IPackageFragment fragment;
                if (!PackageExplorerPart.this.isFlatLayout() && object instanceof IPackageFragment && !(fragment = (IPackageFragment)object).isDefaultPackage() && fragment.hasSubpackages()) {
                    return this.hasFilteredChildren(fragment);
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            return false;
        }

        protected void handleInvalidSelection(ISelection invalidSelection, ISelection newSelection) {
            IStructuredSelection is = (IStructuredSelection)invalidSelection;
            ArrayList<Object> ns = null;
            ns = newSelection instanceof IStructuredSelection ? new ArrayList(((IStructuredSelection)newSelection).toList()) : new ArrayList<Object>();
            boolean changed = false;
            for (Object element : is) {
                IProject project;
                if (element instanceof IJavaProject) {
                    project = ((IJavaProject)element).getProject();
                    if (project.isOpen() || !project.exists()) continue;
                    ns.add(project);
                    changed = true;
                    continue;
                }
                if (!(element instanceof IProject) || !(project = (IProject)element).isOpen()) continue;
                IJavaProject jProject = JavaCore.create((IProject)project);
                if (jProject != null && jProject.exists()) {
                    ns.add(jProject);
                }
                changed = true;
            }
            if (changed) {
                newSelection = new StructuredSelection(ns);
                this.setSelection(newSelection);
            }
            super.handleInvalidSelection(invalidSelection, newSelection);
        }

        @Override
        protected Object[] addAditionalProblemParents(Object[] elements) {
            if (PackageExplorerPart.this.getRootMode() == 2 && elements != null) {
                return PackageExplorerPart.this.fWorkingSetModel.addWorkingSets(elements);
            }
            return elements;
        }
    }
}

