/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class ProblemLocation
implements IProblemLocation {
    private final int fId;
    private final String[] fArguments;
    private final int fOffset;
    private final int fLength;
    private final boolean fIsError;
    private final String fMarkerType;

    public ProblemLocation(int offset, int length, IJavaAnnotation annotation) {
        this.fId = annotation.getId();
        String[] arguments = annotation.getArguments();
        this.fArguments = arguments != null ? arguments : new String[]{};
        this.fOffset = offset;
        this.fLength = length;
        this.fIsError = "org.eclipse.jdt.ui.error".equals(annotation.getType());
        String markerType = annotation.getMarkerType();
        this.fMarkerType = markerType != null ? markerType : "org.eclipse.jdt.core.problem";
    }

    public ProblemLocation(int offset, int length, int id, String[] arguments, boolean isError, String markerType) {
        this.fId = id;
        this.fArguments = arguments;
        this.fOffset = offset;
        this.fLength = length;
        this.fIsError = isError;
        this.fMarkerType = markerType;
    }

    public ProblemLocation(IProblem problem) {
        this.fId = problem.getID();
        this.fArguments = problem.getArguments();
        this.fOffset = problem.getSourceStart();
        this.fLength = problem.getSourceEnd() - this.fOffset + 1;
        this.fIsError = problem.isError();
        this.fMarkerType = problem instanceof CategorizedProblem ? ((CategorizedProblem)problem).getMarkerType() : "org.eclipse.jdt.core.problem";
    }

    @Override
    public int getProblemId() {
        return this.fId;
    }

    @Override
    public String[] getProblemArguments() {
        return this.fArguments;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public int getOffset() {
        return this.fOffset;
    }

    @Override
    public boolean isError() {
        return this.fIsError;
    }

    @Override
    public String getMarkerType() {
        return this.fMarkerType;
    }

    @Override
    public ASTNode getCoveringNode(CompilationUnit astRoot) {
        NodeFinder finder = new NodeFinder((ASTNode)astRoot, this.fOffset, this.fLength);
        return finder.getCoveringNode();
    }

    @Override
    public ASTNode getCoveredNode(CompilationUnit astRoot) {
        NodeFinder finder = new NodeFinder((ASTNode)astRoot, this.fOffset, this.fLength);
        return finder.getCoveredNode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Id: ").append(this.getErrorCode(this.fId)).append('\n');
        buf.append('[').append(this.fOffset).append(", ").append(this.fLength).append(']').append('\n');
        String[] arg = this.fArguments;
        int i = 0;
        while (i < arg.length) {
            buf.append(arg[i]);
            buf.append('\n');
            ++i;
        }
        return buf.toString();
    }

    private String getErrorCode(int code) {
        StringBuffer buf = new StringBuffer();
        if ((code & 0x1000000) != 0) {
            buf.append("TypeRelated + ");
        }
        if ((code & 0x2000000) != 0) {
            buf.append("FieldRelated + ");
        }
        if ((code & 0x8000000) != 0) {
            buf.append("ConstructorRelated + ");
        }
        if ((code & 0x4000000) != 0) {
            buf.append("MethodRelated + ");
        }
        if ((code & 0x10000000) != 0) {
            buf.append("ImportRelated + ");
        }
        if ((code & 0x20000000) != 0) {
            buf.append("Internal + ");
        }
        if ((code & 0x40000000) != 0) {
            buf.append("Syntax + ");
        }
        if ((code & Integer.MIN_VALUE) != 0) {
            buf.append("Javadoc + ");
        }
        buf.append(code & 0xFFFFFF);
        return buf.toString();
    }
}

