/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.javadoc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDocMessages;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLinks;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.JavadocContentAccess;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.internal.text.html.HTMLPrinter;

public class JavadocContentAccess2 {
    private static final String BASE_URL_COMMENT_INTRO = "<!-- baseURL=\"";
    private static final String BLOCK_TAG_START = "<dl>";
    private static final String BLOCK_TAG_END = "</dl>";
    private static final String BlOCK_TAG_ENTRY_START = "<dd>";
    private static final String BlOCK_TAG_ENTRY_END = "</dd>";
    private static final String PARAM_NAME_START = "<b>";
    private static final String PARAM_NAME_END = "</b> ";
    private final IJavaElement fElement;
    private final IMethod fMethod;
    private final Javadoc fJavadoc;
    private final String fSource;
    private final JavadocLookup fJavadocLookup;
    private StringBuffer fBuf;
    private int fLiteralContent;
    private StringBuffer fMainDescription;
    private StringBuffer fReturnDescription;
    private StringBuffer[] fTypeParamDescriptions;
    private StringBuffer[] fParamDescriptions;
    private HashMap<String, StringBuffer> fExceptionDescriptions;

    private JavadocContentAccess2(IJavaElement element, Javadoc javadoc, String source, JavadocLookup lookup) {
        Assert.isNotNull((Object)element);
        Assert.isTrue((element instanceof IMethod || element instanceof ILocalVariable || element instanceof ITypeParameter ? 1 : 0) != 0);
        this.fElement = element;
        this.fMethod = (IMethod)(element instanceof ILocalVariable || element instanceof ITypeParameter ? element.getParent() : element);
        this.fJavadoc = javadoc;
        this.fSource = source;
        this.fJavadocLookup = lookup;
    }

    private JavadocContentAccess2(IJavaElement element, Javadoc javadoc, String source) {
        Assert.isTrue((element instanceof IMember || element instanceof IPackageFragment || element instanceof ILocalVariable || element instanceof ITypeParameter ? 1 : 0) != 0);
        this.fElement = element;
        this.fMethod = null;
        this.fJavadoc = javadoc;
        this.fSource = source;
        this.fJavadocLookup = JavadocLookup.NONE;
    }

    public static String getHTMLContent(IJavaElement element, boolean useAttachedJavadoc) throws CoreException {
        if (element instanceof IPackageFragment) {
            return JavadocContentAccess2.getHTMLContent((IPackageFragment)element);
        }
        if (element instanceof IPackageDeclaration) {
            return JavadocContentAccess2.getHTMLContent((IPackageDeclaration)element);
        }
        if (!(element instanceof IMember || element instanceof ITypeParameter || element instanceof ILocalVariable && ((ILocalVariable)element).isParameter())) {
            return null;
        }
        String sourceJavadoc = JavadocContentAccess2.getHTMLContentFromSource(element);
        if ((sourceJavadoc == null || sourceJavadoc.length() == 0 || sourceJavadoc.trim().equals("{@inheritDoc}")) && useAttachedJavadoc) {
            if (element.getOpenable().getBuffer() == null) {
                return element.getAttachedJavadoc(null);
            }
            IMember member = null;
            if (element instanceof ILocalVariable) {
                member = ((ILocalVariable)element).getDeclaringMember();
            } else if (element instanceof ITypeParameter) {
                member = ((ITypeParameter)element).getDeclaringMember();
            } else if (element instanceof IMember) {
                member = (IMember)element;
            }
            if (JavadocContentAccess2.canInheritJavadoc(member)) {
                IMethod method = (IMethod)member;
                String attachedDocInHierarchy = JavadocContentAccess2.findAttachedDocInHierarchy(method);
                if (attachedDocInHierarchy == null) {
                    return sourceJavadoc;
                }
                StringBuffer superMethodReferences = JavadocContentAccess2.createSuperMethodReferences(method);
                if (superMethodReferences == null) {
                    return attachedDocInHierarchy;
                }
                superMethodReferences.append(attachedDocInHierarchy);
                return superMethodReferences.toString();
            }
        }
        return sourceJavadoc;
    }

    private static StringBuffer createSuperMethodReferences(final IMethod method) throws JavaModelException {
        boolean hasSuperInterfaceMethods;
        IType type = method.getDeclaringType();
        ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy(type);
        final MethodOverrideTester tester = SuperTypeHierarchyCache.getMethodOverrideTester(type);
        final ArrayList superInterfaceMethods = new ArrayList();
        final IMethod[] superClassMethod = new IMethod[1];
        new InheritDocVisitor(){

            @Override
            public Object visit(IType currType) throws JavaModelException {
                IMethod overridden = tester.findOverriddenMethodInType(currType, method);
                if (overridden == null) {
                    return InheritDocVisitor.CONTINUE;
                }
                if (currType.isInterface()) {
                    superInterfaceMethods.add(overridden);
                } else {
                    superClassMethod[0] = overridden;
                }
                return STOP_BRANCH;
            }
        }.visitInheritDoc(type, hierarchy);
        boolean bl = hasSuperInterfaceMethods = superInterfaceMethods.size() != 0;
        if (!hasSuperInterfaceMethods && superClassMethod[0] == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<div>");
        if (hasSuperInterfaceMethods) {
            buf.append(PARAM_NAME_START);
            buf.append(JavaDocMessages.JavaDoc2HTMLTextReader_specified_by_section);
            buf.append(PARAM_NAME_END);
            Iterator iter = superInterfaceMethods.iterator();
            while (iter.hasNext()) {
                IMethod overridden = (IMethod)iter.next();
                buf.append(JavadocContentAccess2.createMethodInTypeLinks(overridden));
                if (!iter.hasNext()) continue;
                buf.append(JavaElementLabels.COMMA_STRING);
            }
        }
        if (superClassMethod[0] != null) {
            if (hasSuperInterfaceMethods) {
                buf.append(JavaElementLabels.COMMA_STRING);
            }
            buf.append(PARAM_NAME_START);
            buf.append(JavaDocMessages.JavaDoc2HTMLTextReader_overrides_section);
            buf.append(PARAM_NAME_END);
            buf.append(JavadocContentAccess2.createMethodInTypeLinks(superClassMethod[0]));
        }
        buf.append("</div>");
        return buf;
    }

    private static String createMethodInTypeLinks(IMethod overridden) {
        CharSequence methodLink = JavadocContentAccess2.createSimpleMemberLink((IMember)overridden);
        CharSequence typeLink = JavadocContentAccess2.createSimpleMemberLink((IMember)overridden.getDeclaringType());
        String methodInType = MessageFormat.format(JavaDocMessages.JavaDoc2HTMLTextReader_method_in_type, methodLink, typeLink);
        return methodInType;
    }

    private static CharSequence createSimpleMemberLink(IMember member) {
        StringBuffer buf = new StringBuffer();
        buf.append("<a href='");
        try {
            String uri = JavaElementLinks.createURI("eclipse-javadoc", (IJavaElement)member);
            buf.append(uri);
        }
        catch (URISyntaxException e) {
            JavaPlugin.log(e);
        }
        buf.append("'>");
        JavaElementLabels.getElementLabel((IJavaElement)member, 0L, buf);
        buf.append("</a>");
        return buf;
    }

    private static String getHTMLContentFromSource(IJavaElement element) throws JavaModelException {
        IMember member;
        if (element instanceof ILocalVariable) {
            member = ((ILocalVariable)element).getDeclaringMember();
        } else if (element instanceof ITypeParameter) {
            member = ((ITypeParameter)element).getDeclaringMember();
        } else if (element instanceof IMember) {
            member = (IMember)element;
        } else {
            return null;
        }
        IBuffer buf = member.getOpenable().getBuffer();
        if (buf == null) {
            return null;
        }
        ISourceRange javadocRange = member.getJavadocRange();
        if (javadocRange == null) {
            String inheritedJavadoc;
            if (JavadocContentAccess2.canInheritJavadoc(member) && (inheritedJavadoc = JavadocContentAccess2.javadoc2HTML(member, element, "/***/")) != null && inheritedJavadoc.length() > 0) {
                return inheritedJavadoc;
            }
            return JavadocContentAccess2.getJavaFxPropertyDoc(member);
        }
        String rawJavadoc = buf.getText(javadocRange.getOffset(), javadocRange.getLength());
        return JavadocContentAccess2.javadoc2HTML(member, element, rawJavadoc);
    }

    private static String getJavaFxPropertyDoc(IMember member) throws JavaModelException {
        if (member instanceof IMethod) {
            boolean isSetter;
            String name = member.getElementName();
            boolean isGetter = name.startsWith("get") && name.length() > 3;
            boolean isBooleanGetter = name.startsWith("is") && name.length() > 2;
            boolean bl = isSetter = name.startsWith("set") && name.length() > 3;
            if (isGetter || isBooleanGetter || isSetter) {
                String propertyName = JavadocContentAccess2.firstToLower(name.substring(isBooleanGetter ? 2 : 3));
                IType type = member.getDeclaringType();
                IMethod method = type.getMethod(String.valueOf(propertyName) + "Property", new String[0]);
                if (method.exists()) {
                    String content = JavadocContentAccess2.getHTMLContentFromSource((IJavaElement)method);
                    if (content != null) {
                        content = isSetter ? Messages.format(JavaDocMessages.JavadocContentAccess2_setproperty_message, new Object[]{propertyName, content}) : Messages.format(JavaDocMessages.JavadocContentAccess2_getproperty_message, new Object[]{propertyName, content});
                    }
                    return content;
                }
            } else if (name.endsWith("Property")) {
                String propertyName = name.substring(0, name.length() - 8);
                IType type = member.getDeclaringType();
                IField field = type.getField(propertyName);
                if (field.exists()) {
                    return JavadocContentAccess2.getHTMLContentFromSource((IJavaElement)field);
                }
            }
        }
        return null;
    }

    private static String firstToLower(String propertyName) {
        char[] c = propertyName.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return String.valueOf(c);
    }

    private static Javadoc getJavadocNode(IJavaElement element, String rawJavadoc) {
        String source = String.valueOf(rawJavadoc) + "class C{}";
        CompilationUnit root = JavadocContentAccess2.createAST(element, source);
        if (root == null) {
            return null;
        }
        List types = root.types();
        if (types.size() != 1) {
            return null;
        }
        AbstractTypeDeclaration type = (AbstractTypeDeclaration)types.get(0);
        return type.getJavadoc();
    }

    private static Javadoc getPackageJavadocNode(IJavaElement element, String cuSource) {
        PackageDeclaration packDecl;
        CompilationUnit cu = JavadocContentAccess2.createAST(element, cuSource);
        if (cu != null && (packDecl = cu.getPackage()) != null) {
            return packDecl.getJavadoc();
        }
        return null;
    }

    private static CompilationUnit createAST(IJavaElement element, String cuSource) {
        Assert.isNotNull((Object)element);
        ASTParser parser = ASTParser.newParser((int)8);
        IJavaProject javaProject = element.getJavaProject();
        parser.setProject(javaProject);
        Map options = javaProject.getOptions(true);
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        parser.setCompilerOptions(options);
        parser.setSource(cuSource.toCharArray());
        return (CompilationUnit)parser.createAST(null);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String javadoc2HTML(IMember member, IJavaElement element, String rawJavadoc) {
        Javadoc javadoc = JavadocContentAccess2.getJavadocNode((IJavaElement)member, rawJavadoc);
        if (javadoc == null) {
            Reader contentReader;
            block13: {
                contentReader = null;
                contentReader = JavadocContentAccess.getHTMLContentReader(member, false, false);
                if (contentReader == null) break block13;
                String string = JavadocContentAccess2.getString(contentReader);
                if (contentReader == null) return string;
                try {
                    contentReader.close();
                    return string;
                }
                catch (IOException iOException) {}
                return string;
                catch (JavaModelException e) {
                    try {
                        JavaPlugin.log(e);
                        if (contentReader == null) return null;
                    }
                    catch (Throwable throwable) {
                        if (contentReader == null) throw throwable;
                        try {
                            contentReader.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        contentReader.close();
                        return null;
                    }
                    catch (IOException iOException) {}
                    return null;
                }
            }
            if (contentReader == null) return null;
            try {
                contentReader.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
        if (!JavadocContentAccess2.canInheritJavadoc(member)) return new JavadocContentAccess2(element, javadoc, rawJavadoc).toHTML();
        IMethod method = (IMethod)member;
        return new JavadocContentAccess2(element, javadoc, rawJavadoc, new JavadocLookup(method.getDeclaringType(), null, null)).toHTML();
    }

    private static boolean canInheritJavadoc(IMember member) {
        if (member instanceof IMethod && member.getJavaProject().exists()) {
            try {
                return !((IMethod)member).isConstructor();
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return false;
    }

    private static String getString(Reader reader) {
        StringBuffer buf = new StringBuffer();
        char[] buffer = new char[1024];
        try {
            int count;
            while ((count = reader.read(buffer)) != -1) {
                buf.append(buffer, 0, count);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return buf.toString();
    }

    private static String findAttachedDocInHierarchy(final IMethod method) throws JavaModelException {
        IType type = method.getDeclaringType();
        ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy(type);
        final MethodOverrideTester tester = SuperTypeHierarchyCache.getMethodOverrideTester(type);
        return (String)new InheritDocVisitor(){

            @Override
            public Object visit(IType currType) throws JavaModelException {
                String attachedJavadoc;
                IMethod overridden = tester.findOverriddenMethodInType(currType, method);
                if (overridden == null) {
                    return InheritDocVisitor.CONTINUE;
                }
                if (overridden.getOpenable().getBuffer() == null && (attachedJavadoc = overridden.getAttachedJavadoc(null)) != null) {
                    String baseURL = JavaDocLocations.getBaseURL((IJavaElement)overridden, overridden.isBinary());
                    if (baseURL != null) {
                        attachedJavadoc = JavadocContentAccess2.BASE_URL_COMMENT_INTRO + baseURL + "\"--> " + attachedJavadoc;
                    }
                    return attachedJavadoc;
                }
                return CONTINUE;
            }
        }.visitInheritDoc(type, hierarchy);
    }

    private String toHTML() {
        this.fBuf = new StringBuffer();
        this.fLiteralContent = 0;
        if (this.fElement instanceof ILocalVariable || this.fElement instanceof ITypeParameter) {
            this.parameterToHTML();
        } else {
            this.elementToHTML();
        }
        String result = this.fBuf.toString();
        this.fBuf = null;
        return result;
    }

    private void parameterToHTML() {
        List<String> typeParameterNames;
        int i;
        String elementName = this.fElement.getElementName();
        List tags = this.fJavadoc.tags();
        for (TagElement tag : tags) {
            String firstText;
            List fragments;
            int size;
            String tagName = tag.getTagName();
            if (!"@param".equals(tagName) || (size = (fragments = tag.fragments()).size()) <= 0) continue;
            Object first = fragments.get(0);
            if (first instanceof SimpleName) {
                String name = ((SimpleName)first).getIdentifier();
                if (!elementName.equals(name)) continue;
                this.handleContentElements(fragments.subList(1, size));
                return;
            }
            if (size <= 2 || !(this.fElement instanceof ITypeParameter) || !(first instanceof TextElement) || !"<".equals(firstText = ((TextElement)first).getText())) continue;
            Object second = fragments.get(1);
            Object third = fragments.get(2);
            if (!(second instanceof SimpleName) || !(third instanceof TextElement)) continue;
            String name = ((SimpleName)second).getIdentifier();
            String thirdText = ((TextElement)third).getText();
            if (!elementName.equals(name) || !">".equals(thirdText)) continue;
            this.handleContentElements(fragments.subList(3, size));
            return;
        }
        if (this.fElement instanceof ILocalVariable) {
            List<String> parameterNames = this.initParameterNames();
            int i2 = parameterNames.indexOf(elementName);
            if (i2 != -1) {
                CharSequence inheritedParamDescription = this.fJavadocLookup.getInheritedParamDescription(this.fMethod, i2);
                this.handleInherited(inheritedParamDescription);
            }
        } else if (this.fElement instanceof ITypeParameter && (i = (typeParameterNames = this.initTypeParameterNames()).indexOf(elementName)) != -1) {
            CharSequence inheritedTypeParamDescription = this.fJavadocLookup.getInheritedTypeParamDescription(this.fMethod, i);
            this.handleInherited(inheritedTypeParamDescription);
        }
    }

    private void elementToHTML() {
        boolean hasExceptions;
        List<String> typeParameterNames = this.initTypeParameterNames();
        List<String> parameterNames = this.initParameterNames();
        List<String> exceptionNames = this.initExceptionNames();
        TagElement deprecatedTag = null;
        TagElement start = null;
        ArrayList<TagElement> typeParameters = new ArrayList<TagElement>();
        ArrayList<TagElement> parameters = new ArrayList<TagElement>();
        TagElement returnTag = null;
        ArrayList<TagElement> exceptions = new ArrayList<TagElement>();
        ArrayList<TagElement> versions = new ArrayList<TagElement>();
        ArrayList<TagElement> authors = new ArrayList<TagElement>();
        ArrayList<TagElement> sees = new ArrayList<TagElement>();
        ArrayList<TagElement> since = new ArrayList<TagElement>();
        ArrayList<TagElement> rest = new ArrayList<TagElement>();
        List tags = this.fJavadoc.tags();
        for (TagElement tag : tags) {
            List fragments;
            String tagName = tag.getTagName();
            if (tagName == null) {
                start = tag;
                continue;
            }
            if ("@param".equals(tagName)) {
                String firstText;
                fragments = tag.fragments();
                int size = fragments.size();
                if (size <= 0) continue;
                Object first = fragments.get(0);
                if (first instanceof SimpleName) {
                    String name = ((SimpleName)first).getIdentifier();
                    int paramIndex = parameterNames.indexOf(name);
                    if (paramIndex != -1) {
                        parameterNames.set(paramIndex, null);
                    }
                    parameters.add(tag);
                    continue;
                }
                if (size <= 2 || !(first instanceof TextElement) || !"<".equals(firstText = ((TextElement)first).getText())) continue;
                Object second = fragments.get(1);
                Object third = fragments.get(2);
                if (!(second instanceof SimpleName) || !(third instanceof TextElement)) continue;
                String name = ((SimpleName)second).getIdentifier();
                String thirdText = ((TextElement)third).getText();
                if (!">".equals(thirdText)) continue;
                int paramIndex = typeParameterNames.indexOf(name);
                if (paramIndex != -1) {
                    typeParameterNames.set(paramIndex, null);
                }
                typeParameters.add(tag);
                continue;
            }
            if ("@return".equals(tagName)) {
                if (returnTag != null) continue;
                returnTag = tag;
                continue;
            }
            if ("@exception".equals(tagName) || "@throws".equals(tagName)) {
                String name;
                int exceptionIndex;
                Object first;
                exceptions.add(tag);
                fragments = tag.fragments();
                if (fragments.size() <= 0 || !((first = fragments.get(0)) instanceof Name) || (exceptionIndex = exceptionNames.indexOf(name = ASTNodes.getSimpleNameIdentifier((Name)first))) == -1) continue;
                exceptionNames.set(exceptionIndex, null);
                continue;
            }
            if ("@since".equals(tagName)) {
                since.add(tag);
                continue;
            }
            if ("@version".equals(tagName)) {
                versions.add(tag);
                continue;
            }
            if ("@author".equals(tagName)) {
                authors.add(tag);
                continue;
            }
            if ("@see".equals(tagName)) {
                sees.add(tag);
                continue;
            }
            if ("@deprecated".equals(tagName)) {
                if (deprecatedTag != null) continue;
                deprecatedTag = tag;
                continue;
            }
            rest.add(tag);
        }
        if (deprecatedTag != null) {
            this.handleDeprecatedTag(deprecatedTag);
        }
        if (start != null) {
            this.handleContentElements(start.fragments());
        } else if (this.fMethod != null) {
            CharSequence inherited = this.fJavadocLookup.getInheritedMainDescription(this.fMethod);
            this.handleInherited(inherited);
        }
        CharSequence[] typeParameterDescriptions = new CharSequence[typeParameterNames.size()];
        boolean hasInheritedTypeParameters = this.inheritTypeParameterDescriptions(typeParameterNames, typeParameterDescriptions);
        boolean hasTypeParameters = typeParameters.size() > 0 || hasInheritedTypeParameters;
        CharSequence[] parameterDescriptions = new CharSequence[parameterNames.size()];
        boolean hasInheritedParameters = this.inheritParameterDescriptions(parameterNames, parameterDescriptions);
        boolean hasParameters = parameters.size() > 0 || hasInheritedParameters;
        CharSequence returnDescription = null;
        if (returnTag == null && this.needsReturnTag()) {
            returnDescription = this.fJavadocLookup.getInheritedReturnDescription(this.fMethod);
        }
        boolean hasReturnTag = returnTag != null || returnDescription != null;
        CharSequence[] exceptionDescriptions = new CharSequence[exceptionNames.size()];
        boolean hasInheritedExceptions = this.inheritExceptionDescriptions(exceptionNames, exceptionDescriptions);
        boolean bl = hasExceptions = exceptions.size() > 0 || hasInheritedExceptions;
        if (hasParameters || hasTypeParameters || hasReturnTag || hasExceptions || versions.size() > 0 || authors.size() > 0 || since.size() > 0 || sees.size() > 0 || rest.size() > 0 || this.fBuf.length() > 0 && (parameterDescriptions.length > 0 || exceptionDescriptions.length > 0)) {
            this.handleSuperMethodReferences();
            this.fBuf.append(BLOCK_TAG_START);
            this.handleParameterTags(typeParameters, typeParameterNames, typeParameterDescriptions, true);
            this.handleParameterTags(parameters, parameterNames, parameterDescriptions, false);
            this.handleReturnTag(returnTag, returnDescription);
            this.handleExceptionTags(exceptions, exceptionNames, exceptionDescriptions);
            this.handleBlockTags(JavaDocMessages.JavaDoc2HTMLTextReader_since_section, since);
            this.handleBlockTags(JavaDocMessages.JavaDoc2HTMLTextReader_version_section, versions);
            this.handleBlockTags(JavaDocMessages.JavaDoc2HTMLTextReader_author_section, authors);
            this.handleBlockTags(JavaDocMessages.JavaDoc2HTMLTextReader_see_section, sees);
            this.handleBlockTags(rest);
            this.fBuf.append(BLOCK_TAG_END);
        } else if (this.fBuf.length() > 0) {
            this.handleSuperMethodReferences();
        }
    }

    private void handleDeprecatedTag(TagElement tag) {
        this.fBuf.append("<p><b>");
        this.fBuf.append(JavaDocMessages.JavaDoc2HTMLTextReader_deprecated_section);
        this.fBuf.append("</b> <i>");
        this.handleContentElements(tag.fragments());
        this.fBuf.append("</i><p>");
    }

    private void handleSuperMethodReferences() {
        if (this.fMethod != null) {
            try {
                StringBuffer superMethodReferences = JavadocContentAccess2.createSuperMethodReferences(this.fMethod);
                if (superMethodReferences != null) {
                    this.fBuf.append(superMethodReferences);
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
    }

    private List<String> initTypeParameterNames() {
        if (this.fMethod != null) {
            try {
                ArrayList<String> typeParameterNames = new ArrayList<String>();
                ITypeParameter[] iTypeParameterArray = this.fMethod.getTypeParameters();
                int n = iTypeParameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeParameter typeParameter = iTypeParameterArray[n2];
                    typeParameterNames.add(typeParameter.getElementName());
                    ++n2;
                }
                return typeParameterNames;
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return Collections.emptyList();
    }

    private List<String> initParameterNames() {
        if (this.fMethod != null) {
            try {
                return new ArrayList<String>(Arrays.asList(this.fMethod.getParameterNames()));
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return Collections.emptyList();
    }

    private List<String> initExceptionNames() {
        if (this.fMethod != null) {
            try {
                String[] exceptionTypes = this.fMethod.getExceptionTypes();
                ArrayList<String> exceptionNames = new ArrayList<String>();
                int i = 0;
                while (i < exceptionTypes.length) {
                    exceptionNames.add(Signature.getSimpleName((String)Signature.toString((String)exceptionTypes[i])));
                    ++i;
                }
                return exceptionNames;
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return Collections.emptyList();
    }

    private boolean needsReturnTag() {
        if (this.fMethod == null) {
            return false;
        }
        try {
            return !"V".equals(this.fMethod.getReturnType());
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return false;
        }
    }

    private boolean inheritTypeParameterDescriptions(List<String> typeParameterNames, CharSequence[] typeParameterDescriptions) {
        boolean hasInheritedTypeParameters = false;
        int i = 0;
        while (i < typeParameterNames.size()) {
            String name = typeParameterNames.get(i);
            if (name != null) {
                typeParameterDescriptions[i] = this.fJavadocLookup.getInheritedTypeParamDescription(this.fMethod, i);
                if (typeParameterDescriptions[i] != null) {
                    hasInheritedTypeParameters = true;
                }
            }
            ++i;
        }
        return hasInheritedTypeParameters;
    }

    private boolean inheritParameterDescriptions(List<String> parameterNames, CharSequence[] parameterDescriptions) {
        boolean hasInheritedParameters = false;
        int i = 0;
        while (i < parameterNames.size()) {
            String name = parameterNames.get(i);
            if (name != null) {
                parameterDescriptions[i] = this.fJavadocLookup.getInheritedParamDescription(this.fMethod, i);
                if (parameterDescriptions[i] != null) {
                    hasInheritedParameters = true;
                }
            }
            ++i;
        }
        return hasInheritedParameters;
    }

    private boolean inheritExceptionDescriptions(List<String> exceptionNames, CharSequence[] exceptionDescriptions) {
        boolean hasInheritedExceptions = false;
        int i = 0;
        while (i < exceptionNames.size()) {
            String name = exceptionNames.get(i);
            if (name != null) {
                exceptionDescriptions[i] = this.fJavadocLookup.getInheritedExceptionDescription(this.fMethod, name);
                if (exceptionDescriptions[i] != null) {
                    hasInheritedExceptions = true;
                }
            }
            ++i;
        }
        return hasInheritedExceptions;
    }

    CharSequence getMainDescription() {
        if (this.fMainDescription == null) {
            this.fBuf = this.fMainDescription = new StringBuffer();
            this.fLiteralContent = 0;
            List tags = this.fJavadoc.tags();
            for (TagElement tag : tags) {
                String tagName = tag.getTagName();
                if (tagName != null) continue;
                this.handleContentElements(tag.fragments());
                break;
            }
            this.fBuf = null;
        }
        return this.fMainDescription.length() > 0 ? this.fMainDescription : null;
    }

    CharSequence getReturnDescription() {
        if (this.fReturnDescription == null) {
            this.fBuf = this.fReturnDescription = new StringBuffer();
            this.fLiteralContent = 0;
            List tags = this.fJavadoc.tags();
            for (TagElement tag : tags) {
                String tagName = tag.getTagName();
                if (!"@return".equals(tagName)) continue;
                this.handleContentElements(tag.fragments());
                break;
            }
            this.fBuf = null;
        }
        return this.fReturnDescription.length() > 0 ? this.fReturnDescription : null;
    }

    CharSequence getInheritedTypeParamDescription(int typeParamIndex) {
        if (this.fMethod != null) {
            StringBuffer description;
            List<String> typeParameterNames = this.initTypeParameterNames();
            if (this.fTypeParamDescriptions == null) {
                this.fTypeParamDescriptions = new StringBuffer[typeParameterNames.size()];
            } else {
                description = this.fTypeParamDescriptions[typeParamIndex];
                if (description != null) {
                    return description.length() > 0 ? description : null;
                }
            }
            this.fTypeParamDescriptions[typeParamIndex] = description = new StringBuffer();
            this.fBuf = description;
            this.fLiteralContent = 0;
            String typeParamName = typeParameterNames.get(typeParamIndex);
            List tags = this.fJavadoc.tags();
            for (TagElement tag : tags) {
                String name;
                List fragments;
                String tagName = tag.getTagName();
                if (!"@param".equals(tagName) || (fragments = tag.fragments()).size() <= 2) continue;
                Object first = fragments.get(0);
                Object second = fragments.get(1);
                Object third = fragments.get(2);
                if (!(first instanceof TextElement) || !(second instanceof SimpleName) || !(third instanceof TextElement)) continue;
                String firstText = ((TextElement)first).getText();
                String thirdText = ((TextElement)third).getText();
                if (!"<".equals(firstText) || !">".equals(thirdText) || !(name = ((SimpleName)second).getIdentifier()).equals(typeParamName)) continue;
                this.handleContentElements(fragments.subList(3, fragments.size()));
                break;
            }
            this.fBuf = null;
            return description.length() > 0 ? description : null;
        }
        return null;
    }

    CharSequence getInheritedParamDescription(int paramIndex) throws JavaModelException {
        if (this.fMethod != null) {
            StringBuffer description;
            String[] parameterNames = this.fMethod.getParameterNames();
            if (this.fParamDescriptions == null) {
                this.fParamDescriptions = new StringBuffer[parameterNames.length];
            } else {
                description = this.fParamDescriptions[paramIndex];
                if (description != null) {
                    return description.length() > 0 ? description : null;
                }
            }
            this.fParamDescriptions[paramIndex] = description = new StringBuffer();
            this.fBuf = description;
            this.fLiteralContent = 0;
            String paramName = parameterNames[paramIndex];
            List tags = this.fJavadoc.tags();
            for (TagElement tag : tags) {
                String name;
                Object first;
                List fragments;
                String tagName = tag.getTagName();
                if (!"@param".equals(tagName) || (fragments = tag.fragments()).size() <= 0 || !((first = fragments.get(0)) instanceof SimpleName) || !(name = ((SimpleName)first).getIdentifier()).equals(paramName)) continue;
                this.handleContentElements(fragments.subList(1, fragments.size()));
                break;
            }
            this.fBuf = null;
            return description.length() > 0 ? description : null;
        }
        return null;
    }

    CharSequence getExceptionDescription(String simpleName) {
        if (this.fMethod != null) {
            StringBuffer description;
            if (this.fExceptionDescriptions == null) {
                this.fExceptionDescriptions = new HashMap();
            } else {
                description = this.fExceptionDescriptions.get(simpleName);
                if (description != null) {
                    return description.length() > 0 ? description : null;
                }
            }
            description = new StringBuffer();
            this.fExceptionDescriptions.put(simpleName, description);
            this.fBuf = description;
            this.fLiteralContent = 0;
            List tags = this.fJavadoc.tags();
            for (TagElement tag : tags) {
                String name;
                Object first;
                List fragments;
                String tagName = tag.getTagName();
                if (!"@throws".equals(tagName) && !"@exception".equals(tagName) || (fragments = tag.fragments()).size() <= 0 || !((first = fragments.get(0)) instanceof Name) || !(name = ASTNodes.getSimpleNameIdentifier((Name)first)).equals(simpleName)) continue;
                if (fragments.size() <= 1) break;
                this.handleContentElements(fragments.subList(1, fragments.size()));
                break;
            }
            this.fBuf = null;
            return description.length() > 0 ? description : null;
        }
        return null;
    }

    private void handleContentElements(List<? extends ASTNode> nodes) {
        this.handleContentElements(nodes, false);
    }

    private void handleContentElements(List<? extends ASTNode> nodes, boolean skipLeadingWhitespace) {
        ASTNode previousNode = null;
        for (ASTNode aSTNode : nodes) {
            if (previousNode != null) {
                int childStart;
                int previousEnd = previousNode.getStartPosition() + previousNode.getLength();
                if (previousEnd > (childStart = aSTNode.getStartPosition())) {
                    Exception exception = new Exception("Illegal ASTNode positions: previousEnd=" + previousEnd + ", childStart=" + childStart + ", element=" + this.fElement.getHandleIdentifier() + ", Javadoc:\n" + this.fSource);
                    JavaPlugin.log(exception);
                } else if (previousEnd != childStart) {
                    String textWithStars = this.fSource.substring(previousEnd, childStart);
                    String text = this.removeDocLineIntros(textWithStars);
                    this.fBuf.append(text);
                }
            }
            previousNode = aSTNode;
            if (aSTNode instanceof TextElement) {
                String text = ((TextElement)aSTNode).getText();
                if (skipLeadingWhitespace) {
                    text = text.replaceFirst("^\\s+", "");
                }
                text = text.replaceAll("(\r\n?|\n)([ \t]*\\*)", "$1");
                this.handleText(text);
                continue;
            }
            if (aSTNode instanceof TagElement) {
                this.handleInlineTagElement((TagElement)aSTNode);
                continue;
            }
            int start = aSTNode.getStartPosition();
            String text = this.fSource.substring(start, start + aSTNode.getLength());
            this.fBuf.append(this.removeDocLineIntros(text));
        }
    }

    private String removeDocLineIntros(String textWithStars) {
        String lineBreakGroup = "(\\r\\n?|\\n)";
        String noBreakSpace = "[^\r\n&&\\s]";
        return textWithStars.replaceAll(String.valueOf(lineBreakGroup) + noBreakSpace + "*\\*", "$1");
    }

    private void handleText(String text) {
        if (this.fLiteralContent == 0) {
            this.fBuf.append(text);
        } else {
            JavadocContentAccess2.appendEscaped(this.fBuf, text);
        }
    }

    private static void appendEscaped(StringBuffer buf, String text) {
        int nextToCopy = 0;
        int length = text.length();
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            String rep = null;
            switch (ch) {
                case '&': {
                    rep = "&amp;";
                    break;
                }
                case '\"': {
                    rep = "&quot;";
                    break;
                }
                case '<': {
                    rep = "&lt;";
                    break;
                }
                case '>': {
                    rep = "&gt;";
                }
            }
            if (rep != null) {
                if (nextToCopy < i) {
                    buf.append(text.substring(nextToCopy, i));
                }
                buf.append(rep);
                nextToCopy = i + 1;
            }
            ++i;
        }
        if (nextToCopy < length) {
            buf.append(text.substring(nextToCopy));
        }
    }

    private void handleInlineTagElement(TagElement node) {
        String name = node.getTagName();
        if ("@value".equals(name) && this.handleValueTag(node)) {
            return;
        }
        boolean isLink = "@link".equals(name);
        boolean isLinkplain = "@linkplain".equals(name);
        boolean isCode = "@code".equals(name);
        boolean isLiteral = "@literal".equals(name);
        if (isLiteral || isCode) {
            ++this.fLiteralContent;
        }
        if (isLink || isCode) {
            this.fBuf.append("<code>");
        }
        if (isLink || isLinkplain) {
            this.handleLink(node.fragments());
        } else if (isCode || isLiteral) {
            this.handleContentElements(node.fragments(), true);
        } else if (!this.handleInheritDoc(node) && !this.handleDocRoot(node)) {
            int start = node.getStartPosition();
            String text = this.fSource.substring(start, start + node.getLength());
            this.fBuf.append(this.removeDocLineIntros(text));
        }
        if (isLink || isCode) {
            this.fBuf.append("</code>");
        }
        if (isLiteral || isCode) {
            --this.fLiteralContent;
        }
    }

    private boolean handleValueTag(TagElement node) {
        block9: {
            List fragments;
            block8: {
                fragments = node.fragments();
                if (this.fElement instanceof IMember) break block8;
                return false;
            }
            try {
                MemberRef memberRef;
                Object first;
                if (fragments.isEmpty()) {
                    if (this.fElement instanceof IField && JdtFlags.isStatic((IMember)((IField)this.fElement)) && JdtFlags.isFinal((IMember)((IField)this.fElement))) {
                        IField field = (IField)this.fElement;
                        return this.handleConstantValue(field, false);
                    }
                    break block9;
                }
                if (fragments.size() != 1 || !((first = fragments.get(0)) instanceof MemberRef) || (memberRef = (MemberRef)first).getQualifier() != null) break block9;
                SimpleName name = memberRef.getName();
                IType type = this.fElement instanceof IType ? (IType)this.fElement : ((IMember)this.fElement).getDeclaringType();
                while (type != null) {
                    IField field = type.getField(name.getIdentifier());
                    if (field != null && field.exists()) {
                        if (JdtFlags.isStatic((IMember)field) && JdtFlags.isFinal((IMember)field)) {
                            return this.handleConstantValue(field, true);
                        }
                        break;
                    }
                    type = type.getDeclaringType();
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return false;
    }

    private boolean handleConstantValue(IField field, boolean link) throws JavaModelException {
        Object constant;
        IVariableBinding variableBinding;
        Object constantValue;
        IBinding binding;
        ASTNode nameNode;
        CompilationUnit cuNode;
        String text = null;
        ISourceRange nameRange = field.getNameRange();
        if (SourceRange.isAvailable((ISourceRange)nameRange) && (cuNode = SharedASTProvider.getAST(field.getTypeRoot(), SharedASTProvider.WAIT_ACTIVE_ONLY, null)) != null && (nameNode = NodeFinder.perform((ASTNode)cuNode, (ISourceRange)nameRange)) instanceof SimpleName && (binding = ((SimpleName)nameNode).resolveBinding()) instanceof IVariableBinding && (constantValue = (variableBinding = (IVariableBinding)binding).getConstantValue()) != null) {
            text = constantValue instanceof String ? ASTNodes.getEscapedStringLiteral((String)constantValue) : constantValue.toString();
        }
        if (text == null && (constant = field.getConstant()) != null) {
            text = constant.toString();
        }
        if (text != null) {
            text = HTMLPrinter.convertToHTMLContentWithWhitespace(text);
            if (link) {
                try {
                    String uri = JavaElementLinks.createURI("eclipse-javadoc", (IJavaElement)field);
                    this.fBuf.append(JavaElementLinks.createLink(uri, text));
                }
                catch (URISyntaxException e) {
                    JavaPlugin.log(e);
                    return false;
                }
            } else {
                this.handleText(text);
            }
            return true;
        }
        return false;
    }

    private boolean handleDocRoot(TagElement node) {
        if (!"@docRoot".equals(node.getTagName())) {
            return false;
        }
        try {
            String url = null;
            if (this.fElement instanceof IMember && ((IMember)this.fElement).isBinary()) {
                URL javadocBaseLocation = JavaUI.getJavadocBaseLocation(this.fElement);
                if (javadocBaseLocation != null) {
                    url = javadocBaseLocation.toExternalForm();
                }
            } else {
                IPath location;
                IResource resource;
                IPackageFragmentRoot srcRoot = JavaModelUtil.getPackageFragmentRoot(this.fElement);
                if (srcRoot != null && (resource = srcRoot.getResource()) != null && (location = resource.getLocation()) != null) {
                    url = location.toFile().toURI().toASCIIString();
                }
            }
            if (url != null) {
                if (url.endsWith("/")) {
                    url = url.substring(0, url.length() - 1);
                }
                this.fBuf.append(url);
                return true;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    private boolean handleInheritDoc(TagElement node) {
        block18: {
            if (!"@inheritDoc".equals(node.getTagName())) {
                return false;
            }
            if (this.fMethod != null) break block18;
            return false;
        }
        try {
            TagElement blockTag = (TagElement)node.getParent();
            String blockTagName = blockTag.getTagName();
            if (blockTagName == null) {
                CharSequence inherited = this.fJavadocLookup.getInheritedMainDescription(this.fMethod);
                return this.handleInherited(inherited);
            }
            if ("@param".equals(blockTagName)) {
                List fragments = blockTag.fragments();
                int size = fragments.size();
                if (size > 0) {
                    String firstText;
                    Object first = fragments.get(0);
                    if (first instanceof SimpleName) {
                        String name = ((SimpleName)first).getIdentifier();
                        String[] parameterNames = this.fMethod.getParameterNames();
                        int i = 0;
                        while (i < parameterNames.length) {
                            if (name.equals(parameterNames[i])) {
                                CharSequence inherited = this.fJavadocLookup.getInheritedParamDescription(this.fMethod, i);
                                return this.handleInherited(inherited);
                            }
                            ++i;
                        }
                    } else if (size > 2 && first instanceof TextElement && "<".equals(firstText = ((TextElement)first).getText())) {
                        String thirdText;
                        Object second = fragments.get(1);
                        Object third = fragments.get(2);
                        if (second instanceof SimpleName && third instanceof TextElement && ">".equals(thirdText = ((TextElement)third).getText())) {
                            String name = ((SimpleName)second).getIdentifier();
                            ITypeParameter[] typeParameters = this.fMethod.getTypeParameters();
                            int i = 0;
                            while (i < typeParameters.length) {
                                ITypeParameter typeParameter = typeParameters[i];
                                if (name.equals(typeParameter.getElementName())) {
                                    CharSequence inherited = this.fJavadocLookup.getInheritedTypeParamDescription(this.fMethod, i);
                                    return this.handleInherited(inherited);
                                }
                                ++i;
                            }
                        }
                    }
                }
            } else {
                Object first;
                List fragments;
                if ("@return".equals(blockTagName)) {
                    CharSequence inherited = this.fJavadocLookup.getInheritedReturnDescription(this.fMethod);
                    return this.handleInherited(inherited);
                }
                if (("@throws".equals(blockTagName) || "@exception".equals(blockTagName)) && (fragments = blockTag.fragments()).size() > 0 && (first = fragments.get(0)) instanceof Name) {
                    String name = ASTNodes.getSimpleNameIdentifier((Name)first);
                    CharSequence inherited = this.fJavadocLookup.getInheritedExceptionDescription(this.fMethod, name);
                    return this.handleInherited(inherited);
                }
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return false;
    }

    private boolean handleInherited(CharSequence inherited) {
        if (inherited == null) {
            return false;
        }
        this.fBuf.append(inherited);
        return true;
    }

    private void handleBlockTags(String title, List<TagElement> tags) {
        if (tags.isEmpty()) {
            return;
        }
        this.handleBlockTagTitle(title);
        for (TagElement tag : tags) {
            this.fBuf.append(BlOCK_TAG_ENTRY_START);
            if ("@see".equals(tag.getTagName())) {
                this.handleSeeTag(tag);
            } else {
                this.handleContentElements(tag.fragments());
            }
            this.fBuf.append(BlOCK_TAG_ENTRY_END);
        }
    }

    private void handleReturnTag(TagElement tag, CharSequence returnDescription) {
        if (tag == null && returnDescription == null) {
            return;
        }
        this.handleBlockTagTitle(JavaDocMessages.JavaDoc2HTMLTextReader_returns_section);
        this.fBuf.append(BlOCK_TAG_ENTRY_START);
        if (tag != null) {
            this.handleContentElements(tag.fragments());
        } else {
            this.fBuf.append(returnDescription);
        }
        this.fBuf.append(BlOCK_TAG_ENTRY_END);
    }

    private void handleBlockTags(List<TagElement> tags) {
        for (TagElement tag : tags) {
            this.handleBlockTagTitle(tag.getTagName());
            this.fBuf.append(BlOCK_TAG_ENTRY_START);
            this.handleContentElements(tag.fragments());
            this.fBuf.append(BlOCK_TAG_ENTRY_END);
        }
    }

    private void handleBlockTagTitle(String title) {
        this.fBuf.append("<dt>");
        this.fBuf.append(title);
        this.fBuf.append("</dt>");
    }

    private void handleSeeTag(TagElement tag) {
        this.handleLink(tag.fragments());
    }

    private void handleExceptionTags(List<TagElement> tags, List<String> exceptionNames, CharSequence[] exceptionDescriptions) {
        if (tags.size() == 0 && this.containsOnlyNull(exceptionNames)) {
            return;
        }
        this.handleBlockTagTitle(JavaDocMessages.JavaDoc2HTMLTextReader_throws_section);
        for (TagElement tag : tags) {
            this.fBuf.append(BlOCK_TAG_ENTRY_START);
            this.handleThrowsTag(tag);
            this.fBuf.append(BlOCK_TAG_ENTRY_END);
        }
        int i = 0;
        while (i < exceptionDescriptions.length) {
            CharSequence description = exceptionDescriptions[i];
            String name = exceptionNames.get(i);
            if (name != null) {
                this.fBuf.append(BlOCK_TAG_ENTRY_START);
                this.handleLink(Collections.singletonList(this.fJavadoc.getAST().newSimpleName(name)));
                if (description != null) {
                    this.fBuf.append(JavaElementLabels.CONCAT_STRING);
                    this.fBuf.append(description);
                }
                this.fBuf.append(BlOCK_TAG_ENTRY_END);
            }
            ++i;
        }
    }

    private void handleThrowsTag(TagElement tag) {
        List fragments = tag.fragments();
        int size = fragments.size();
        if (size > 0) {
            this.handleLink(fragments.subList(0, 1));
            if (size > 1) {
                this.fBuf.append(JavaElementLabels.CONCAT_STRING);
                this.handleContentElements(fragments.subList(1, size));
            }
        }
    }

    private void handleParameterTags(List<TagElement> tags, List<String> parameterNames, CharSequence[] parameterDescriptions, boolean isTypeParameters) {
        if (tags.size() == 0 && this.containsOnlyNull(parameterNames)) {
            return;
        }
        String tagTitle = isTypeParameters ? JavaDocMessages.JavaDoc2HTMLTextReader_type_parameters_section : JavaDocMessages.JavaDoc2HTMLTextReader_parameters_section;
        this.handleBlockTagTitle(tagTitle);
        for (TagElement tag : tags) {
            this.fBuf.append(BlOCK_TAG_ENTRY_START);
            this.handleParamTag(tag);
            this.fBuf.append(BlOCK_TAG_ENTRY_END);
        }
        int i = 0;
        while (i < parameterDescriptions.length) {
            CharSequence description = parameterDescriptions[i];
            String name = parameterNames.get(i);
            if (name != null) {
                this.fBuf.append(BlOCK_TAG_ENTRY_START);
                this.fBuf.append(PARAM_NAME_START);
                if (isTypeParameters) {
                    this.fBuf.append("&lt;");
                }
                this.fBuf.append(name);
                if (isTypeParameters) {
                    this.fBuf.append("&gt;");
                }
                this.fBuf.append(PARAM_NAME_END);
                if (description != null) {
                    this.fBuf.append(description);
                }
                this.fBuf.append(BlOCK_TAG_ENTRY_END);
            }
            ++i;
        }
    }

    private void handleParamTag(TagElement tag) {
        List fragments = tag.fragments();
        int i = 0;
        int size = fragments.size();
        if (size > 0) {
            String firstText;
            Object first = fragments.get(0);
            this.fBuf.append(PARAM_NAME_START);
            if (first instanceof SimpleName) {
                String name = ((SimpleName)first).getIdentifier();
                this.fBuf.append(name);
                ++i;
            } else if (first instanceof TextElement && "<".equals(firstText = ((TextElement)first).getText())) {
                Object second;
                this.fBuf.append("&lt;");
                ++i;
                if (size > 1 && (second = fragments.get(1)) instanceof SimpleName) {
                    Object third;
                    String thirdText;
                    String name = ((SimpleName)second).getIdentifier();
                    this.fBuf.append(name);
                    ++i;
                    if (size > 2 && ">".equals(thirdText = ((TextElement)(third = fragments.get(2))).getText())) {
                        this.fBuf.append("&gt;");
                        ++i;
                    }
                }
            }
            this.fBuf.append(PARAM_NAME_END);
            this.handleContentElements(fragments.subList(i, fragments.size()));
        }
    }

    private void handleLink(List<? extends ASTNode> fragments) {
        int fs = fragments.size();
        if (fs > 0) {
            Name qualifier;
            ASTNode first = fragments.get(0);
            String refTypeName = null;
            String refMemberName = null;
            String[] refMethodParamTypes = null;
            String[] refMethodParamNames = null;
            if (first instanceof Name) {
                Name name = (Name)first;
                refTypeName = name.getFullyQualifiedName();
            } else if (first instanceof MemberRef) {
                MemberRef memberRef = (MemberRef)first;
                qualifier = memberRef.getQualifier();
                refTypeName = qualifier == null ? "" : qualifier.getFullyQualifiedName();
                refMemberName = memberRef.getName().getIdentifier();
            } else if (first instanceof MethodRef) {
                MethodRef methodRef = (MethodRef)first;
                qualifier = methodRef.getQualifier();
                refTypeName = qualifier == null ? "" : qualifier.getFullyQualifiedName();
                refMemberName = methodRef.getName().getIdentifier();
                List params = methodRef.parameters();
                int ps = params.size();
                refMethodParamTypes = new String[ps];
                refMethodParamNames = new String[ps];
                int i = 0;
                while (i < ps) {
                    MethodRefParameter param = (MethodRefParameter)params.get(i);
                    refMethodParamTypes[i] = ASTNodes.asString((ASTNode)param.getType());
                    SimpleName paramName = param.getName();
                    if (paramName != null) {
                        refMethodParamNames[i] = paramName.getIdentifier();
                    }
                    ++i;
                }
            }
            if (refTypeName != null) {
                this.fBuf.append("<a href='");
                try {
                    String scheme = "eclipse-javadoc";
                    String uri = JavaElementLinks.createURI(scheme, this.fElement, refTypeName, refMemberName, refMethodParamTypes);
                    this.fBuf.append(uri);
                }
                catch (URISyntaxException e) {
                    JavaPlugin.log(e);
                }
                this.fBuf.append("'>");
                if (!(fs <= 1 || fs == 2 && JavadocContentAccess2.isWhitespaceTextElement(fragments.get(1)))) {
                    this.handleContentElements(fragments.subList(1, fs), true);
                } else {
                    this.fBuf.append(refTypeName);
                    if (refMemberName != null) {
                        if (refTypeName.length() > 0) {
                            this.fBuf.append('.');
                        }
                        this.fBuf.append(refMemberName);
                        if (refMethodParamTypes != null) {
                            this.fBuf.append('(');
                            int i = 0;
                            while (i < refMethodParamTypes.length) {
                                String pType = refMethodParamTypes[i];
                                this.fBuf.append(pType);
                                String pName = refMethodParamNames[i];
                                if (pName != null) {
                                    this.fBuf.append(' ').append(pName);
                                }
                                if (i < refMethodParamTypes.length - 1) {
                                    this.fBuf.append(", ");
                                }
                                ++i;
                            }
                            this.fBuf.append(')');
                        }
                    }
                }
                this.fBuf.append("</a>");
            } else {
                this.handleContentElements(fragments);
            }
        }
    }

    private static boolean isWhitespaceTextElement(Object fragment) {
        if (!(fragment instanceof TextElement)) {
            return false;
        }
        TextElement textElement = (TextElement)fragment;
        return textElement.getText().trim().length() == 0;
    }

    private boolean containsOnlyNull(List<String> parameterNames) {
        Iterator<String> iter = parameterNames.iterator();
        while (iter.hasNext()) {
            if (iter.next() == null) continue;
            return false;
        }
        return true;
    }

    public static String extractBaseURL(String content) {
        int introLength;
        int endIndex;
        int introStart = content.indexOf(BASE_URL_COMMENT_INTRO);
        if (introStart != -1 && (endIndex = content.indexOf(34, introStart + (introLength = BASE_URL_COMMENT_INTRO.length()))) != -1) {
            return content.substring(introStart + introLength, endIndex);
        }
        return null;
    }

    public static String getHTMLContent(IPackageDeclaration packageDeclaration) throws CoreException {
        IJavaElement element = packageDeclaration.getAncestor(4);
        if (element instanceof IPackageFragment) {
            return JavadocContentAccess2.getHTMLContent((IPackageFragment)element);
        }
        return null;
    }

    public static String getHTMLContent(IPackageFragment packageFragment) throws CoreException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)packageFragment.getAncestor(3);
        boolean isBinary = root.getKind() == 2;
        Object packageInfo = isBinary ? packageFragment.getClassFile("package-info.class") : packageFragment.getCompilationUnit("package-info.java");
        if (packageInfo != null && packageInfo.exists()) {
            Javadoc packageJavadocNode;
            String cuSource = packageInfo.getSource();
            if (cuSource != null && (packageJavadocNode = JavadocContentAccess2.getPackageJavadocNode((IJavaElement)packageFragment, cuSource)) != null) {
                Object element = isBinary ? packageInfo.getType() : packageInfo.getParent();
                return new JavadocContentAccess2((IJavaElement)element, packageJavadocNode, cuSource).toHTML();
            }
        } else {
            Object nonJavaResource;
            Object[] nonJavaResources;
            Object[] objectArray = nonJavaResources = packageFragment.getNonJavaResources();
            int n = nonJavaResources.length;
            int n2 = 0;
            while (n2 < n) {
                IFile iFile;
                nonJavaResource = objectArray[n2];
                if (nonJavaResource instanceof IFile && (iFile = (IFile)nonJavaResource).exists() && "package.html".equals(iFile.getName())) {
                    return JavadocContentAccess2.getIFileContent(iFile);
                }
                ++n2;
            }
            if (isBinary) {
                objectArray = nonJavaResources;
                n = nonJavaResources.length;
                n2 = 0;
                while (n2 < n) {
                    nonJavaResource = objectArray[n2];
                    if (nonJavaResource instanceof IJarEntryResource) {
                        IJarEntryResource jarEntryResource = (IJarEntryResource)nonJavaResource;
                        String encoding = JavadocContentAccess2.getSourceAttachmentEncoding(root);
                        if ("package.html".equals(jarEntryResource.getName()) && jarEntryResource.isFile()) {
                            return JavadocContentAccess2.getHTMLContent(jarEntryResource, encoding);
                        }
                    }
                    ++n2;
                }
                String contents = JavadocContentAccess2.getHTMLContentFromAttachedSource(root, packageFragment);
                if (contents != null) {
                    return contents;
                }
            }
        }
        if (root.isArchive() || root.isExternal()) {
            return packageFragment.getAttachedJavadoc(null);
        }
        return null;
    }

    private static String getHTMLContent(IJarEntryResource jarEntryResource, String encoding) throws CoreException {
        String string;
        block7: {
            InputStream in = jarEntryResource.getContents();
            try {
                string = JavadocContentAccess2.getContentsFromInputStream(in, encoding);
                if (in == null) break block7;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return string;
    }

    private static String getHTMLContentFromAttachedSource(IPackageFragmentRoot root, IPackageFragment packageFragment) throws CoreException {
        Javadoc packageJavadocNode;
        String filePath = String.valueOf(packageFragment.getElementName().replace('.', '/')) + '/' + "package-info.java";
        String contents = JavadocContentAccess2.getFileContentFromAttachedSource(root, filePath);
        if (contents != null && (packageJavadocNode = JavadocContentAccess2.getPackageJavadocNode((IJavaElement)packageFragment, contents)) != null) {
            return new JavadocContentAccess2((IJavaElement)packageFragment, packageJavadocNode, contents).toHTML();
        }
        filePath = String.valueOf(packageFragment.getElementName().replace('.', '/')) + '/' + "package.html";
        return JavadocContentAccess2.getFileContentFromAttachedSource(root, filePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getFileContentFromAttachedSource(IPackageFragmentRoot root, String filePath) throws CoreException {
        InputStream in;
        ZipFile zipFile;
        block28: {
            String string;
            IPath sourceAttachmentPath = root.getSourceAttachmentPath();
            if (sourceAttachmentPath == null) return null;
            File file = null;
            String encoding = null;
            if (sourceAttachmentPath.getDevice() == null) {
                IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                IResource res = wsRoot.findMember(sourceAttachmentPath);
                if (res instanceof IFile) {
                    IPath location = res.getLocation();
                    if (location == null) {
                        return null;
                    }
                    file = location.toFile();
                    encoding = ((IFile)res).getCharset(false);
                } else if (res instanceof IContainer) {
                    if (!((res = ((IContainer)res).findMember(filePath)) instanceof IFile)) {
                        return null;
                    }
                    encoding = ((IFile)res).getCharset(false);
                    if (encoding != null) return JavadocContentAccess2.getContentsFromInputStream(((IFile)res).getContents(), encoding);
                    encoding = JavadocContentAccess2.getSourceAttachmentEncoding(root);
                    return JavadocContentAccess2.getContentsFromInputStream(((IFile)res).getContents(), encoding);
                }
            }
            if (file == null || !file.exists()) {
                file = sourceAttachmentPath.toFile();
            }
            if (file.isDirectory()) {
                IPath packagedocPath = sourceAttachmentPath.append(filePath);
                if (!packagedocPath.toFile().exists()) return null;
                return JavadocContentAccess2.getFileContent(packagedocPath.toFile());
            }
            if (!file.exists()) return null;
            IPath sourceAttachmentRootPath = root.getSourceAttachmentRootPath();
            String packagedocPath = sourceAttachmentRootPath != null ? sourceAttachmentRootPath.append(filePath).toString() : filePath;
            zipFile = null;
            in = null;
            try {
                zipFile = new ZipFile(file, 1);
                ZipEntry packagedocFile = zipFile.getEntry(packagedocPath);
                if (packagedocFile == null) break block28;
                in = zipFile.getInputStream(packagedocFile);
                if (encoding == null) {
                    encoding = JavadocContentAccess2.getSourceAttachmentEncoding(root);
                }
                string = JavadocContentAccess2.getContentsFromInputStream(in, encoding);
            }
            catch (IOException e) {
                try {
                    throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), e.getMessage(), (Throwable)e));
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (zipFile == null) throw throwable;
                        zipFile.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (zipFile == null) return string;
                zipFile.close();
                return string;
            }
            catch (IOException iOException) {}
            return string;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (zipFile == null) return null;
            zipFile.close();
            return null;
        }
        catch (IOException iOException) {}
        return null;
    }

    private static String getContentsFromInputStream(InputStream in, String encoding) throws CoreException {
        StringBuffer buffer = new StringBuffer(15360);
        Reader reader = null;
        try {
            try {
                reader = new BufferedReader(new InputStreamReader(in, encoding), 15360);
                char[] readBuffer = new char[2048];
                int charCount = reader.read(readBuffer);
                while (charCount > 0) {
                    buffer.append(readBuffer, 0, charCount);
                    charCount = reader.read(readBuffer);
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), e.getMessage(), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        return buffer.toString();
    }

    private static String getSourceAttachmentEncoding(IPackageFragmentRoot root) throws JavaModelException {
        int kind;
        String encoding = ResourcesPlugin.getEncoding();
        IClasspathEntry entry = root.getRawClasspathEntry();
        if (entry != null && ((kind = entry.getEntryKind()) == 1 || kind == 4)) {
            IClasspathAttribute[] extraAttributes = entry.getExtraAttributes();
            int i = 0;
            while (i < extraAttributes.length) {
                IClasspathAttribute attrib = extraAttributes[i];
                if ("source_encoding".equals(attrib.getName())) {
                    return attrib.getValue();
                }
                ++i;
            }
        }
        return encoding;
    }

    private static String getIFileContent(IFile file) throws CoreException {
        String content = null;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath fullPath = file.getFullPath();
        manager.connect(fullPath, LocationKind.IFILE, null);
        try {
            ITextFileBuffer buffer = manager.getTextFileBuffer(fullPath, LocationKind.IFILE);
            if (buffer != null) {
                content = buffer.getDocument().get();
            }
        }
        finally {
            manager.disconnect(fullPath, LocationKind.IFILE, null);
        }
        return content;
    }

    private static String getFileContent(File file) throws CoreException {
        String content = null;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        Path fullPath = new Path(file.getAbsolutePath());
        manager.connect((IPath)fullPath, LocationKind.LOCATION, null);
        try {
            ITextFileBuffer buffer = manager.getTextFileBuffer((IPath)fullPath, LocationKind.LOCATION);
            if (buffer != null) {
                content = buffer.getDocument().get();
            }
        }
        finally {
            manager.disconnect((IPath)fullPath, LocationKind.LOCATION, null);
        }
        return content;
    }

    /* synthetic */ JavadocContentAccess2(IJavaElement iJavaElement, Javadoc javadoc, String string, JavadocLookup javadocLookup, JavadocContentAccess2 javadocContentAccess2) {
        this(iJavaElement, javadoc, string, javadocLookup);
    }

    private static abstract class InheritDocVisitor {
        public static final Object STOP_BRANCH = new Object(){

            public String toString() {
                return "STOP_BRANCH";
            }
        };
        public static final Object CONTINUE = new Object(){

            public String toString() {
                return "CONTINUE";
            }
        };

        private InheritDocVisitor() {
        }

        public abstract Object visit(IType var1) throws JavaModelException;

        public Object visitInheritDoc(IType currentType, ITypeHierarchy typeHierarchy) throws JavaModelException {
            ArrayList<IType> visited = new ArrayList<IType>();
            visited.add(currentType);
            Object result = this.visitInheritDocInterfaces(visited, currentType, typeHierarchy);
            if (result != CONTINUE) {
                return result;
            }
            IType superClass = currentType.isInterface() ? currentType.getJavaProject().findType("java.lang.Object") : typeHierarchy.getSuperclass(currentType);
            while (superClass != null && !visited.contains(superClass)) {
                result = this.visit(superClass);
                if (result == STOP_BRANCH) {
                    return null;
                }
                if (result == CONTINUE) {
                    visited.add(superClass);
                    result = this.visitInheritDocInterfaces(visited, superClass, typeHierarchy);
                    if (result != CONTINUE) {
                        return result;
                    }
                    superClass = typeHierarchy.getSuperclass(superClass);
                    continue;
                }
                return result;
            }
            return null;
        }

        private Object visitInheritDocInterfaces(ArrayList<IType> visited, IType currentType, ITypeHierarchy typeHierarchy) throws JavaModelException {
            Object result;
            ArrayList<IType> toVisitChildren = new ArrayList<IType>();
            IType[] superInterfaces = typeHierarchy.getSuperInterfaces(currentType);
            int i = 0;
            while (i < superInterfaces.length) {
                IType superInterface = superInterfaces[i];
                if (!visited.contains(superInterface)) {
                    visited.add(superInterface);
                    result = this.visit(superInterface);
                    if (result != STOP_BRANCH) {
                        if (result == CONTINUE) {
                            toVisitChildren.add(superInterface);
                        } else {
                            return result;
                        }
                    }
                }
                ++i;
            }
            for (IType child : toVisitChildren) {
                result = this.visitInheritDocInterfaces(visited, child, typeHierarchy);
                if (result == CONTINUE) continue;
                return result;
            }
            return CONTINUE;
        }
    }

    private static class JavadocLookup {
        private static final JavadocLookup NONE = new JavadocLookup(null){

            @Override
            public CharSequence getInheritedMainDescription(IMethod method) {
                return null;
            }

            @Override
            public CharSequence getInheritedParamDescription(IMethod method, int i) {
                return null;
            }

            @Override
            public CharSequence getInheritedReturnDescription(IMethod method) {
                return null;
            }

            @Override
            public CharSequence getInheritedExceptionDescription(IMethod method, String name) {
                return null;
            }
        };
        private final IType fStartingType;
        private final HashMap<IMethod, JavadocContentAccess2> fContentAccesses;
        private ITypeHierarchy fTypeHierarchy;
        private MethodOverrideTester fOverrideTester;

        private JavadocLookup(IType startingType) {
            this.fStartingType = startingType;
            this.fContentAccesses = new HashMap();
        }

        public CharSequence getInheritedMainDescription(IMethod method) {
            return this.getInheritedDescription(method, new DescriptionGetter(){

                @Override
                public CharSequence getDescription(JavadocContentAccess2 contentAccess) {
                    return contentAccess.getMainDescription();
                }
            });
        }

        public CharSequence getInheritedTypeParamDescription(IMethod method, final int typeParamIndex) {
            return this.getInheritedDescription(method, new DescriptionGetter(){

                @Override
                public CharSequence getDescription(JavadocContentAccess2 contentAccess) throws JavaModelException {
                    return contentAccess.getInheritedTypeParamDescription(typeParamIndex);
                }
            });
        }

        public CharSequence getInheritedParamDescription(IMethod method, final int paramIndex) {
            return this.getInheritedDescription(method, new DescriptionGetter(){

                @Override
                public CharSequence getDescription(JavadocContentAccess2 contentAccess) throws JavaModelException {
                    return contentAccess.getInheritedParamDescription(paramIndex);
                }
            });
        }

        public CharSequence getInheritedReturnDescription(IMethod method) {
            return this.getInheritedDescription(method, new DescriptionGetter(){

                @Override
                public CharSequence getDescription(JavadocContentAccess2 contentAccess) {
                    return contentAccess.getReturnDescription();
                }
            });
        }

        public CharSequence getInheritedExceptionDescription(IMethod method, final String simpleName) {
            return this.getInheritedDescription(method, new DescriptionGetter(){

                @Override
                public CharSequence getDescription(JavadocContentAccess2 contentAccess) {
                    return contentAccess.getExceptionDescription(simpleName);
                }
            });
        }

        private CharSequence getInheritedDescription(final IMethod method, final DescriptionGetter descriptionGetter) {
            try {
                return (CharSequence)new InheritDocVisitor(){

                    @Override
                    public Object visit(IType currType) throws JavaModelException {
                        IMethod overridden = JavadocLookup.this.getOverrideTester().findOverriddenMethodInType(currType, method);
                        if (overridden == null) {
                            return InheritDocVisitor.CONTINUE;
                        }
                        JavadocContentAccess2 contentAccess = JavadocLookup.this.getJavadocContentAccess(overridden);
                        if (contentAccess == null) {
                            if (overridden.getOpenable().getBuffer() == null) {
                                return InheritDocVisitor.STOP_BRANCH;
                            }
                            return InheritDocVisitor.CONTINUE;
                        }
                        CharSequence overriddenDescription = descriptionGetter.getDescription(contentAccess);
                        if (overriddenDescription != null) {
                            return overriddenDescription;
                        }
                        return InheritDocVisitor.CONTINUE;
                    }
                }.visitInheritDoc(method.getDeclaringType(), this.getTypeHierarchy());
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return null;
            }
        }

        private JavadocContentAccess2 getJavadocContentAccess(IMethod method) throws JavaModelException {
            JavadocContentAccess2 cached = this.fContentAccesses.get(method);
            if (cached != null) {
                return cached;
            }
            if (this.fContentAccesses.containsKey(method)) {
                return null;
            }
            IBuffer buf = method.getOpenable().getBuffer();
            if (buf == null) {
                this.fContentAccesses.put(method, null);
                return null;
            }
            ISourceRange javadocRange = method.getJavadocRange();
            if (javadocRange == null) {
                this.fContentAccesses.put(method, null);
                return null;
            }
            String rawJavadoc = buf.getText(javadocRange.getOffset(), javadocRange.getLength());
            Javadoc javadoc = JavadocContentAccess2.getJavadocNode((IJavaElement)method, rawJavadoc);
            if (javadoc == null) {
                this.fContentAccesses.put(method, null);
                return null;
            }
            JavadocContentAccess2 contentAccess = new JavadocContentAccess2((IJavaElement)method, javadoc, rawJavadoc, this, null);
            this.fContentAccesses.put(method, contentAccess);
            return contentAccess;
        }

        private ITypeHierarchy getTypeHierarchy() throws JavaModelException {
            if (this.fTypeHierarchy == null) {
                this.fTypeHierarchy = SuperTypeHierarchyCache.getTypeHierarchy(this.fStartingType);
            }
            return this.fTypeHierarchy;
        }

        private MethodOverrideTester getOverrideTester() throws JavaModelException {
            if (this.fOverrideTester == null) {
                this.fOverrideTester = SuperTypeHierarchyCache.getMethodOverrideTester(this.fStartingType);
            }
            return this.fOverrideTester;
        }

        /* synthetic */ JavadocLookup(IType iType, JavadocLookup javadocLookup, JavadocLookup javadocLookup2) {
            this(iType);
        }

        private static interface DescriptionGetter {
            public CharSequence getDescription(JavadocContentAccess2 var1) throws JavaModelException;
        }
    }
}

