/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.template.contentassist;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.jdt.internal.corext.template.java.JavaDocContext;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.jdt.internal.ui.javaeditor.IndentUtil;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.template.contentassist.InclusivePositionUpdater;
import org.eclipse.jdt.internal.ui.text.template.contentassist.MultiVariable;
import org.eclipse.jdt.internal.ui.text.template.contentassist.MultiVariableGuess;
import org.eclipse.jdt.internal.ui.text.template.contentassist.PositionBasedCompletionProposal;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateContentAssistMessages;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateInformationControlCreator;
import org.eclipse.jdt.internal.ui.text.template.contentassist.VariablePosition;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension7;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.IWorkbenchPartOrientation;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class TemplateProposal
implements IJavaCompletionProposal,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension4,
ICompletionProposalExtension6,
ICompletionProposalExtension7 {
    private final Template fTemplate;
    private final TemplateContext fContext;
    private final Image fImage;
    private final IRegion fRegion;
    private int fRelevance;
    private boolean fIsSubstringMatch;
    private IRegion fSelectedRegion;
    private StyledString fDisplayString;
    private InclusivePositionUpdater fUpdater;

    public TemplateProposal(Template template, TemplateContext context, IRegion region, Image image) {
        Assert.isNotNull((Object)template);
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)region);
        this.fTemplate = template;
        this.fContext = context;
        this.fImage = image;
        this.fRegion = region;
        this.fDisplayString = null;
        this.fRelevance = this.computeRelevance();
    }

    private int computeRelevance() {
        int base = 8;
        boolean isSubstring = false;
        try {
            if (this.fContext instanceof DocumentTemplateContext) {
                DocumentTemplateContext templateContext = (DocumentTemplateContext)this.fContext;
                IDocument document = templateContext.getDocument();
                String content = document.get(this.fRegion.getOffset(), this.fRegion.getLength());
                String templateName = this.fTemplate.getName();
                if (content.length() > 0 && templateName.startsWith(content)) {
                    base += 10;
                }
                if (templateName.equalsIgnoreCase(content)) {
                    base += 4;
                }
                if (this.fContext instanceof JavaDocContext) {
                    base += 31;
                }
                String templateNameLC = templateName.toLowerCase();
                String contentLC = content.toLowerCase();
                isSubstring = content.length() > 0 && !templateNameLC.startsWith(contentLC) && templateNameLC.contains(contentLC);
            }
        }
        catch (BadLocationException badLocationException) {}
        int rel = base * 16 + 1;
        return isSubstring ? rel - 400 : rel;
    }

    public final Template getTemplate() {
        return this.fTemplate;
    }

    protected final TemplateContext getContext() {
        return this.fContext;
    }

    @Deprecated
    public final void apply(IDocument document) {
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        try {
            int start;
            TemplateBuffer templateBuffer;
            this.fContext.setReadOnly(false);
            try {
                this.beginCompoundChange(viewer);
                int oldReplaceOffset = this.getReplaceOffset();
                try {
                    templateBuffer = this.fContext.evaluate(this.fTemplate);
                }
                catch (TemplateException templateException) {
                    this.fSelectedRegion = this.fRegion;
                    this.endCompoundChange(viewer);
                    return;
                }
                start = this.getReplaceOffset();
                int shift = start - oldReplaceOffset;
                int end = Math.max(this.getReplaceEndOffset(), offset + shift);
                if (end > document.getLength()) {
                    end = offset;
                }
                String templateString = templateBuffer.getString();
                document.replace(start, end - start, templateString);
            }
            finally {
                this.endCompoundChange(viewer);
            }
            LinkedModeModel model = new LinkedModeModel();
            TemplateVariable[] variables = templateBuffer.getVariables();
            MultiVariableGuess guess = this.fContext instanceof CompilationUnitContext ? ((CompilationUnitContext)this.fContext).getMultiVariableGuess() : null;
            boolean hasPositions = false;
            int i = 0;
            while (i != variables.length) {
                TemplateVariable variable = variables[i];
                if (!variable.isUnambiguous()) {
                    VariablePosition first;
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    int[] offsets = variable.getOffsets();
                    int length = variable.getLength();
                    if (guess != null && variable instanceof MultiVariable) {
                        first = new VariablePosition(document, offsets[0] + start, length, guess, (MultiVariable)variable);
                        guess.addSlave(first);
                    } else {
                        String[] values = variable.getValues();
                        ICompletionProposal[] proposals = new ICompletionProposal[values.length];
                        int j = 0;
                        while (j < values.length) {
                            this.ensurePositionCategoryInstalled(document, model);
                            Position pos = new Position(offsets[0] + start, length);
                            document.addPosition(this.getCategory(), pos);
                            proposals[j] = new PositionBasedCompletionProposal(values[j], pos, length);
                            ++j;
                        }
                        first = proposals.length > 1 ? new ProposalPosition(document, offsets[0] + start, length, proposals) : new LinkedPosition(document, offsets[0] + start, length);
                    }
                    int j = 0;
                    while (j != offsets.length) {
                        if (j == 0) {
                            group.addPosition((LinkedPosition)first);
                        } else {
                            group.addPosition(new LinkedPosition(document, offsets[j] + start, length));
                        }
                        ++j;
                    }
                    model.addGroup(group);
                    hasPositions = true;
                }
                ++i;
            }
            if (hasPositions) {
                model.forceInstall();
                JavaEditor editor = this.getJavaEditor();
                if (editor != null) {
                    model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(editor));
                }
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, viewer);
                ui.setExitPosition(viewer, this.getCaretOffset(templateBuffer) + start, 0, Integer.MAX_VALUE);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            } else {
                this.fSelectedRegion = new Region(this.getCaretOffset(templateBuffer) + start, 0);
            }
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
            this.openErrorDialog(viewer.getTextWidget().getShell(), (Exception)((Object)e));
            this.fSelectedRegion = this.fRegion;
        }
        catch (BadPositionCategoryException e) {
            JavaPlugin.log(e);
            this.openErrorDialog(viewer.getTextWidget().getShell(), (Exception)((Object)e));
            this.fSelectedRegion = this.fRegion;
        }
    }

    private void endCompoundChange(ITextViewer viewer) {
        if (viewer instanceof ITextViewerExtension) {
            ITextViewerExtension extension = (ITextViewerExtension)viewer;
            IRewriteTarget target = extension.getRewriteTarget();
            target.endCompoundChange();
        }
    }

    private void beginCompoundChange(ITextViewer viewer) {
        if (viewer instanceof ITextViewerExtension) {
            ITextViewerExtension extension = (ITextViewerExtension)viewer;
            IRewriteTarget target = extension.getRewriteTarget();
            target.beginCompoundChange();
        }
    }

    private JavaEditor getJavaEditor() {
        IEditorPart part = JavaPlugin.getActivePage().getActiveEditor();
        if (part instanceof JavaEditor) {
            return (JavaEditor)part;
        }
        return null;
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        if (!document.containsPositionCategory(this.getCategory())) {
            document.addPositionCategory(this.getCategory());
            this.fUpdater = new InclusivePositionUpdater(this.getCategory());
            document.addPositionUpdater((IPositionUpdater)this.fUpdater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    TemplateProposal.this.ensurePositionCategoryRemoved(document);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.getCategory())) {
            try {
                document.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            document.removePositionUpdater((IPositionUpdater)this.fUpdater);
        }
    }

    private String getCategory() {
        return "TemplateProposalCategory_" + this.toString();
    }

    private int getCaretOffset(TemplateBuffer buffer) {
        TemplateVariable[] variables = buffer.getVariables();
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            if (variable.getType().equals("cursor")) {
                return variable.getOffsets()[0];
            }
            ++i;
        }
        return buffer.getString().length();
    }

    protected final int getReplaceOffset() {
        int start;
        if (this.fContext instanceof DocumentTemplateContext) {
            DocumentTemplateContext docContext = (DocumentTemplateContext)this.fContext;
            start = docContext.getStart();
        } else {
            start = this.fRegion.getOffset();
        }
        return start;
    }

    protected final int getReplaceEndOffset() {
        int end;
        if (this.fContext instanceof DocumentTemplateContext) {
            DocumentTemplateContext docContext = (DocumentTemplateContext)this.fContext;
            end = docContext.getEnd();
        } else {
            end = this.fRegion.getOffset() + this.fRegion.getLength();
        }
        return end;
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    public String getAdditionalProposalInfo() {
        TemplateBuffer templateBuffer;
        try {
            this.fContext.setReadOnly(true);
            try {
                templateBuffer = this.fContext.evaluate(this.fTemplate);
            }
            catch (TemplateException templateException) {
                return null;
            }
        }
        catch (BadLocationException e) {
            this.handleException(JavaPlugin.getActiveWorkbenchShell(), new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, "", (Throwable)e)));
            return null;
        }
        Document document = new Document(templateBuffer.getString());
        IndentUtil.indentLines((IDocument)document, (ILineRange)new LineRange(0, document.getNumberOfLines()), null, null);
        return document.get();
    }

    public String getDisplayString() {
        return this.getStyledDisplayString().getString();
    }

    public StyledString getStyledDisplayString() {
        if (this.fDisplayString == null) {
            Object[] arguments = new String[]{this.fTemplate.getName(), this.fTemplate.getDescription()};
            String decorated = Messages.format(TemplateContentAssistMessages.TemplateProposal_displayString, arguments);
            StyledString string = new StyledString(this.fTemplate.getName(), StyledString.COUNTER_STYLER);
            this.fDisplayString = StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.QUALIFIER_STYLER, (StyledString)string);
        }
        return this.fDisplayString;
    }

    public void setDisplayString(StyledString displayString) {
        this.fDisplayString = displayString;
    }

    public StyledString getStyledDisplayString(IDocument document, int offset, final BoldStylerProvider boldStylerProvider) {
        StyledString styledDisplayString = new StyledString();
        styledDisplayString.append(this.getStyledDisplayString());
        int start = this.getPrefixCompletionStart(document, offset);
        int patternLength = offset - start;
        try {
            String pattern = document.get(start, patternLength);
            if (!pattern.isEmpty()) {
                boolean hasBracket;
                StyledString.Styler styler = new StyledString.Styler(){

                    public void applyStyles(TextStyle textStyle) {
                        textStyle.foreground = JFaceResources.getColorRegistry().get("COUNTER_COLOR");
                        textStyle.font = boldStylerProvider.getBoldFont();
                    }
                };
                String displayString = styledDisplayString.getString();
                boolean bl = hasBracket = this.fContext instanceof JavaDocContext && displayString.indexOf(60) == 0;
                if (hasBracket) {
                    displayString = displayString.substring(1);
                    if (pattern.indexOf(60) == 0) {
                        pattern = pattern.substring(1);
                        int[] nArray = new int[2];
                        nArray[1] = 1;
                        Strings.markMatchingRegions(styledDisplayString, 0, nArray, styler);
                    }
                }
                int matchRule = 1;
                if ("enabled".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.codeComplete.substringMatch")) && CharOperation.substringMatch((String)pattern, (String)displayString)) {
                    matchRule = 512;
                }
                int[] matchingRegions = SearchPattern.getMatchingRegions((String)pattern, (String)displayString, (int)matchRule);
                if (hasBracket && matchingRegions != null) {
                    int i = 0;
                    while (i < matchingRegions.length) {
                        int n = i;
                        matchingRegions[n] = matchingRegions[n] + 1;
                        i += 2;
                    }
                }
                Strings.markMatchingRegions(styledDisplayString, 0, matchingRegions, styler);
            }
        }
        catch (BadLocationException badLocationException) {}
        return styledDisplayString;
    }

    public Image getImage() {
        return this.fImage;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    private void openErrorDialog(Shell shell, Exception e) {
        MessageDialog.openError((Shell)shell, (String)TemplateContentAssistMessages.TemplateEvaluator_error_title, (String)e.getMessage());
    }

    private void handleException(Shell shell, CoreException e) {
        ExceptionHandler.handle(e, shell, TemplateContentAssistMessages.TemplateEvaluator_error_title, null);
    }

    @Override
    public int getRelevance() {
        return this.fIsSubstringMatch ? this.fRelevance - 400 : this.fRelevance;
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }

    public IInformationControlCreator getInformationControlCreator() {
        JavaEditor editor = this.getJavaEditor();
        int orientation = editor instanceof IWorkbenchPartOrientation ? ((IWorkbenchPartOrientation)editor).getOrientation() : 0x2000000;
        return new TemplateInformationControlCreator(orientation);
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            int replaceOffset = this.getReplaceOffset();
            if (offset >= replaceOffset) {
                String content = document.get(replaceOffset, offset - replaceOffset).toLowerCase();
                String templateName = this.fTemplate.getName().toLowerCase();
                boolean isSubstringEnabled = "enabled".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.codeComplete.substringMatch"));
                boolean valid = false;
                this.fIsSubstringMatch = false;
                if (templateName.startsWith(content)) {
                    valid = true;
                } else if (isSubstringEnabled && templateName.contains(content)) {
                    valid = true;
                    this.fIsSubstringMatch = true;
                }
                if (!valid && this.fContext instanceof JavaDocContext && templateName.startsWith("<")) {
                    if (templateName.startsWith(content, 1)) {
                        valid = true;
                    } else if (isSubstringEnabled && CharOperation.substringMatch((String)(content.indexOf(60) == 0 ? content.substring(1) : content), (String)templateName.substring(1))) {
                        valid = true;
                        this.fIsSubstringMatch = true;
                    }
                }
                return valid;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        if (this.isSelectionTemplate()) {
            return "";
        }
        return this.fTemplate.getName();
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.getReplaceOffset();
    }

    public boolean isAutoInsertable() {
        if (this.isSelectionTemplate()) {
            return false;
        }
        return this.fTemplate.isAutoInsertable();
    }

    private boolean isSelectionTemplate() {
        DocumentTemplateContext ctx;
        return this.fContext instanceof DocumentTemplateContext && (ctx = (DocumentTemplateContext)this.fContext).getCompletionLength() > 0;
    }
}

