/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class ResourceToItemsMapper {
    private static final int NUMBER_LIST_REUSE = 10;
    private HashMap<IResource, Object> fResourceToItem = new HashMap();
    private Stack<List<Item>> fReuseLists = new Stack();
    private IContentViewerAccessor fContentViewerAccess;

    public ResourceToItemsMapper(IContentViewerAccessor viewer) {
        this.fContentViewerAccess = viewer;
    }

    public void resourceChanged(IResource changedResource) {
        Object obj = this.fResourceToItem.get(changedResource);
        if (obj != null) {
            if (obj instanceof Item) {
                this.updateItem((Item)obj);
            } else {
                List list = (List)obj;
                int k = 0;
                while (k < list.size()) {
                    this.updateItem((Item)list.get(k));
                    ++k;
                }
            }
        }
    }

    private void updateItem(Item item) {
        if (!item.isDisposed()) {
            this.fContentViewerAccess.doUpdateItem((Widget)item);
        }
    }

    public void addToMap(Object element, Item item) {
        IResource resource = ResourceToItemsMapper.getCorrespondingResource(element);
        if (resource != null) {
            Object existingMapping = this.fResourceToItem.get(resource);
            if (existingMapping == null) {
                this.fResourceToItem.put(resource, item);
            } else if (existingMapping instanceof Item) {
                if (existingMapping != item) {
                    List<Item> list = this.getNewList();
                    list.add((Item)existingMapping);
                    list.add(item);
                    this.fResourceToItem.put(resource, list);
                }
            } else {
                List list = (List)existingMapping;
                if (!list.contains(item)) {
                    list.add(item);
                }
            }
        }
    }

    public void removeFromMap(Object element, Item item) {
        IResource resource = ResourceToItemsMapper.getCorrespondingResource(element);
        if (resource != null) {
            Object existingMapping = this.fResourceToItem.get(resource);
            if (existingMapping == null) {
                return;
            }
            if (existingMapping instanceof Item) {
                this.fResourceToItem.remove(resource);
            } else {
                List list = (List)existingMapping;
                list.remove(item);
                if (list.isEmpty()) {
                    this.fResourceToItem.remove(list);
                    this.releaseList(list);
                }
            }
        }
    }

    private List<Item> getNewList() {
        if (!this.fReuseLists.isEmpty()) {
            return this.fReuseLists.pop();
        }
        return new ArrayList<Item>(2);
    }

    private void releaseList(List<Item> list) {
        if (this.fReuseLists.size() < 10) {
            this.fReuseLists.push(list);
        }
    }

    public void clearMap() {
        this.fResourceToItem.clear();
    }

    public boolean isEmpty() {
        return this.fResourceToItem.isEmpty();
    }

    private static IResource getCorrespondingResource(Object element) {
        if (element instanceof IJavaElement) {
            ICompilationUnit cu;
            IJavaElement elem = (IJavaElement)element;
            IResource res = elem.getResource();
            if (res == null && (cu = (ICompilationUnit)elem.getAncestor(5)) != null) {
                res = cu.getResource();
            }
            return res;
        }
        if (element instanceof IResource) {
            return (IResource)element;
        }
        return null;
    }

    public static interface IContentViewerAccessor {
        public void doUpdateItem(Widget var1);
    }
}

