/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.titan.common.utils.Appender;
import org.eclipse.titan.common.utils.Joiner;

public class MapAppender {
    private final Appender simpleAppender;
    private final String keyValueDelimiter;

    public MapAppender(Appendable appendable, String entryDelimiter, String keyValueDelimiter) {
        this.simpleAppender = new Appender(appendable, entryDelimiter);
        this.keyValueDelimiter = keyValueDelimiter;
    }

    public <K, V> MapAppender append(K key, V value) throws IOException {
        this.simpleAppender.append(String.valueOf(key) + this.keyValueDelimiter + String.valueOf(value));
        return this;
    }

    public MapAppender append(Object ... items) throws IOException {
        Joiner joiner = new Joiner(this.keyValueDelimiter);
        joiner.join(Arrays.asList(items)).appendTo(this.simpleAppender);
        return this;
    }

    public MapAppender append(Iterable<? extends Map.Entry<?, ?>> iterable) throws IOException {
        for (Map.Entry<?, ?> entry : iterable) {
            this.append((K)entry.getKey(), (V)entry.getValue());
        }
        return this;
    }

    public MapAppender append(Map<?, ?> map) throws IOException {
        return this.append(map.entrySet());
    }
}

