/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.svg;

import fr.inria.zvtm.svg.SVGReader;
import java.awt.Color;
import java.awt.Font;
import java.util.StringTokenizer;

public class Context {
    String font_family;
    String font_size;
    String font_weight;
    String font_style;
    Color fill;
    Color stroke;
    boolean fillColorDefined = false;
    boolean strokeColorDefined = false;
    Float fill_opacity;
    String title;
    String url;
    String url_title;
    String css_class;
    String closestAncestorGroupID;
    String closestAncestorGroupClass;

    Context() {
    }

    Context(String s) {
        if (s != null) {
            this.processStyleInfo(s);
        }
    }

    void add(String s) {
        this.processStyleInfo(s);
    }

    void processStyleInfo(String styleInfo) {
        String[] ar = null;
        if (styleInfo != null) {
            StringTokenizer st = new StringTokenizer(styleInfo, ";");
            ar = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                ar[i++] = st.nextToken();
            }
        }
        if (ar != null) {
            for (int i = 0; i < ar.length; ++i) {
                if (ar[i].startsWith("fill")) {
                    this.fill = SVGReader.getColor(ar[i].substring("fill".length()));
                    this.fillColorDefined = true;
                    continue;
                }
                if (ar[i].startsWith("stroke")) {
                    SVGReader.getColor(ar[i].substring("stroke".length()));
                    this.strokeColorDefined = true;
                    continue;
                }
                if (ar[i].startsWith("fill-opacity")) {
                    this.fill_opacity = new Float(ar[i].substring("fill-opacity".length()));
                    continue;
                }
                if (ar[i].startsWith("font-family:")) {
                    this.font_family = ar[i].substring("font-family".length());
                    continue;
                }
                if (ar[i].startsWith("font-size")) {
                    this.font_size = ar[i].substring("font-size:".length());
                    if (!this.font_size.endsWith("pt")) continue;
                    this.font_size = this.font_size.substring(0, this.font_size.length() - 2);
                    continue;
                }
                if (ar[i].startsWith("font-weight")) {
                    this.font_weight = ar[i].substring("font-weight:".length());
                    continue;
                }
                if (!ar[i].startsWith("font-style")) continue;
                this.font_style = ar[i].substring("font-style:".length());
            }
        }
    }

    public boolean hasTransparencyInformation() {
        return this.fill_opacity != null;
    }

    public Color getFillColor() {
        return this.fill;
    }

    public boolean hasFillColorInformation() {
        return this.fillColorDefined;
    }

    public Color getStrokeColor() {
        return this.stroke;
    }

    public boolean hasStrokeColorInformation() {
        return this.strokeColorDefined;
    }

    public float getAlphaTransparencyValue() {
        if (this.fill_opacity != null) {
            return this.fill_opacity.floatValue();
        }
        return 1.0f;
    }

    Font getDefinedFont() {
        if (this.font_family != null || this.font_size != null || this.font_style != null || this.font_weight != null) {
            int size;
            String fam = this.font_family != null ? this.font_family : "Default";
            try {
                size = this.font_size != null ? Math.round(new Float(this.font_size).floatValue()) : 10;
            }
            catch (NumberFormatException ex) {
                System.err.println("Warning: Font size value not supported (using default): " + this.font_size);
                size = 10;
            }
            int style = this.font_style != null && this.font_style.equals("italic") ? (this.font_weight != null && this.font_weight.equals("bold") ? 3 : 2) : (this.font_weight != null && this.font_weight.equals("bold") ? 1 : 0);
            return SVGReader.getFont(fam, style, size);
        }
        return null;
    }

    public void setURL(String s) {
        this.url = s;
    }

    public String getURL() {
        return this.url;
    }

    public void setURLTitle(String s) {
        this.url_title = s;
    }

    public String getURLTitle() {
        return this.url_title;
    }

    public void setTitle(String s) {
        this.title = s;
    }

    public String getTitle() {
        return this.title;
    }

    public void setClosestAncestorGroupID(String s) {
        this.closestAncestorGroupID = s;
    }

    public String getClosestAncestorGroupID() {
        return this.closestAncestorGroupID;
    }

    public void setClosestAncestorGroupClass(String s) {
        this.closestAncestorGroupClass = s;
    }

    public String getClosestAncestorGroupClass() {
        return this.closestAncestorGroupClass;
    }

    public Context duplicate() {
        Context copy = new Context(null);
        copy.font_family = this.font_family;
        copy.font_size = this.font_size;
        copy.font_weight = this.font_weight;
        copy.font_style = this.font_style;
        copy.fill = this.fill;
        copy.stroke = this.stroke;
        copy.fillColorDefined = this.fillColorDefined;
        copy.strokeColorDefined = this.strokeColorDefined;
        copy.fill_opacity = this.fill_opacity;
        copy.url = this.url;
        copy.title = this.title;
        copy.url_title = this.url_title;
        copy.closestAncestorGroupID = this.closestAncestorGroupID;
        copy.closestAncestorGroupClass = this.closestAncestorGroupClass;
        return copy;
    }
}

