/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.VRectangle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VRectangleOr<T>
extends VRectangle {
    int[] xcoords = new int[4];
    int[] ycoords = new int[4];

    public VRectangleOr() {
        this(0.0, 0.0, 0, 10.0, 10.0, Color.WHITE, Color.BLACK, 0.0, 1.0f);
    }

    public VRectangleOr(double x, double y, int z, double w, double h, Color c, double or) {
        this(x, y, z, w, h, c, Color.BLACK, or, 1.0f);
    }

    public VRectangleOr(double x, double y, int z, double w, double h, Color c, Color bc, double or) {
        this(x, y, z, w, h, c, bc, or, 1.0f);
    }

    public VRectangleOr(double x, double y, int z, double w, double h, Color c, Color bc, double or, float alpha) {
        super(x, y, z, w, h, c);
        this.orient = or;
        this.setTranslucencyValue(alpha);
    }

    @Override
    public double getOrient() {
        return this.orient;
    }

    @Override
    public void orientTo(double angle) {
        this.orient = angle;
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public boolean fillsView(double w, double h, int camIndex) {
        if (this.orient == 0.0) {
            return w <= (double)(this.pc[camIndex].cx + this.pc[camIndex].cw) && 0 >= this.pc[camIndex].cx - this.pc[camIndex].cw && h <= (double)(this.pc[camIndex].cy + this.pc[camIndex].ch) && 0 >= this.pc[camIndex].cy - this.pc[camIndex].ch;
        }
        return this.pc[camIndex].p.contains(0, 0) && this.pc[camIndex].p.contains(w, 0.0) && this.pc[camIndex].p.contains(0.0, h) && this.pc[camIndex].p.contains(w, h);
    }

    @Override
    public boolean visibleInDisc(double dvx, double dvy, double dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        if (this.orient == 0.0) {
            return dvs.intersects(this.vx - this.vw / 2.0, this.vy - this.vh / 2.0, this.vw, this.vh);
        }
        return this.pc[camIndex].p.intersects(jpx - dpr, jpy - dpr, 2 * dpr, 2 * dpr);
    }

    @Override
    public boolean visibleInRegion(double wb, double nb, double eb, double sb, int i) {
        if (this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb) {
            return true;
        }
        return this.vx - this.size / 2.0 <= eb && this.vx + this.size / 2.0 >= wb && this.vy - this.size / 2.0 <= nb && this.vy + this.size / 2.0 >= sb;
    }

    @Override
    public boolean coordInside(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        if (this.orient == 0.0) {
            return jpx >= this.pc[camIndex].cx - this.pc[camIndex].cw && jpx <= this.pc[camIndex].cx + this.pc[camIndex].cw && jpy >= this.pc[camIndex].cy - this.pc[camIndex].ch && jpy <= this.pc[camIndex].cy + this.pc[camIndex].ch;
        }
        return this.pc[camIndex].p.contains(jpx, jpy);
    }

    @Override
    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = (int)Math.round((double)(d.width / 2) + (this.vx - c.vx) * this.coef);
        this.pc[i].cy = (int)Math.round((double)(d.height / 2) - (this.vy - c.vy) * this.coef);
        this.pc[i].cw = (int)Math.round(Math.ceil(this.vw / 2.0 * this.coef));
        this.pc[i].ch = (int)Math.round(Math.ceil(this.vh / 2.0 * this.coef));
        if (this.orient != 0.0) {
            float x1 = -this.pc[i].cw;
            float y1 = -this.pc[i].ch;
            float x2 = this.pc[i].cw;
            float y2 = this.pc[i].ch;
            this.xcoords[0] = (int)Math.round((double)x2 * Math.cos(this.orient) + (double)y1 * Math.sin(this.orient) + (double)this.pc[i].cx);
            this.ycoords[0] = (int)Math.round((double)y1 * Math.cos(this.orient) - (double)x2 * Math.sin(this.orient) + (double)this.pc[i].cy);
            this.xcoords[1] = (int)Math.round((double)x1 * Math.cos(this.orient) + (double)y1 * Math.sin(this.orient) + (double)this.pc[i].cx);
            this.ycoords[1] = (int)Math.round((double)y1 * Math.cos(this.orient) - (double)x1 * Math.sin(this.orient) + (double)this.pc[i].cy);
            this.xcoords[2] = (int)Math.round((double)x1 * Math.cos(this.orient) + (double)y2 * Math.sin(this.orient) + (double)this.pc[i].cx);
            this.ycoords[2] = (int)Math.round((double)y2 * Math.cos(this.orient) - (double)x1 * Math.sin(this.orient) + (double)this.pc[i].cy);
            this.xcoords[3] = (int)Math.round((double)x2 * Math.cos(this.orient) + (double)y2 * Math.sin(this.orient) + (double)this.pc[i].cx);
            this.ycoords[3] = (int)Math.round((double)y2 * Math.cos(this.orient) - (double)x2 * Math.sin(this.orient) + (double)this.pc[i].cy);
            if (this.pc[i].p == null) {
                this.pc[i].p = new Polygon(this.xcoords, this.ycoords, 4);
            } else {
                for (int j = 0; j < this.xcoords.length; ++j) {
                    this.pc[i].p.xpoints[j] = this.xcoords[j];
                    this.pc[i].p.ypoints[j] = this.ycoords[j];
                }
                this.pc[i].p.invalidate();
            }
        }
    }

    @Override
    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, double lensx, double lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * (double)lensMag;
        this.pc[i].lcx = (int)Math.round((double)(lensWidth / 2) + (this.vx - lensx) * this.coef);
        this.pc[i].lcy = (int)Math.round((double)(lensHeight / 2) - (this.vy - lensy) * this.coef);
        this.pc[i].lcw = (int)Math.round(this.vw / 2.0 * this.coef);
        this.pc[i].lch = (int)Math.round(this.vh / 2.0 * this.coef);
        if (this.orient != 0.0) {
            float x1 = -this.pc[i].lcw;
            float y1 = -this.pc[i].lch;
            float x2 = this.pc[i].lcw;
            float y2 = this.pc[i].lch;
            this.xcoords[0] = (int)Math.round((double)x2 * Math.cos(this.orient) + (double)y1 * Math.sin(this.orient) + (double)this.pc[i].lcx);
            this.ycoords[0] = (int)Math.round((double)y1 * Math.cos(this.orient) - (double)x2 * Math.sin(this.orient) + (double)this.pc[i].lcy);
            this.xcoords[1] = (int)Math.round((double)x1 * Math.cos(this.orient) + (double)y1 * Math.sin(this.orient) + (double)this.pc[i].lcx);
            this.ycoords[1] = (int)Math.round((double)y1 * Math.cos(this.orient) - (double)x1 * Math.sin(this.orient) + (double)this.pc[i].lcy);
            this.xcoords[2] = (int)Math.round((double)x1 * Math.cos(this.orient) + (double)y2 * Math.sin(this.orient) + (double)this.pc[i].lcx);
            this.ycoords[2] = (int)Math.round((double)y2 * Math.cos(this.orient) - (double)x1 * Math.sin(this.orient) + (double)this.pc[i].lcy);
            this.xcoords[3] = (int)Math.round((double)x2 * Math.cos(this.orient) + (double)y2 * Math.sin(this.orient) + (double)this.pc[i].lcx);
            this.ycoords[3] = (int)Math.round((double)y2 * Math.cos(this.orient) - (double)x2 * Math.sin(this.orient) + (double)this.pc[i].lcy);
            if (this.pc[i].lp == null) {
                this.pc[i].lp = new Polygon(this.xcoords, this.ycoords, 4);
            } else {
                for (int j = 0; j < this.xcoords.length; ++j) {
                    this.pc[i].lp.xpoints[j] = this.xcoords[j];
                    this.pc[i].lp.ypoints[j] = this.ycoords[j];
                }
                this.pc[i].lp.invalidate();
            }
        }
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        if (this.pc[i].cw == 1 && this.pc[i].ch == 1) {
            g.setColor(this.color);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
                g.setComposite(acO);
            } else {
                g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
            }
        } else if (this.orient == 0.0) {
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                if (this.filled) {
                    g.setColor(this.color);
                    g.fillRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw, 2 * this.pc[i].ch);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        if (dx + this.pc[i].cx - this.pc[i].cw > 0 || dy + this.pc[i].cy - this.pc[i].ch > 0 || dx + this.pc[i].cx - this.pc[i].cw + 2 * this.pc[i].cw - 1 < vW || dy + this.pc[i].cy - this.pc[i].ch + 2 * this.pc[i].ch - 1 < vH) {
                            g.setStroke(this.stroke);
                            g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw, 2 * this.pc[i].ch);
                            g.setStroke(stdS);
                        }
                    } else {
                        g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw, 2 * this.pc[i].ch);
                    }
                }
                g.setComposite(acO);
            } else {
                if (this.filled) {
                    g.setColor(this.color);
                    g.fillRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw, 2 * this.pc[i].ch);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        if (dx + this.pc[i].cx - this.pc[i].cw > 0 || dy + this.pc[i].cy - this.pc[i].ch > 0 || dx + this.pc[i].cx - this.pc[i].cw + 2 * this.pc[i].cw - 1 < vW || dy + this.pc[i].cy - this.pc[i].ch + 2 * this.pc[i].ch - 1 < vH) {
                            g.setStroke(this.stroke);
                            g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw, 2 * this.pc[i].ch);
                            g.setStroke(stdS);
                        }
                    } else {
                        g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw, 2 * this.pc[i].ch);
                    }
                }
            }
        } else if (this.alphaC != null) {
            g.setComposite(this.alphaC);
            if (this.filled) {
                g.setColor(this.color);
                g.fillPolygon(this.pc[i].p);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.drawPolygon(this.pc[i].p);
                    g.setStroke(stdS);
                } else {
                    g.drawPolygon(this.pc[i].p);
                }
            }
            g.setComposite(acO);
        } else {
            if (this.filled) {
                g.setColor(this.color);
                g.fillPolygon(this.pc[i].p);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.drawPolygon(this.pc[i].p);
                    g.setStroke(stdS);
                } else {
                    g.drawPolygon(this.pc[i].p);
                }
            }
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        if (this.pc[i].lcw == 1 || this.pc[i].lch == 1) {
            g.setColor(this.color);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
                g.setComposite(acO);
            } else {
                g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
            }
        } else if (this.orient == 0.0) {
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                if (this.filled) {
                    g.setColor(this.color);
                    g.fillRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw, 2 * this.pc[i].lch);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        if (dx + this.pc[i].lcx - this.pc[i].lcw > 0 || dy + this.pc[i].lcy - this.pc[i].lch > 0 || dx + this.pc[i].lcx - this.pc[i].lcw + 2 * this.pc[i].lcw - 1 < vW || dy + this.pc[i].lcy - this.pc[i].lch + 2 * this.pc[i].lch - 1 < vH) {
                            g.setStroke(this.stroke);
                            g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw, 2 * this.pc[i].lch);
                            g.setStroke(stdS);
                        }
                    } else {
                        g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw, 2 * this.pc[i].lch);
                    }
                }
                g.setComposite(acO);
            } else {
                if (this.filled) {
                    g.setColor(this.color);
                    g.fillRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw, 2 * this.pc[i].lch);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        if (dx + this.pc[i].lcx - this.pc[i].lcw > 0 || dy + this.pc[i].lcy - this.pc[i].lch > 0 || dx + this.pc[i].lcx - this.pc[i].lcw + 2 * this.pc[i].lcw - 1 < vW || dy + this.pc[i].lcy - this.pc[i].lch + 2 * this.pc[i].lch - 1 < vH) {
                            g.setStroke(this.stroke);
                            g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw, 2 * this.pc[i].lch);
                            g.setStroke(stdS);
                        }
                    } else {
                        g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw, 2 * this.pc[i].lch);
                    }
                }
            }
        } else if (this.alphaC != null) {
            g.setComposite(this.alphaC);
            if (this.filled) {
                g.setColor(this.color);
                g.fillPolygon(this.pc[i].lp);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.drawPolygon(this.pc[i].lp);
                    g.setStroke(stdS);
                } else {
                    g.drawPolygon(this.pc[i].lp);
                }
            }
            g.setComposite(acO);
        } else {
            if (this.filled) {
                g.setColor(this.color);
                g.fillPolygon(this.pc[i].lp);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.drawPolygon(this.pc[i].lp);
                    g.setStroke(stdS);
                } else {
                    g.drawPolygon(this.pc[i].lp);
                }
            }
        }
    }

    @Override
    public Object clone() {
        VRectangleOr<T> res = new VRectangleOr<T>(this.vx, this.vy, this.vz, this.vw, this.vh, this.color, this.borderColor, this.orient);
        res.cursorInsideColor = this.cursorInsideColor;
        return res;
    }
}

