/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.ClosedShape;
import fr.inria.zvtm.glyphs.projection.ProjText;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VText<T>
extends ClosedShape {
    public static final short TEXT_ANCHOR_START = 0;
    public static final short TEXT_ANCHOR_MIDDLE = 1;
    public static final short TEXT_ANCHOR_END = 2;
    protected short text_anchor = 0;
    protected ProjText[] pc;
    protected boolean zoomSensitive = true;
    protected static Font mainFont = new Font("Dialog", 0, 10);
    protected float fontSize = mainFont.getSize2D();
    protected Font font;
    protected String text;
    protected float scaleFactor = 1.0f;
    protected double lcoef = 1.0;
    protected double oldcoef = 1.0;
    protected double oldlcoef = 1.0;
    public int paddingX = 1;
    public int paddingY = 1;
    static float TEXT_AS_LINE_PROJ_COEF = 0.5f;

    public static Font getMainFont() {
        return mainFont;
    }

    public static void setMainFont(Font f) {
        mainFont = f;
        VirtualSpaceManager.INSTANCE.onMainFontUpdated();
    }

    public VText(String t) {
        this(0.0, 0.0, 0, Color.BLACK, null, t, 0, 1.0f, 1.0f);
    }

    public VText(double x, double y, int z, Color c, String t) {
        this(x, y, z, c, null, t, 0, 1.0f, 1.0f);
    }

    public VText(double x, double y, int z, Color c, String t, short ta) {
        this(x, y, z, c, null, t, ta, 1.0f, 1.0f);
    }

    public VText(double x, double y, int z, Color c, String t, short ta, float scale) {
        this(x, y, z, c, null, t, ta, scale, 1.0f);
    }

    public VText(double x, double y, int z, Color c, String t, short ta, float scale, float alpha) {
        this(x, y, z, c, null, t, ta, scale, alpha);
    }

    public VText(double x, double y, int z, Color c, Color bkg, String t, short ta, float scale, float alpha) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.text = t;
        this.setColor(c);
        if (bkg != null) {
            this.setDrawBorder(true);
            this.setBorderColor(bkg);
        } else {
            this.setDrawBorder(false);
        }
        this.text_anchor = ta;
        this.scaleFactor = scale;
        this.setTranslucencyValue(alpha);
    }

    @Override
    public void initCams(int nbCam) {
        this.pc = new ProjText[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new ProjText();
        }
    }

    @Override
    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                ProjText[] ta = this.pc;
                this.pc = new ProjText[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new ProjText();
            } else {
                System.err.println("VText:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new ProjText[1];
            this.pc[0] = new ProjText();
        } else {
            System.err.println("VText:Error while adding camera " + verifIndex);
        }
    }

    @Override
    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    @Override
    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    @Override
    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
    }

    @Override
    public void sizeTo(double factor) {
    }

    @Override
    public void reSize(double factor) {
    }

    @Override
    public void orientTo(double angle) {
    }

    @Override
    public double getSize() {
        for (int i = 0; i < this.pc.length; ++i) {
            if (!(this.pc[i] != null & this.pc[i].valid)) continue;
            return (float)Math.sqrt(this.pc[i].cw * this.pc[i].cw + this.pc[i].ch * this.pc[i].ch);
        }
        return 0.0;
    }

    @Override
    public double getOrient() {
        return this.orient;
    }

    public void setZoomSensitive(boolean b) {
        if (this.zoomSensitive != b) {
            this.zoomSensitive = b;
            VirtualSpaceManager.INSTANCE.repaint();
        }
    }

    public boolean isZoomSensitive() {
        return this.zoomSensitive;
    }

    public static void setTextDisplayedAsSegCoef(float f) {
        TEXT_AS_LINE_PROJ_COEF = f;
    }

    public static float getTextDisplayedAsSegCoef() {
        return TEXT_AS_LINE_PROJ_COEF;
    }

    @Override
    public void setBorderColor(Color c) {
        super.setBorderColor(c);
        if (c != null) {
            this.setDrawBorder(true);
        } else {
            this.setDrawBorder(false);
        }
    }

    @Override
    public Color getBorderColor() {
        return super.getBorderColor();
    }

    @Override
    public boolean visibleInRegion(double wb, double nb, double eb, double sb, int i) {
        if (!this.validBounds(i)) {
            return true;
        }
        if (this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb) {
            return true;
        }
        if (this.text_anchor == 0) {
            return this.vx <= eb && this.vx + this.pc[i].cw >= wb && this.vy <= nb && this.vy + this.pc[i].ch >= sb;
        }
        if (this.text_anchor == 1) {
            return this.vx - this.pc[i].cw / 2.0 <= eb && this.vx + this.pc[i].cw / 2.0 >= wb && this.vy <= nb && this.vy + this.pc[i].ch >= sb;
        }
        return this.vx - this.pc[i].cw <= eb && this.vx >= wb && this.vy <= nb && this.vy + this.pc[i].ch >= sb;
    }

    @Override
    public boolean containedInRegion(double wb, double nb, double eb, double sb, int i) {
        if (this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb) {
            if (this.text_anchor == 0) {
                return this.vx <= eb && this.vx + this.pc[i].cw >= wb && this.vy <= nb && this.vy - this.pc[i].ch >= sb;
            }
            if (this.text_anchor == 1) {
                return this.vx + this.pc[i].cw / 2.0 <= eb && this.vx - this.pc[i].cw / 2.0 >= wb && this.vy <= nb && this.vy - this.pc[i].ch >= sb;
            }
            return this.vx + this.pc[i].cw <= eb && this.vx >= wb && this.vy <= nb && this.vy - this.pc[i].ch >= sb;
        }
        return false;
    }

    @Override
    public boolean fillsView(double w, double h, int camIndex) {
        return false;
    }

    @Override
    public boolean coordInside(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        boolean res = false;
        switch (this.text_anchor) {
            case 0: {
                if (!(cvx >= this.vx) || !(cvy >= this.vy) || !(cvx <= this.vx + this.pc[camIndex].cw) || !(cvy <= this.vy + this.pc[camIndex].ch)) break;
                res = true;
                break;
            }
            case 1: {
                if (!(cvx >= this.vx - this.pc[camIndex].cw / 2.0) || !(cvy >= this.vy) || !(cvx <= this.vx + this.pc[camIndex].cw / 2.0) || !(cvy <= this.vy + this.pc[camIndex].ch)) break;
                res = true;
                break;
            }
            default: {
                if (!(cvx <= this.vx) || !(cvy >= this.vy) || !(cvx >= this.vx - this.pc[camIndex].cw) || !(cvy <= this.vy + this.pc[camIndex].ch)) break;
                res = true;
            }
        }
        return res;
    }

    @Override
    public boolean visibleInDisc(double dvx, double dvy, double dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        if (this.text_anchor == 0) {
            return dvs.intersects(this.vx, this.vy, this.pc[camIndex].cw, this.pc[camIndex].ch);
        }
        if (this.text_anchor == 1) {
            return dvs.intersects(this.vx - this.pc[camIndex].cw / 2.0, this.vy, this.pc[camIndex].cw, this.pc[camIndex].ch);
        }
        return dvs.intersects(this.vx - this.pc[camIndex].cw, this.vy, this.pc[camIndex].cw, this.pc[camIndex].ch);
    }

    @Override
    public short mouseInOut(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    @Override
    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = d.width / 2 + (int)Math.round((this.vx - c.vx) * this.coef);
        this.pc[i].cy = d.height / 2 - (int)Math.round((this.vy - c.vy) * this.coef);
    }

    @Override
    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, double lensx, double lensy) {
        int i = c.getIndex();
        this.lcoef = c.focal / (c.focal + c.altitude) * (double)lensMag;
        this.pc[i].lcx = lensWidth / 2 + (int)Math.round((this.vx - lensx) * this.lcoef);
        this.pc[i].lcy = lensHeight / 2 - (int)Math.round((this.vy - lensy) * this.lcoef);
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (!this.pc[i].valid || !this.zoomSensitive && this.coef != this.oldcoef) {
            g.setFont(this.font != null ? this.font : VText.getMainFont());
            Rectangle2D bounds = g.getFontMetrics().getStringBounds(this.text, g);
            if (this.zoomSensitive) {
                this.pc[i].cw = bounds.getWidth() * (double)this.scaleFactor;
                this.pc[i].ch = bounds.getHeight() * (double)this.scaleFactor;
            } else {
                this.pc[i].cw = bounds.getWidth() * (double)this.scaleFactor / this.coef;
                this.pc[i].ch = bounds.getHeight() * (double)this.scaleFactor / this.coef;
                this.oldcoef = this.coef;
            }
            this.pc[i].valid = true;
        }
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        double trueCoef = (double)this.scaleFactor * this.coef;
        if (trueCoef * (double)this.fontSize > (double)TEXT_AS_LINE_PROJ_COEF || !this.zoomSensitive) {
            g.setFont(this.font != null ? this.font : VText.getMainFont());
            AffineTransform at = this.text_anchor == 0 ? AffineTransform.getTranslateInstance(dx + this.pc[i].cx, dy + this.pc[i].cy) : (this.text_anchor == 1 ? AffineTransform.getTranslateInstance((double)(dx + this.pc[i].cx) - this.pc[i].cw * this.coef / 2.0, dy + this.pc[i].cy) : AffineTransform.getTranslateInstance((double)(dx + this.pc[i].cx) - this.pc[i].cw * this.coef, dy + this.pc[i].cy));
            if (this.zoomSensitive) {
                at.concatenate(AffineTransform.getScaleInstance(trueCoef, trueCoef));
            }
            g.setTransform(at);
            int rectH = (int)Math.round(this.pc[i].ch / (double)this.scaleFactor);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                if (this.isBorderDrawn()) {
                    g.setColor(this.borderColor);
                    g.fillRect(dx - this.paddingX, dy - rectH + 1 + 2 * this.paddingY, (int)Math.round(this.pc[i].cw / (double)this.scaleFactor + (double)this.paddingX), rectH - 1 + 2 * this.paddingY);
                }
                g.setColor(this.color);
                g.drawString(this.text, 0.0f, 0.0f);
                g.setComposite(acO);
            } else {
                if (this.isBorderDrawn()) {
                    g.setColor(this.borderColor);
                    g.fillRect(dx - this.paddingX, dy - rectH + 1 + 2 * this.paddingY, (int)Math.round(this.pc[i].cw / (double)this.scaleFactor + (double)this.paddingX), rectH - 1 + 2 * this.paddingY);
                }
                g.setColor(this.color);
                g.drawString(this.text, 0.0f, 0.0f);
            }
            g.setTransform(stdT);
        } else {
            g.setColor(this.color);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
                g.setComposite(acO);
            } else {
                g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
            }
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (!this.pc[i].lvalid || !this.zoomSensitive && this.lcoef != this.oldlcoef) {
            g.setFont(this.font != null ? this.font : VText.getMainFont());
            Rectangle2D bounds = g.getFontMetrics().getStringBounds(this.text, g);
            if (this.zoomSensitive) {
                this.pc[i].lcw = bounds.getWidth() * (double)this.scaleFactor;
                this.pc[i].lch = bounds.getHeight() * (double)this.scaleFactor;
            } else {
                this.pc[i].lcw = bounds.getWidth() * (double)this.scaleFactor / this.coef;
                this.pc[i].lch = bounds.getHeight() * (double)this.scaleFactor / this.coef;
                this.oldlcoef = this.lcoef;
            }
            this.pc[i].lvalid = true;
        }
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        double trueCoef = (double)this.scaleFactor * this.lcoef;
        g.setColor(this.color);
        if (trueCoef * (double)this.fontSize > (double)TEXT_AS_LINE_PROJ_COEF || !this.zoomSensitive) {
            g.setFont(this.font != null ? this.font : VText.getMainFont());
            AffineTransform at = this.text_anchor == 0 ? AffineTransform.getTranslateInstance(dx + this.pc[i].lcx, dy + this.pc[i].lcy) : (this.text_anchor == 1 ? AffineTransform.getTranslateInstance((double)(dx + this.pc[i].lcx) - this.pc[i].lcw * this.lcoef / 2.0, dy + this.pc[i].lcy) : AffineTransform.getTranslateInstance((double)(dx + this.pc[i].lcx) - this.pc[i].lcw * this.lcoef, dy + this.pc[i].lcy));
            if (this.zoomSensitive) {
                at.concatenate(AffineTransform.getScaleInstance(trueCoef, trueCoef));
            }
            g.setTransform(at);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                g.drawString(this.text, 0.0f, 0.0f);
                g.setComposite(acO);
            } else {
                g.drawString(this.text, 0.0f, 0.0f);
            }
            g.setTransform(stdT);
        } else if (this.alphaC != null) {
            g.setComposite(this.alphaC);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
            g.setComposite(acO);
        } else {
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    public void setText(String t) {
        this.text = t;
        VirtualSpaceManager.INSTANCE.repaint();
        this.invalidate();
    }

    public void setScale(float s) {
        this.scaleFactor = s;
        this.invalidate();
    }

    public float getScale() {
        return this.scaleFactor;
    }

    public void invalidate() {
        try {
            for (int i = 0; i < this.pc.length; ++i) {
                this.pc[i].valid = false;
                this.pc[i].lvalid = false;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public Point2D.Double getBounds(int i) {
        return new Point2D.Double(this.pc[i].cw, this.pc[i].ch);
    }

    public boolean validBounds(int i) {
        return this.pc[i].valid;
    }

    public void setFont(Font f) {
        if (f != null) {
            this.font = f;
            this.fontSize = this.font.getSize2D();
        } else {
            this.font = null;
            this.fontSize = VText.getMainFont().getSize2D();
        }
        VirtualSpaceManager.INSTANCE.repaint();
        this.invalidate();
    }

    public Font getFont() {
        if (this.font != null) {
            return this.font;
        }
        return VText.getMainFont();
    }

    public boolean usesSpecificFont() {
        return this.font != null;
    }

    public String getText() {
        return this.text;
    }

    public void setTextAnchor(short ta) {
        this.text_anchor = ta;
    }

    public short getTextAnchor() {
        return this.text_anchor;
    }

    @Override
    public Shape getJava2DShape() {
        return null;
    }

    @Override
    public Object clone() {
        VText<T> res = new VText<T>(this.vx, this.vy, this.vz, this.color, this.borderColor, new StringBuffer(this.text).toString(), this.text_anchor, this.getScale(), this.alphaC != null ? this.alphaC.getAlpha() : 1.0f);
        res.cursorInsideColor = this.cursorInsideColor;
        return res;
    }

    @Override
    public void highlight(boolean b, Color selectedColor) {
        boolean update = false;
        if (b) {
            if (this.cursorInsideFColor != null) {
                this.color = this.cursorInsideFColor;
                update = true;
            }
            if (this.cursorInsideColor != null) {
                this.borderColor = this.cursorInsideColor;
                update = true;
            }
        } else if (this.isSelected() && selectedColor != null) {
            this.borderColor = selectedColor;
            update = true;
        } else {
            if (this.cursorInsideFColor != null) {
                this.color = this.fColor;
                update = true;
            }
            if (this.cursorInsideColor != null) {
                this.borderColor = this.bColor;
                update = true;
            }
        }
        if (update) {
            VirtualSpaceManager.INSTANCE.repaint();
        }
    }

    public void setPadding(int x, int y) {
        this.paddingX = x;
        this.paddingY = y;
    }

    public Point getPadding() {
        return new Point(this.paddingX, this.paddingY);
    }
}

