/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.actions;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.console.ConsoleWriter;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.exceptions.UserException;
import org.eclipse.titan.log.viewer.extractors.ComponentEvent;
import org.eclipse.titan.log.viewer.extractors.ComponentEventDispatcher;
import org.eclipse.titan.log.viewer.extractors.ComponentExtractor;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.utils.LogFileHandler;
import org.eclipse.titan.log.viewer.utils.Messages;

public class ExtractComponentsAction
implements IRunnableWithProgress,
Observer {
    private IFile logFile;
    private ComponentExtractor componentExtractor;
    private LogFileHandler logFileHandler;
    private LogFileMetaData logFileMetaData;
    private IProgressMonitor monitor;
    private int lastWorked;
    private List<String> components;
    private ComponentEventDispatcher componentEventDispatcher;

    public ExtractComponentsAction(IFile logFile) {
        this.logFile = logFile;
        this.componentExtractor = new ComponentExtractor();
        this.componentEventDispatcher = new ComponentEventDispatcher();
        this.componentExtractor.addObserver(this.componentEventDispatcher);
        this.logFileHandler = new LogFileHandler(logFile);
        this.logFileMetaData = null;
        this.lastWorked = 0;
        this.componentEventDispatcher.addObserver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.monitor = monitor;
        this.components = null;
        try {
            this.logFileMetaData = this.logFileHandler.autoDetect();
        }
        catch (TechnicalException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new UserException(e.getMessage()));
            return;
        }
        try {
            if (this.monitor != null) {
                this.monitor.beginTask(Messages.getString("ExtractComponentsAction.0"), 100);
            }
            long start = System.currentTimeMillis();
            this.componentExtractor.extractComponentsFromLogFile(this.logFileMetaData, monitor);
            long stop = System.currentTimeMillis();
            this.components = this.componentExtractor.getComponents();
            int numComp = this.components.size() + 2;
            ConsoleWriter.getInstance().writeToConsole(Messages.getString("ExtractComponentsAction.1") + numComp + Messages.getString("ExtractComponentsAction.4") + this.logFile.getName() + Messages.getString("ExtractComponentsAction.5") + (double)(stop - start) / 1000.0 + Messages.getString("ExtractComponentsAction.2"), this.logFileMetaData.getProjectName());
            ConsoleWriter.getInstance().writeToConsole("", this.logFileMetaData.getProjectName());
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            String errorMsg = Messages.getString("ExtractComponentsAction.3") + this.logFile.getName() + "Reason: " + e.getMessage();
            TitanLogExceptionHandler.handleException(new TechnicalException(errorMsg));
        }
        finally {
            this.componentEventDispatcher.deleteObserver(this);
            this.componentExtractor.deleteObserver(this.componentEventDispatcher);
            if (this.monitor != null) {
                this.monitor.done();
            }
        }
    }

    @Override
    public void update(Observable observable, Object event) {
        if (event instanceof ComponentEvent) {
            ComponentEvent componentEvent = (ComponentEvent)event;
            if (this.monitor != null) {
                this.monitor.subTask(componentEvent.getCompName());
            }
            int worked = componentEvent.getProgress();
            if (this.monitor != null) {
                this.monitor.worked(worked - this.lastWorked);
            }
            this.lastWorked = worked;
        }
    }

    public List<String> getComponents() {
        return this.components;
    }
}

