/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.actions.ExtractComponentsAction;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.preferences.PreferencesHandler;
import org.eclipse.titan.log.viewer.preferences.PreferencesHolder;
import org.eclipse.titan.log.viewer.preferences.pages.ComponentsVisualOrderPrefPage;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.titan.log.viewer.utils.ResourcePropertyHandler;
import org.eclipse.titan.log.viewer.utils.SelectionUtils;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExtractComponentsMenuAction
extends AbstractHandler
implements IActionDelegate {
    private ISelection selection;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        this.run(this.selection);
        return null;
    }

    public void run(IAction action) {
        this.run(this.selection);
    }

    public void run(ISelection selection) {
        List<String> components = null;
        if (selection == null) {
            return;
        }
        if (!SelectionUtils.isSelectionALogFile(selection)) {
            return;
        }
        IFile logFile = SelectionUtils.selectionToIFile(selection);
        if (logFile == null) {
            return;
        }
        try {
            ExtractComponentsAction extractCompAction = new ExtractComponentsAction(logFile);
            new ProgressMonitorDialog(null).run(false, false, (IRunnableWithProgress)extractCompAction);
            components = extractCompAction.getComponents();
        }
        catch (InvocationTargetException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("ExtractComponentsMenuAction.0") + e.getTargetException().getMessage()));
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("ExtractComponentsMenuAction.1") + e.getMessage()));
        }
        String projectName = logFile.getProject().getName();
        PreferencesHolder preferences = PreferencesHandler.getInstance().getPreferences(projectName);
        this.setNewProperties(components, logFile, preferences);
    }

    private void setNewProperties(List<String> components, IFile logFile, PreferencesHolder preferences) {
        if (components == null) {
            return;
        }
        if (!preferences.getReplaceCompVisOrder()) {
            List<String> compVisOrder = preferences.getVisualOrderComponents();
            for (String currComponent : components) {
                if (compVisOrder.contains(currComponent)) continue;
                compVisOrder.add(currComponent);
            }
            components = compVisOrder;
        } else {
            components.add(0, "System Under Test");
            components.add(0, "Main Test Component");
        }
        if (preferences.getOpenPropAfterCompExt()) {
            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn(null, (IAdaptable)logFile.getProject(), (String)"org.eclipse.titan.log.viewer.properties.CompVisOrderPage", null, null);
            Object currentPage = dialog.getSelectedPage();
            if (currentPage instanceof ComponentsVisualOrderPrefPage) {
                ComponentsVisualOrderPrefPage componentsVisualOrderPrefPage = (ComponentsVisualOrderPrefPage)((Object)currentPage);
                componentsVisualOrderPrefPage.setUseProjectSetting(true);
                componentsVisualOrderPrefPage.clearList();
                for (String component : components) {
                    componentsVisualOrderPrefPage.addComponent(component);
                }
                dialog.open();
            }
        } else {
            StringBuilder path = new StringBuilder("");
            for (String currComponent : components) {
                path.append(currComponent);
                path.append(File.pathSeparator);
            }
            try {
                ResourcePropertyHandler.setProperty((IResource)logFile.getProject(), "org.eclipse.titan.log.viewer.properties.CompVisOrderPage", "useProjectSettings", "true");
                ResourcePropertyHandler.setProperty((IResource)logFile.getProject(), "org.eclipse.titan.log.viewer.properties.CompVisOrderPage", "org.eclipse.titan.log.viewer_component_order_id", path.toString());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            this.setEnabled(false);
            return;
        }
        this.selection = (IStructuredSelection)selection;
        this.setEnabled(SelectionUtils.isSelectionALogFile(this.selection));
    }
}

