/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.parsers;

import java.io.Closeable;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.factories.MessageAnalyserFactory;
import org.eclipse.titan.log.viewer.models.FilterPattern;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.models.LogRecordIndex;
import org.eclipse.titan.log.viewer.parsers.ConnectedRecord;
import org.eclipse.titan.log.viewer.parsers.Decipherer;
import org.eclipse.titan.log.viewer.parsers.EventObjectFactory;
import org.eclipse.titan.log.viewer.parsers.MessageAnalyser;
import org.eclipse.titan.log.viewer.parsers.data.LogRecord;
import org.eclipse.titan.log.viewer.parsers.data.TestCase;
import org.eclipse.titan.log.viewer.preferences.PreferencesHandler;
import org.eclipse.titan.log.viewer.preferences.PreferencesHolder;
import org.eclipse.titan.log.viewer.readers.TestFileReader;
import org.eclipse.titan.log.viewer.views.msc.model.EventObject;
import org.eclipse.titan.log.viewer.views.msc.model.EventType;
import org.eclipse.titan.log.viewer.views.msc.model.ExecutionModel;
import org.eclipse.titan.log.viewer.views.msc.model.TestComponent;

public class Parser {
    private static final String MAPPING = "Mapping";
    private static final String UNMAPPING = "Unmapping";
    private static final String DISCONNECTING = "Disconnecting";
    private static final String CONNECTING = "Connecting";
    private int tcRecords = 0;
    private int ptcs = 0;
    private int sends = 0;
    private int recs = 0;
    private int maps = 0;
    private int cons = 0;
    private int enqs = 0;
    private long start = 0L;
    private long end = 0L;
    private final LogFileMetaData logFileMetaData;
    private LogRecordIndex[] logRecordIndexes;
    private ExecutionModel executionModel;
    private MessageAnalyser messageAnalyser;
    private final Decipherer decipherer = new Decipherer();
    private boolean mtcTerminated = false;
    private Set<String> currentlyLivingComponents;
    private Map<String, TestComponent> components;
    private List<Integer> setverdictVector = new ArrayList<Integer>();
    private List<ConnectedRecord> errorVector = new ArrayList<ConnectedRecord>();
    private List<ConnectedRecord> failVector = new ArrayList<ConnectedRecord>();
    private boolean displaySetverdictError;
    private boolean displaySetverdictFail;
    private boolean displaySetverdictInconc;
    private boolean displaySetverdictNone;
    private boolean displaySetverdictPass;
    private boolean filterConnectingPorts;
    private boolean filterMappingPorts;
    private Map<String, Boolean> filteredSilentEvents;
    private boolean wasCanceled = false;
    private List<Integer> eventVector = new ArrayList<Integer>();
    private EventObjectFactory eventObjectFactory = new EventObjectFactory();

    public Parser(LogFileMetaData logFileMetaData) {
        this.logFileMetaData = logFileMetaData;
    }

    public int getCons() {
        return this.cons;
    }

    public int getTestCaseRecords() {
        return this.tcRecords;
    }

    public int getMaps() {
        return this.maps;
    }

    public int getPtcs() {
        return this.ptcs;
    }

    public int getRecs() {
        return this.recs;
    }

    public int getSends() {
        return this.sends;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public long getEnd() {
        return this.end;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public int getEnqs() {
        return this.enqs;
    }

    public boolean wasCanceled() {
        return this.wasCanceled;
    }

    public int getNumberOfEvents() {
        return this.eventVector.size();
    }

    public boolean getMTCTerminated() {
        return this.mtcTerminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExecutionModel preParse(TestCase testCase, LogRecordIndex[] logRecordIndexes, PreferencesHolder preferences, FilterPattern filterPattern, IProgressMonitor monitor) throws IOException, ParseException, TechnicalException {
        IProgressMonitor internalMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.wasCanceled = false;
        this.logRecordIndexes = logRecordIndexes;
        this.executionModel = new ExecutionModel(this);
        this.executionModel.setFilterPattern(filterPattern);
        this.executionModel.addIgnoredComponent(preferences.getIgnoredComponents());
        this.executionModel.setSutName(preferences.getSutName());
        this.executionModel.addIgnoredSignals(preferences.getIgnoredSignals());
        this.executionModel.addIgnoredFunctions(preferences.getIgnoredFunctions());
        this.executionModel.setContainedTestCase(testCase);
        this.executionModel.getTestCase().setTestCaseName(testCase.getTestCaseName());
        this.executionModel.getTestCase().setVerdict(testCase.getVerdict());
        EventObject sut = this.createEventObject(null, EventType.SYSTEM_CREATE);
        sut.setName(preferences.getSutName());
        sut.setEventNumber(0);
        this.executionModel.addComponent(sut);
        this.executionModel.addLifeLineInfo(sut);
        EventObject hc = this.createEventObject(null, EventType.HC_CREATE);
        hc.setEventNumber(1);
        this.executionModel.addComponent(hc);
        this.executionModel.addLifeLineInfo(hc);
        EventObject mtc = this.createEventObject(null, EventType.MTC_CREATE);
        mtc.setEventNumber(2);
        this.executionModel.addComponent(mtc);
        this.executionModel.addLifeLineInfo(mtc);
        this.components = this.executionModel.getComponents();
        this.messageAnalyser = MessageAnalyserFactory.createMessageAnalyser(this.logFileMetaData);
        this.setUpFromPreferences(preferences, filterPattern);
        this.tcRecords = logRecordIndexes.length;
        TestFileReader reader = null;
        try {
            reader = new TestFileReader(this.logFileMetaData.getFilePath(), logRecordIndexes);
            this.eventVector = new ArrayList<Integer>();
            internalMonitor.beginTask("Loading...", reader.size());
            this.currentlyLivingComponents = new HashSet<String>();
            while (reader.hasNextRecord() && !internalMonitor.isCanceled()) {
                try {
                    LogRecord logRecord = reader.getNextRecord();
                    logRecord.setRecordNumber(testCase.getStartRecordNumber() + logRecord.getRecordNumber());
                    this.preParseLogRecord(logRecord, this.currentlyLivingComponents);
                    internalMonitor.worked(1);
                }
                catch (ParseException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                    ParseException throwable = new ParseException(e.getMessage(), 0);
                    throwable.initCause(e);
                    throw throwable;
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)reader);
        this.currentlyLivingComponents.remove("mtc");
        this.currentlyLivingComponents.remove("hc");
        this.currentlyLivingComponents.remove("system");
        int additionalIndex = 3;
        for (String compRef : this.currentlyLivingComponents) {
            EventObject event = new EventObject(EventType.PTC_TERMINATE);
            event.setEventNumber(this.eventVector.size() + additionalIndex);
            ++additionalIndex;
            event.setReference(compRef);
            event.setName(compRef);
            this.executionModel.addLifeLineInfo(event);
        }
        this.wasCanceled = internalMonitor.isCanceled();
        internalMonitor.done();
        if (!this.mtcTerminated) {
            mtc = this.eventObjectFactory.createEventObject(EventType.MTC_TERMINATE, null, this.messageAnalyser, this.logFileMetaData.getTimeStampConstant());
            mtc.setEventNumber(this.eventVector.size() + additionalIndex);
            ++additionalIndex;
            this.executionModel.addLifeLineInfo(mtc);
        }
        hc = this.eventObjectFactory.createEventObject(EventType.HC_TERMINATE, null, this.messageAnalyser, this.logFileMetaData.getTimeStampConstant());
        hc.setEventNumber(this.eventVector.size() + additionalIndex);
        this.executionModel.addLifeLineInfo(hc);
        sut = this.eventObjectFactory.createEventObject(EventType.SYSTEM_TERMINATE, null, this.messageAnalyser, this.logFileMetaData.getTimeStampConstant());
        sut.setEventNumber(this.eventVector.size() + ++additionalIndex);
        this.executionModel.addLifeLineInfo(sut);
        this.setVerdict();
        return this.executionModel;
    }

    private void setVerdict() {
        int[] setverdictArray = new int[this.setverdictVector.size()];
        for (int i = 0; i < this.setverdictVector.size(); ++i) {
            int verdictPlace;
            setverdictArray[i] = verdictPlace = this.setverdictVector.get(i).intValue();
        }
        this.executionModel.setSetverdict(setverdictArray);
    }

    private void setUpFromPreferences(PreferencesHolder preferences, FilterPattern filterPattern) {
        this.messageAnalyser.setErrorCausedBy(preferences.getErrorCausedBy());
        this.messageAnalyser.setFailCausedBy(preferences.getFailCausedBy());
        if (filterPattern == null) {
            this.displaySetverdictError = preferences.getSetverdictError();
            this.displaySetverdictFail = preferences.getSetverdictFail();
            this.displaySetverdictInconc = preferences.getSetverdictInconc();
            this.displaySetverdictNone = preferences.getSetverdictNone();
            this.displaySetverdictPass = preferences.getSetverdictPass();
            this.filterConnectingPorts = preferences.getFilteredConnectingPorts();
            this.filterMappingPorts = preferences.getFilteredMappingPorts();
            this.filteredSilentEvents = preferences.getFilteredSilentEvents();
        } else {
            this.displaySetverdictError = true;
            this.displaySetverdictFail = true;
            this.displaySetverdictInconc = true;
            this.displaySetverdictNone = true;
            this.displaySetverdictPass = true;
            this.filterConnectingPorts = false;
            this.filterMappingPorts = false;
            this.filteredSilentEvents = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventObject> parseRegion(int startIndex, int endIndex, IProgressMonitor monitor) throws IOException, ParseException {
        IProgressMonitor internalMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        TestFileReader reader = null;
        this.wasCanceled = false;
        ArrayList<EventObject> result = new ArrayList<EventObject>(endIndex - startIndex + 6 + 1);
        PreferencesHolder preferences = PreferencesHandler.getInstance().getPreferences(this.logFileMetaData.getProjectName());
        TestCase testCase = this.executionModel.getTestCase();
        EventObject sut = this.createEventObject(null, EventType.SYSTEM_CREATE);
        sut.setName(preferences.getSutName());
        result.add(sut);
        EventObject hc = this.createEventObject(null, EventType.HC_CREATE);
        result.add(hc);
        EventObject mtc = this.createEventObject(null, EventType.MTC_CREATE);
        result.add(mtc);
        this.tcRecords = this.logRecordIndexes.length;
        try {
            reader = new TestFileReader(this.logFileMetaData.getFilePath(), this.logRecordIndexes);
            internalMonitor.beginTask("Loading...", reader.size());
            for (int i = startIndex; i <= endIndex && i < this.eventVector.size() && !internalMonitor.isCanceled(); ++i) {
                try {
                    int actualIndex = this.eventVector.get(i) - testCase.getStartRecordNumber();
                    reader.setCurrentLogRecord(actualIndex);
                    LogRecord logRecord = reader.getNextRecord();
                    logRecord.setRecordNumber(testCase.getStartRecordNumber() + logRecord.getRecordNumber());
                    EventObject event = this.parseLogRecord(logRecord, i);
                    if (event != null) {
                        result.add(event);
                    }
                    internalMonitor.worked(1);
                    continue;
                }
                catch (ParseException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                    ParseException throwable = new ParseException(e.getMessage(), 0);
                    throwable.initCause(e);
                    throw throwable;
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)reader);
        this.wasCanceled = internalMonitor.isCanceled();
        internalMonitor.done();
        for (String compRef : this.currentlyLivingComponents) {
            EventObject event = new EventObject(EventType.PTC_TERMINATE);
            event.setReference(compRef);
            event.setName(compRef);
            result.add(event);
        }
        if (!this.mtcTerminated) {
            mtc = this.eventObjectFactory.createEventObject(EventType.MTC_TERMINATE, null, this.messageAnalyser, this.logFileMetaData.getTimeStampConstant());
            result.add(mtc);
        }
        hc = this.eventObjectFactory.createEventObject(EventType.HC_TERMINATE, null, this.messageAnalyser, this.logFileMetaData.getTimeStampConstant());
        result.add(hc);
        sut = this.eventObjectFactory.createEventObject(EventType.SYSTEM_TERMINATE, null, this.messageAnalyser, this.logFileMetaData.getTimeStampConstant());
        result.add(sut);
        return result;
    }

    private void preParseLogRecord(LogRecord logRecord, Set<String> currentlyLivingComponents) {
        ConnectedRecord connectedRecord;
        EventObject event;
        String receiveType;
        String message = logRecord.getMessage();
        this.messageAnalyser.setMessage(message);
        boolean isLogRecordIgnored = false;
        if (this.executionModel.getFilterPattern() != null) {
            boolean bl = isLogRecordIgnored = !this.executionModel.getFilterPattern().match(logRecord);
        }
        if (this.messageAnalyser.isSend()) {
            Set<String> sources;
            String logComponentRef;
            String source;
            String sendTarget;
            TestComponent tc;
            String sendType = this.messageAnalyser.getSendType();
            if (!(isLogRecordIgnored || this.isSignalIgnored(sendType) || this.components == null || (tc = this.components.get(sendTarget = this.messageAnalyser.getSendTarget())) == null || (source = this.getSource(logComponentRef = logRecord.getComponentReference(), sources = tc.getMappedFromReference(this.messageAnalyser.getSendSource()))) == null || this.isComponentIgnored(source))) {
                ++this.sends;
                this.eventVector.add(logRecord.getRecordNumber());
            }
        } else if (this.messageAnalyser.isReceive()) {
            String sourceRef;
            TestComponent tc;
            receiveType = this.messageAnalyser.getReceiveType();
            if (!isLogRecordIgnored && !this.isSignalIgnored(receiveType) && this.components != null && (tc = this.components.get(sourceRef = this.messageAnalyser.getReceiveSource())) != null) {
                Set<String> targetRefs;
                String receiveTargetPort = this.messageAnalyser.getReceiveTarget();
                String logComponentRef = logRecord.getComponentReference();
                String targetRef = this.getTargetRef(logComponentRef, targetRefs = tc.getMappedFromReference(receiveTargetPort));
                if (targetRef != null && !this.isComponentIgnored(targetRef)) {
                    ++this.recs;
                    this.eventVector.add(logRecord.getRecordNumber());
                }
            }
        } else if (this.messageAnalyser.isEnqueued()) {
            String sourceRef;
            TestComponent tc;
            receiveType = this.messageAnalyser.getReceiveType();
            if (!isLogRecordIgnored && !this.isSignalIgnored(receiveType) && this.components != null && (tc = this.components.get(sourceRef = this.messageAnalyser.getReceiveSource())) != null) {
                Set<String> targetRefs;
                String enqueuedTargetPort = this.messageAnalyser.getEnqueuedTarget();
                String logComponentRef = logRecord.getComponentReference();
                String targetRef = this.getTargetRef(logComponentRef, targetRefs = tc.getMappedFromReference(enqueuedTargetPort));
                if (targetRef != null && !this.isComponentIgnored(targetRef)) {
                    ++this.enqs;
                    this.eventVector.add(logRecord.getRecordNumber());
                }
            }
        } else if (this.messageAnalyser.isReceiveOperation()) {
            String sourceRef;
            TestComponent tc;
            String recieveType = this.messageAnalyser.getReceiveOperationType();
            if (!isLogRecordIgnored && !this.isSignalIgnored(recieveType) && this.components != null && (tc = this.components.get(sourceRef = this.messageAnalyser.getReceiveSource())) != null) {
                Set<String> targetRefs;
                String receiveTargetPort = this.messageAnalyser.getReceiveOperationTarget();
                String logComponentRef = logRecord.getComponentReference();
                String targetRef = this.getTargetRef(logComponentRef, targetRefs = tc.getMappedFromReference(receiveTargetPort));
                if (targetRef != null && !this.isComponentIgnored(targetRef)) {
                    ++this.recs;
                    this.eventVector.add(logRecord.getRecordNumber());
                }
            }
        } else if (this.messageAnalyser.isStartFunction()) {
            String targetRef;
            if (!(this.components == null || (targetRef = this.messageAnalyser.getStartFunctionReference()) == null || isLogRecordIgnored || this.isComponentIgnored(targetRef) || this.isFunctionIgnored(this.messageAnalyser.getStartFunctionName()))) {
                this.eventVector.add(logRecord.getRecordNumber());
            }
        } else if (this.messageAnalyser.isComponentCreation()) {
            if (this.components != null) {
                event = this.createEventObject(logRecord, EventType.PTC_CREATE);
                event.setEventNumber(this.eventVector.size() + 3);
                String reference = event.getReference();
                currentlyLivingComponents.add(reference);
                TestComponent tc = this.components.get(reference);
                if (tc == null) {
                    this.addComponent(event);
                    if (reference != null && !this.isComponentIgnored(reference)) {
                        ++this.ptcs;
                        this.eventVector.add(logRecord.getRecordNumber());
                        this.executionModel.addLifeLineInfo(event);
                    }
                } else if (!this.isComponentIgnored(reference)) {
                    logRecord.setComponentReference("mtc");
                    this.eventVector.add(logRecord.getRecordNumber());
                    this.executionModel.addLifeLineInfo(event);
                }
            }
        } else if (this.messageAnalyser.isComponentDone()) {
            event = this.createEventObject(logRecord, EventType.PTC_DONE);
            String reference = event.getReference();
            if (reference != null && !this.isComponentIgnored(reference)) {
                this.eventVector.add(logRecord.getRecordNumber());
            }
        } else if (this.messageAnalyser.isComponentTermination()) {
            if (this.components != null) {
                String ref = this.messageAnalyser.getComponentTerminationReference();
                currentlyLivingComponents.remove(ref);
                if (ref != null && !this.isComponentIgnored(ref)) {
                    String terminationVerdict = this.messageAnalyser.getComponentTerminationVerdict();
                    TestComponent component = this.components.get(ref);
                    if (component != null) {
                        component.setVerdict(terminationVerdict);
                    }
                    EventObject event2 = this.createEventObject(logRecord, EventType.PTC_TERMINATE);
                    event2.setEventNumber(this.eventVector.size() + 3);
                    event2.setReference(ref);
                    this.eventVector.add(logRecord.getRecordNumber());
                    this.executionModel.addLifeLineInfo(event2);
                }
            }
        } else if (this.messageAnalyser.isPortMapping()) {
            String mappingSource = this.messageAnalyser.getPortMappingSource();
            String compRef = this.messageAnalyser.getComponentRef(mappingSource);
            String target = this.messageAnalyser.getPortMappingTarget();
            String targetRef = this.messageAnalyser.getComponentRef(target);
            String sourcePort = this.messageAnalyser.getPort(mappingSource);
            String targetPort = this.messageAnalyser.getPort(target);
            if (!(this.filterMappingPorts || isLogRecordIgnored || this.isComponentIgnored(compRef) || this.isComponentIgnored(targetRef))) {
                logRecord.setComponentReference(compRef);
                this.eventVector.add(logRecord.getRecordNumber());
                ++this.maps;
            }
            this.addPortMapping(compRef, sourcePort, targetRef, targetPort);
        } else if (this.messageAnalyser.isPortUnmapping()) {
            String unmappingSource = this.messageAnalyser.getPortUnMapping();
            String compRef = this.messageAnalyser.getComponentRef(unmappingSource);
            compRef = this.messageAnalyser.getComponentRef(compRef);
            String target = this.messageAnalyser.getPortUnMappingTarget();
            String targetRef = this.messageAnalyser.getComponentRef(target);
            if (!(this.filterMappingPorts || isLogRecordIgnored || this.isComponentIgnored(compRef) || this.isComponentIgnored(targetRef))) {
                logRecord.setComponentReference(compRef);
                this.eventVector.add(logRecord.getRecordNumber());
                ++this.maps;
            }
        } else if (this.messageAnalyser.isPortConnection()) {
            String connectionSource = this.messageAnalyser.getPortConnectionSource();
            String compRef = this.messageAnalyser.getComponentRef(connectionSource);
            String target = this.messageAnalyser.getPortConnectionTarget();
            String targetRef = this.messageAnalyser.getComponentRef(target);
            String sourcePort = this.messageAnalyser.getPort(connectionSource);
            String targetPort = this.messageAnalyser.getPort(target);
            if (!(this.filterConnectingPorts || isLogRecordIgnored || this.isComponentIgnored(compRef) || this.isComponentIgnored(targetRef))) {
                logRecord.setComponentReference(compRef);
                this.eventVector.add(logRecord.getRecordNumber());
                ++this.cons;
            }
            this.addPortMapping(compRef, sourcePort, targetRef, targetPort);
        } else if (this.messageAnalyser.isPortDisconnection()) {
            String disconnectionSource = this.messageAnalyser.getPortDisconnectionSource();
            String compRef = this.messageAnalyser.getComponentRef(disconnectionSource);
            String target = this.messageAnalyser.getPortConnectionTarget();
            String targetRef = this.messageAnalyser.getComponentRef(target);
            if (!(this.filterConnectingPorts || isLogRecordIgnored || this.isComponentIgnored(compRef) || this.isComponentIgnored(targetRef))) {
                logRecord.setComponentReference(compRef);
                this.eventVector.add(logRecord.getRecordNumber());
                ++this.cons;
            }
        } else if (this.messageAnalyser.isTestcaseStart()) {
            this.eventVector.add(logRecord.getRecordNumber());
        } else if (this.messageAnalyser.isTestcaseEnd()) {
            this.eventVector.add(logRecord.getRecordNumber());
            this.notifyChange();
        } else if (this.messageAnalyser.isMTCCreation()) {
            event = this.createEventObject(logRecord, EventType.MTC_CREATE);
            this.addComponent(event);
            this.eventVector.add(logRecord.getRecordNumber());
        } else if (this.messageAnalyser.isMTCTermination()) {
            this.eventVector.add(logRecord.getRecordNumber());
            this.mtcTerminated = true;
        } else if (this.messageAnalyser.isMTCDone()) {
            this.eventVector.add(logRecord.getRecordNumber());
        } else if (this.messageAnalyser.isSetverdict()) {
            if (logRecord.getComponentReference() != null && !isLogRecordIgnored && !this.isComponentIgnored(logRecord.getComponentReference())) {
                String setverdicttype = this.messageAnalyser.getSetverdictType();
                if ("inconc".equals(setverdicttype) && this.displaySetverdictInconc) {
                    this.setverdictVector.add(this.eventVector.size());
                    this.eventVector.add(logRecord.getRecordNumber());
                } else if ("error".equals(setverdicttype) && this.displaySetverdictError) {
                    this.setverdictVector.add(this.eventVector.size());
                    this.eventVector.add(logRecord.getRecordNumber());
                } else if ("fail".equals(setverdicttype) && this.displaySetverdictFail) {
                    this.setverdictVector.add(this.eventVector.size());
                    this.eventVector.add(logRecord.getRecordNumber());
                } else if ("none".equals(setverdicttype) && this.displaySetverdictNone) {
                    this.setverdictVector.add(this.eventVector.size());
                    this.eventVector.add(logRecord.getRecordNumber());
                } else if ("pass".equals(setverdicttype) && this.displaySetverdictPass) {
                    this.setverdictVector.add(this.eventVector.size());
                    this.eventVector.add(logRecord.getRecordNumber());
                }
                this.errorVector.clear();
                this.failVector.clear();
            }
        } else {
            Boolean filtered = this.isEventIgnored(logRecord.getEventType());
            String compRef = logRecord.getComponentReference();
            if (compRef == null || compRef.length() == 0) {
                compRef = this.messageAnalyser.isSilentEvent();
            }
            if (compRef != null && compRef.length() > 0 && !this.isComponentIgnored(logRecord.getComponentReference())) {
                this.addDummyComponent(compRef);
                currentlyLivingComponents.add(compRef);
            }
            boolean bl = isLogRecordIgnored = isLogRecordIgnored || this.isComponentIgnored(logRecord.getComponentReference());
            if (!filtered.booleanValue() && !isLogRecordIgnored) {
                this.eventVector.add(logRecord.getRecordNumber());
            }
        }
        if (this.messageAnalyser.isDynamicTestCaseError()) {
            connectedRecord = new ConnectedRecord(logRecord.getRecordOffset(), logRecord.getRecordLength(), logRecord.getRecordNumber());
            this.errorVector.add(connectedRecord);
        }
        if (this.messageAnalyser.isFailMessages()) {
            connectedRecord = new ConnectedRecord(logRecord.getRecordOffset(), logRecord.getRecordLength(), logRecord.getRecordNumber());
            this.failVector.add(connectedRecord);
        }
    }

    private String getSource(String logComponentRef, Set<String> sources) {
        String source = null;
        if (sources != null) {
            Iterator<String> iterator = sources.iterator();
            while (iterator.hasNext()) {
                String source1;
                source = source1 = iterator.next();
                if (logComponentRef == null || !logComponentRef.equals(source)) continue;
                break;
            }
        }
        return source;
    }

    private String getTargetRef(String logComponentRef, Set<String> targetRefs) {
        String targetRef = null;
        if (targetRefs != null) {
            Iterator<String> iterator = targetRefs.iterator();
            while (iterator.hasNext()) {
                String targetRef1;
                targetRef = targetRef1 = iterator.next();
                if (logComponentRef == null || !logComponentRef.equals(targetRef)) continue;
                break;
            }
        }
        return targetRef;
    }

    private void addDummyComponent(String compRef) {
        if (this.components.get(compRef) != null) {
            return;
        }
        EventObject object = new EventObject(EventType.PTC_CREATE);
        object.setReference(compRef);
        object.setName(compRef);
        object.setRecordNumber(0);
        object.setEventNumber(0);
        this.addComponent(object);
        this.executionModel.addLifeLineInfo(object);
        ++this.ptcs;
    }

    private EventObject parseLogRecord(LogRecord logRecord, int eventIndex) {
        ConnectedRecord connectedRecord;
        EventObject event;
        String recieveType;
        String message = logRecord.getMessage();
        this.messageAnalyser.setMessage(message);
        boolean isLogRecordIgnored = false;
        if (this.executionModel.getFilterPattern() != null) {
            boolean bl = isLogRecordIgnored = !this.executionModel.getFilterPattern().match(logRecord);
        }
        if (this.messageAnalyser.isSend()) {
            Set<String> sources;
            String logComponentRef;
            String source;
            String sendTarget;
            TestComponent tc;
            String sendType = this.messageAnalyser.getSendType();
            if (!this.isSignalIgnored(sendType) && this.components != null && (tc = this.components.get(sendTarget = this.messageAnalyser.getSendTarget())) != null && (source = this.getSource(logComponentRef = logRecord.getComponentReference(), sources = tc.getMappedFromReference(this.messageAnalyser.getSendSource()))) != null && !this.isComponentIgnored(source)) {
                ++this.sends;
                EventObject event2 = this.createEventObject(logRecord, EventType.SEND);
                String deciphered = this.decipherer.decipher(sendType.trim(), this.messageAnalyser.getSendValue());
                if (deciphered != null) {
                    event2.setName(deciphered);
                } else {
                    event2.setName(sendType);
                }
                event2.setReference(source);
                event2.setTarget(sendTarget);
                if (tc.getAlternative() != null) {
                    event2.setTarget(tc.getAlternative());
                }
                return event2;
            }
        } else if (this.messageAnalyser.isReceive()) {
            String sourceRef;
            TestComponent tc;
            recieveType = this.messageAnalyser.getReceiveType();
            if (!this.isSignalIgnored(recieveType) && !isLogRecordIgnored && this.components != null && (tc = this.components.get(sourceRef = this.messageAnalyser.getReceiveSource())) != null) {
                Set<String> targetRefs;
                String recieveTargetPort = this.messageAnalyser.getReceiveTarget();
                String logComponentRef = logRecord.getComponentReference();
                String targetRef = this.getTargetRef(logComponentRef, targetRefs = tc.getMappedFromReference(recieveTargetPort));
                if (targetRef != null && !this.isComponentIgnored(targetRef)) {
                    return this.handleReceive(logRecord, recieveType, sourceRef, tc, recieveTargetPort, targetRef);
                }
            }
        } else if (this.messageAnalyser.isEnqueued()) {
            String sourceRef;
            TestComponent tc;
            recieveType = this.messageAnalyser.getReceiveType();
            if (!this.isSignalIgnored(recieveType) && !isLogRecordIgnored && this.components != null && (tc = this.components.get(sourceRef = this.messageAnalyser.getReceiveSource())) != null) {
                Set<String> targetRefs;
                String enqueuedTargetPort = this.messageAnalyser.getEnqueuedTarget();
                String logComponentRef = logRecord.getComponentReference();
                String targetRef = this.getTargetRef(logComponentRef, targetRefs = tc.getMappedFromReference(enqueuedTargetPort));
                if (targetRef != null && !this.isComponentIgnored(targetRef)) {
                    ++this.enqs;
                    EventObject event3 = this.createEventObject(logRecord, EventType.ENQUEUED);
                    String msg = this.messageAnalyser.getReceiveValue();
                    String deciphered = this.decipherer.decipher(recieveType, msg);
                    if (deciphered != null) {
                        event3.setName(deciphered);
                    } else {
                        event3.setName(recieveType);
                    }
                    event3.setReference(sourceRef);
                    event3.setTarget(targetRef);
                    event3.setPort(enqueuedTargetPort);
                    if (tc.getAlternative() != null) {
                        event3.setReference(tc.getAlternative());
                    }
                    return event3;
                }
            }
        } else if (this.messageAnalyser.isReceiveOperation()) {
            String sourceRef;
            TestComponent tc;
            recieveType = this.messageAnalyser.getReceiveOperationType();
            if (!this.isSignalIgnored(recieveType) && this.components != null && (tc = this.components.get(sourceRef = this.messageAnalyser.getReceiveSource())) != null) {
                Set<String> targetRefs;
                String receiveTargetPort = this.messageAnalyser.getReceiveOperationTarget();
                String logComponentRef = logRecord.getComponentReference();
                String targetRef = this.getTargetRef(logComponentRef, targetRefs = tc.getMappedFromReference(receiveTargetPort));
                if (targetRef != null && !this.isComponentIgnored(targetRef)) {
                    return this.handleReceive(logRecord, recieveType, sourceRef, tc, receiveTargetPort, targetRef);
                }
            }
        } else if (this.messageAnalyser.isStartFunction()) {
            String targetRef;
            if (this.components != null && (targetRef = this.messageAnalyser.getStartFunctionReference()) != null && !this.isComponentIgnored(targetRef) && !this.isFunctionIgnored(this.messageAnalyser.getStartFunctionName())) {
                EventObject event4 = this.createEventObject(logRecord, EventType.FUNCTION);
                event4.setName(this.messageAnalyser.getStartFunctionName());
                event4.setReference("mtc");
                event4.setTarget(targetRef);
                return event4;
            }
        } else if (this.messageAnalyser.isComponentCreation()) {
            if (this.components != null) {
                event = this.createEventObject(logRecord, EventType.PTC_CREATE);
                String reference = event.getReference();
                TestComponent tc = this.components.get(reference);
                if (tc == null || tc.getRecordNumber() == logRecord.getRecordNumber()) {
                    if (reference != null && !this.isComponentIgnored(reference)) {
                        return event;
                    }
                } else if (!this.isComponentIgnored(reference)) {
                    logRecord.setComponentReference(reference);
                    event = this.eventObjectFactory.createEventObject(EventType.SILENT_EVENT, logRecord, this.messageAnalyser, this.logFileMetaData.getTimeStampConstant());
                    return event;
                }
            }
        } else if (this.messageAnalyser.isComponentDone()) {
            event = this.createEventObject(logRecord, EventType.PTC_DONE);
            String reference = event.getReference();
            if (reference != null && !this.isComponentIgnored(reference)) {
                return event;
            }
        } else if (this.messageAnalyser.isComponentTermination()) {
            String ref;
            if (this.components != null && (ref = this.messageAnalyser.getComponentTerminationReference()) != null && !this.isComponentIgnored(ref)) {
                String terminationVerdict = this.messageAnalyser.getComponentTerminationVerdict();
                TestComponent component = this.components.get(ref);
                if (component != null) {
                    component.setVerdict(terminationVerdict);
                }
                EventObject event5 = this.createEventObject(logRecord, EventType.PTC_TERMINATE);
                event5.setReference(ref);
                event5.setName(terminationVerdict);
                return event5;
            }
        } else if (this.messageAnalyser.isPortMapping()) {
            String mappingSource = this.messageAnalyser.getPortMappingSource();
            String compRef = this.messageAnalyser.getComponentRef(mappingSource);
            String target = this.messageAnalyser.getPortMappingTarget();
            String targetRef = this.messageAnalyser.getComponentRef(target);
            String sourcePort = this.messageAnalyser.getPort(mappingSource);
            String targetPort = this.messageAnalyser.getPort(target);
            if (!(this.filterMappingPorts || this.isComponentIgnored(compRef) || this.isComponentIgnored(targetRef))) {
                logRecord.setComponentReference(compRef);
                EventObject event6 = this.createEventObject(logRecord, EventType.MAPPING_PORT);
                event6.setPort(sourcePort);
                event6.setTargetPort(targetPort);
                event6.setTarget(targetRef);
                event6.setName(MAPPING);
                return event6;
            }
            this.addPortMapping(compRef, sourcePort, targetRef, targetPort);
        } else if (this.messageAnalyser.isPortUnmapping()) {
            String unmappingSource = this.messageAnalyser.getPortUnMapping();
            String compRef = this.messageAnalyser.getComponentRef(unmappingSource);
            compRef = this.messageAnalyser.getComponentRef(compRef);
            String target = this.messageAnalyser.getPortUnMappingTarget();
            String targetRef = this.messageAnalyser.getComponentRef(target);
            String sourcePort = this.messageAnalyser.getPort(unmappingSource);
            String targetPort = this.messageAnalyser.getPort(target);
            if (!(this.filterMappingPorts || this.isComponentIgnored(compRef) || this.isComponentIgnored(targetRef))) {
                logRecord.setComponentReference(compRef);
                EventObject event7 = this.createEventObject(logRecord, EventType.UNMAPPING_PORT);
                event7.setPort(sourcePort);
                event7.setTargetPort(targetPort);
                event7.setTarget(targetRef);
                event7.setName(UNMAPPING);
                return event7;
            }
        } else if (this.messageAnalyser.isPortConnection()) {
            String connectionSource = this.messageAnalyser.getPortConnectionSource();
            String compRef = this.messageAnalyser.getComponentRef(connectionSource);
            String target = this.messageAnalyser.getPortConnectionTarget();
            String targetRef = this.messageAnalyser.getComponentRef(target);
            String sourcePort = this.messageAnalyser.getPort(connectionSource);
            String targetPort = this.messageAnalyser.getPort(target);
            if (!(this.filterConnectingPorts || this.isComponentIgnored(compRef) || this.isComponentIgnored(targetRef))) {
                logRecord.setComponentReference(compRef);
                EventObject event8 = this.createEventObject(logRecord, EventType.CONNECTING_PORT);
                event8.setPort(sourcePort);
                event8.setTargetPort(targetPort);
                event8.setTarget(targetRef);
                event8.setName(CONNECTING);
                return event8;
            }
            this.addPortMapping(compRef, sourcePort, targetRef, targetPort);
        } else if (this.messageAnalyser.isPortDisconnection()) {
            String disconnectionSource = this.messageAnalyser.getPortDisconnectionSource();
            String compRef = this.messageAnalyser.getComponentRef(disconnectionSource);
            String target = this.messageAnalyser.getPortConnectionTarget();
            String targetRef = this.messageAnalyser.getComponentRef(target);
            String sourcePort = this.messageAnalyser.getPort(disconnectionSource);
            String targetPort = this.messageAnalyser.getPort(target);
            if (!(this.filterConnectingPorts || this.isComponentIgnored(compRef) || this.isComponentIgnored(targetRef))) {
                logRecord.setComponentReference(compRef);
                EventObject event9 = this.createEventObject(logRecord, EventType.DISCONNECTING_PORT);
                event9.setPort(sourcePort);
                event9.setTargetPort(targetPort);
                event9.setTarget(targetRef);
                event9.setName(DISCONNECTING);
                return event9;
            }
        } else {
            if (this.messageAnalyser.isTestcaseStart()) {
                return this.eventObjectFactory.createEventObject(EventType.TC_START, logRecord, this.messageAnalyser, this.logFileMetaData.getTimeStampConstant());
            }
            if (this.messageAnalyser.isTestcaseEnd()) {
                return this.eventObjectFactory.createEventObject(EventType.TC_END, logRecord, this.messageAnalyser, this.logFileMetaData.getTimeStampConstant());
            }
            if (this.messageAnalyser.isMTCCreation()) {
                EventObject event10 = this.createEventObject(logRecord, EventType.MTC_CREATE);
                this.addComponent(event10);
                return event10;
            }
            if (this.messageAnalyser.isMTCTermination()) {
                return this.eventObjectFactory.createEventObject(EventType.MTC_TERMINATE, logRecord, this.messageAnalyser, this.logFileMetaData.getTimeStampConstant());
            }
            if (this.messageAnalyser.isMTCDone()) {
                TestComponent component;
                if (this.components != null && (component = this.components.get("mtc")) != null) {
                    String verdict = this.messageAnalyser.getMTCVerdict();
                    component.setVerdict(verdict);
                }
                EventObject event11 = this.createEventObject(logRecord, EventType.SILENT_EVENT);
                event11.setReference("mtc");
                return event11;
            }
            if (this.messageAnalyser.isSetverdict()) {
                if (logRecord.getComponentReference() != null && !this.isComponentIgnored(logRecord.getComponentReference())) {
                    String setverdicttype = this.messageAnalyser.getSetverdictType();
                    if ("inconc".equals(setverdicttype) && this.displaySetverdictInconc) {
                        this.setverdictVector.add(eventIndex);
                        EventObject event12 = this.createEventObject(logRecord, EventType.SETVERDICT_INCONC);
                        event12.setName(setverdicttype);
                        return event12;
                    }
                    if ("error".equals(setverdicttype) && this.displaySetverdictError) {
                        this.setverdictVector.add(eventIndex);
                        EventObject event13 = this.createEventObject(logRecord, EventType.SETVERDICT);
                        event13.setName(setverdicttype);
                        ConnectedRecord[] connectedRecords = this.errorVector.toArray(new ConnectedRecord[this.errorVector.size()]);
                        event13.setConnectedRecords(connectedRecords);
                        return event13;
                    }
                    if ("fail".equals(setverdicttype) && this.displaySetverdictFail) {
                        this.setverdictVector.add(eventIndex);
                        EventObject event14 = this.createEventObject(logRecord, EventType.SETVERDICT);
                        event14.setName(setverdicttype);
                        ConnectedRecord[] connectedRecords = this.failVector.toArray(new ConnectedRecord[this.failVector.size()]);
                        event14.setConnectedRecords(connectedRecords);
                        return event14;
                    }
                    if ("none".equals(setverdicttype) && this.displaySetverdictNone) {
                        this.setverdictVector.add(eventIndex);
                        EventObject event15 = this.createEventObject(logRecord, EventType.SETVERDICT_NONE);
                        event15.setName(setverdicttype);
                        return event15;
                    }
                    if ("pass".equals(setverdicttype) && this.displaySetverdictPass) {
                        this.setverdictVector.add(eventIndex);
                        EventType setverdictPass = EventType.SETVERDICT_PASS;
                        EventObject event16 = this.createEventObject(logRecord, setverdictPass);
                        event16.setName(setverdicttype);
                        return event16;
                    }
                    this.errorVector.clear();
                    this.failVector.clear();
                }
            } else {
                Boolean filtered = this.isEventIgnored(logRecord.getEventType());
                if (!filtered.booleanValue()) {
                    if (logRecord.getComponentReference() != null && logRecord.getComponentReference().trim().length() > 0) {
                        return this.eventObjectFactory.createEventObject(EventType.SILENT_EVENT, logRecord, this.messageAnalyser, this.logFileMetaData.getTimeStampConstant());
                    }
                    String compRef = this.messageAnalyser.isSilentEvent();
                    logRecord.setComponentReference(compRef != null ? compRef : "mtc");
                    return this.eventObjectFactory.createEventObject(EventType.SILENT_EVENT, logRecord, this.messageAnalyser, this.logFileMetaData.getTimeStampConstant());
                }
            }
        }
        if (this.messageAnalyser.isDynamicTestCaseError()) {
            connectedRecord = new ConnectedRecord(logRecord.getRecordOffset(), logRecord.getRecordLength(), logRecord.getRecordNumber());
            this.errorVector.add(connectedRecord);
        }
        if (this.messageAnalyser.isFailMessages()) {
            connectedRecord = new ConnectedRecord(logRecord.getRecordOffset(), logRecord.getRecordLength(), logRecord.getRecordNumber());
            this.failVector.add(connectedRecord);
        }
        return null;
    }

    private EventObject createEventObject(LogRecord logRecord, EventType eventType) {
        return this.eventObjectFactory.createEventObject(eventType, logRecord, this.messageAnalyser, this.logFileMetaData.getTimeStampConstant());
    }

    private EventObject handleReceive(LogRecord logRecord, String receiveType, String sourceRef, TestComponent tc, String receiveTargetPort, String targetRef) {
        ++this.recs;
        EventObject event = this.createEventObject(logRecord, EventType.RECEIVE);
        String deciphered = this.decipherer.decipher(receiveType, this.messageAnalyser.getReceiveValue());
        if (deciphered != null) {
            event.setName(deciphered);
        } else {
            event.setName(receiveType);
        }
        event.setReference(sourceRef);
        event.setTarget(targetRef);
        event.setPort(receiveTargetPort);
        if (tc.getAlternative() != null) {
            event.setReference(tc.getAlternative());
        }
        return event;
    }

    private void notifyChange() {
        this.executionModel.notifyChange();
    }

    private void addPortMapping(String portMappingSourceRef, String portMappingSourcePort, String portMappingTargetRef, String portMappingTargetPort) {
        this.executionModel.addPortMapping(portMappingSourceRef, portMappingSourcePort, portMappingTargetRef, portMappingTargetPort);
    }

    private void addComponent(EventObject event) {
        this.executionModel.addComponent(event);
    }

    private boolean isComponentIgnored(String source) {
        return this.executionModel.isComponentIgnored(source);
    }

    private boolean isSignalIgnored(String sendType) {
        return this.executionModel.isSignalIgnored(sendType);
    }

    private boolean isFunctionIgnored(String sendType) {
        return this.executionModel.isFunctionIgnored(sendType);
    }

    private boolean isEventIgnored(String event) {
        if (this.executionModel.getFilterPattern() != null) {
            return this.executionModel.isEventIgnored(event);
        }
        return this.filteredSilentEvents.get(event);
    }

    public boolean setDecipheringRuleset(String name) {
        return this.decipherer.setDecipheringRuleset(name);
    }
}

