/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.preferences.fieldeditors;

import java.util.Set;
import java.util.SortedMap;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.titan.log.viewer.utils.ImportExportUtils;

public class CheckBoxTreeEditor
extends FieldEditor {
    private Tree checkTree;
    private String prefName;
    private int numberOfNodes = 0;

    public CheckBoxTreeEditor(String prefName, String labelText, SortedMap<String, String[]> treeContent, Composite parent) {
        this.prefName = prefName;
        this.init(prefName, labelText);
        this.createControl(parent);
        this.setTreeContent(treeContent);
    }

    protected void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = this.getNumberOfControls();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 8;
        parent.setLayout((Layout)layout);
        this.doFillIntoGrid(parent, layout.numColumns);
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.checkTree.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.checkTree = new Tree(parent, 2080);
        this.checkTree.setLayoutData((Object)new GridData(1808));
        this.checkTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail != 32 || !(e.item instanceof TreeItem)) {
                    return;
                }
                TreeItem item = (TreeItem)e.item;
                TreeItem parent = item.getParentItem();
                if (parent != null) {
                    TreeItem[] children = parent.getItems();
                    int numberOfChildren = children.length;
                    int checkedChildren = CheckBoxTreeEditor.countChecked(children);
                    this.updateParent(parent, numberOfChildren, checkedChildren);
                } else {
                    item.setGrayed(false);
                    boolean checked = item.getChecked();
                    TreeItem[] children = item.getItems();
                    CheckBoxTreeEditor.setChecked(children, checked);
                }
                CheckBoxTreeEditor.this.valueChanged();
            }

            private void updateParent(TreeItem parent, int numberOfChildren, int checkedChildren) {
                if (checkedChildren == numberOfChildren) {
                    parent.setGrayed(false);
                    parent.setChecked(true);
                } else if (checkedChildren == 0) {
                    parent.setGrayed(false);
                    parent.setChecked(false);
                } else {
                    parent.setChecked(true);
                    parent.setGrayed(true);
                }
            }
        });
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = numColumns;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.heightHint = this.convertVerticalDLUsToPixels((Control)this.checkTree, 40);
        this.checkTree.setLayoutData((Object)gridData);
    }

    private void setTreeContent(SortedMap<String, String[]> treeContent) {
        this.checkTree.setRedraw(false);
        Set<String> parents = treeContent.keySet();
        int index = 0;
        int tmpNumberOfNodes = 0;
        for (String parent : parents) {
            TreeItem parentItem = new TreeItem(this.checkTree, 0);
            parentItem.setText(parent);
            this.checkTree.setData(parent, (Object)index++);
            ++tmpNumberOfNodes;
            String[] strings = (String[])treeContent.get(parent);
            for (int i = 0; i < strings.length; ++i) {
                String child = strings[i];
                TreeItem childItem = new TreeItem(parentItem, 0);
                childItem.setText(child);
                this.checkTree.setData(parent + "_" + child, (Object)i);
                ++tmpNumberOfNodes;
            }
        }
        this.numberOfNodes = tmpNumberOfNodes;
        this.checkTree.setRedraw(true);
    }

    private void valueChanged() {
        TreeItem[] newItems = this.checkTree.getItems();
        this.fireValueChanged("field_editor_value", null, newItems);
    }

    public void deselectAll() {
        TreeItem[] parents;
        for (TreeItem parent : parents = this.checkTree.getItems()) {
            parent.setChecked(false);
            if (parent.getGrayed()) {
                parent.setGrayed(false);
            }
            TreeItem[] children = parent.getItems();
            CheckBoxTreeEditor.setChecked(children, false);
        }
    }

    public void selectAll() {
        TreeItem[] parents;
        for (TreeItem parent : parents = this.checkTree.getItems()) {
            parent.setChecked(true);
            if (parent.getGrayed()) {
                parent.setGrayed(false);
            }
            TreeItem[] children = parent.getItems();
            CheckBoxTreeEditor.setChecked(children, true);
        }
    }

    protected void doLoadDefault() {
        String prefDefValues = this.getPreferenceStore().getDefaultString(this.prefName);
        if (prefDefValues.length() > 0) {
            this.updateCheckedState(prefDefValues);
            this.updateGrayedState();
        }
    }

    protected void doLoad() {
        String prefValues = this.getPreferenceStore().getString(this.prefName);
        if (prefValues.length() > 0) {
            this.updateCheckedState(prefValues);
            this.updateGrayedState();
        }
    }

    private void updateCheckedState(String prefValues) {
        String[] categories;
        for (String category : categories = prefValues.split(";")) {
            String[] currCategory = category.split("=");
            if (currCategory.length <= 1) continue;
            String currKey = currCategory[0];
            boolean currValue = Boolean.valueOf(currCategory[1]);
            if (currKey.contains("_")) {
                String cat = currKey.split("_")[0];
                int parentIndex = (Integer)this.checkTree.getData(cat);
                int childIndex = (Integer)this.checkTree.getData(currKey);
                this.checkTree.getItem(parentIndex).getItem(childIndex).setChecked(currValue);
                continue;
            }
            this.checkTree.getItem(((Integer)this.checkTree.getData(currKey)).intValue()).setChecked(currValue);
        }
    }

    private void updateGrayedState() {
        TreeItem[] parents;
        for (TreeItem parent : parents = this.checkTree.getItems()) {
            TreeItem[] children = parent.getItems();
            int numOfCheckChildren = CheckBoxTreeEditor.countChecked(children);
            if (numOfCheckChildren > 0 && numOfCheckChildren < children.length) {
                parent.setGrayed(true);
                continue;
            }
            parent.setGrayed(false);
        }
    }

    protected void doStore() {
        String prefValues = ImportExportUtils.arrayToString(this.getElements(), ";");
        this.getPreferenceStore().setValue(this.prefName, prefValues);
    }

    public int getNumberOfControls() {
        return 1;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        this.checkTree.setEnabled(enabled);
        super.setEnabled(enabled, parent);
    }

    public String[] getElements() {
        TreeItem[] parents = this.checkTree.getItems();
        String[] prefValues = new String[this.numberOfNodes];
        int currPrefIndex = 0;
        for (TreeItem currParent : parents) {
            TreeItem[] children;
            prefValues[currPrefIndex++] = currParent.getText() + "=" + Boolean.toString(currParent.getChecked());
            for (TreeItem currChild : children = currParent.getItems()) {
                prefValues[currPrefIndex++] = currParent.getText() + "_" + currChild.getText() + "=" + Boolean.toString(currChild.getChecked());
            }
        }
        return prefValues;
    }

    private static int countChecked(TreeItem[] items) {
        int checked = 0;
        for (TreeItem item : items) {
            if (!item.getChecked()) continue;
            ++checked;
        }
        return checked;
    }

    private static void setChecked(TreeItem[] items, boolean checked) {
        for (TreeItem item : items) {
            item.setChecked(checked);
        }
    }
}

