/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.ui.core;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.views.msc.ui.core.Lifeline;
import org.eclipse.titan.log.viewer.views.msc.ui.core.MSCNode;
import org.eclipse.titan.log.viewer.views.msc.ui.core.RectangleDrawer;
import org.eclipse.titan.log.viewer.views.msc.ui.view.IGC;
import org.eclipse.titan.log.viewer.views.msc.util.MSCConstants;

public abstract class ComponentEventNode
extends MSCNode {
    private Lifeline lifeline;

    public ComponentEventNode(int eventOccurrence, Lifeline lifeline) {
        super(eventOccurrence);
        this.lifeline = lifeline;
    }

    @Override
    public int getX() {
        return MSCConstants.COLUMN_WIDTH * this.lifeline.getIndex() + 6;
    }

    @Override
    public int getY() {
        return MSCConstants.ROW_HEIGHT * this.getStartOccurrence() + 5;
    }

    @Override
    public int getWidth() {
        return MSCConstants.COLUMN_WIDTH - 12 + 1;
    }

    @Override
    public int getHeight() {
        return MSCConstants.ROW_HEIGHT - 10 + 1;
    }

    @Override
    public boolean positiveDistanceToPoint(int x, int y) {
        return true;
    }

    @Override
    public void draw(IGC context) {
        Rectangle rectangle = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        RectangleDrawer.drawShadow(context, rectangle, RectangleDrawer.getColor("COLOR_GREY"), 1);
        RectangleDrawer.drawBox(context, rectangle, this.getBackgroundColor(), RectangleDrawer.getColor("COLOR_WHITE"), 1);
        RectangleDrawer.drawBorder(context, rectangle, RectangleDrawer.getColor("COLOR_BLACK"), 1);
        this.drawText(context, rectangle);
    }

    private void drawText(IGC context, Rectangle rectangle) {
        context.setForeground(RectangleDrawer.getColor("COLOR_BLACK"));
        context.setFont((Font)Activator.getDefault().getCachedResource("FONT_DEFAULT"));
        context.drawTextTruncatedCentred(this.getName(), rectangle.x + 5, rectangle.y, rectangle.width - 1 - 10, rectangle.height - 1, true);
    }

    protected abstract Color getBackgroundColor();
}

