/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.generators;

import edu.uci.ics.jung.graph.util.EdgeType;
import java.awt.Color;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ISetting;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeReferenceList;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.error.ErrorHandler;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeColours;
import org.eclipse.titanium.graph.components.NodeDescriptor;
import org.eclipse.titanium.graph.generators.GraphGenerator;

public class ComponentGraphGenerator
extends GraphGenerator {
    public ComponentGraphGenerator(IProject project, ErrorHandler eHandler) {
        super(project, eHandler);
        if (eHandler == null) {
            this.errorHandler.reportErrorMessage("The referenced error handler mustn't be null(source: ComponentGraphGenerator)");
        }
    }

    @Override
    protected void createGraph() {
        this.analyzeProject();
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)this.project);
        List visitedProjects = ProjectBasedBuilder.getProjectBasedBuilder((IProject)this.project).getAllReachableProjects();
        for (IProject currentProject : visitedProjects) {
            for (Module module : projectSourceParser.getModules()) {
                this.handleModule(currentProject, module);
            }
        }
    }

    private void handleModule(final IProject currentProject, Module mod) {
        mod.accept(new ASTVisitor(){

            public int visit(IVisitableNode node) {
                if (!(node instanceof Def_Type)) {
                    return super.visit(node);
                }
                Def_Type defType = (Def_Type)node;
                Type type = defType.getType(CompilationTimeStamp.getBaseTimestamp());
                if (!(type instanceof Component_Type)) {
                    return super.visit(node);
                }
                Component_Type componentType = (Component_Type)type;
                Identifier id = defType.getIdentifier();
                NodeDescriptor sourceNode = new NodeDescriptor(id.getDisplayName(), id.getName(), NodeColours.LIGHT_GREEN, currentProject, false, id.getLocation());
                if (!ComponentGraphGenerator.this.graph.containsVertex((Object)sourceNode)) {
                    ComponentGraphGenerator.this.graph.addVertex((Object)sourceNode);
                    ComponentGraphGenerator.this.labels.put(sourceNode.getName(), sourceNode);
                }
                ComponentCollector componentCollector = new ComponentCollector(currentProject, sourceNode.getName());
                ComponentTypeReferenceList compReferenceList = componentType.getComponentBody().getExtensions();
                compReferenceList.accept((ASTVisitor)componentCollector);
                ComponentTypeReferenceList compReferenceListAttribute = componentType.getComponentBody().getAttributeExtensions();
                if (compReferenceListAttribute != null) {
                    compReferenceListAttribute.accept((ASTVisitor)componentCollector);
                }
                return 1;
            }
        });
    }

    private void analyzeProject() {
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)this.project);
        if (projectSourceParser.getLastTimeChecked() == null) {
            WorkspaceJob job = projectSourceParser.analyzeAll();
            while (job == null) {
                try {
                    Thread.sleep(500L);
                    job = projectSourceParser.analyzeAll();
                }
                catch (InterruptedException e) {
                    ErrorReporter.logExceptionStackTrace((String)"Error while waiting for analyzis result", (Throwable)e);
                }
            }
            try {
                job.join();
            }
            catch (InterruptedException e) {
                ErrorReporter.logExceptionStackTrace((String)"Error while waiting for analyzis result", (Throwable)e);
            }
        }
    }

    private class ComponentCollector
    extends ASTVisitor {
        final IProject currentProject;
        final String sourceName;

        public ComponentCollector(IProject currentProject, String sourceName) {
            this.currentProject = currentProject;
            this.sourceName = sourceName;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Reference) {
                Reference reference = (Reference)node;
                ISetting setting = reference.getRefdSetting(CompilationTimeStamp.getBaseTimestamp());
                Identifier id = reference.getId();
                if (!ComponentGraphGenerator.this.labels.containsKey(id.getName())) {
                    NodeDescriptor destinationNode = new NodeDescriptor(id.getDisplayName(), id.getName(), NodeColours.LIGHT_GREEN, this.currentProject, false, setting.getLocation());
                    ComponentGraphGenerator.this.graph.addVertex((Object)destinationNode);
                    ComponentGraphGenerator.this.labels.put(destinationNode.getName(), destinationNode);
                }
                EdgeDescriptor edge = new EdgeDescriptor(this.sourceName + "->" + id.getName(), Color.black);
                ComponentGraphGenerator.this.graph.addEdge((Object)edge, ComponentGraphGenerator.this.labels.get(this.sourceName), ComponentGraphGenerator.this.labels.get(id.getName()), EdgeType.DIRECTED);
            }
            return super.visit(node);
        }
    }
}

