/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.gui.dialogs;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titanium.graph.visualization.GraphHandler;
import org.eclipse.titanium.swt.SWTResourceManager;

public class ExportPreferencesDialog
extends Dialog {
    protected GraphHandler.ImageExportType result = GraphHandler.ImageExportType.EXPORT_SEEN_GRAPH;
    protected Shell shlExportGraph;
    private Combo mode;

    public ExportPreferencesDialog(Shell parent) {
        super(parent);
        this.setText("Export Graph");
    }

    public GraphHandler.ImageExportType open() {
        this.createContents();
        this.shlExportGraph.open();
        this.shlExportGraph.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shlExportGraph.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        this.shlExportGraph = new Shell(this.getParent(), 34848);
        this.shlExportGraph.setImage(SWTResourceManager.getImage("resources/icons/sample.gif"));
        this.shlExportGraph.setSize(226, 130);
        this.shlExportGraph.setText("Export Preferences");
        this.mode = new Combo((Composite)this.shlExportGraph, 8);
        this.mode.setItems(new String[]{"Whole graph", "Only the seen part", "The satellite view"});
        this.mode.setBounds(10, 31, 200, 23);
        this.mode.select(0);
        Label lblPartToExport = new Label((Composite)this.shlExportGraph, 0);
        lblPartToExport.setBounds(10, 10, 94, 15);
        lblPartToExport.setText("Part to export");
        this.shlExportGraph.setLocation(100, 100);
        Button btnOk = new Button((Composite)this.shlExportGraph, 0);
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (ExportPreferencesDialog.this.mode.getSelectionIndex()) {
                    case 0: {
                        ExportPreferencesDialog.this.result = GraphHandler.ImageExportType.EXPORT_WHOLE_GRAPH;
                        break;
                    }
                    case 1: {
                        ExportPreferencesDialog.this.result = GraphHandler.ImageExportType.EXPORT_SEEN_GRAPH;
                        break;
                    }
                    case 2: {
                        ExportPreferencesDialog.this.result = GraphHandler.ImageExportType.EXPORT_SATELLITE;
                        break;
                    }
                    default: {
                        ErrorReporter.logError((String)("unexpected selection index " + ExportPreferencesDialog.this.mode.getSelectionIndex()));
                        ExportPreferencesDialog.this.result = GraphHandler.ImageExportType.EXPORT_SEEN_GRAPH;
                    }
                }
                if (!ExportPreferencesDialog.this.shlExportGraph.isDisposed()) {
                    ExportPreferencesDialog.this.shlExportGraph.close();
                }
            }
        });
        btnOk.setBounds(64, 60, 75, 25);
        btnOk.setText("OK");
        btnOk.setFocus();
    }
}

