/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.statements.Receive_Port_Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.AnyOrOmit_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Any_Value_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TypeSet;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

final class SuperfluousTemplate
extends ASTVisitor {
    private IType receivableType;
    private boolean hasValueRedirection;
    private TemplateInstance template;
    private boolean receivesAny;
    private boolean receivesAllOfType;

    public SuperfluousTemplate(Receive_Port_Statement rec) {
        TypeSet ts;
        Port_Type port = rec.getPortType();
        this.receivableType = null;
        if (port != null && (ts = port.getPortBody().getOutMessage()) != null && ts.getNofTypes() == 1) {
            this.receivableType = ts.getTypeByIndex(0);
        }
        this.hasValueRedirection = rec.getRedirectValue() != null;
        this.template = null;
        this.receivesAny = false;
        this.receivesAllOfType = false;
    }

    public boolean hasValueRedirect() {
        return this.hasValueRedirection;
    }

    public IType getReceivable() {
        return this.receivableType;
    }

    public TemplateInstance getTemplate() {
        return this.template;
    }

    public boolean canReceiveAny() {
        return this.receivesAny;
    }

    public boolean canReceiveAll() {
        return this.receivesAllOfType;
    }

    public int visit(IVisitableNode node) {
        if (node instanceof TemplateInstance) {
            this.template = (TemplateInstance)node;
            TTCN3Template body = this.template.getTemplateBody();
            if (body instanceof Any_Value_Template || body instanceof AnyOrOmit_Template) {
                Type type = this.template.getType();
                if (type == null) {
                    this.receivesAny = true;
                } else if (this.receivableType != null && type.isIdentical(CompilationTimeStamp.getBaseTimestamp(), this.receivableType)) {
                    this.receivesAllOfType = true;
                }
            }
            return 1;
        }
        return 3;
    }
}

