/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.markers.handler.Marker;
import org.eclipse.titanium.markers.handler.MarkerHandler;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseProjectCodeSmellSpotter;
import org.eclipse.titanium.markers.utils.AnalyzerBuilder;

public class Analyzer {
    private final Map<Class<? extends IVisitableNode>, Set<BaseModuleCodeSmellSpotter>> actions;
    private final Set<BaseProjectCodeSmellSpotter> projectActions;

    Analyzer(Map<Class<? extends IVisitableNode>, Set<BaseModuleCodeSmellSpotter>> actions, Set<BaseProjectCodeSmellSpotter> projectActions) {
        this.actions = actions;
        this.projectActions = projectActions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Marker> internalAnalyzeModule(Module module) {
        CodeSmellVisitor v = new CodeSmellVisitor();
        IProject iProject = module.getProject();
        synchronized (iProject) {
            module.accept((ASTVisitor)v);
        }
        return v.markers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Marker> internalAnalyzeProject(IProject project) {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        for (BaseProjectCodeSmellSpotter spotter : this.projectActions) {
            List<Marker> ms;
            IProject iProject = project;
            synchronized (iProject) {
                ms = spotter.checkProject(project);
            }
            markers.addAll(ms);
        }
        return markers;
    }

    public MarkerHandler analyzeModule(IProgressMonitor monitor, Module module) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IResource res = module.getLocation().getFile();
        HashMap<IResource, List<Marker>> markers = new HashMap<IResource, List<Marker>>();
        markers.put(res, this.internalAnalyzeModule(module));
        progress.worked(80);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        IProject project = module.getProject();
        markers.put((IResource)project, this.internalAnalyzeProject(project));
        progress.worked(20);
        return new MarkerHandler(markers);
    }

    public MarkerHandler analyzeProject(IProgressMonitor monitor, IProject project) {
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)project);
        Set knownModuleNames = projectSourceParser.getKnownModuleNames();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + knownModuleNames.size()));
        progress.subTask("Project level analysis");
        HashMap<IResource, List<Marker>> markers = new HashMap<IResource, List<Marker>>();
        markers.put((IResource)project, this.internalAnalyzeProject(project));
        progress.worked(1);
        for (String moduleName : knownModuleNames) {
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            Module mod = projectSourceParser.getModuleByName(moduleName);
            progress.subTask("Analyzing module " + mod.getName());
            IResource moduleResource = mod.getLocation().getFile();
            markers.put(moduleResource, this.internalAnalyzeModule(mod));
            progress.worked(1);
        }
        return new MarkerHandler(markers);
    }

    public static AnalyzerBuilder builder() {
        return new AnalyzerBuilder();
    }

    private class CodeSmellVisitor
    extends ASTVisitor {
        private final List<Marker> markers = new ArrayList<Marker>();

        public int visit(IVisitableNode node) {
            Set actionsOnNode = (Set)Analyzer.this.actions.get(node.getClass());
            if (actionsOnNode != null) {
                for (BaseModuleCodeSmellSpotter spotter : actionsOnNode) {
                    this.markers.addAll(spotter.checkNode(node));
                }
            }
            return 3;
        }
    }
}

