/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics;

import java.util.EnumSet;
import java.util.Set;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.StatColumn;

public enum ProjectMetric implements IMetricEnum
{
    NOF_TTCN3_MODULES("Number of TTCN3 modules", "Number of TTCN3 modules in the project"),
    NOF_ASN1_MODULES("Number of ASN1 modules", "Number of ASN1 modules in the project");

    public static final String GROUP_NAME = "Project";
    private String displayName;
    private String hint;
    private Set<StatColumn> requestedStatistics;
    private boolean isInteger;

    private ProjectMetric(String name, String hint) {
        this(name, hint, EnumSet.allOf(StatColumn.class), true);
    }

    private ProjectMetric(String name, String hint, Set<StatColumn> requestedStatistics) {
        this(name, hint, requestedStatistics, true);
    }

    private ProjectMetric(String name, String hint, Set<StatColumn> requestedStatistics, boolean isInteger) {
        this.displayName = name;
        this.hint = hint;
        this.requestedStatistics = requestedStatistics;
        this.isInteger = isInteger;
    }

    @Override
    public String id() {
        return "Project." + this.name();
    }

    @Override
    public String getName() {
        return this.displayName;
    }

    @Override
    public String getHint() {
        return this.hint;
    }

    @Override
    public Set<StatColumn> requestedStatistics() {
        return this.requestedStatistics;
    }

    @Override
    public boolean isInteger() {
        return this.isInteger;
    }

    @Override
    public String groupName() {
        return GROUP_NAME;
    }
}

