/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;

public class HistoryPageInput {
    private final List<IResource> list;
    private final List<File> files;
    private final Repository repo;
    private final Object singleFile;
    private final Object singleItem;

    public HistoryPageInput(Repository repository, IResource[] resourceItems) {
        this.repo = repository;
        this.list = Arrays.asList(resourceItems);
        if (resourceItems.length == 1) {
            this.singleItem = resourceItems[0];
            this.singleFile = resourceItems[0].getType() == 1 ? resourceItems[0] : null;
        } else {
            this.singleItem = null;
            this.singleFile = null;
        }
        this.files = null;
    }

    public HistoryPageInput(Repository repository, File[] fileItems) {
        this.repo = repository;
        this.list = null;
        if (fileItems.length == 1 && fileItems[0].isFile() && !this.inGitDir(repository, fileItems[0])) {
            this.singleItem = fileItems[0];
            this.singleFile = fileItems[0];
            this.files = Arrays.asList(fileItems);
        } else {
            this.singleItem = null;
            this.singleFile = null;
            this.files = this.filterFilesInGitDir(repository, fileItems);
        }
    }

    public HistoryPageInput(Repository repository) {
        this.repo = repository;
        this.list = null;
        this.singleFile = null;
        this.singleItem = null;
        this.files = null;
    }

    public Repository getRepository() {
        return this.repo;
    }

    public IResource[] getItems() {
        return this.list == null ? null : this.list.toArray(new IResource[this.list.size()]);
    }

    public File[] getFileList() {
        return this.files == null ? null : this.files.toArray(new File[this.files.size()]);
    }

    public Object getSingleFile() {
        return this.singleFile;
    }

    public Object getSingleItem() {
        return this.singleItem;
    }

    public boolean isSingleFile() {
        return this.singleFile != null;
    }

    public Ref getHead() {
        try {
            Ref h = this.repo.exactRef("HEAD");
            if (h != null && h.isSymbolic()) {
                return h;
            }
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException(NLS.bind((String)UIText.GitHistoryPage_errorParsingHead, (Object)Activator.getDefault().getRepositoryUtil().getRepositoryName(this.repo)), e);
        }
    }

    private boolean inGitDir(Repository repository, File file) {
        return file.getAbsoluteFile().toPath().startsWith(repository.getDirectory().getAbsoluteFile().toPath());
    }

    private List<File> filterFilesInGitDir(Repository repository, File[] fileItems) {
        ArrayList<File> result = new ArrayList<File>(fileItems.length);
        Path gitDirPath = repository.getDirectory().getAbsoluteFile().toPath();
        File[] fileArray = fileItems;
        int n = fileItems.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!f.getAbsoluteFile().toPath().startsWith(gitDirPath)) {
                result.add(f);
            }
            ++n2;
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }
}

