/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.pull;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.egit.core.op.CreateLocalBranchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RefContentAssistProvider;
import org.eclipse.egit.ui.internal.components.RemoteSelectionCombo;
import org.eclipse.egit.ui.internal.push.AddRemoteWizard;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PullWizardPage
extends WizardPage {
    private RemoteSelectionCombo remoteSelectionCombo;
    private List<RemoteConfig> remoteConfigs;
    private RemoteConfig remoteConfig;
    private RefContentAssistProvider assist;
    private Repository repository;
    private String fullBranch;
    private Button mergeRadio;
    private Button rebaseRadio;
    private Button rememberConfigForBranch;
    private CreateLocalBranchOperation.UpstreamConfig upstreamConfig;
    private Ref head;
    private Text remoteBranchNameText;
    private ControlDecoration missingBranchDecorator;
    private boolean configureUpstream;

    public PullWizardPage(Repository repository) {
        super(UIText.PullWizardPage_PageName);
        this.setTitle(UIText.PullWizardPage_PageTitle);
        this.setMessage(UIText.PullWizardPage_PageMessage);
        this.setImageDescriptor(UIIcons.WIZBAN_PULL);
        this.repository = repository;
        try {
            this.head = repository.findRef("HEAD");
            this.fullBranch = repository.getFullBranch();
        }
        catch (IOException ex) {
            Activator.logError(ex.getMessage(), ex);
        }
    }

    public void createControl(Composite parent) {
        try {
            this.remoteConfigs = RemoteConfig.getAllRemoteConfigs((Config)this.repository.getConfig());
            Collections.sort(this.remoteConfigs, new Comparator<RemoteConfig>(){

                @Override
                public int compare(RemoteConfig first, RemoteConfig second) {
                    return String.CASE_INSENSITIVE_ORDER.compare(first.getName(), second.getName());
                }
            });
            this.setDefaultUpstreamConfig();
        }
        catch (URISyntaxException e) {
            this.remoteConfigs = new ArrayList<RemoteConfig>();
            this.handleError(e);
        }
        Composite res = new Composite(parent, 0);
        res.setLayout((Layout)new GridLayout(3, false));
        Label remoteLabel = new Label(res, 0);
        remoteLabel.setText(UIText.PushBranchPage_RemoteLabel);
        this.remoteSelectionCombo = new RemoteSelectionCombo(res, 0, RemoteSelectionCombo.SelectionType.PUSH);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.remoteSelectionCombo);
        this.setRemoteConfigs();
        this.remoteSelectionCombo.addRemoteSelectionListener(new RemoteSelectionCombo.IRemoteSelectionListener(){

            @Override
            public void remoteSelected(RemoteConfig rc) {
                PullWizardPage.this.remoteConfig = rc;
                PullWizardPage.this.setRefAssist(rc);
                PullWizardPage.this.checkPage();
            }
        });
        Button newRemoteButton = new Button(res, 8);
        newRemoteButton.setText(UIText.PushBranchPage_NewRemoteButton);
        GridDataFactory.fillDefaults().applyTo((Control)newRemoteButton);
        newRemoteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PullWizardPage.this.showNewRemoteDialog();
            }
        });
        Label branchNameLabel = new Label(res, 0);
        branchNameLabel.setText(UIText.PullWizardPage_referenceLabel);
        branchNameLabel.setToolTipText(UIText.PullWizardPage_referenceTooltip);
        this.remoteBranchNameText = new Text(res, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.remoteBranchNameText);
        UIUtils.addRefContentProposalToText(this.remoteBranchNameText, this.repository, new UIUtils.IRefListProvider(){

            @Override
            public List<Ref> getRefList() {
                if (PullWizardPage.this.assist != null) {
                    return PullWizardPage.this.assist.getRefsForContentAssist(false, true);
                }
                return Collections.emptyList();
            }
        });
        this.remoteBranchNameText.setText(this.getSuggestedBranchName());
        this.remoteBranchNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PullWizardPage.this.checkPage();
            }
        });
        this.mergeRadio = new Button(res, 16);
        this.mergeRadio.setText(UIText.UpstreamConfigComponent_MergeRadio);
        this.mergeRadio.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        this.mergeRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PullWizardPage.this.upstreamConfig = CreateLocalBranchOperation.UpstreamConfig.MERGE;
            }
        });
        this.rebaseRadio = new Button(res, 16);
        this.rebaseRadio.setText(UIText.UpstreamConfigComponent_RebaseRadio);
        this.rebaseRadio.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        this.mergeRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PullWizardPage.this.upstreamConfig = CreateLocalBranchOperation.UpstreamConfig.REBASE;
            }
        });
        this.mergeRadio.setSelection(this.upstreamConfig == CreateLocalBranchOperation.UpstreamConfig.MERGE);
        this.rebaseRadio.setSelection(this.upstreamConfig == CreateLocalBranchOperation.UpstreamConfig.REBASE);
        if (this.fullBranch != null && this.fullBranch.startsWith("refs/heads/")) {
            this.rememberConfigForBranch = new Button(res, 32);
            GridData checkboxLayoutData = new GridData(1, 0x1000000, false, false, 3, 1);
            checkboxLayoutData.verticalIndent = 20;
            this.rememberConfigForBranch.setText(UIText.UpstreamConfigComponent_ConfigureUpstreamCheck);
            this.rememberConfigForBranch.setToolTipText(UIText.UpstreamConfigComponent_ConfigureUpstreamToolTip);
            this.rememberConfigForBranch.setLayoutData((Object)checkboxLayoutData);
            this.rememberConfigForBranch.setSelection(this.configureUpstream);
            this.rememberConfigForBranch.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PullWizardPage.this.configureUpstream = PullWizardPage.this.rememberConfigForBranch.getSelection();
                    PullWizardPage.this.checkPage();
                }
            });
        }
        this.setPageComplete(this.isPageComplete());
        this.setControl((Control)res);
    }

    private void setRemoteConfigs() {
        this.remoteSelectionCombo.setItems(this.remoteConfigs);
        if (this.head != null) {
            String branchName = Repository.shortenRefName((String)this.head.getName());
            BranchConfig branchConfig = new BranchConfig((Config)this.repository.getConfig(), branchName);
            String remoteName = branchConfig.getRemote();
            if (remoteName != null) {
                for (RemoteConfig rc : this.remoteConfigs) {
                    if (!remoteName.equals(rc.getName())) continue;
                    this.remoteSelectionCombo.setSelectedRemote(rc);
                }
            }
        }
        this.remoteConfig = this.remoteSelectionCombo.getSelectedRemote();
        this.setRefAssist(this.remoteConfig);
    }

    private void showNewRemoteDialog() {
        AddRemoteWizard wizard = new AddRemoteWizard(this.repository);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        int result = dialog.open();
        if (result == 0) {
            URIish uri = wizard.getUri();
            String remoteName = wizard.getRemoteName();
            try {
                StoredConfig repoConfig = this.repository.getConfig();
                RemoteConfig newRemoteConfig = new RemoteConfig((Config)repoConfig, remoteName);
                newRemoteConfig.addURI(uri);
                RefSpec defaultFetchSpec = new RefSpec().setForceUpdate(true).setSourceDestination("refs/heads/*", "refs/remotes/" + remoteName + "/*");
                newRemoteConfig.addFetchRefSpec(defaultFetchSpec);
                newRemoteConfig.update((Config)repoConfig);
                repoConfig.save();
                List allRemoteConfigs = RemoteConfig.getAllRemoteConfigs((Config)this.repository.getConfig());
                this.remoteSelectionCombo.setItems(allRemoteConfigs);
                for (RemoteConfig current : allRemoteConfigs) {
                    if (!newRemoteConfig.getName().equals(current.getName())) continue;
                    this.setSelectedRemote(current);
                }
            }
            catch (URISyntaxException ex) {
                Activator.logError(ex.getMessage(), ex);
            }
            catch (IOException ex) {
                Activator.logError(ex.getMessage(), ex);
            }
        }
    }

    private void setRefAssist(RemoteConfig config) {
        if (config != null && config.getURIs().size() > 0) {
            this.assist = new RefContentAssistProvider(this.repository, (URIish)config.getURIs().get(0), this.getContainer());
        }
    }

    void setSelectedRemote(RemoteConfig config) {
        this.remoteSelectionCombo.setSelectedRemote(config);
        this.remoteConfig = config;
        this.setRefAssist(this.remoteConfig);
        this.checkPage();
    }

    public boolean isPageComplete() {
        return this.remoteConfig != null && this.remoteBranchNameText.getText() != null && !this.remoteBranchNameText.getText().isEmpty();
    }

    private void checkPage() {
        block10: {
            block9: {
                try {
                    if (this.remoteConfig != null) break block9;
                    this.setErrorMessage(UIText.PushBranchPage_ChooseRemoteError);
                }
                catch (Throwable throwable) {
                    this.setPageComplete(this.getErrorMessage() == null);
                    throw throwable;
                }
                this.setPageComplete(this.getErrorMessage() == null);
                return;
            }
            String branchName = this.remoteBranchNameText.getText();
            String branchNameMessage = null;
            if (branchName.length() == 0) {
                branchNameMessage = MessageFormat.format(UIText.PullWizardPage_ChooseReference, this.remoteConfig.getName());
            }
            if (branchNameMessage == null) break block10;
            this.setErrorMessage(branchNameMessage);
            if (this.missingBranchDecorator == null) {
                this.missingBranchDecorator = new ControlDecoration((Control)this.remoteBranchNameText, 16512);
                this.missingBranchDecorator.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
            }
            this.missingBranchDecorator.setDescriptionText(branchNameMessage);
            this.missingBranchDecorator.show();
            this.setPageComplete(this.getErrorMessage() == null);
            return;
        }
        if (this.missingBranchDecorator != null) {
            this.missingBranchDecorator.hide();
        }
        if (this.overrideUpstreamConfiguration() && this.hasDifferentUpstreamConfiguration()) {
            this.setMessage(UIText.PushBranchPage_UpstreamConfigOverwriteWarning, 2);
        } else {
            this.setMessage(UIText.PullWizardPage_PageMessage);
        }
        this.setErrorMessage(null);
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private void handleError(URISyntaxException e) {
        Activator.handleError(e.getMessage(), e, false);
        this.setErrorMessage(e.getMessage());
    }

    private String getSuggestedBranchName() {
        if (this.fullBranch != null) {
            String branchName = Repository.shortenRefName((String)this.fullBranch);
            StoredConfig config = this.repository.getConfig();
            BranchConfig branchConfig = new BranchConfig((Config)config, branchName);
            String merge = branchConfig.getMerge();
            if (!branchConfig.isRemoteLocal() && merge != null && merge.startsWith("refs/heads/")) {
                return Repository.shortenRefName((String)merge);
            }
            if (merge == null && this.fullBranch.startsWith("refs/heads/")) {
                return branchName;
            }
        }
        return "";
    }

    boolean overrideUpstreamConfiguration() {
        return this.configureUpstream;
    }

    boolean isRebaseSelected() {
        return this.upstreamConfig == CreateLocalBranchOperation.UpstreamConfig.REBASE;
    }

    CreateLocalBranchOperation.UpstreamConfig getUpstreamConfig() {
        return this.upstreamConfig;
    }

    private boolean hasDifferentUpstreamConfiguration() {
        String branchName = Repository.shortenRefName((String)this.fullBranch);
        BranchConfig branchConfig = new BranchConfig((Config)this.repository.getConfig(), branchName);
        String remote = branchConfig.getRemote();
        if (remote == null) {
            return false;
        }
        if (!remote.equals(this.remoteConfig.getName())) {
            return true;
        }
        String merge = branchConfig.getMerge();
        if (merge == null || !merge.equals(this.getFullRemoteReference())) {
            return true;
        }
        boolean rebase = branchConfig.isRebase();
        return rebase != this.isRebaseSelected();
    }

    private void setDefaultUpstreamConfig() {
        boolean rebase;
        boolean alreadyConfigured;
        String branchName = Repository.shortenRefName((String)this.fullBranch);
        BranchConfig branchConfig = new BranchConfig((Config)this.repository.getConfig(), branchName);
        boolean bl = alreadyConfigured = branchConfig.getMerge() != null;
        CreateLocalBranchOperation.UpstreamConfig config = alreadyConfigured ? ((rebase = branchConfig.isRebase()) ? CreateLocalBranchOperation.UpstreamConfig.REBASE : CreateLocalBranchOperation.UpstreamConfig.MERGE) : CreateLocalBranchOperation.UpstreamConfig.getDefault((Repository)this.repository, (String)("refs/remotes/origin/" + branchName));
        this.upstreamConfig = config;
    }

    String getFullRemoteReference() {
        if (!this.remoteBranchNameText.getText().startsWith("refs/")) {
            return "refs/heads/" + this.remoteBranchNameText.getText();
        }
        return this.remoteBranchNameText.getText();
    }

    RemoteConfig getRemoteConfig() {
        return this.remoteConfig;
    }

    public void dispose() {
        super.dispose();
        if (this.missingBranchDecorator != null) {
            this.missingBranchDecorator.dispose();
        }
    }
}

