/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import fr.inria.zvtm.glyphs.DPath;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import net.claribole.zgrviewer.PolyLine;

public class LinkSliderCalc {
    public PolyLine polyLine;
    protected Point2D mousePos;
    protected Point2D nearestPoint;
    protected Line2D nearestSeg;
    protected double viewWidth;
    protected double scale;
    protected double fractionAlongPath;
    DPath path;

    public LinkSliderCalc(DPath p, double viewWidth) {
        this(p, 0.5, viewWidth);
    }

    public LinkSliderCalc(DPath p, double flatness, double viewWidth) {
        this.path = p;
        this.polyLine = new PolyLine(this.path.getJava2DGeneralPath().getPathIterator(new AffineTransform(), flatness));
        this.viewWidth = viewWidth;
    }

    public DPath getPath() {
        return this.path;
    }

    public void updateMousePosition(Point2D mousePos) {
        this.mousePos = new Point2D.Double(mousePos.getX(), mousePos.getX());
        this.nearestSeg = this.polyLine.nearestSegment(mousePos);
        this.nearestPoint = PolyLine.nearestPointOnSegment(mousePos, this.nearestSeg);
        double partialDist = this.polyLine.cumLengthAt(this.nearestPoint);
        double pathLen = this.polyLine.getLength();
        double x = partialDist / pathLen;
        double y = Math.pow(1.0 - Math.pow(x * 2.0 - 1.0, 6.0), 4.0) * (1.0 - this.viewWidth / pathLen);
        this.scale = Math.min(1.0, Math.max(0.01, 1.0 - y));
        this.fractionAlongPath = x;
    }

    public Point2D getPositionAlongPath() {
        return this.nearestPoint;
    }

    public double getFractionAlongPath() {
        return this.fractionAlongPath;
    }

    public double getScale() {
        return this.scale;
    }

    public Line2D getTangentSegmentAtPathPosition() {
        return this.nearestSeg;
    }
}

