/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import fr.inria.zvtm.animation.Animation;
import fr.inria.zvtm.animation.interpolation.IdentityInterpolator;
import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.VCursor;
import fr.inria.zvtm.engine.ViewPanel;
import fr.inria.zvtm.engine.portals.Portal;
import fr.inria.zvtm.event.PortalListener;
import fr.inria.zvtm.glyphs.ClosedShape;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.VSegment;
import fr.inria.zvtm.glyphs.VText;
import java.awt.Point;
import java.util.Vector;
import net.claribole.zgrviewer.GraphicsManager;
import net.claribole.zgrviewer.LEdge;
import net.claribole.zgrviewer.LNode;

public abstract class BaseEventHandler
implements PortalListener {
    protected static final float WHEEL_ZOOMOUT_FACTOR = 21.0f;
    protected static final float WHEEL_ZOOMIN_FACTOR = 22.0f;
    protected static final float ZOOM_SPEED_COEF = 0.02f;
    protected static final float PAN_SPEED_FACTOR = 50.0f;
    protected GraphicsManager grMngr;
    protected Camera activeCam;
    protected VSegment navSeg;
    protected boolean cursorNearBorder = false;
    protected int lastJPX;
    protected int lastJPY;
    protected double lastVX;
    protected double lastVY;
    protected int jpxD;
    protected int jpyD;
    protected double tfactor;
    protected double x1;
    protected double y1;
    protected double x2;
    protected double y2;
    protected double mvx;
    protected double mvy;
    protected int lx;
    protected int ly;
    protected boolean zoomingInRegion = false;
    protected boolean manualLeftButtonMove = false;
    protected boolean manualRightButtonMove = false;
    protected boolean autoZooming = false;
    protected double dragValue;
    protected boolean toolPaletteIsActive = false;
    protected boolean inZoomWindow = false;
    protected boolean inMagWindow = false;
    protected boolean draggingMagWindow = false;
    protected boolean draggingZoomWindow = false;
    protected boolean draggingZoomWindowContent = false;
    protected double LS_SX;
    protected double LS_SY;
    protected Point relative;
    boolean editingSpline = false;
    boolean movingEdgeLabelOrBox = false;
    boolean movingNode = false;

    public void enterPortal(Portal p) {
        this.inZoomWindow = true;
    }

    public void exitPortal(Portal p) {
        this.inZoomWindow = false;
    }

    protected void resetDragMagInteraction() {
        this.inMagWindow = false;
        this.inZoomWindow = false;
        this.draggingZoomWindow = false;
        this.draggingZoomWindowContent = false;
    }

    public void pressInEditMode(Glyph g, VCursor c, Camera cam, int mod) {
        Vector hoveredGlyphs = c.getPicker().getIntersectingGlyphs(cam);
        if (hoveredGlyphs != null && hoveredGlyphs.size() > 0) {
            for (Glyph g2 : hoveredGlyphs) {
                if (g2.getType() == null || !g2.getType().equals("sge")) continue;
                this.editingSpline = true;
                c.stickGlyph(g2);
                return;
            }
        }
        if (!this.attemptEditEdge(c, cam, mod)) {
            if (g != null) {
                this.grMngr.geom.clearSplineEditingGlyphs();
                if (g instanceof VText && g.getOwner() != null && g.getOwner() instanceof LEdge) {
                    this.movingEdgeLabelOrBox = true;
                    c.stickGlyph(g);
                } else if (g.getOwner() != null && g.getOwner() instanceof LNode) {
                    this.movingNode = true;
                    this.grMngr.geom.stickNodeComponents(g, (LNode)g.getOwner());
                    c.stickGlyph(g);
                } else if (g instanceof ClosedShape) {
                    this.movingEdgeLabelOrBox = true;
                    c.stickGlyph(g);
                } else {
                    this.attemptEditEdge(c, cam, mod);
                }
            } else {
                this.grMngr.geom.clearSplineEditingGlyphs();
            }
        }
    }

    public boolean attemptEditEdge(VCursor c, Camera cam, int mod) {
        Vector otherGlyphs = c.getPicker().getIntersectingGlyphs(cam);
        if (otherGlyphs != null && otherGlyphs.size() > 0) {
            for (Glyph eg : otherGlyphs) {
                if (eg.getOwner() == null || !(eg.getOwner() instanceof LEdge) || eg instanceof VText && mod != 1) continue;
                this.grMngr.geom.clearSplineEditingGlyphs();
                this.grMngr.geom.editEdgeSpline((LEdge)eg.getOwner());
                return true;
            }
        }
        return false;
    }

    protected void unzoom(ViewPanel v) {
        Animation a = this.grMngr.vsm.getAnimationManager().getAnimationFactory().createCameraAltAnim(300, v.cams[0], (double)new Float(this.grMngr.cfgMngr.autoUnzoomFactor * (v.cams[0].getAltitude() + v.cams[0].getFocal())).floatValue(), true, IdentityInterpolator.getInstance(), null);
        this.grMngr.vsm.getAnimationManager().startAnimation(a, false);
        this.autoZooming = false;
    }
}

