/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.designerconnection;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.StringUtils;

public final class DynamicLinkingHelper {
    private DynamicLinkingHelper() {
    }

    public static void getAllReachableProjects(List<IProject> referenceChain, IProject actualProject, List<IProject> knownProjects) {
        IProject[] referencedProjects;
        if (knownProjects.contains(actualProject)) {
            return;
        }
        if (referenceChain.contains(actualProject)) {
            knownProjects.add(actualProject);
            return;
        }
        if (actualProject.isAccessible()) {
            try {
                referencedProjects = actualProject.getReferencedProjects();
            }
            catch (CoreException e) {
                referencedProjects = new IProject[]{};
            }
        } else {
            referencedProjects = new IProject[]{};
        }
        if (0 == referencedProjects.length) {
            knownProjects.add(actualProject);
        }
        int oldSize = referenceChain.size();
        referenceChain.add(actualProject);
        for (IProject tempProject : referencedProjects) {
            DynamicLinkingHelper.getAllReachableProjects(referenceChain, tempProject, knownProjects);
        }
        referenceChain.remove(oldSize);
        if (!knownProjects.contains(actualProject)) {
            knownProjects.add(actualProject);
        }
    }

    public static IProject getProject(String projectName) {
        IProject[] projects;
        if (StringUtils.isNullOrEmpty((String)projectName)) {
            return null;
        }
        for (IProject project : projects = ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            if (!project.isAccessible() || !project.getName().equals(projectName)) continue;
            try {
                if (!project.hasNature("org.eclipse.titan.designer.core.TITANNature")) continue;
                return project;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
        return null;
    }
}

