/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.designerconnection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathConverter;
import org.eclipse.titan.executor.TITANDebugConsole;
import org.eclipse.titan.executor.designerconnection.DesignerHelper;
import org.eclipse.titan.executor.designerconnection.DynamicLinkingHelper;
import org.eclipse.ui.console.MessageConsole;

public final class EnvironmentHelper {
    public static final String TTCN_3_DIR = "TTCN3_DIR";
    public static final String LD_LIBRARY_PATH = "LD_LIBRARY_PATH";

    private EnvironmentHelper() {
    }

    public static Map<String, String> resolveVariables(HashMap<String, String> originalVariables) throws CoreException {
        HashMap<String, String> env = new HashMap<String, String>(originalVariables.size());
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        for (Map.Entry<String, String> variable : originalVariables.entrySet()) {
            String finalValue;
            if (null == variable.getValue() || null == (finalValue = manager.performStringSubstitution(variable.getValue()))) continue;
            env.put(variable.getKey(), finalValue);
        }
        return env;
    }

    public static Map<String, String> resolveVariables(Map<String, String> originalVariables, Map<String, String> additionalVariables) throws CoreException {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        for (Map.Entry<String, String> variable : additionalVariables.entrySet()) {
            String finalValue;
            if (null == variable.getValue() || null == (finalValue = manager.performStringSubstitution(variable.getValue()))) continue;
            originalVariables.put(variable.getKey(), finalValue);
        }
        return originalVariables;
    }

    public static String getTitanPath(Map<String, String> env) {
        if (env.containsKey(TTCN_3_DIR)) {
            return env.get(TTCN_3_DIR);
        }
        String temp = DesignerHelper.getTTCN3DIR();
        if (null == temp || 0 == temp.trim().length()) {
            return temp;
        }
        return PathConverter.convert((String)temp, (boolean)true, (MessageConsole)TITANDebugConsole.getConsole());
    }

    public static Map<String, String> setTitanPath(Map<String, String> env) {
        if (env.containsKey(TTCN_3_DIR)) {
            return env;
        }
        String temp = DesignerHelper.getTTCN3DIR();
        if (null == temp || 0 == temp.trim().length()) {
            return env;
        }
        temp = PathConverter.convert((String)temp, (boolean)true, (MessageConsole)TITANDebugConsole.getConsole());
        env.put(TTCN_3_DIR, temp);
        return env;
    }

    public static Map<String, String> set_LICENSE_FILE_PATH(Map<String, String> env) {
        if (env.containsKey("TTCN3_LICENSE_FILE")) {
            return env;
        }
        String temp = DesignerHelper.getTTCN3LICENSEFILE();
        if (null == temp || 0 == temp.trim().length()) {
            return env;
        }
        temp = PathConverter.convert((String)temp, (boolean)true, (MessageConsole)TITANDebugConsole.getConsole());
        env.put("TTCN3_LICENSE_FILE", temp);
        return env;
    }

    public static Map<String, String> set_LD_LIBRARY_PATH(IProject actualProject, Map<String, String> env) {
        StringBuilder workingDirectories = new StringBuilder();
        if (null != actualProject) {
            ArrayList<IProject> knownProjects = new ArrayList<IProject>();
            DynamicLinkingHelper.getAllReachableProjects(new ArrayList<IProject>(), actualProject, knownProjects);
            for (IProject tempProject : knownProjects) {
                try {
                    String workingdirectory = tempProject.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "workingDir"));
                    String projectPath = actualProject.getLocation().toString();
                    workingDirectories.append(':').append(PathConverter.convert((String)(projectPath + "/" + workingdirectory), (boolean)true, (MessageConsole)TITANDebugConsole.getConsole()));
                }
                catch (CoreException e) {
                    ErrorReporter.logError((String)("The working directory of project " + tempProject.getName() + " could not be determined"));
                }
            }
            String libraryPath = env.get(LD_LIBRARY_PATH);
            libraryPath = libraryPath == null ? "" : libraryPath;
            String titanPath = EnvironmentHelper.getTitanPath(env);
            String newLibraryPath = libraryPath + workingDirectories.toString() + (titanPath.length() > 0 ? ":" + titanPath + "/lib" : "");
            env.put(LD_LIBRARY_PATH, newLibraryPath);
        }
        return env;
    }
}

