/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.executors.jni;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.titan.common.product.ProductIdentity;
import org.eclipse.titan.executor.executors.TitanLaunchConfigurationDelegate;
import org.eclipse.titan.executor.executors.jni.JniExecutor;
import org.eclipse.titan.executor.jni.JNIMiddleWare;

public final class LaunchConfigurationDelegate
extends TitanLaunchConfigurationDelegate {
    private final ProductIdentity versionLow = ProductIdentity.getProductIdentity((String)"CRL 113 200", (int)5, (int)5, (int)1, (int)0);
    private final ProductIdentity versionHigh = ProductIdentity.getProductIdentity((String)"CRL 113 200", (int)5, (int)5, (int)1, (int)0);

    public void launch(ILaunchConfiguration arg0, String arg1, ILaunch arg2, IProgressMonitor arg3) throws CoreException {
        Exception exception = JNIMiddleWare.getException();
        if (null != exception) {
            Status status = new Status(4, "org.eclipse.titan.executor", 0, exception.getMessage(), (Throwable)exception);
            throw new CoreException((IStatus)status);
        }
        long version = JNIMiddleWare.getSharedLibraryVersion();
        ProductIdentity currentVersion = ProductIdentity.getProductIdentity((String)"CRL 113 200", (long)version);
        if (this.versionLow.compareTo(currentVersion) > 0 || this.versionHigh.compareTo(currentVersion) < 0) {
            Status status = this.versionLow.equals((Object)this.versionHigh) ? new Status(4, "org.eclipse.titan.executor", 0, "Bad version of JNI dynamic library detected.\nSupported version: " + this.versionHigh + "\n" + "Current version: " + currentVersion, null) : new Status(4, "org.eclipse.titan.executor", 0, "Bad version of JNI dynamic library detected.\nSupported versions: " + this.versionLow + " - " + this.versionHigh + "\n" + "Current version: " + currentVersion, null);
            throw new CoreException((IStatus)status);
        }
        if (JniExecutor.isRunning()) {
            Status status = new Status(4, "org.eclipse.titan.executor", 0, "The Jni based launcher is already running.\nOnly one instance can be running at any time.", null);
            throw new CoreException((IStatus)status);
        }
        this.showExecutionPerspective();
        JniExecutor executor = new JniExecutor(arg0);
        executor.startSession(arg2);
    }
}

