/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.animation.examples;

import fr.inria.zvtm.animation.Animation;
import fr.inria.zvtm.animation.AnimationManager;
import fr.inria.zvtm.animation.DefaultTimingHandler;
import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.engine.ViewPanel;
import fr.inria.zvtm.engine.VirtualSpace;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.event.ViewListener;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.VCircle;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import org.jdesktop.animation.timing.interpolation.Interpolator;
import org.jdesktop.animation.timing.interpolation.SplineInterpolator;

public class TestMultipleGlyphs {
    VirtualSpaceManager vsm = VirtualSpaceManager.INSTANCE;
    VirtualSpace vs;
    ViewListener eh;
    View testView;
    Camera cam;

    TestMultipleGlyphs(String vt) {
        VirtualSpaceManager.setDebug(true);
        this.initTest(vt);
    }

    public void initTest(String vt) {
        this.eh = new MyEventHandler(this);
        this.vs = this.vsm.addVirtualSpace("src");
        this.cam = this.vs.addCamera();
        Vector<Camera> cameras = new Vector<Camera>();
        cameras.add(this.cam);
        this.cam.setZoomFloor(-90.0);
        this.testView = this.vsm.addFrameView(cameras, "Test", vt, 800, 600, true);
        this.testView.setBackgroundColor(Color.LIGHT_GRAY);
        this.testView.setListener(this.eh);
        this.cam.setAltitude(50.0);
        AnimationManager am = this.vsm.getAnimationManager();
        int NB_GLYPHS = 100;
        ArrayList circles = new ArrayList();
        Random rnd = new Random();
        for (int i = 0; i < 100; ++i) {
            final VCircle circle = new VCircle(63 * i, 30 * i, 0, 30.0, Color.getHSBColor(rnd.nextFloat(), rnd.nextFloat(), rnd.nextFloat()));
            circles.add(circle);
            this.vs.addGlyph(circle);
            Animation anim = am.getAnimationFactory().createAnimation(3000, -1.0, Animation.RepeatBehavior.REVERSE, circle, Animation.Dimension.POSITION, new DefaultTimingHandler(){
                final double initX;
                final double initY;
                {
                    this.initX = circle.vx;
                    this.initY = circle.vy;
                }

                @Override
                public void timingEvent(float fraction, Object subject, Animation.Dimension dim) {
                    Glyph g = (Glyph)subject;
                    g.moveTo(this.initX, (double)(1.0f - fraction) * this.initY);
                }
            }, (Interpolator)new SplineInterpolator(0.1f, 0.95f, 0.2f, 0.95f));
            anim.setStartFraction(rnd.nextFloat());
            am.startAnimation(anim, false);
        }
    }

    public static void main(String[] args) {
        System.out.println("-----------------");
        System.out.println("General information");
        System.out.println("JVM version: " + System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version"));
        System.out.println("OS type: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "/" + System.getProperty("os.arch") + " " + System.getProperty("sun.cpu.isalist"));
        System.out.println("-----------------");
        System.out.println("Directory information");
        System.out.println("Java Classpath: " + System.getProperty("java.class.path"));
        System.out.println("Java directory: " + System.getProperty("java.home"));
        System.out.println("Launching from: " + System.getProperty("user.dir"));
        System.out.println("-----------------");
        System.out.println("User informations");
        System.out.println("User name: " + System.getProperty("user.name"));
        System.out.println("User home directory: " + System.getProperty("user.home"));
        System.out.println("-----------------");
        new TestMultipleGlyphs(args.length > 0 ? args[0] : "std");
    }

    class MyEventHandler
    implements ViewListener {
        TestMultipleGlyphs application;
        int lastJPX;
        int lastJPY;

        MyEventHandler(TestMultipleGlyphs appli) {
            this.application = appli;
        }

        @Override
        public void press1(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        }

        @Override
        public void release1(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        }

        @Override
        public void click1(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
        }

        @Override
        public void press2(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        }

        @Override
        public void release2(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        }

        @Override
        public void click2(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
        }

        @Override
        public void press3(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
            this.lastJPX = jpx;
            this.lastJPY = jpy;
            v.setDrawDrag(true);
            this.application.vsm.getActiveView().mouse.setSensitivity(false);
        }

        @Override
        public void release3(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
            this.application.cam.setXspeed(0.0);
            this.application.cam.setYspeed(0.0);
            this.application.cam.setZspeed(0.0);
            v.setDrawDrag(false);
            this.application.vsm.getActiveView().mouse.setSensitivity(true);
        }

        @Override
        public void click3(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
        }

        @Override
        public void mouseMoved(ViewPanel v, int jpx, int jpy, MouseEvent e) {
        }

        @Override
        public void mouseDragged(ViewPanel v, int mod, int buttonNumber, int jpx, int jpy, MouseEvent e) {
            if (buttonNumber == 3 || (mod == 4 || mod == 5) && buttonNumber == 1) {
                Camera c = this.application.vsm.getActiveCamera();
                double a = (c.focal + Math.abs(c.altitude)) / c.focal;
                if (mod == 5) {
                    this.application.cam.setXspeed(0.0);
                    this.application.cam.setYspeed(0.0);
                    this.application.cam.setZspeed(c.altitude > 0.0 ? (double)(this.lastJPY - jpy) * (a / 50.0) : (double)(this.lastJPY - jpy) / (a * 50.0));
                } else {
                    this.application.cam.setXspeed(c.altitude > 0.0 ? (double)(jpx - this.lastJPX) * (a / 50.0) : (double)(jpx - this.lastJPX) / (a * 50.0));
                    this.application.cam.setYspeed(c.altitude > 0.0 ? (double)(this.lastJPY - jpy) * (a / 50.0) : (double)(this.lastJPY - jpy) / (a * 50.0));
                    this.application.cam.setZspeed(0.0);
                }
            }
        }

        @Override
        public void mouseWheelMoved(ViewPanel v, short wheelDirection, int jpx, int jpy, MouseWheelEvent e) {
            Camera c = this.application.vsm.getActiveCamera();
            double a = (c.focal + Math.abs(c.altitude)) / c.focal;
            if (wheelDirection == 1) {
                c.altitudeOffset(-a * 5.0);
                this.application.vsm.repaint();
            } else {
                c.altitudeOffset(a * 5.0);
                this.application.vsm.repaint();
            }
        }

        @Override
        public void enterGlyph(Glyph g) {
            g.highlight(true, null);
        }

        @Override
        public void exitGlyph(Glyph g) {
            g.highlight(false, null);
        }

        @Override
        public void Ktype(ViewPanel v, char c, int code, int mod, KeyEvent e) {
        }

        @Override
        public void Kpress(ViewPanel v, char c, int code, int mod, KeyEvent e) {
        }

        @Override
        public void Krelease(ViewPanel v, char c, int code, int mod, KeyEvent e) {
        }

        @Override
        public void viewActivated(View v) {
        }

        @Override
        public void viewDeactivated(View v) {
        }

        @Override
        public void viewIconified(View v) {
        }

        @Override
        public void viewDeiconified(View v) {
        }

        @Override
        public void viewClosing(View v) {
            System.exit(0);
        }
    }
}

