/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.engine;

import fr.inria.zvtm.animation.Animation;
import fr.inria.zvtm.animation.AnimationFactory;
import fr.inria.zvtm.animation.AnimationManager;
import fr.inria.zvtm.animation.interpolation.IdentityInterpolator;
import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.engine.VirtualSpace;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.RectangularShape;
import fr.inria.zvtm.glyphs.VImage;
import fr.inria.zvtm.glyphs.VRectangle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.ImageIcon;

public class ScrollLayer
implements ComponentListener {
    static final Color PASTEL_BLUE = new Color(122, 120, 156);
    int MIN_SLIDER_SIZE = 5;
    Camera controlledCamera;
    View controlledView;
    Camera slC;
    VirtualSpace slVS;
    String slVSname;
    Glyph vgutter;
    Glyph vslider;
    Glyph upBt;
    Glyph downBt;
    RectangularShape vgutterRS;
    RectangularShape vsliderRS;
    RectangularShape upBtRS;
    RectangularShape downBtRS;
    Glyph hgutter;
    Glyph hslider;
    Glyph leftBt;
    Glyph rightBt;
    RectangularShape hgutterRS;
    RectangularShape hsliderRS;
    RectangularShape leftBtRS;
    RectangularShape rightBtRS;
    double[] observedRegionBounds = new double[4];
    double[] populatedRegionBounds = new double[4];
    int panelWidth;
    int panelHeight;
    static final String SCROLLSPACE_NAME_PREFIX = "scrollspace";

    public ScrollLayer(Camera cc) {
        this.controlledCamera = cc;
        this.slVSname = SCROLLSPACE_NAME_PREFIX + this.controlledCamera.hashCode();
        this.slVS = VirtualSpaceManager.INSTANCE.addVirtualSpace(this.slVSname);
        this.slC = this.slVS.addCamera();
        this.vgutter = new VRectangle(0.0, 0.0, 0, 8.0, 8.0, Color.WHITE, PASTEL_BLUE, 1.0f);
        this.vslider = new VRectangle(0.0, 0.0, 0, 8.0, 8.0, PASTEL_BLUE, PASTEL_BLUE, 1.0f);
        this.upBt = new VImage(new ImageIcon(this.getClass().getResource("/images/button_up_16x16.png")).getImage());
        this.downBt = new VImage(new ImageIcon(this.getClass().getResource("/images/button_down_16x16.png")).getImage());
        this.hgutter = new VRectangle(0.0, 0.0, 0, 8.0, 8.0, Color.WHITE, PASTEL_BLUE, 1.0f);
        this.hslider = new VRectangle(0.0, 0.0, 0, 8.0, 8.0, PASTEL_BLUE, PASTEL_BLUE, 1.0f);
        this.leftBt = new VImage(new ImageIcon(this.getClass().getResource("/images/button_left_16x16.png")).getImage());
        this.rightBt = new VImage(new ImageIcon(this.getClass().getResource("/images/button_right_16x16.png")).getImage());
        this.vgutterRS = (RectangularShape)((Object)this.vgutter);
        this.vsliderRS = (RectangularShape)((Object)this.vslider);
        this.upBtRS = (RectangularShape)((Object)this.upBt);
        this.downBtRS = (RectangularShape)((Object)this.downBt);
        this.hgutterRS = (RectangularShape)((Object)this.hgutter);
        this.hsliderRS = (RectangularShape)((Object)this.hslider);
        this.leftBtRS = (RectangularShape)((Object)this.leftBt);
        this.rightBtRS = (RectangularShape)((Object)this.rightBt);
        this.slVS.addGlyph(this.vgutter);
        this.slVS.addGlyph(this.vslider);
        this.slVS.addGlyph(this.upBt);
        this.slVS.addGlyph(this.downBt);
        this.slVS.addGlyph(this.hgutter);
        this.slVS.addGlyph(this.hslider);
        this.slVS.addGlyph(this.leftBt);
        this.slVS.addGlyph(this.rightBt);
    }

    public ScrollLayer(Camera cc, Glyph[] widgets) {
        this.controlledCamera = cc;
        this.slVSname = SCROLLSPACE_NAME_PREFIX + this.controlledCamera.hashCode();
        this.slVS = VirtualSpaceManager.INSTANCE.addVirtualSpace(this.slVSname);
        this.slC = this.slVS.addCamera();
        this.vgutter = widgets[0];
        this.vslider = widgets[1];
        this.upBt = widgets[2];
        this.downBt = widgets[3];
        this.hgutter = widgets[4];
        this.hslider = widgets[5];
        this.leftBt = widgets[6];
        this.rightBt = widgets[7];
        this.vgutterRS = (RectangularShape)((Object)this.vgutter);
        this.vsliderRS = (RectangularShape)((Object)this.vslider);
        this.upBtRS = (RectangularShape)((Object)this.upBt);
        this.downBtRS = (RectangularShape)((Object)this.downBt);
        this.hgutterRS = (RectangularShape)((Object)this.hgutter);
        this.hsliderRS = (RectangularShape)((Object)this.hslider);
        this.leftBtRS = (RectangularShape)((Object)this.leftBt);
        this.rightBtRS = (RectangularShape)((Object)this.rightBt);
        this.vgutter.setSensitivity(false);
        this.hgutter.setSensitivity(false);
        this.slVS.addGlyph(this.vgutter);
        this.slVS.addGlyph(this.vslider);
        this.slVS.addGlyph(this.upBt);
        this.slVS.addGlyph(this.downBt);
        this.slVS.addGlyph(this.hgutter);
        this.slVS.addGlyph(this.hslider);
        this.slVS.addGlyph(this.leftBt);
        this.slVS.addGlyph(this.rightBt);
    }

    public void setView(View v) {
        this.controlledView = v;
        this.controlledView.getPanel().getComponent().addComponentListener(this);
        this.updateViewSize(v.getPanel().getComponent());
        this.updateScrollBars();
    }

    public void setMinimumSliderSize(int s) {
        this.MIN_SLIDER_SIZE = s / 2;
        this.updateScrollBars();
    }

    public void virtualSpaceUpdated() {
        this.controlledCamera.getOwningSpace().findFarmostGlyphCoords(this.populatedRegionBounds);
        this.updateScrollBars();
    }

    public void cameraUpdated() {
        this.controlledView.getVisibleRegion(this.controlledCamera, this.observedRegionBounds);
        this.updateScrollBars();
    }

    void updateWidgetInvariants() {
        this.vgutter.vx = this.vslider.vx = (double)Math.round(Math.ceil((double)this.panelWidth / 2.0 - this.vgutterRS.getWidth()));
        this.downBt.vx = this.vslider.vx;
        this.upBt.vx = this.vslider.vx;
        this.upBt.vy = Math.round(Math.floor((double)this.panelHeight / 2.0 - this.upBtRS.getHeight()));
        this.downBt.vy = Math.round(Math.ceil((double)(-this.panelHeight) / 2.0 + this.downBtRS.getHeight() + 2.0 * this.hgutterRS.getHeight()));
        this.vgutter.vy = Math.round(Math.ceil((this.upBt.vy + this.downBt.vy) / 2.0));
        this.vgutterRS.setHeight(Math.round(Math.ceil((double)this.panelHeight / 2.0 - this.hgutterRS.getHeight() - this.upBtRS.getHeight() - this.downBtRS.getHeight())));
        this.hgutter.vy = this.hslider.vy = (double)Math.round(Math.floor((double)(-this.panelHeight) / 2.0 + this.hgutterRS.getHeight()));
        this.rightBt.vy = this.hslider.vy;
        this.leftBt.vy = this.hslider.vy;
        this.leftBt.vx = Math.round(Math.ceil((double)(-this.panelWidth) / 2.0 + this.leftBtRS.getWidth()));
        this.rightBt.vx = Math.round(Math.ceil((double)this.panelWidth / 2.0 - this.rightBtRS.getWidth() - 2.0 * this.vgutterRS.getWidth()));
        this.hgutter.vx = Math.round(Math.ceil((this.leftBt.vx + this.rightBt.vx) / 2.0));
        this.hgutterRS.setWidth(Math.round(Math.ceil((double)this.panelWidth / 2.0 - this.vgutterRS.getWidth() - this.leftBtRS.getWidth() - this.rightBtRS.getWidth())));
    }

    public void updateScrollBars() {
        this.updateVerticalScrollBar();
        this.updateHorizontalScrollBar();
    }

    public void updateVerticalScrollBar() {
        double ratio;
        double sliderSize;
        double totalHeight = this.populatedRegionBounds[1] - this.populatedRegionBounds[3];
        double observedHeight = this.observedRegionBounds[1] - this.observedRegionBounds[3];
        if (totalHeight < observedHeight) {
            observedHeight = totalHeight;
        }
        if ((sliderSize = (double)Math.round((ratio = observedHeight / totalHeight) * this.vgutterRS.getHeight())) < (double)this.MIN_SLIDER_SIZE) {
            sliderSize = this.MIN_SLIDER_SIZE;
        }
        this.vsliderRS.setHeight(sliderSize);
        double y = Math.round(2.0 * (this.controlledCamera.vy - (this.populatedRegionBounds[1] + this.populatedRegionBounds[3]) / 2.0) / (this.populatedRegionBounds[1] - this.populatedRegionBounds[3]) * this.vgutterRS.getHeight());
        if (y > this.upBt.vy - this.upBtRS.getHeight() - sliderSize) {
            y = this.upBt.vy - this.upBtRS.getHeight() - sliderSize;
        } else if (y < this.downBt.vy + this.downBtRS.getHeight() + sliderSize) {
            y = this.downBt.vy + this.downBtRS.getHeight() + sliderSize;
        }
        this.vslider.vy = y;
    }

    public void updateHorizontalScrollBar() {
        double ratio;
        double sliderSize;
        double totalWidth = this.populatedRegionBounds[2] - this.populatedRegionBounds[0];
        double observedWidth = this.observedRegionBounds[2] - this.observedRegionBounds[0];
        if (totalWidth < observedWidth) {
            observedWidth = totalWidth;
        }
        if ((sliderSize = (double)Math.round((ratio = observedWidth / totalWidth) * this.hgutterRS.getWidth())) < (double)this.MIN_SLIDER_SIZE) {
            sliderSize = this.MIN_SLIDER_SIZE;
        }
        this.hsliderRS.setWidth(sliderSize);
        double x = Math.round(2.0 * (this.controlledCamera.vx - (this.populatedRegionBounds[2] + this.populatedRegionBounds[0]) / 2.0) / (this.populatedRegionBounds[2] - this.populatedRegionBounds[0]) * this.hgutterRS.getWidth());
        if (x > this.rightBt.vx - this.rightBtRS.getWidth() - sliderSize) {
            x = this.rightBt.vx - this.rightBtRS.getWidth() - sliderSize;
        } else if (x < this.leftBt.vx + this.leftBtRS.getWidth() + sliderSize) {
            x = this.leftBt.vx + this.leftBtRS.getWidth() + sliderSize;
        }
        this.hslider.vx = x;
    }

    void updateCameraVerticalPosition() {
        this.controlledCamera.moveTo(this.controlledCamera.vx, Math.round(this.vslider.vy * (this.populatedRegionBounds[1] - this.populatedRegionBounds[3]) / (2.0 * this.vgutterRS.getHeight()) + (this.populatedRegionBounds[1] + this.populatedRegionBounds[3]) / 2.0));
    }

    void updateCameraHorizontalPosition() {
        this.controlledCamera.moveTo(Math.round(this.hslider.vx * (this.populatedRegionBounds[2] - this.populatedRegionBounds[0]) / (2.0 * this.hgutterRS.getWidth()) + (this.populatedRegionBounds[2] + this.populatedRegionBounds[0]) / 2.0), this.controlledCamera.vy);
    }

    public boolean cursorInside(int cx, int cy) {
        double coef = (this.slC.focal + this.slC.altitude) / this.slC.focal;
        double vx = Math.round((double)(cx - this.panelWidth / 2) * coef + this.slC.vx);
        double vy = Math.round((double)(this.panelHeight / 2 - cy) * coef + this.slC.vy);
        return vx > this.vgutter.vx - this.vgutterRS.getWidth() || vy < this.hgutter.vy + this.hgutterRS.getHeight();
    }

    public Camera getWidgetCamera() {
        return this.slC;
    }

    public Camera getControlledCamera() {
        return this.controlledCamera;
    }

    public void draggingHorizontalSlider(int dx) {
        if (this.hslider.vx + (double)dx + this.hsliderRS.getWidth() < this.rightBt.vx - this.rightBtRS.getWidth() && this.hslider.vx + (double)dx - this.hsliderRS.getWidth() > this.leftBt.vx + this.leftBtRS.getWidth()) {
            this.hslider.move(dx, 0.0);
            this.updateCameraHorizontalPosition();
        }
    }

    public void draggingVerticalSlider(int dy) {
        if (this.vslider.vy + (double)dy + this.vsliderRS.getHeight() < this.upBt.vy - this.upBtRS.getHeight() && this.vslider.vy + (double)dy - this.vsliderRS.getHeight() > this.downBt.vy + this.downBtRS.getHeight()) {
            this.vslider.move(0.0, dy);
            this.updateCameraVerticalPosition();
        }
    }

    public void moveUp() {
        double dy = this.vsliderRS.getHeight();
        if (this.vslider.vy + dy + this.vsliderRS.getHeight() < this.upBt.vy - this.upBtRS.getHeight() && this.vslider.vy + dy - this.vsliderRS.getHeight() > this.downBt.vy + this.downBtRS.getHeight()) {
            this.vslider.move(0.0, dy);
            this.updateCameraVerticalPosition();
        } else {
            this.vslider.moveTo(this.vslider.vx, this.upBt.vy - this.upBtRS.getHeight() - this.vsliderRS.getHeight());
            this.updateCameraVerticalPosition();
        }
    }

    public void moveDown() {
        double dy = -this.vsliderRS.getHeight();
        if (this.vslider.vy + dy + this.vsliderRS.getHeight() < this.upBt.vy - this.upBtRS.getHeight() && this.vslider.vy + dy - this.vsliderRS.getHeight() > this.downBt.vy + this.downBtRS.getHeight()) {
            this.vslider.move(0.0, dy);
            this.updateCameraVerticalPosition();
        } else {
            this.vslider.moveTo(this.vslider.vx, this.downBt.vy + this.downBtRS.getHeight() + this.vsliderRS.getHeight());
            this.updateCameraVerticalPosition();
        }
    }

    public void moveLeft() {
        double dx = -this.hsliderRS.getWidth();
        if (this.hslider.vx + dx + this.hsliderRS.getWidth() < this.rightBt.vx - this.rightBtRS.getWidth() && this.hslider.vx + dx - this.hsliderRS.getWidth() > this.leftBt.vx + this.leftBtRS.getWidth()) {
            this.hslider.move(dx, 0.0);
            this.updateCameraHorizontalPosition();
        } else {
            this.hslider.moveTo(this.leftBt.vx + this.leftBtRS.getWidth() + this.hsliderRS.getWidth(), this.hslider.vy);
            this.updateCameraHorizontalPosition();
        }
    }

    public void moveRight() {
        double dx = this.hsliderRS.getWidth();
        if (this.hslider.vx + dx + this.hsliderRS.getWidth() < this.rightBt.vx - this.rightBtRS.getWidth() && this.hslider.vx + dx - this.hsliderRS.getWidth() > this.leftBt.vx + this.leftBtRS.getWidth()) {
            this.hslider.move(dx, 0.0);
            this.updateCameraHorizontalPosition();
        } else {
            this.hslider.moveTo(this.rightBt.vx - this.rightBtRS.getWidth() - this.hsliderRS.getWidth(), this.hslider.vy);
            this.updateCameraHorizontalPosition();
        }
    }

    public Glyph getVerticalSlider() {
        return this.vslider;
    }

    public Glyph getHorizontalSlider() {
        return this.hslider;
    }

    public Glyph getUpButton() {
        return this.upBt;
    }

    public Glyph getDownButton() {
        return this.downBt;
    }

    public Glyph getLeftButton() {
        return this.leftBt;
    }

    public Glyph getRightButton() {
        return this.rightBt;
    }

    public void fade(AnimationManager am, int duration, float alphaOffset) throws ClassCastException {
        Glyph[] wids;
        AnimationFactory fac = am.getAnimationFactory();
        for (Glyph g : wids = new Glyph[]{this.vgutter, this.vslider, this.upBt, this.downBt, this.hgutter, this.hslider, this.rightBt, this.leftBt}) {
            Animation anim = fac.createTranslucencyAnim(duration, g, alphaOffset, true, IdentityInterpolator.getInstance(), null);
            am.startAnimation(anim, false);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updateViewSize(e.getComponent());
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    void updateViewSize(Component c) {
        Dimension d = c.getSize();
        this.panelWidth = d.width;
        this.panelHeight = d.height;
        this.updateWidgetInvariants();
        this.cameraUpdated();
    }
}

