/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.GlyphIcon;
import fr.inria.zvtm.glyphs.VEllipse;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

class IcEllipse
extends GlyphIcon
implements Icon {
    VEllipse glyph;
    double rW;
    double rH;
    int trW;
    int trH;
    double factor;

    IcEllipse(VEllipse g, int w, int h) {
        this.glyph = g;
        this.width = w;
        this.height = h;
    }

    @Override
    public void setGlyph(Glyph g) {
        this.glyph = (VEllipse)g;
    }

    @Override
    public Glyph getGlyph() {
        return this.glyph;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.cWidth = c.getWidth() / 2;
        this.cHeight = c.getHeight() / 2;
        this.rW = this.glyph.getWidth();
        this.rH = this.glyph.getHeight();
        this.factor = Math.max(this.rW / (double)this.width, this.rH / (double)this.height);
        this.trW = (int)Math.round(this.rW / (this.factor * 2.0)) - 2;
        this.trH = (int)Math.round(this.rH / (this.factor * 2.0)) - 2;
        if (this.glyph.isFilled()) {
            g.setColor(this.glyph.getColor());
            g.fillOval(this.cWidth - this.trW, this.cHeight - this.trH, 2 * this.trW, 2 * this.trH);
        }
        g.setColor(this.glyph.getBorderColor());
        g.drawOval(this.cWidth - this.trW, this.cHeight - this.trH, 2 * this.trW, 2 * this.trH);
    }
}

