/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.glyphs.Glyph;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;

public class SemZoomGlyph<T>
extends Glyph {
    private final ArrayList<Glyph> glyphs;
    private final ArrayList<Double> transitions;

    public SemZoomGlyph(List<Glyph> glyphs, List<Double> transitions) {
        if (glyphs == null) {
            throw new IllegalArgumentException("null array of Glyphs");
        }
        if (transitions.size() != glyphs.size() - 1) {
            throw new IllegalArgumentException("incorrect number of transitions (" + (glyphs.size() - 1) + " transitions expected)");
        }
        this.glyphs = new ArrayList<Glyph>(glyphs);
        this.transitions = new ArrayList<Double>(transitions);
    }

    @Override
    public boolean fillsView(double w, double h, int camIndex) {
        return false;
    }

    @Override
    public short mouseInOut(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        return 0;
    }

    @Override
    public void resetMouseIn() {
    }

    @Override
    public void resetMouseIn(int i) {
    }

    @Override
    public boolean coordInside(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        return true;
    }

    @Override
    public void removeCamera(int index) {
        for (Glyph glyph : this.glyphs) {
            glyph.removeCamera(index);
        }
    }

    @Override
    public void addCamera(int index) {
        for (Glyph glyph : this.glyphs) {
            glyph.addCamera(index);
        }
    }

    @Override
    public void initCams(int nbCam) {
        for (Glyph glyph : this.glyphs) {
            glyph.initCams(nbCam);
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        Glyph glyph = this.selectChild(i);
        glyph.drawForLens(g, vW, vH, i, stdS, stdT, dx, dy);
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        Glyph glyph = this.selectChild(i);
        glyph.draw(g, vW, vH, i, stdS, stdT, dx, dy);
    }

    @Override
    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, double lensx, double lensy) {
        for (Glyph glyph : this.glyphs) {
            glyph.projectForLens(c, lensWidth, lensHeight, lensMag, lensx, lensy);
        }
    }

    @Override
    public void project(Camera c, Dimension d) {
    }

    @Override
    public void highlight(boolean b, Color selectedColor) {
    }

    @Override
    public void orientTo(double angle) {
    }

    @Override
    public double getOrient() {
        return 0.0;
    }

    @Override
    public void reSize(double factor) {
    }

    @Override
    public void sizeTo(double newSize) {
    }

    @Override
    public void move(double dx, double dy) {
    }

    @Override
    public void moveTo(double x, double y) {
    }

    @Override
    public double getSize() {
        return 10.0;
    }

    protected Glyph selectChild(int camIndex) {
        return null;
    }

    @Override
    public Shape getJava2DShape() {
        return null;
    }
}

