/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.ClosedShape;
import fr.inria.zvtm.glyphs.RectangularShape;
import fr.inria.zvtm.glyphs.projection.RProjectedCoordsP;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class VImage<T>
extends ClosedShape
implements RectangularShape {
    public double vw;
    public double vh;
    public double ar;
    public AffineTransform at;
    public RProjectedCoordsP[] pc;
    public Image image;
    public boolean zoomSensitive = true;
    public double scaleFactor = 1.0;
    public double trueCoef = 1.0;
    public Object interpolationMethod = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;

    public VImage(Image img) {
        this(0.0, 0.0, 0, img, 1.0, 1.0f);
    }

    public VImage(double x, double y, int z, Image img) {
        this(x, y, z, img, 1.0, 1.0f);
    }

    public VImage(double x, double y, int z, Image img, double scale) {
        this(x, y, z, img, scale, 1.0f);
    }

    public VImage(double x, double y, int z, Image img, double scale, float alpha) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.image = img;
        this.vw = (double)this.image.getWidth(null) * scale;
        this.vh = (double)this.image.getHeight(null) * scale;
        this.ar = this.vw == 0.0 && this.vh == 0.0 ? 1.0 : this.vw / this.vh;
        this.computeSize();
        this.orient = 0.0;
        this.setBorderColor(Color.black);
        this.scaleFactor = scale;
        this.setTranslucencyValue(alpha);
    }

    @Override
    public void initCams(int nbCam) {
        this.pc = new RProjectedCoordsP[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new RProjectedCoordsP();
        }
    }

    @Override
    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                RProjectedCoordsP[] ta = this.pc;
                this.pc = new RProjectedCoordsP[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new RProjectedCoordsP();
            } else {
                System.err.println("VImage:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new RProjectedCoordsP[1];
            this.pc[0] = new RProjectedCoordsP();
        } else {
            System.err.println("VImage:Error while adding camera " + verifIndex);
        }
    }

    @Override
    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    @Override
    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    @Override
    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
        this.borderColor = this.bColor;
    }

    @Override
    public double getOrient() {
        return this.orient;
    }

    @Override
    public void orientTo(double angle) {
    }

    @Override
    public double getSize() {
        return this.size;
    }

    void computeSize() {
        this.size = Math.sqrt(this.vw * this.vw + this.vh * this.vh);
    }

    public void setScale(double s) {
        this.scaleFactor = s;
        this.vw = (double)this.image.getWidth(null) * this.scaleFactor;
        this.vh = (double)this.image.getHeight(null) * this.scaleFactor;
        this.computeSize();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    public double getScale() {
        return this.scaleFactor;
    }

    @Override
    public void setWidth(double w) {
        this.vw = w;
        this.vh = this.vw / this.ar;
        this.computeSize();
        this.scaleFactor = this.size / Math.sqrt(Math.pow(this.image.getWidth(null), 2.0) + Math.pow(this.image.getHeight(null), 2.0));
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void setHeight(double h) {
        this.vh = h;
        this.vw = this.vh * this.ar;
        this.computeSize();
        this.scaleFactor = this.size / Math.sqrt(Math.pow(this.image.getWidth(null), 2.0) + Math.pow(this.image.getHeight(null), 2.0));
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public double getWidth() {
        return this.vw;
    }

    @Override
    public double getHeight() {
        return this.vh;
    }

    @Override
    public void sizeTo(double s) {
        this.size = s;
        this.vw = this.size * this.ar / Math.sqrt(this.ar * this.ar + 1.0);
        this.vh = this.size / Math.sqrt(this.ar * this.ar + 1.0);
        this.scaleFactor = this.size / Math.sqrt(Math.pow(this.image.getWidth(null), 2.0) + Math.pow(this.image.getHeight(null), 2.0));
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void reSize(double factor) {
        this.size *= factor;
        this.vw = this.size * this.ar / Math.sqrt(this.ar * this.ar + 1.0);
        this.vh = this.size / Math.sqrt(this.ar * this.ar + 1.0);
        this.scaleFactor = this.size / Math.sqrt(Math.pow(this.image.getWidth(null), 2.0) + Math.pow(this.image.getHeight(null), 2.0));
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public double[] getBounds() {
        double[] res = new double[]{this.vx - this.vw / 2.0, this.vy + this.vh / 2.0, this.vx + this.vw / 2.0, this.vy - this.vh / 2.0};
        return res;
    }

    public void setImage(Image i) {
        this.image = i;
        this.vw = (double)this.image.getWidth(null) * this.scaleFactor;
        this.vh = (double)this.image.getHeight(null) * this.scaleFactor;
        this.ar = this.vw / this.vh;
        this.computeSize();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    public Image getImage() {
        return this.image;
    }

    public void setZoomSensitive(boolean b) {
        if (this.zoomSensitive != b) {
            this.zoomSensitive = b;
            VirtualSpaceManager.INSTANCE.repaint();
        }
    }

    public boolean isZoomSensitive() {
        return this.zoomSensitive;
    }

    @Override
    public boolean fillsView(double w, double h, int camIndex) {
        return false;
    }

    @Override
    public boolean coordInside(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        return jpx >= this.pc[camIndex].cx - this.pc[camIndex].cw && jpx <= this.pc[camIndex].cx + this.pc[camIndex].cw && jpy >= this.pc[camIndex].cy - this.pc[camIndex].ch && jpy <= this.pc[camIndex].cy + this.pc[camIndex].ch;
    }

    @Override
    public boolean visibleInRegion(double wb, double nb, double eb, double sb, int i) {
        if (this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb) {
            return true;
        }
        return this.vx - this.vw <= eb && this.vx + this.vw >= wb && this.vy - this.vh <= nb && this.vy + this.vh >= sb;
    }

    @Override
    public boolean visibleInDisc(double dvx, double dvy, double dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return dvs.intersects(this.vx - this.vw / 2.0, this.vy - this.vh / 2.0, this.vw, this.vh);
    }

    @Override
    public short mouseInOut(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    @Override
    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = (int)Math.round((double)d.width / 2.0 + (this.vx - c.vx) * this.coef);
        this.pc[i].cy = (int)Math.round((double)d.height / 2.0 - (this.vy - c.vy) * this.coef);
        if (this.zoomSensitive) {
            this.pc[i].cw = (int)Math.round(this.vw / 2.0 * this.coef);
            this.pc[i].ch = (int)Math.round(this.vh / 2.0 * this.coef);
        } else {
            this.pc[i].cw = (int)Math.round(this.vw / 2.0);
            this.pc[i].ch = (int)Math.round(this.vh / 2.0);
        }
    }

    @Override
    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, double lensx, double lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * (double)lensMag;
        this.pc[i].lcx = (int)Math.round((double)lensWidth / 2.0 + (this.vx - lensx) * this.coef);
        this.pc[i].lcy = (int)Math.round((double)lensHeight / 2.0 - (this.vy - lensy) * this.coef);
        if (this.zoomSensitive) {
            this.pc[i].lcw = (int)Math.round(this.vw / 2.0 * this.coef);
            this.pc[i].lch = (int)Math.round(this.vh / 2.0 * this.coef);
        } else {
            this.pc[i].lcw = (int)Math.round(this.vw / 2.0);
            this.pc[i].lch = (int)Math.round(this.vh / 2.0);
        }
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        if (this.pc[i].cw >= 1 || this.pc[i].ch >= 1) {
            this.trueCoef = this.zoomSensitive ? this.scaleFactor * this.coef : this.scaleFactor;
            if (Math.abs(this.trueCoef - 1.0) < (double)0.01f) {
                this.trueCoef = 1.0;
            }
            if (this.trueCoef != 1.0) {
                this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch);
                g.setTransform(this.at);
                if (this.alphaC != null) {
                    g.setComposite(this.alphaC);
                    if (this.interpolationMethod != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolationMethod);
                        g.drawImage(this.image, AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef), null);
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                    } else {
                        g.drawImage(this.image, AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef), null);
                    }
                    g.setTransform(stdT);
                    if (this.paintBorder) {
                        g.setColor(this.borderColor);
                        if (this.stroke != null) {
                            g.setStroke(this.stroke);
                            g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw - 1, 2 * this.pc[i].ch - 1);
                            g.setStroke(stdS);
                        } else {
                            g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw - 1, 2 * this.pc[i].ch - 1);
                        }
                    }
                    g.setComposite(acO);
                } else {
                    if (this.interpolationMethod != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolationMethod);
                        g.drawImage(this.image, AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef), null);
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                    } else {
                        g.drawImage(this.image, AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef), null);
                    }
                    g.setTransform(stdT);
                    if (this.paintBorder) {
                        g.setColor(this.borderColor);
                        if (this.stroke != null) {
                            g.setStroke(this.stroke);
                            g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw - 1, 2 * this.pc[i].ch - 1);
                            g.setStroke(stdS);
                        } else {
                            g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw - 1, 2 * this.pc[i].ch - 1);
                        }
                    }
                }
            } else if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                g.drawImage(this.image, dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, null);
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw - 1, 2 * this.pc[i].ch - 1);
                        g.setStroke(stdS);
                    } else {
                        g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw - 1, 2 * this.pc[i].ch - 1);
                    }
                }
                g.setComposite(acO);
            } else {
                g.drawImage(this.image, dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, null);
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw - 1, 2 * this.pc[i].ch - 1);
                        g.setStroke(stdS);
                    } else {
                        g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw - 1, 2 * this.pc[i].ch - 1);
                    }
                }
            }
        } else {
            g.setColor(this.borderColor);
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        if (this.pc[i].lcw >= 1 || this.pc[i].lch >= 1) {
            this.trueCoef = this.zoomSensitive ? this.scaleFactor * this.coef : this.scaleFactor;
            if (Math.abs(this.trueCoef - 1.0) < (double)0.01f) {
                this.trueCoef = 1.0;
            }
            if (this.trueCoef != 1.0) {
                g.setTransform(AffineTransform.getTranslateInstance(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch));
                if (this.alphaC != null) {
                    g.setComposite(this.alphaC);
                    if (this.interpolationMethod != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolationMethod);
                        g.drawImage(this.image, AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef), null);
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                    } else {
                        g.drawImage(this.image, AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef), null);
                    }
                    g.setTransform(stdT);
                    if (this.paintBorder) {
                        g.setColor(this.borderColor);
                        if (this.stroke != null) {
                            g.setStroke(this.stroke);
                            g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw - 1, 2 * this.pc[i].lch - 1);
                            g.setStroke(stdS);
                        } else {
                            g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw - 1, 2 * this.pc[i].lch - 1);
                        }
                    }
                    g.setComposite(acO);
                } else {
                    if (this.interpolationMethod != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolationMethod);
                        g.drawImage(this.image, AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef), null);
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                    } else {
                        g.drawImage(this.image, AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef), null);
                    }
                    g.setTransform(stdT);
                    if (this.paintBorder) {
                        g.setColor(this.borderColor);
                        if (this.stroke != null) {
                            g.setStroke(this.stroke);
                            g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw - 1, 2 * this.pc[i].lch - 1);
                            g.setStroke(stdS);
                        } else {
                            g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw - 1, 2 * this.pc[i].lch - 1);
                        }
                    }
                }
            } else if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                g.drawImage(this.image, dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, null);
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw - 1, 2 * this.pc[i].lch - 1);
                        g.setStroke(stdS);
                    } else {
                        g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw - 1, 2 * this.pc[i].lch - 1);
                    }
                }
                g.setComposite(acO);
            } else {
                g.drawImage(this.image, dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, null);
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw - 1, 2 * this.pc[i].lch - 1);
                        g.setStroke(stdS);
                    } else {
                        g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw - 1, 2 * this.pc[i].lch - 1);
                    }
                }
            }
        } else {
            g.setColor(this.borderColor);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    public void setInterpolationMethod(Object im) {
        this.interpolationMethod = im;
    }

    public Object getInterpolationMethod() {
        return this.interpolationMethod;
    }

    @Override
    public Shape getJava2DShape() {
        return new Rectangle2D.Double(this.vx - this.vw / 2.0, this.vy - this.vh / 2.0, this.vw, this.vh);
    }

    @Override
    public Object clone() {
        VImage<T> res = new VImage<T>(this.vx, this.vy, this.vz, this.image);
        res.setWidth(this.vw);
        res.setHeight(this.vh);
        res.borderColor = this.borderColor;
        res.cursorInsideColor = this.cursorInsideColor;
        res.bColor = this.bColor;
        res.setZoomSensitive(this.zoomSensitive);
        return res;
    }
}

