/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.widgets;

import fr.inria.zvtm.widgets.TranslucentWidget;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class TranslucentTextField
extends JTextField
implements TranslucentWidget {
    AlphaComposite bgAC = AB_08;
    AlphaComposite fgAC = AB_10;
    Color borderColor;

    public TranslucentTextField() {
        this.init();
    }

    public TranslucentTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.init();
    }

    public TranslucentTextField(int columns) {
        super(columns);
        this.init();
    }

    public TranslucentTextField(String text) {
        super(text);
        this.init();
    }

    public TranslucentTextField(String text, int columns) {
        super(text, columns);
        this.init();
    }

    void init() {
        this.setOpaque(false);
        this.initColors();
    }

    void initColors() {
        this.setForeground(Color.WHITE);
        this.setBackground(Color.BLACK);
        this.setSelectionColor(Color.WHITE);
        this.setSelectedTextColor(Color.BLACK);
        this.setBorderColor(Color.WHITE);
    }

    @Override
    public void setBackgroundTranslucence(float alpha) {
        this.bgAC = AlphaComposite.getInstance(3, alpha);
    }

    @Override
    public void setForegroundTranslucence(float alpha) {
        this.fgAC = AlphaComposite.getInstance(3, alpha);
    }

    public void setBorderColor(Color c) {
        this.borderColor = c;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setComposite(this.bgAC);
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setComposite(this.fgAC);
        if (this.borderColor != null) {
            g2d.setColor(this.borderColor);
            g2d.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        g2d.setColor(this.getForeground());
        super.paint(g2d);
    }
}

