/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import com.google.inject.AbstractModule;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.inject.Singleton;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.core.internal.embedder.IMavenComponentContributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExtensionModule
extends AbstractModule
implements IMavenComponentContributor.IMavenComponentBinder {
    private static final Logger log = LoggerFactory.getLogger(ExtensionModule.class);

    ExtensionModule() {
    }

    @Override
    public <T> void bind(Class<T> role, Class<? extends T> impl, String hint) {
        ScopedBindingBuilder builder = hint == null || hint.length() <= 0 || "default".equals(hint) ? this.bind(role).to(impl) : this.bind(role).annotatedWith((Annotation)Names.named((String)hint)).to(impl);
        if (impl.getAnnotation(Singleton.class) != null) {
            builder.in(com.google.inject.Singleton.class);
        }
    }

    protected void configure() {
        IExtensionRegistry r = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = r.getConfigurationElementsFor("org.eclipse.m2e.core.mavenComponentContributors");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement c = iConfigurationElementArray[n2];
            if ("configurator".equals(c.getName())) {
                try {
                    IMavenComponentContributor contributor = (IMavenComponentContributor)c.createExecutableExtension("class");
                    contributor.contribute(this);
                }
                catch (CoreException ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                }
            }
            ++n2;
        }
    }
}

