/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.databinding;

import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.fx.ui.databinding.internal.TemplateTextOnlyPropertyTableCell;
import org.eclipse.fx.ui.databinding.internal.TextOnlyPropertyTableCell;
import org.eclipse.jdt.annotation.NonNull;

public interface PropertyTableCellFactory<S, T>
extends Callback<TableColumn<S, T>, TableCell<S, T>> {
    public static <S, T> @NonNull PropertyTableCellFactory<S, T> textFactory(@NonNull IValueProperty property) {
        return param -> PropertyTableCellFactory.textCell(property);
    }

    public static <S, T> @NonNull PropertyTableCellFactory<S, T> textFactory(@NonNull String template, IValueProperty ... property) {
        return param -> PropertyTableCellFactory.textCell(template, property);
    }

    public static <S, T> @NonNull TableCell<S, T> textCell(@NonNull IValueProperty property) {
        return new TextOnlyPropertyTableCell(property);
    }

    public static <S, T> @NonNull TableCell<S, T> textCell(@NonNull String template, IValueProperty ... property) {
        return new TemplateTextOnlyPropertyTableCell(template, property);
    }
}

